/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.reLayout;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSPicture;
import jet.datastream.DSTableObject;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelFormular;
import jet.export.excel.reLayout.BaseTableLayout;
import jet.export.excel.reLayout.ExcelInfo;
import jet.export.excel.v7x.xlsAffix.ExcelChartWriter;
import jet.export.util.CCUtil;
import jet.report.xls.GlobalWorksheet;
import jet.udos.JHyperLinkRslt;

public class ExcelTableLayout
extends BaseTableLayout {
    private boolean QOIV = true;
    private ExcelFormular addColor;
    private GlobalWorksheet append;
    private boolean black;
    private boolean clear;
    private String createChartInfo;
    private int get;
    private int getChartInfo;
    private Hashtable getChildren;
    private Hashtable getColorPropertyByName;
    private Hashtable getColumnIndex;
    private ExcelCache getErrorImage;

    public ExcelTableLayout(ExcelFormular excelFormular, GlobalWorksheet globalWorksheet, boolean bl, String string, ExcelCache excelCache) {
        this.addColor = excelFormular;
        this.append = globalWorksheet;
        this.black = bl;
        this.clear = JRLog.isError(2);
        this.createChartInfo = string;
        this.getErrorImage = excelCache;
    }

    public Object[][] getTableObject(DSTableObject dSTableObject, ExcelInfo excelInfo) throws JRStopEngineException {
        return super.getTableObject(dSTableObject, excelInfo);
    }

    private void layout() {
        if (this.tableCellPsTable != null) {
            Enumeration enumeration = this.tableCellPsTable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                int n = (Integer)this.tableCellColCountTable.remove(k);
                Hashtable hashtable = (Hashtable)this.tableCellPsTable.get(k);
                this.layoutTable(k, n, hashtable);
            }
            this.tableCellPsTable.clear();
            this.tableCellPsTable = null;
            this.tableCellColCountTable = null;
        }
    }

    public void setCurrentInfo(int n, int n2, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        this.get = n;
        this.getChartInfo = n2;
        this.getChildren = hashtable;
        this.getColorPropertyByName = hashtable2;
        this.getColumnIndex = hashtable3;
    }

    protected void registerTableCellColor(List list) {
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        int n2 = 0;
        while (n2 < n) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n2);
            if (this.addColor(jRObjectResult)) {
                this.append(jRObjectResult);
            }
            ++n2;
        }
    }

    private void QOIV(DSContainer dSContainer) {
        Vector vector = dSContainer.getChildren();
        int n = 0;
        while (n < vector.size()) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n);
            if (this.addColor(jRObjectResult)) {
                this.append(jRObjectResult);
            }
            ++n;
        }
    }

    private boolean addColor(JRObjectResult jRObjectResult) {
        return this.getErrorImage.isExport(jRObjectResult);
    }

    private void append(JRObjectResult jRObjectResult) {
        int n = jRObjectResult.getObjectType();
        if ((n & 0x20) == 32) {
            if (n == 262178) {
                DSParagraph dSParagraph = (DSParagraph)jRObjectResult;
                Vector vector = dSParagraph.getChildren();
                if (vector.size() == 1) {
                    this.append((JRObjectResult)vector.get(0));
                } else if (vector.size() != 0) {
                    this.black((DSParagraph)jRObjectResult);
                }
            } else {
                this.QOIV((DSContainer)jRObjectResult);
            }
        } else if ((n & 0x40) == 64) {
            if (n == 71) {
                this.getFieldSp((DSChartPlatform)jRObjectResult);
            }
        } else if ((n & 0x80) == 128) {
            if (n == 129) {
                this.getChildren((DSPicture)jRObjectResult);
            }
        } else if ((n & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
            this.get((DSField)jRObjectResult);
        } else if (n == 4096) {
            this.createChartInfo((JRVisiableResult)jRObjectResult);
        } else if (JRLog.isAd()) {
            JRLog.print("Now, Can not treat this object : " + jRObjectResult + " type is : " + n + " When export to excel");
        }
    }

    private void black(DSParagraph dSParagraph) {
        int[] nArray = this.clear(dSParagraph);
        int n = 0;
        while (n < 3) {
            if (nArray[n] != -1) {
                this.append.addColor(nArray[n]);
            }
            ++n;
        }
    }

    private int[] clear(DSParagraph dSParagraph) {
        int[] nArray = new int[]{-1, -1, -1};
        Color color = Color.black;
        Color color2 = this.getColumnIndex(dSParagraph, "Background");
        nArray[0] = this.getErrorImage(color);
        if (color2 != null) {
            nArray[1] = this.getErrorImage(color2);
        }
        return nArray;
    }

    private void createChartInfo(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            Image image = (Image)jRVisiableResult.getPropertyByName("displayImage").getObject();
            if (image == null) {
                Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
                Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
                int n = this.getErrorImage(color);
                this.append.addColor(n);
                if (color2 != null) {
                    int n2 = this.getErrorImage(color2);
                    this.append.addColor(n2);
                }
            } else {
                this.append.addColor(255);
            }
        } else {
            this.append.addColor(255);
        }
    }

    private void get(DSField dSField) {
        int[] nArray = new int[3];
        nArray = this.getChartInfo(dSField);
        this.append.addColor(nArray[0]);
        if (nArray[1] != -1) {
            this.append.addColor(nArray[1]);
        }
        this.append.addColor(nArray[2]);
    }

    private int[] getChartInfo(DSField dSField) {
        int[] nArray = new int[]{-1, -1, -1};
        Color color = this.getColumnIndex(dSField, "Foreground");
        Color color2 = this.getColumnIndex(dSField, "Background");
        Color color3 = this.getColumnIndex(dSField, "BorderColor");
        nArray[0] = this.getErrorImage(color);
        if (color2 != null) {
            nArray[1] = this.getErrorImage(color2);
        }
        nArray[2] = this.getErrorImage(color3);
        return nArray;
    }

    private void getChildren(DSPicture dSPicture) {
        int n = -1;
        Color color = this.getColumnIndex(dSPicture, "BorderColor");
        if (color != null) {
            n = this.getErrorImage(color);
        }
        if (n != -1) {
            this.append.addColor(n);
        }
    }

    private Color getColumnIndex(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    private int getErrorImage(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    private void getFieldSp(DSChartPlatform dSChartPlatform) {
        ExcelChartWriter excelChartWriter = new ExcelChartWriter(this.append, this.createChartInfo, this.getErrorImage);
        String string = this.getIntPropertyByName(dSChartPlatform);
        excelChartWriter.createChartInfo(dSChartPlatform);
        if (excelChartWriter.isError()) {
            this.getColorPropertyByName.put(string, excelChartWriter.getErrorImage());
        } else {
            this.getColumnIndex.put(string, excelChartWriter.getChartInfo());
        }
    }

    private String getIntPropertyByName(DSChartPlatform dSChartPlatform) {
        int n = this.getObject(dSChartPlatform, "X");
        int n2 = this.getObject(dSChartPlatform, "Y");
        String string = "" + dSChartPlatform.getTemplateIndex() + '*' + this.get + '*' + n + '*' + n2 + '$' + this.getChartInfo;
        if (this.getChildren.get(string) != null) {
            int n3 = (Integer)this.getChildren.get(string) + 1;
            this.getChildren.put(string, new Integer(n3));
            string = string + '_' + n3;
        } else {
            this.getChildren.put(string, new Integer(0));
            string = string + '_' + 0;
        }
        return string;
    }

    private int getObject(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    public void free() {
    }

    protected int getParagraphSp(DSParagraph dSParagraph, boolean bl) {
        int n = 1;
        Vector vector = dSParagraph.getChildren();
        if (vector.size() == 1) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(0);
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x100) == 256) {
                n = this.getFieldSp((DSField)jRObjectResult, bl);
            } else if ((n2 & 0x80) == 128 || n2 == 71) {
                n = bl ? this.getRowIndex(jRObjectResult) + this.getObjectType(jRObjectResult) : this.getColumnIndex(jRObjectResult) + this.getParagraphSp(jRObjectResult);
            }
        }
        return n;
    }

    protected int getObjSpan(int n, JRObjectResult jRObjectResult, boolean bl) {
        int n2 = (n & 0x100) == 256 ? this.getFieldSp((DSField)jRObjectResult, bl) : ((n & 0x80) == 128 || n == 71 ? (bl ? this.getRowIndex(jRObjectResult) + this.getObjectType(jRObjectResult) : this.getColumnIndex(jRObjectResult) + this.getParagraphSp(jRObjectResult)) : (n == 262178 ? this.getParagraphSp((DSParagraph)jRObjectResult, bl) : 1));
        return n2;
    }

    private int getObjectType(JRObjectResult jRObjectResult) {
        return ((Number)jRObjectResult.getPropertyByName("RowNumber").getObject()).shortValue();
    }

    private int getParagraphSp(JRObjectResult jRObjectResult) {
        return ((Number)jRObjectResult.getPropertyByName("ColumnNumber").getObject()).shortValue();
    }

    protected void layout(DSTemplatible dSTemplatible) {
        if (this.QOIV) {
            this.layout();
            this.QOIV = false;
        }
    }

    protected boolean hasSummary(JRObjectResult jRObjectResult) {
        return this.addColor.hasSubSummary(jRObjectResult);
    }

    protected void getSubRSum(JRObjectResult jRObjectResult) {
        this.addColor.getSubRSum(jRObjectResult);
    }

    protected int[] getChartIndex(JRObjectResult jRObjectResult) {
        int[] nArray = new int[]{this.getColumnIndex(jRObjectResult), this.getRowIndex(jRObjectResult), this.getParagraphSp(jRObjectResult), this.getObjectType(jRObjectResult)};
        return nArray;
    }

    protected boolean treatSubSummary(JRObjectResult jRObjectResult, int n, int n2, int n3) throws JRStopEngineException {
        return this.addColor.treatSubSummary(jRObjectResult, n, n2, n3);
    }
}

