/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Hashtable;
import jet.datastream.DSField;
import jet.datastream.DSPicture;
import jet.datastream.DSTemplatible;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderImage;
import jet.datastream.render.RenderImageButton;
import jet.datastream.render.RenderRank;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.export.util.ImageGrabber;
import jet.export.util.ImageInfo;
import jet.export.util.ImageProperty;
import jet.export.util.ImageTool;

public class ImageEngine {
    private ImageProperty QOIV = null;
    private HashMap clipRect = new HashMap();
    private int convertToBufferedImage = Unit.getResolution();
    public static final int IMAGETYPE_GIF = 4;
    public static final int IMAGETYPE_JPG = 0;
    public static final int IMAGETYPE_PNG = 3;
    private Hashtable convertUnitToPixel = new Hashtable();
    private static ImageInfo creatBufferedImage = new ImageInfo();
    private static Dimension createGraphics = new Dimension(0, 0);

    public void setResolusion(int n) {
        this.convertToBufferedImage = n;
    }

    public void drawImage(Graphics graphics, ImageObserver imageObserver, JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult == null) {
            return;
        }
        if (graphics instanceof Graphics2D) {
            Point point;
            Dimension dimension;
            DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
            ImageProperty imageProperty = (ImageProperty)this.convertUnitToPixel.get(dSTemplatible);
            Rectangle rectangle = null;
            if (jRVisiableResult instanceof DSPicture) {
                if (imageProperty == null) {
                    imageProperty = this.drawImage((DSPicture)jRVisiableResult);
                    this.convertUnitToPixel.put(dSTemplatible, imageProperty);
                }
                int n = jRVisiableResult.getWidth();
                int n2 = jRVisiableResult.getHeight();
                dimension = this.convertUnitToPixel(n, n2, imageProperty);
                rectangle = new Rectangle(0, 0, n, n2);
                point = ImageTool.getAlignPosition(new Dimension(n, n2), dimension, imageProperty.getAlignment());
            } else {
                DSField dSField = (DSField)jRVisiableResult;
                Render render = dSField.getRender(imageObserver);
                int n = dSField.getWidth();
                int n3 = dSField.getHeight();
                imageProperty = this.fillRect(dSField, render);
                dimension = this.creatBufferedImage(render);
                rectangle = new Rectangle(render.getX(), render.getY(), render.getWidth(), render.getHeight());
                point = ImageTool.getAlignPosition(new Dimension(n, n3), dimension, imageProperty.getAlignment());
            }
            this.QOIV((Graphics2D)graphics, imageProperty, point, dimension, rectangle, imageObserver);
        } else {
            this.clipRect(graphics, imageObserver, jRVisiableResult);
        }
    }

    private void QOIV(Graphics2D graphics2D, ImageProperty imageProperty, Point point, Dimension dimension, Rectangle rectangle, ImageObserver imageObserver) {
        int n = Unit.convertUnitToPixel(point.x, this.convertToBufferedImage);
        int n2 = Unit.convertUnitToPixel(point.y, this.convertToBufferedImage);
        int n3 = Unit.convertUnitToPixel(dimension.width, this.convertToBufferedImage);
        int n4 = Unit.convertUnitToPixel(dimension.height, this.convertToBufferedImage);
        rectangle.x = Unit.convertUnitToPixel(rectangle.x, this.convertToBufferedImage);
        rectangle.y = Unit.convertUnitToPixel(rectangle.y, this.convertToBufferedImage);
        rectangle.width = Unit.convertUnitToPixel(rectangle.width, this.convertToBufferedImage);
        rectangle.height = Unit.convertUnitToPixel(rectangle.height, this.convertToBufferedImage);
        double d = Math.toRadians(imageProperty.getAngle());
        Point point2 = new Point(n + n3 / 2, n2 + n4 / 2);
        Point point3 = new Point(n, n2);
        Image image = imageProperty.getImage();
        ExportUtil.waitImage(image);
        if (image != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(d, point2.x, point2.y);
            graphics2D.transform(affineTransform);
            graphics2D.drawImage(image, point3.x, point3.y, n3, n4, imageObserver);
            affineTransform = graphics2D.getTransform();
            affineTransform.rotate(-d, point2.x, point2.y);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
        }
    }

    private void clipRect(Graphics graphics, ImageObserver imageObserver, JRVisiableResult jRVisiableResult) {
        ImageInfo imageInfo = null;
        if (jRVisiableResult instanceof DSPicture) {
            imageInfo = this.getImage(true, false, (DSPicture)jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSField) {
            imageInfo = this.getImage(true, false, ((DSField)jRVisiableResult).getRender());
        }
        if (imageInfo != null) {
            Image image = imageInfo.getImage();
            int n = Unit.convertUnitToPixel(imageInfo.getX(), this.convertToBufferedImage);
            int n2 = Unit.convertUnitToPixel(imageInfo.getY(), this.convertToBufferedImage);
            int n3 = Unit.convertUnitToPixel(imageInfo.getWidth(), this.convertToBufferedImage);
            int n4 = Unit.convertUnitToPixel(imageInfo.getHeight(), this.convertToBufferedImage);
            if (image != null) {
                graphics.drawImage(image, n, n2, n3, n4, imageObserver);
            }
        }
    }

    public ImageInfo getImage(boolean bl, boolean bl2, Render render) {
        DSField dSField = render.getParent();
        if (dSField == null) {
            Image image = render.getImage();
            return this.convertToBufferedImage(image);
        }
        int n = render.getWidth();
        int n2 = render.getHeight();
        ImageProperty imageProperty = this.fillRect(dSField, render);
        Image image = imageProperty.getImage();
        int n3 = 0;
        int n4 = 0;
        if (image != null) {
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (image == null || n3 <= 0 || n4 <= 0) {
            return creatBufferedImage;
        }
        Dimension dimension = this.creatBufferedImage(render);
        if (dimension == null) {
            return this.convertToBufferedImage(image);
        }
        ImageInfo imageInfo = new ImageInfo();
        Point point = ImageTool.getAlignPosition(new Dimension(n, n2), dimension, imageProperty.getAlignment());
        if (bl2 && imageProperty.getAngle() == 0.0) {
            imageInfo.setX(point.x);
            imageInfo.setY(point.y);
            imageInfo.setWidth(dimension.width);
            imageInfo.setHeight(dimension.height);
            imageInfo.setOriginalImage(image);
        } else {
            imageInfo.setWidth(n);
            imageInfo.setHeight(n2);
            imageInfo.setType(3);
        }
        Image image2 = this.createGraphics(image, new Rectangle(point.x, point.y, dimension.width, dimension.height), new Dimension(n, n2), imageProperty.getAngle(), bl, bl2);
        imageInfo.setImage(image2);
        return imageInfo;
    }

    private ImageInfo convertToBufferedImage(Image image) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImage(image);
        imageInfo.setWidth(image.getWidth(null));
        imageInfo.setHeight(image.getHeight(null));
        imageInfo.setOriginalImage(image);
        return imageInfo;
    }

    public ImageInfo getImage(boolean bl, boolean bl2, DSPicture dSPicture) {
        int n;
        int n2;
        DSTemplatible dSTemplatible = dSPicture.getTemplate();
        Object v = this.clipRect.get(dSTemplatible);
        if (v != null) {
            return (ImageInfo)v;
        }
        ImageInfo imageInfo = new ImageInfo();
        int n3 = dSPicture.getWidth();
        int n4 = dSPicture.getHeight();
        ImageProperty imageProperty = this.drawImage(dSPicture);
        Image image = imageProperty.getImage();
        Dimension dimension = this.convertUnitToPixel(n3, n4, imageProperty);
        if (image == null || dimension.width <= 0 || dimension.height <= 0) {
            return creatBufferedImage;
        }
        if (bl2 && imageProperty.getAngle() == 0.0) {
            n2 = dimension.width > n3 ? n3 : dimension.width;
            n = dimension.height > n4 ? n4 : dimension.height;
        } else {
            n2 = n3;
            n = n4;
        }
        Point point = ImageTool.getAlignPosition(new Dimension(n3, n4), dimension, imageProperty.getAlignment());
        if (bl2 && imageProperty.getAngle() == 0.0) {
            imageInfo.setX(point.x);
            imageInfo.setY(point.y);
            imageInfo.setWidth(dimension.width);
            imageInfo.setHeight(dimension.height);
            imageInfo.setOriginalImage(image);
        } else {
            imageInfo.setWidth(n2);
            imageInfo.setHeight(n);
            imageInfo.setType(3);
        }
        Image image2 = this.createGraphics(image, new Rectangle(point.x, point.y, dimension.width, dimension.height), new Dimension(n2, n), imageProperty.getAngle(), bl, bl2);
        imageInfo.setImage(image2);
        if (!(CCUtil.isChangeByFormularProperty(dSPicture, "PictureName") || CCUtil.isChangeByFormularProperty(dSPicture, "MaxScalingRatio") || CCUtil.isChangeByFormularProperty(dSPicture, "Rotation"))) {
            this.clipRect.put(dSTemplatible, imageInfo);
        }
        return imageInfo;
    }

    private Dimension convertUnitToPixel(int n, int n2, ImageProperty imageProperty) {
        Image image = imageProperty.getImage();
        int n3 = 0;
        int n4 = 0;
        if (image != null) {
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (image == null || n3 <= 0 || n4 <= 0) {
            return createGraphics;
        }
        float f = ImageTool.getResolutionRatio(this.convertToBufferedImage);
        Dimension dimension = ImageTool.getImageSize(n3, n4, f);
        Dimension dimension2 = ImageTool.getScalingSize(n, n2, dimension.width, dimension.height, imageProperty.getScaleMode(), imageProperty.getMaxRatio());
        return dimension2;
    }

    private Dimension creatBufferedImage(Render render) {
        Dimension dimension = null;
        if (render instanceof RenderImage) {
            dimension = ((RenderImage)render).getdrawSize();
        } else if (render instanceof RenderImageButton) {
            dimension = ((RenderImageButton)render).getdrawSize();
        } else if (render instanceof RenderRank) {
            dimension = ((RenderRank)render).getdrawSize();
        }
        return dimension;
    }

    private Image createGraphics(Image image, Rectangle rectangle, Dimension dimension, double d, boolean bl, boolean bl2) {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        if (bl2 && d == 0.0) {
            if (!bl) {
                imageGrabber.processImage();
                if (imageGrabber.hasAlpha()) {
                    return imageGrabber.convertToBufferedImage(false);
                }
            }
            return image;
        }
        int n = Unit.convertUnitToPixel(rectangle.x, this.convertToBufferedImage);
        int n2 = Unit.convertUnitToPixel(rectangle.y, this.convertToBufferedImage);
        int n3 = Unit.convertUnitToPixel(rectangle.width, this.convertToBufferedImage);
        int n4 = Unit.convertUnitToPixel(rectangle.height, this.convertToBufferedImage);
        int n5 = Unit.convertUnitToPixel(dimension.width, this.convertToBufferedImage);
        int n6 = Unit.convertUnitToPixel(dimension.height, this.convertToBufferedImage);
        BufferedImage bufferedImage = this.dispose(image, d, bl, n, n2, n3, n4, n5, n6);
        return bufferedImage;
    }

    private BufferedImage dispose(Image image, double d, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        BufferedImage bufferedImage = ImageTool.creatBufferedImage(bl, n5, n6);
        double d2 = Math.toRadians(d);
        Point point = new Point(n + n3 / 2, n2 + n4 / 2);
        Point point2 = new Point(n, n2);
        ExportUtil.waitImage(image);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n5, n6);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2, point.x, point.y);
        graphics2D.transform(affineTransform);
        graphics2D.drawImage(image, point2.x, point2.y, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private ImageProperty drawImage(DSPicture dSPicture) {
        Image image = CCUtil.getImagePropertyByName(dSPicture, "PictureName");
        int n = CCUtil.getIntPropertyByName(dSPicture, "VerticalAlignment");
        int n2 = CCUtil.getIntPropertyByName(dSPicture, "HorizontalAlignment");
        int n3 = CCUtil.getIntPropertyByName(dSPicture, "Rotation");
        int n4 = CCUtil.getIntPropertyByName(dSPicture, "ScalingMode");
        float f = CCUtil.getFloatPropertyByName(dSPicture, "MaxScalingRatio");
        int n5 = ImageTool.transAlignment(n, n2);
        ImageProperty imageProperty = new ImageProperty();
        imageProperty.setImage(image);
        imageProperty.setAngle(n3);
        imageProperty.setAlignment(n5);
        imageProperty.setMaxRatio(f);
        imageProperty.setScaleMode(n4);
        return imageProperty;
    }

    private ImageProperty fillRect(DSField dSField, Render render) {
        int n = CCUtil.getIntPropertyByName(dSField, "VerticalAlignment");
        int n2 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        int n3 = ImageTool.transAlignment(n, n2);
        double d = render.getRotation();
        Image image = render.getImage();
        ImageProperty imageProperty = new ImageProperty();
        imageProperty.setImage(image);
        imageProperty.setAngle(d);
        imageProperty.setAlignment(n3);
        return imageProperty;
    }
}

