/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.pStream = new PrintStream(outputStream);
    }

    protected void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println();
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return n;
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return byArray.length;
    }

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n);
            int n2 = 0;
            while (n2 < n) {
                if (n2 + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, n2, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray, n2, n - n2);
                }
                n2 += this.bytesPerAtom();
            }
            if (n < this.bytesPerLine()) break;
            this.encodeLineSuffix(outputStream);
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encode(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encode(byteArrayInputStream, outputStream);
    }

    public String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = null;
        try {
            this.encode(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString("8859_1");
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return string;
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n);
            int n2 = 0;
            while (n2 < n) {
                if (n2 + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, n2, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray, n2, n - n2);
                }
                n2 += this.bytesPerAtom();
            }
            this.encodeLineSuffix(outputStream);
            if (n >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }
}

