/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.report.xls.Biff;
import jet.report.xls.ColorConstants;
import jet.report.xls.ColorIndex;
import jet.report.xls.PaletteColorIndex;
import util.RandomAccessStream;

class Palette
extends Biff
implements ColorConstants {
    public static final int DFCOLORCOUNT = 56;
    public static final int MINCELLSIZE = 48;
    int[] HSBtoRGB = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0xD8D8D8, 0xFFFFCC, 0xEEEEEE, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 4941445, 7449533, 12703467, 15003384, 5072195, 11228747, 16513259, 16119260, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    boolean[] QOIV = new boolean[56];
    Hashtable RGBtoHSB = new Hashtable();
    private boolean add = false;

    public Palette() {
        this.length = 226;
        int n = this.HSBtoRGB.length;
        while (--n >= 2) {
            this.RGBtoHSB.put(new Integer(this.HSBtoRGB[n]), new ColorIndex(n + 8, this.HSBtoRGB[n]));
        }
        this.RGBtoHSB.put(new Integer(this.HSBtoRGB[1]), new ColorIndex(9, this.HSBtoRGB[1]));
        this.RGBtoHSB.put(new Integer(this.HSBtoRGB[0]), new ColorIndex(8, this.HSBtoRGB[0]));
        this.QOIV[0] = true;
        this.QOIV[1] = true;
    }

    public final int opcode() {
        return 146;
    }

    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, (short)56);
        int n = 0;
        while (n < 56) {
            this.writeInt(randomAccessStream, this.HSBtoRGB(this.HSBtoRGB[n]));
            ++n;
        }
        return this.length + 4;
    }

    int HSBtoRGB(int n) {
        return (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >> 16;
    }

    public int getColor(int n, int n2, int n3) {
        return (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
    }

    public int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int RGBtoHBS(int n) {
        int n2 = this.getRed(n);
        int n3 = this.getGreen(n);
        int n4 = this.getBlue(n);
        float[] fArray2 = new float[3];
        fArray2 = Color.RGBtoHSB(n2, n3, n4, fArray2);
        int n5 = (int)((double)(fArray2[0] * 240.0f) + 0.5);
        int n6 = (int)((double)(fArray2[1] * 240.0f) + 0.5);
        n4 = (int)((double)(fArray2[2] * 240.0f) + 0.5);
        return (n5 & 0xFF) << 16 | (n4 & 0xFF) << 8 | (n6 & 0xFF) << 0;
    }

    int QOIV(int n) {
        return n >> 16 & 0xFF;
    }

    int RGBtoHSB(int n) {
        return n >> 8 & 0xFF;
    }

    int add(int n) {
        return n >> 0 & 0xFF;
    }

    public int HBStoRGB(int n) {
        int n2 = this.QOIV(n);
        int n3 = this.RGBtoHSB(n);
        int n4 = this.add(n);
        float f = ((float)n2 - 0.5f) / 240.0f;
        float f2 = ((float)n3 - 0.5f) / 240.0f;
        float f3 = ((float)n4 - 0.5f) / 240.0f;
        int n5 = Color.HSBtoRGB(f, f3, f2) & 0xFFFFFF;
        return n5;
    }

    int I(int n) {
        PaletteColorIndex paletteColorIndex = (PaletteColorIndex)this.RGBtoHSB.get(new Integer(n &= 0xFFFFFF));
        return paletteColorIndex.F;
    }

    void Z(int n) {
        if (this.add) {
            return;
        }
        ColorIndex colorIndex = (ColorIndex)this.RGBtoHSB.get(new Integer(n &= 0xFFFFFF));
        if (colorIndex == null) {
            int n2 = this.RGBtoHSB.size() + 18;
            this.RGBtoHSB.put(new Integer(n), new ColorIndex(n2, n));
        } else {
            int n3 = colorIndex.F - 8;
            if (n3 < 56) {
                this.QOIV[n3] = true;
            }
        }
    }

    private int append() {
        int n = 0;
        int n2 = 0;
        while (n2 < 56) {
            n += this.QOIV[n2] ? 0 : 1;
            ++n2;
        }
        return n;
    }

    boolean I() {
        if (this.add) {
            return false;
        }
        if (this.RGBtoHSB.size() > 56) {
            this.add = true;
            int n = this.append();
            if (this.RGBtoHSB.size() - n > 56) {
                Serializable serializable;
                Object object;
                Object object2;
                Serializable serializable2;
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                int n2 = 0;
                while (n2 < 56) {
                    serializable2 = new Integer(this.HSBtoRGB[n2]);
                    if (this.QOIV[n2]) {
                        hashtable.put(serializable2, this.RGBtoHSB.remove(serializable2));
                    } else {
                        hashtable2.put(serializable2, this.RGBtoHSB.remove(serializable2));
                    }
                    ++n2;
                }
                serializable2 = new Hashtable();
                ((Hashtable)serializable2).putAll(this.RGBtoHSB);
                this.RGBtoHSB.clear();
                Enumeration enumeration = ((Hashtable)serializable2).keys();
                Vector<Float> vector = new Vector<Float>();
                Hashtable<Object, ArrayList> hashtable3 = new Hashtable<Object, ArrayList>();
                while (enumeration.hasMoreElements()) {
                    Object object3;
                    float f;
                    Enumeration enumeration2;
                    Object k = enumeration.nextElement();
                    ColorIndex colorIndex = (ColorIndex)((Hashtable)serializable2).get(k);
                    float f2 = Float.MAX_VALUE;
                    object2 = hashtable.keys();
                    while (object2.hasMoreElements()) {
                        enumeration2 = object2.nextElement();
                        if (k.equals(enumeration2) || !((f = this.clear(colorIndex, (ColorIndex)(object3 = (ColorIndex)hashtable.get(enumeration2)))) < f2)) continue;
                        f2 = f;
                    }
                    enumeration2 = hashtable2.keys();
                    while (enumeration2.hasMoreElements()) {
                        ColorIndex colorIndex2;
                        float f3;
                        object3 = enumeration2.nextElement();
                        if (k.equals(object3) || !((f3 = this.clear(colorIndex, colorIndex2 = (ColorIndex)hashtable2.get(object3))) < f2)) continue;
                        f2 = f3;
                    }
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        f = ((Float)vector.get(n3)).floatValue();
                        if (f2 <= f) break;
                        ++n3;
                    }
                    object = new Float(f2);
                    vector.insertElementAt((Float)object, n3);
                    serializable = hashtable3.containsKey(object) ? (ArrayList)hashtable3.get(object) : new ArrayList();
                    serializable.add(k);
                    hashtable3.put(object, (ArrayList)serializable);
                }
                this.RGBtoHSB.putAll(hashtable);
                hashtable = null;
                int n4 = 0;
                int n5 = hashtable2.size();
                while (((Hashtable)serializable2).size() > n5) {
                    Object e = vector.get(n4);
                    ++n4;
                    if (!hashtable3.containsKey(e)) continue;
                    object2 = (ArrayList)hashtable3.remove(e);
                    int n6 = 0;
                    while (n6 < ((ArrayList)object2).size()) {
                        Object e2 = ((ArrayList)object2).get(n6);
                        object = (ColorIndex)((Hashtable)serializable2).remove(e2);
                        serializable = new Integer(((ColorIndex)object).C());
                        if (this.RGBtoHSB.containsKey(serializable)) {
                            this.RGBtoHSB.put(e2, new PaletteColorIndex(((PaletteColorIndex)this.RGBtoHSB.get((Object)serializable)).F));
                        } else {
                            if (!hashtable2.containsKey(serializable)) {
                                System.out.println("(" + ((ColorIndex)object).Z() + ")rf(" + ((ColorIndex)object).C() + ")");
                            }
                            int n7 = ((PaletteColorIndex)hashtable2.get((Object)serializable)).F;
                            this.RGBtoHSB.put(e2, new PaletteColorIndex(n7));
                            n7 -= 8;
                            if (--n5 < 0) {
                                n5 = 0;
                            }
                            this.QOIV[n7] = true;
                        }
                        ++n6;
                    }
                }
                enumeration = ((Hashtable)serializable2).keys();
                int n8 = 55;
                while (n8 >= 0) {
                    if (!this.QOIV[n8]) {
                        if (!enumeration.hasMoreElements()) break;
                        object2 = (Integer)enumeration.nextElement();
                        this.RGBtoHSB.put(object2, new PaletteColorIndex(n8 + 8));
                        this.HSBtoRGB[n8] = (Integer)object2;
                    }
                    --n8;
                }
                ((Hashtable)serializable2).clear();
            } else {
                Object object;
                Hashtable hashtable = new Hashtable();
                int n9 = 0;
                while (n9 < 56) {
                    object = new Integer(this.HSBtoRGB[n9]);
                    if (this.QOIV[n9]) {
                        hashtable.put(object, this.RGBtoHSB.remove(object));
                    } else {
                        this.RGBtoHSB.remove(object);
                    }
                    ++n9;
                }
                object = this.RGBtoHSB.keys();
                int n10 = 55;
                while (n10 >= 0) {
                    if (!this.QOIV[n10]) {
                        if (!object.hasMoreElements()) break;
                        Integer n11 = (Integer)object.nextElement();
                        this.RGBtoHSB.put(n11, new PaletteColorIndex(n10 + 8));
                        this.HSBtoRGB[n10] = n11;
                    }
                    --n10;
                }
                this.RGBtoHSB.putAll(hashtable);
            }
        }
        return true;
    }

    void index(int n, int[] nArray) {
        nArray[0] = this.QOIV(n) == 240 ? 47 : this.QOIV(n) / 5;
        nArray[1] = this.RGBtoHSB(n) == 240 ? 47 : this.RGBtoHSB(n) / 5;
        nArray[2] = this.add(n) == 240 ? 47 : this.add(n) / 5;
    }

    private float clear(ColorIndex colorIndex, ColorIndex colorIndex2) {
        float f = colorIndex.B() - colorIndex2.B();
        f = f < 0.0f ? -f : f;
        f = (double)f > 0.4 ? (float)(0.8 - (double)f) : f;
        f *= f;
        float f2 = colorIndex.D() - colorIndex2.D();
        f2 *= f2;
        float f3 = colorIndex.F() - colorIndex2.F();
        f3 *= f3;
        float f4 = (float)Math.sqrt(f + f2 + f3);
        if (colorIndex.I() > f4) {
            colorIndex.I(f4, colorIndex2.Z());
        }
        return f4;
    }
}

