/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.creator;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.exception.UserException;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptField;
import jet.report.SubReportLinks;
import jet.rptengine.JCommunicator;
import jet.rptengine.creator.ContainerCreator;
import jet.rptengine.creator.ExecuteEnv;
import jet.rptengine.layoutManager.LayoutManager;
import jet.rptservice.api.exception.JRScheduleException;

public abstract class AbstractCreator {
    public static final int FINISHED = 0;
    public static final int BREAKED = 3;
    public static final int FINISHED_BREAKED = 2;
    public static final int UNFINISHED_UNBREAKED = 1;
    public static final int BREAKED_IN_WIDTH = 4;
    protected ArrayList unProcessedChildren = new ArrayList();
    public LayoutManager layoutManager;
    public ExecuteEnv env;
    protected AbstractCreator parent;
    protected int stateCode = 3;
    protected boolean bStopping = false;
    protected ArrayList fNames = null;

    public JRObjectResult createAChild() {
        return null;
    }

    public abstract JRVisiableResult doLayout(boolean var1) throws UserException, JRScheduleException, DSException, JRStopEngineException;

    public void finish() throws JRStopEngineException {
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public boolean isStopped() {
        return this.bStopping;
    }

    public void stop() {
        this.bStopping = true;
    }

    protected void informeChildrenStop() {
    }

    public boolean isPublic() {
        return true;
    }

    public String getAUL() {
        return null;
    }

    public void setParentCreator(ContainerCreator containerCreator) {
        this.parent = containerCreator;
    }

    public abstract void init(LayoutManager var1) throws JRScheduleException, JRStopEngineException;

    public abstract JRObjectTemplate getTemplate();

    public void setLinkReport(JRVisiableResult jRVisiableResult, ExecuteEnv executeEnv, JRecord jRecord) {
        block10: {
            if (jRVisiableResult == null) {
                return;
            }
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)jRVisiableResult.getTemplate();
            if (jRObjectTemplate.isLinkable() && !executeEnv.engine.isPipe()) {
                String string = null;
                try {
                    JetLink jetLink = (JetLink)jRObjectTemplate.getLinkProperty();
                    if (jetLink != null) {
                        SubReportLinks subReportLinks = (SubReportLinks)jetLink.getValue();
                        if (jetLink.linkReport()) {
                            if (subReportLinks.rptName != null && subReportLinks.rptName.length() != 0 && !executeEnv.engine.isDHTML) {
                                string = JetRptField.parseRptName(jetLink.getReportName())[0];
                                int[] nArray = new int[1];
                                int n = ((JCommunicator)executeEnv.engine.getCommunicator()).getLinkedReport(jRObjectTemplate, jRecord, executeEnv.engine, nArray);
                                jRVisiableResult.setLink(n, -1, nArray[0]);
                            }
                        } else {
                            String string2 = subReportLinks.urlValue;
                            if (string2 != null && string2.length() > 0) {
                                int n = ((JCommunicator)executeEnv.engine.getCommunicator()).setLinkedInfo(jetLink, jRecord, executeEnv.engine);
                                jRVisiableResult.setLink(-1, -1, n);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, exception);
                    }
                    if (string == null || ((JCommunicator)executeEnv.engine.getCommunicator()).getErrSubReport().contains(string)) break block10;
                    ((JCommunicator)executeEnv.engine.getCommunicator()).getErrSubReport().add(string);
                    if (executeEnv.getRptListener() == null) break block10;
                    this.env.getRptListener().noteError(Thread.currentThread(), exception, 0, exception.getMessage());
                }
            }
        }
    }

    public ArrayList getFNames() {
        return this.fNames;
    }

    public void setFNames(ArrayList arrayList) {
        this.fNames = arrayList;
    }

    public void setStateCode(int n) {
        this.stateCode = n;
    }

    public void clear() {
    }
}

