/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.infocenter;

import com.jinfonet.util.JRLog;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.Group;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.SpecialFields;
import jet.formula.JetRptFormula;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectInfo.bursting.RecipientMappingIdentifier;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.accessor.cube.subject.RptDimension;
import jet.rptservice.engine.infocenter.DataSetInfo;
import jet.rptservice.engine.infocenter.DimensionDesc;
import jet.rptservice.engine.infocenter.MDimensionDesc;
import jet.rptservice.engine.infocenter.PartialData;
import jet.rptservice.engine.infocenter.PartialDataSet;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.listener.DataSetListener;
import jet.rptservice.pub.JRecordSecurityContainer;
import jet.rptservice.pub.KeyReportView;
import jet.rptservice.pub.RSDResultSet;
import jet.rptservice.util.Tools;
import jet.server.api.SecurityContext;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.tools.UniverseTools;

public class DataSetCenter {
    private int QOIV = Integer.MIN_VALUE;
    private String add = null;
    private Vector addAll;
    private Vector addDimension;
    private Vector addElement;
    private Vector addMeasure;
    private Vector append;
    private Vector clear;
    private Vector clearAllColumnValues;
    private JetRptDataSet close;
    private boolean closeCubeData = true;
    private boolean closeRawData = true;
    private boolean contains = true;
    private boolean containsKey = true;
    private IExpression createJetRptFormula = null;
    private JetUUniverse currentTimeMillis;
    private boolean elementAt = false;
    private JRecordSecurityContainer equalsIgnoreCase;
    private DataSetInfo error;
    private SpecialFields get;
    private JRawDataQuery getAdditionMappingNames;
    private int getBasedFieldName = Integer.MIN_VALUE;
    private boolean getBindInfo = true;
    private JRawDataQuery getBurstingDataSetNames;
    private HashMap getBurstingKeyColumn;
    private boolean getBurstingRecipientSchema = true;
    private HashMap getBurstingSchemas;
    private boolean getCFFormulas = true;
    private boolean getConstantFormulas = false;
    private CubeModel getDataSet = null;
    private JCubeQuery getDataSetCubeViewInfo = null;
    private int getDataSetInfo = -1;
    private DataSetListener getDataSetLogic;
    private DataSetListener getDataSetMappingFields;
    private DataSetStatus getDataSourceName = null;
    private HashMap getDbFieldFormulaMappingNames;
    private DataBlock getDbFieldPass1FormulaNames;
    private HashMap getDbFields = null;
    private Hashtable getDimensionName;
    private Hashtable getDimensions;

    public DataSetCenter(String string, int n, ReportSetCenter reportSetCenter) {
        JRptSetEngine jRptSetEngine = reportSetCenter.getRptSetEngine();
        this.add = string;
        this.QOIV = n;
        this.close = jRptSetEngine.getReportSet().getDataSet(string);
        this.currentTimeMillis = jRptSetEngine.getUniverse();
        this.error = reportSetCenter.getDataSetInfo(string);
        this.refreshRecSecurity(jRptSetEngine.getUserName(), JRptSetEngine.getSecurityData(), jRptSetEngine.getSecurityContext(), jRptSetEngine.isRsd() || jRptSetEngine.isBurstingRsd());
        this.refresh(this.currentTimeMillis);
    }

    public int getRawDataId() {
        return this.QOIV;
    }

    public void setRawDataId(int n) {
        this.QOIV = n;
    }

    public int getCubeQueryId() {
        return this.getDataSetInfo;
    }

    public void setCubeQueryId(int n) {
        this.getDataSetInfo = n;
    }

    public void setRawDataQuery(JRawDataQuery jRawDataQuery) {
        this.getAdditionMappingNames = jRawDataQuery;
    }

    public JRawDataQuery getRawDataQuery() {
        return this.getAdditionMappingNames;
    }

    public void setCubeQuery(JCubeQuery jCubeQuery) {
        this.getDataSetCubeViewInfo = jCubeQuery;
    }

    public JCubeQuery getCubeQuery() {
        return this.getDataSetCubeViewInfo;
    }

    public CubeModel getCubeModel() {
        return this.getDataSet;
    }

    public boolean needRefresh() {
        return this.closeCubeData;
    }

    public void setNeedRefresh(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.setNeedRefresh()..., set: " + bl);
        }
        this.closeCubeData = bl;
    }

    public boolean needRefreshCube() {
        return this.contains;
    }

    public void setNeedRefreshCube(boolean bl) {
        this.contains = bl;
    }

    public boolean needInitCubeQuery() {
        return this.containsKey;
    }

    public void setNeedInitCubeQuery(boolean bl) {
        this.containsKey = bl;
    }

    public int getGeneralRawDataId() {
        return this.getBasedFieldName;
    }

    public void setGeneralRawDataId(int n) {
        this.getBasedFieldName = n;
    }

    public void setGeneralRawDataQuery(JRawDataQuery jRawDataQuery) {
        this.getBurstingDataSetNames = jRawDataQuery;
    }

    public JRawDataQuery getGeneralRawDataQuery() {
        return this.getBurstingDataSetNames;
    }

    public void setNeedRefreshGeneralQuery(boolean bl) {
        this.getBindInfo = bl;
    }

    public boolean needRefreshGeneralQuery() {
        return this.getBindInfo;
    }

    public boolean needInitQuery() {
        return this.closeRawData;
    }

    public void setNeedInitQuery(boolean bl) {
        this.closeRawData = bl;
    }

    public IExpression getFilter() {
        return this.createJetRptFormula;
    }

    public JetRptDataSet getDataSet() {
        return this.close;
    }

    public String getDataSetName() {
        return this.add;
    }

    public JRecordSecurityContainer getSecContainer() {
        return this.equalsIgnoreCase;
    }

    public void setRsdResultSet(RSDResultSet rSDResultSet) {
        this.error.setRsdResultSet(rSDResultSet);
    }

    public RSDResultSet getRsdResultSet() {
        return this.error.getRsdResultSet();
    }

    public void setBindInfo(String[][] stringArray) {
        this.error.setBindInfo(stringArray);
    }

    public String[][] getBindInfo() {
        return this.error.getBindInfo();
    }

    public void setSpecialFields(SpecialFields specialFields) {
        this.get = specialFields;
    }

    public SpecialFields getSpecialFields() {
        return this.get;
    }

    public Hashtable getCFFormulas() {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.getDimensionName.values().iterator();
        while (iterator.hasNext()) {
            Hashtable hashtable2 = (Hashtable)iterator.next();
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    public Hashtable getFlyFormulas() {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.getDimensions.values().iterator();
        while (iterator.hasNext()) {
            Hashtable hashtable2 = (Hashtable)iterator.next();
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    public void putPartialData(PartialData partialData, JetUUniverse jetUUniverse) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.putPartialData()..., pd: " + partialData + " unv: " + jetUUniverse);
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        if (this.getDbFieldFormulaMappingNames == null) {
            this.getDbFieldFormulaMappingNames = new HashMap();
        }
        if (!this.getDbFieldFormulaMappingNames.containsKey(partialData)) {
            PartialDataSet partialDataSet = new PartialDataSet(partialData, jetUUniverse);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "put PartialDataSet: " + partialDataSet);
            }
            this.getDbFieldFormulaMappingNames.put(partialData, partialDataSet);
        }
        Tools.logTrace(6, "End of DataSetCenter.putPartialData().");
    }

    public PartialDataSet getPartialDataSet(PartialData partialData) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.getPartialDataSet()..., pd: " + partialData);
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        PartialDataSet partialDataSet = null;
        if (this.getDbFieldFormulaMappingNames != null) {
            partialDataSet = (PartialDataSet)this.getDbFieldFormulaMappingNames.get(partialData);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getPartialDataSet(), return: " + partialDataSet);
        }
        return partialDataSet;
    }

    private void QOIV(List list, List list2) {
        if (list2 == null) {
            return;
        }
        int n = 0;
        while (n < list2.size()) {
            String string = (String)list2.get(n);
            if (!list.contains(string = string.toUpperCase())) {
                list.add(string);
            }
            ++n;
        }
    }

    private void add(List list, String string) {
        String string2;
        if (string != null && !list.contains(string2 = string.toUpperCase())) {
            list.add(string2);
        }
    }

    public void refresh(JetUUniverse jetUUniverse) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refresh()..., unv: " + jetUUniverse);
        }
        block0 : switch (this.close.getMappingListSrc()) {
            case 1: {
                int n = this.close.getMappingListType();
                switch (n) {
                    case 0: {
                        JetRptQueryDataSet jetRptQueryDataSet = (JetRptQueryDataSet)this.close;
                        String string = jetRptQueryDataSet.getDsName();
                        String string2 = jetRptQueryDataSet.getQueryName();
                        this.addElement = UniverseTools.getFieldResourceNames(jetUUniverse, string, string2);
                        if (!JRLog.isTrace(6)) break;
                        JRLog.trace(6, "all field names: " + Tools.toString(this.addElement));
                        break;
                    }
                    case 2: {
                        Vector vector = this.close.getAdditionMappingNames();
                        if (vector == null) break;
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            String string = (String)vector.elementAt(n2);
                            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)this.close.getResourceByName(string);
                            if (jetUResourceEntity instanceof JetUFormula) {
                                JetRptFormula jetRptFormula = ((JetUFormula)jetUResourceEntity).getRptFormula();
                                if (jetRptFormula.isConstant()) {
                                    if (this.clear == null) {
                                        this.clear = new Vector();
                                    }
                                    this.add(this.clear, string);
                                } else if (jetRptFormula.isGlobal()) {
                                    if (this.clearAllColumnValues == null) {
                                        this.clearAllColumnValues = new Vector();
                                    }
                                    this.add(this.clearAllColumnValues, string);
                                } else {
                                    if (this.append == null) {
                                        this.append = new Vector();
                                    }
                                    this.add(this.append, string);
                                }
                            } else {
                                if (this.addDimension == null) {
                                    this.addDimension = new Vector();
                                }
                                this.add(this.addDimension, string);
                            }
                            ++n2;
                        }
                        break block0;
                    }
                    case 1: {
                        break;
                    }
                }
                break;
            }
            case 4: {
                this.addDimension = new Vector();
                Vector vector = this.close.getAdditionMappingNames();
                if (vector == null) break;
                if (this.addDimension == null) {
                    this.addDimension = new Vector();
                }
                this.QOIV(this.addDimension, vector);
                break;
            }
        }
        Tools.logTrace(6, "End of DataSetCenter.refresh().");
    }

    public void refresh(ReportViewCenter reportViewCenter) {
        Object[] objectArray;
        Object object;
        RptDimension[] rptDimensionArray;
        Vector<String> vector;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refresh()..., viewCenter: " + reportViewCenter);
            JRLog.trace(6, "rptName: " + reportViewCenter.getRptCenter().getRptName() + " viewName: " + reportViewCenter.getViewName());
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        long l = System.currentTimeMillis();
        int[] nArray = null;
        int n = this.close.getMappingListType();
        if (this.close.getMappingListSrc() == 3 && n == 0) {
            n = 1;
        }
        switch (n) {
            case 0: {
                nArray = new int[]{1, 2, 3, 4};
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                nArray = new int[]{0, 1, 2, 3, 4};
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            vector = reportViewCenter.getDataSetMappingFields(nArray[n2], this.add);
            this.refreshMappingFields(nArray[n2], vector);
            ++n2;
        }
        this.refreshCubeModel(reportViewCenter);
        vector = new Vector();
        Vector<String> vector2 = new Vector();
        Vector<String> vector3 = new Vector<String>();
        if (this.getDataSet != null) {
            rptDimensionArray = this.getDataSet.getDimensions();
            int n3 = rptDimensionArray == null ? 0 : rptDimensionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = rptDimensionArray[n4].getmappingName();
                if (!this.addAll(string)) {
                    object = ObjectLogicFactory.getDataSetLogic();
                    objectArray = object.getResourceByName(this.close, string);
                    if (objectArray instanceof JetUParameter) {
                        vector2.add(string);
                    } else if (objectArray instanceof JetUFormula) {
                        vector3.add(string);
                    } else {
                        vector.add(string);
                    }
                }
                ++n4;
            }
        }
        if ((rptDimensionArray = ObjectLogicFactory.getReportLogic()).isBurstingReport(reportViewCenter.getOriReportView())) {
            JetUUniverse jetUUniverse = reportViewCenter.getReportViewEngine().getRptSetEngine().getUniverse();
            BurstingSchema[] burstingSchemaArray = rptDimensionArray.getBurstingSchemas(reportViewCenter.getOriReportView());
            int n5 = 0;
            while (burstingSchemaArray != null && n5 < burstingSchemaArray.length) {
                BurstingRecipientSchema burstingRecipientSchema;
                RecipientMappingIdentifier[] recipientMappingIdentifierArray;
                object = burstingSchemaArray[n5];
                objectArray = object.getBurstingDataSetNames();
                if (Tools.contains(objectArray, this.add) && (recipientMappingIdentifierArray = (burstingRecipientSchema = object.getBurstingRecipientSchema()).getRecipientMappingIdentifiers()) != null) {
                    int n6 = 0;
                    while (n6 < recipientMappingIdentifierArray.length) {
                        String string;
                        Vector<String> vector4 = null;
                        String string2 = recipientMappingIdentifierArray[n6].getBurstingKeyColumn();
                        JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(this.close.getDataSourceName(), string2);
                        if (jetUResourceEntity != null && !(vector4 = jetUResourceEntity instanceof JetUParameter ? vector2 : (jetUResourceEntity instanceof JetUFormula ? vector3 : vector)).contains(string = string2.toUpperCase())) {
                            vector4.addElement(string);
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
        }
        this.refreshMappingFields(1, vector2);
        this.refreshMappingFields(2, vector3);
        this.refreshMappingFields(0, vector);
        if (this.getDimensionName == null) {
            this.getDimensionName = new Hashtable();
        }
        Hashtable hashtable = reportViewCenter.getCFFormulas(this.add);
        KeyReportView keyReportView = new KeyReportView(reportViewCenter.getRptCenter().getRptName(), reportViewCenter.getViewName());
        if (hashtable != null && !hashtable.isEmpty()) {
            this.getDimensionName.put(keyReportView, hashtable);
        } else {
            this.getDimensionName.remove(keyReportView);
        }
        if (this.getDimensions == null) {
            this.getDimensions = new Hashtable();
        }
        if ((hashtable = reportViewCenter.getFlyFormulas(this.add)) != null && !hashtable.isEmpty()) {
            this.getDimensions.put(keyReportView, hashtable);
        } else {
            this.getDimensions.remove(keyReportView);
        }
        Tools.logTrace(6, "End of DataSetCenter.refresh().");
    }

    private boolean addAll(String string) {
        if (this.addAll != null && this.addAll.contains(string)) {
            return true;
        }
        if (this.append != null && this.append.contains(string)) {
            return true;
        }
        return this.addMeasure != null && this.addMeasure.contains(string);
    }

    public void refreshCubeModel(ReportViewCenter reportViewCenter) {
        List list = reportViewCenter.getDataSetCubeViewInfo(this.add);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.getDataSet == null) {
            this.getDataSet = new CubeModel();
        }
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            boolean bl2 = false;
            if (e instanceof MDimensionDesc) {
                object = (MDimensionDesc)e;
                bl2 = this.getDataSet.addMeasure(((MDimensionDesc)object).getMdimensionName(), ((MDimensionDesc)object).getBasedFieldName(), ((MDimensionDesc)object).getFunctionType());
            } else {
                object = (DimensionDesc)e;
                bl2 = this.getDataSet.addDimension(((DimensionDesc)object).getDimensionName(), ((DimensionDesc)object).getBasedFieldName());
            }
            bl = bl || bl2;
            ++n;
        }
        if (bl) {
            this.setNeedInitCubeQuery(true);
            this.setNeedRefreshCube(true);
        }
    }

    public void refreshMappingFields(int n, Vector vector) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refreshMappingFields()..., type = " + n);
        }
        if (vector == null) {
            return;
        }
        Vector vector2 = null;
        switch (n) {
            case 0: {
                if (this.close.getMappingListType() == 0 && this.close.getMappingListSrc() != 3) {
                    Tools.logTrace(6, "not refresh db field because the type is all.");
                    return;
                }
                if (this.addAll == null) {
                    this.addAll = new Vector();
                }
                vector2 = this.addAll;
                break;
            }
            case 1: {
                if (this.addMeasure == null) {
                    this.addMeasure = new Vector();
                }
                vector2 = this.addMeasure;
                break;
            }
            case 2: {
                if (this.append == null) {
                    this.append = new Vector();
                }
                vector2 = this.append;
                break;
            }
            case 3: {
                if (this.clear == null) {
                    this.clear = new Vector();
                }
                vector2 = this.clear;
                break;
            }
            case 4: {
                if (this.clearAllColumnValues == null) {
                    this.clearAllColumnValues = new Vector();
                }
                vector2 = this.clearAllColumnValues;
                break;
            }
            default: {
                JRLog.error(3, "Invalid type: " + n);
                return;
            }
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            if (!vector2.contains(string)) {
                this.closeRawData = true;
                this.setNeedRefresh(true);
                vector2.addElement(string);
            }
            ++n2;
        }
    }

    public String[] getAllMappingName() {
        Vector vector = new Vector();
        Vector[] vectorArray = null;
        int n = this.close.getMappingListType();
        if (this.close.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.addMeasure, this.append, this.clear};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.addMeasure, this.append, this.clear};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.addMeasure, this.append, this.clear};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.addMeasure, this.append, this.clear};
        }
        if (vectorArray != null) {
            int n2 = 0;
            while (n2 < vectorArray.length) {
                if (vectorArray[n2] != null) {
                    int n3 = 0;
                    while (n3 < vectorArray[n2].size()) {
                        Object e = vectorArray[n2].elementAt(n3);
                        if (!vector.contains(e)) {
                            vector.addElement(e);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return vector.toArray(new String[0]);
    }

    public String[] getDbFieldFormulaMappingNames() {
        return this.getDbFieldFormulaMappingNames(true);
    }

    public String[] getMappingNames(int n) {
        int n2;
        Vector vector = new Vector();
        Vector[] vectorArray = null;
        block0 : switch (n) {
            case 0: {
                if (this.close.getMappingListSrc() == 1) {
                    n2 = this.close.getMappingListType();
                    switch (n2) {
                        case 0: {
                            vectorArray = new Vector[]{this.addElement};
                            break block0;
                        }
                        case 2: {
                            vectorArray = new Vector[]{this.addAll, this.addDimension};
                            break block0;
                        }
                        case 1: {
                            vectorArray = new Vector[]{this.addAll};
                            break block0;
                        }
                    }
                    return null;
                }
                vectorArray = new Vector[]{this.addAll};
                break;
            }
            case 1: {
                vectorArray = new Vector[]{this.addMeasure};
                break;
            }
            case 2: {
                vectorArray = new Vector[]{this.append};
                break;
            }
            case 3: {
                vectorArray = new Vector[]{this.clear};
                break;
            }
            case 4: {
                vectorArray = new Vector[]{this.clearAllColumnValues};
                break;
            }
            default: {
                return null;
            }
        }
        if (vectorArray != null) {
            n2 = 0;
            while (n2 < vectorArray.length) {
                if (vectorArray[n2] != null) {
                    vector.addAll(vectorArray[n2]);
                }
                ++n2;
            }
        }
        return vector.toArray(new String[0]);
    }

    public JetRptFormula[] getConstantFormulas(JetUUniverse jetUUniverse, Hashtable hashtable) {
        return this.addElement(this.clear, jetUUniverse, hashtable);
    }

    private JetRptFormula[] addDimension(JetUUniverse jetUUniverse, Hashtable hashtable) {
        return this.addElement(this.clearAllColumnValues, jetUUniverse, hashtable);
    }

    private JetRptFormula[] addElement(Vector vector, JetUUniverse jetUUniverse, Hashtable hashtable) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        String string = this.close.getDataSourceName();
        Vector vector2 = jetUUniverse.getFormulasInDatabase(string);
        JetRptFormula[] jetRptFormulaArray = new JetRptFormula[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            JetUFormula jetUFormula;
            Object object;
            String string2 = (String)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                object = (JetUFormula)vector2.elementAt(n2);
                if (string2.equalsIgnoreCase(((JetUResourceEntity)object).getResourceNameInUpperCase())) {
                    jetRptFormulaArray[n] = ((JetUFormula)object).createJetRptFormula();
                    break;
                }
                ++n2;
            }
            if (jetRptFormulaArray[n] == null && (jetUFormula = (JetUFormula)hashtable.get(object = string2.toUpperCase())) != null) {
                jetRptFormulaArray[n] = jetUFormula.createJetRptFormula();
            }
            ++n;
        }
        return jetRptFormulaArray;
    }

    public JetRptFormula[] getConstantGlobalFormulas(JetUUniverse jetUUniverse, Hashtable hashtable) {
        JetRptFormula[] jetRptFormulaArray;
        int n;
        JetRptFormula[] jetRptFormulaArray2 = this.getConstantFormulas(jetUUniverse, hashtable);
        int n2 = jetRptFormulaArray2 == null ? 0 : jetRptFormulaArray2.length;
        int n3 = n2 + (n = (jetRptFormulaArray = this.addDimension(jetUUniverse, hashtable)) == null ? 0 : jetRptFormulaArray.length);
        if (n3 == 0) {
            return null;
        }
        JetRptFormula[] jetRptFormulaArray3 = new JetRptFormula[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            jetRptFormulaArray3[n4] = jetRptFormulaArray2[n5];
            ++n5;
            ++n4;
        }
        int n6 = 0;
        while (n6 < n) {
            jetRptFormulaArray3[n4] = jetRptFormulaArray[n6];
            ++n6;
            ++n4;
        }
        return jetRptFormulaArray3;
    }

    public boolean hasUsed() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.hasUsed()..., dataSetCenter: " + this + " hasUsed: " + this.elementAt);
        }
        return this.elementAt;
    }

    public void setHasUsed(boolean bl) {
        this.elementAt = bl;
    }

    public boolean hasData() {
        Vector[] vectorArray = null;
        int n = this.close.getMappingListType();
        if (this.close.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.addMeasure, this.append, this.clear, this.clearAllColumnValues};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.addMeasure, this.append, this.clear, this.clearAllColumnValues};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.addMeasure, this.append, this.clear, this.clearAllColumnValues};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.addMeasure, this.append, this.clear, this.clearAllColumnValues};
        }
        int n2 = 0;
        while (n2 < vectorArray.length) {
            if (vectorArray[n2] != null && vectorArray[n2].size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasDbFieldOrPass1Formula() {
        String[] stringArray = this.getDbFieldPass1FormulaNames();
        return stringArray != null && stringArray.length > 0;
    }

    public String[] getDbFieldPass1FormulaNames() {
        Tools.logTrace(6, "DataSetCenter.getDbFieldPass1FormulaNames()...");
        Vector[] vectorArray = null;
        int n = this.close.getMappingListType();
        if (this.close.getMappingListSrc() == 1) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set mapping list src: data_query.");
                JRLog.trace(6, "data set mapping list type: 0");
            }
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.append};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.append};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.append};
                    break;
                }
            }
        } else {
            Tools.logTrace(6, "data set mapping list src: others.");
            vectorArray = new Vector[]{this.addAll, this.append};
        }
        Vector vector = new Vector();
        if (vectorArray != null) {
            int n2 = 0;
            while (n2 < vectorArray.length) {
                if (vectorArray[n2] != null) {
                    vector.addAll(vectorArray[n2]);
                }
                ++n2;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getDbFieldPass1FormulaNames(), return: " + vector);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean hasConstantFormula() {
        return this.clear != null && !this.clear.isEmpty();
    }

    private boolean addMeasure() {
        return this.clearAllColumnValues != null && !this.clearAllColumnValues.isEmpty();
    }

    public boolean hasConstantGlobalFormula() {
        return this.hasConstantFormula() || this.addMeasure();
    }

    public String[] getConstantGlobalFormulaNames() {
        Tools.logTrace(6, "DataSetCenter.getConstantGlobalFormulaNames()...");
        String[] stringArray = this.clear == null ? new String[]{} : this.clear.toArray(new String[this.clear.size()]);
        String[] stringArray2 = this.clearAllColumnValues == null ? new String[]{} : this.clearAllColumnValues.toArray(new String[this.clearAllColumnValues.size()]);
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = n + n2;
        if (n3 == 0) {
            return null;
        }
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            stringArray3[n4] = stringArray[n5];
            ++n5;
            ++n4;
        }
        int n6 = 0;
        while (n6 < n2) {
            stringArray3[n4] = stringArray2[n6];
            ++n6;
            ++n4;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getConstantGlobalFormulaNames(), return: " + Tools.toString(stringArray3));
        }
        return stringArray3;
    }

    public void setDataSetGroupQuery(String string, JGroupQuery jGroupQuery) {
        if (this.getBurstingKeyColumn == null) {
            this.getBurstingKeyColumn = new HashMap();
        }
        GroupValueContainer groupValueContainer = new GroupValueContainer(this, jGroupQuery);
        this.getBurstingKeyColumn.put(string, groupValueContainer);
    }

    public List getDataSetValues(String string) {
        if (this.getBurstingKeyColumn == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingKeyColumn.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.C();
    }

    public void setDataSetValues(String string, List list) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingKeyColumn.get(string);
        groupValueContainer.I(list);
    }

    public Group getDataSetValueTree(String string) {
        if (this.getBurstingKeyColumn == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingKeyColumn.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.Z();
    }

    public void setDataSetValueTree(String string, Group group) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingKeyColumn.get(string);
        groupValueContainer.I(group);
    }

    public void setComponentGroupQuery(String string, JGroupQuery jGroupQuery) {
        if (this.getBurstingSchemas == null) {
            this.getBurstingSchemas = new HashMap();
        }
        GroupValueContainer groupValueContainer = new GroupValueContainer(this, jGroupQuery);
        this.getBurstingSchemas.put(string, groupValueContainer);
    }

    public List getComponentValues(String string) {
        if (this.getBurstingSchemas == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingSchemas.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.C();
    }

    public void setComponentValues(String string, List list) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingSchemas.get(string);
        groupValueContainer.I(list);
    }

    public Group getComponentValueTree(String string) {
        if (this.getBurstingSchemas == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingSchemas.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.Z();
    }

    public void setComponentValueTree(String string, Group group) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBurstingSchemas.get(string);
        groupValueContainer.I(group);
    }

    public boolean isNewDataSetValues() {
        return this.getBurstingRecipientSchema;
    }

    public void setNewDataSetValues(boolean bl) {
        this.getBurstingRecipientSchema = bl;
    }

    public boolean isNewComponentValues() {
        return this.getCFFormulas;
    }

    public void setNewComponentValues(boolean bl) {
        this.getCFFormulas = bl;
    }

    public void closeRawData() {
        Tools.logTrace(6, "DataSetCenter.closeRawData()...");
        this.getBurstingRecipientSchema = true;
        this.getCFFormulas = true;
        this.clearAllColumnValues();
        this.closeCubeData();
        if (this.getAdditionMappingNames != null) {
            if (JRLog.isTrace(6)) {
                try {
                    JRLog.trace(6, "close raw data query, id: " + this.getAdditionMappingNames.getQueryId());
                }
                catch (DSException dSException) {
                    // empty catch block
                }
            }
            this.append(this.getAdditionMappingNames);
            this.getAdditionMappingNames = null;
        }
        if (this.getBurstingDataSetNames != null) {
            if (JRLog.isTrace(6)) {
                try {
                    JRLog.trace(6, "close generate raw data query, id: " + this.getBurstingDataSetNames.getQueryId());
                }
                catch (DSException dSException) {
                    // empty catch block
                }
            }
            this.append(this.getBurstingDataSetNames);
            this.getBurstingDataSetNames = null;
        }
        this.closeRawData = true;
        this.setNeedRefresh(true);
        this.getBindInfo = true;
        Tools.logTrace(6, "End of DataSetCenter.closeRawData().");
    }

    public void closeCubeData() {
        Tools.logTrace(6, "DataSetCenter.closeCubeData()...");
        if (this.getDataSetCubeViewInfo != null) {
            if (JRLog.isTrace(6)) {
                try {
                    JRLog.trace(6, "close cube query, id: " + this.getDataSetCubeViewInfo.getQueryId());
                }
                catch (DSException dSException) {
                    // empty catch block
                }
            }
            this.append(this.getDataSetCubeViewInfo);
            this.getDataSetCubeViewInfo = null;
        }
        this.setNeedInitCubeQuery(true);
        this.setNeedRefreshCube(true);
        Tools.logTrace(6, "End of DataSetCenter.closeCubeData().");
    }

    private void append(JQuery jQuery) {
        try {
            jQuery.close();
        }
        catch (DSException dSException) {
            JRLog.error(3, dSException);
        }
    }

    public void clearAllColumnValues() {
        HashMap[] hashMapArray = new HashMap[]{this.getBurstingKeyColumn, this.getBurstingSchemas};
        int n = 0;
        while (n < hashMapArray.length) {
            if (hashMapArray[n] != null && !hashMapArray[n].isEmpty()) {
                Iterator iterator = hashMapArray[n].values().iterator();
                while (iterator.hasNext()) {
                    GroupValueContainer groupValueContainer = (GroupValueContainer)iterator.next();
                    try {
                        groupValueContainer.I().close();
                    }
                    catch (DSException dSException) {
                        JRLog.error(3, dSException);
                    }
                }
                hashMapArray[n].clear();
            }
            ++n;
        }
    }

    public void clearMem() {
        if (this.addAll != null) {
            this.addAll.clear();
            this.addAll = null;
        }
        if (this.addDimension != null) {
            this.addDimension.clear();
            this.addDimension = null;
        }
        if (this.addElement != null) {
            this.addElement.clear();
            this.addElement = null;
        }
        if (this.addMeasure != null) {
            this.addMeasure.clear();
            this.addMeasure = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        this.close = null;
        this.currentTimeMillis = null;
        if (this.createJetRptFormula != null) {
            this.createJetRptFormula = null;
        }
        this.equalsIgnoreCase = null;
        this.error = null;
        this.closeRawData();
        this.getAdditionMappingNames = null;
        this.getBurstingDataSetNames = null;
        if (this.getDbFields != null) {
            this.getDbFields.clear();
            this.getDbFields = null;
        }
    }

    public boolean isApplyBrowseFilter() {
        return this.getConstantFormulas;
    }

    public void setApplyBrowseFilter(boolean bl) {
        this.getConstantFormulas = bl;
    }

    public void setRawDataListener(DataSetListener dataSetListener) {
        this.getDataSetLogic = dataSetListener;
    }

    public DataSetListener getRawDataListener() {
        return this.getDataSetLogic;
    }

    public void setGeneralRawDataListener(DataSetListener dataSetListener) {
        this.getDataSetMappingFields = dataSetListener;
    }

    public DataSetListener getGeneralRawDataListener() {
        return this.getDataSetMappingFields;
    }

    public void refreshRecSecurity(String string, SecurityData securityData, SecurityContext securityContext, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refreshRecSecurity()..., userName: " + string + " secData: " + securityData + " secCxt: " + securityContext + " ignoreSecurity: " + bl);
        }
        if (bl) {
            this.equalsIgnoreCase = new JRecordSecurityContainer(true);
        } else {
            try {
                this.equalsIgnoreCase = new JRecordSecurityContainer(this.currentTimeMillis, this.close, string, securityData, securityContext);
            }
            catch (ParseException parseException) {
                JRLog.error(3, parseException);
                this.equalsIgnoreCase = new JRecordSecurityContainer();
            }
        }
        Tools.logTrace(6, "End of DataSetCenter.refreshRecSecurity().");
    }

    public void clear() {
        if (this.addAll != null) {
            this.addAll.clear();
            this.addAll = null;
        }
        if (this.addDimension != null) {
            this.addDimension.clear();
            this.addDimension = null;
        }
        if (this.addElement != null) {
            this.addElement.clear();
            this.addElement = null;
        }
        if (this.addMeasure != null) {
            this.addMeasure.clear();
            this.addMeasure = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.clearAllColumnValues != null) {
            this.clearAllColumnValues.clear();
            this.clearAllColumnValues = null;
        }
        this.getDataSet = null;
    }

    public void backupDataStatus(ReportSetCenter reportSetCenter) {
        this.getDataSourceName = new DataSetStatus(this, reportSetCenter, this.add);
    }

    public boolean hasBackupedDataStatus() {
        return this.getDataSourceName != null;
    }

    public boolean equalsForRawData(ReportSetCenter reportSetCenter) {
        return this.getDataSourceName == null ? false : this.getDataSourceName.I(reportSetCenter, this.add);
    }

    public String[] getDbFieldFormulaMappingNames(boolean bl) {
        Vector vector = new Vector();
        Vector[] vectorArray = null;
        int n = this.close.getMappingListType();
        if (this.close.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.append, this.clear};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.append, this.clear};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.append, this.clear};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.append, this.clear};
        }
        if (vectorArray != null) {
            int n2 = 0;
            while (n2 < vectorArray.length) {
                if (vectorArray[n2] != null) {
                    int n3 = 0;
                    while (n3 < vectorArray[n2].size()) {
                        Object e = vectorArray[n2].elementAt(n3);
                        if (!vector.contains(e)) {
                            vector.addElement(e);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        if (bl && this.getDbFieldFormulaMappingNames != null && !this.getDbFieldFormulaMappingNames.isEmpty()) {
            Iterator iterator = this.getDbFieldFormulaMappingNames.keySet().iterator();
            while (iterator.hasNext()) {
                PartialDataSet partialDataSet = (PartialDataSet)this.getDbFieldFormulaMappingNames.get(iterator.next());
                this.clear(vector, new String[][]{partialDataSet.getDbFields(), partialDataSet.getPass1Formulas(), partialDataSet.getPass2Formulas()});
            }
        }
        return vector.toArray(new String[0]);
    }

    private void clear(Vector vector, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                int n2 = 0;
                while (n2 < stringArray[n].length) {
                    String string = stringArray[n][n2];
                    if (!vector.contains(string)) {
                        vector.addElement(string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    Vector I(int[] nArray) {
        Vector vector = new Vector();
        if (nArray != null && nArray.length > 0 && this.getDbFieldFormulaMappingNames != null && !this.getDbFieldFormulaMappingNames.isEmpty()) {
            Iterator iterator = this.getDbFieldFormulaMappingNames.keySet().iterator();
            while (iterator.hasNext()) {
                PartialDataSet partialDataSet = (PartialDataSet)this.getDbFieldFormulaMappingNames.get(iterator.next());
                String[][] stringArray = new String[nArray.length][];
                int n = 0;
                while (n < nArray.length) {
                    switch (nArray[n]) {
                        case 0: {
                            stringArray[n] = partialDataSet.getDbFields();
                            break;
                        }
                        case 1: {
                            stringArray[n] = partialDataSet.getParameters();
                            break;
                        }
                        case 2: {
                            stringArray[n] = partialDataSet.getPass1Formulas();
                            break;
                        }
                        case 5: {
                            stringArray[n] = partialDataSet.getPass2Formulas();
                            break;
                        }
                        case 3: {
                            stringArray[n] = partialDataSet.getConstantFormulas();
                            break;
                        }
                        case 4: {
                            stringArray[n] = partialDataSet.getGlobalFormulas();
                            break;
                        }
                        case 6: {
                            stringArray[n] = partialDataSet.getGroupFormulas();
                            break;
                        }
                    }
                    ++n;
                }
                this.clear(vector, stringArray);
            }
        }
        return vector;
    }

    public void setDataBlock(DataBlock dataBlock) {
        this.getDbFieldPass1FormulaNames = dataBlock;
    }

    public DataBlock getDataBlock() {
        return this.getDbFieldPass1FormulaNames;
    }

    public void cacheDisplayNameValues(Map map) {
        if (map != null) {
            this.getDbFields = new HashMap();
            this.getDbFields.putAll(map);
        }
    }

    public Hashtable getCachedDisplayNameValues() {
        if (this.getDbFields == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.getDbFields);
        return hashtable;
    }

    public boolean hasCachedDisplayNameValues() {
        return this.getDbFields != null;
    }

    public void clearCachedDisplayNameValuese() {
        this.getDbFields = null;
    }

    private class DataSetStatus {
        private int[] QOIV;
        private String[][] addElement;
        private CubeModel append;
        private int equals;
        private int error;
        private int get;
        private String getCatalogName;
        private String getCubeModel;
        private String getDataDriver;
        private String getDataSet;
        private String getDataSetCenter;
        private JRecordSecurityContainer getDataSourceName;
        private boolean getIExpression;
        private final DataSetCenter this$0;

        DataSetStatus(DataSetCenter dataSetCenter, ReportSetCenter reportSetCenter, String string) {
            this.this$0 = dataSetCenter;
            this.QOIV = new int[]{0, 1, 2, 3, 4};
            this.append = null;
            this.equals = -1;
            this.error = -1;
            this.get = -1;
            this.getCatalogName = null;
            this.getCubeModel = null;
            this.getDataDriver = null;
            this.getDataSet = "";
            this.getDataSetCenter = null;
            this.getDataSourceName = null;
            this.getIExpression = false;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DataSetStatus()... rptSetCenter: " + reportSetCenter + " dataSetName: " + string);
            }
            DataSetCenter dataSetCenter2 = reportSetCenter.getDataSetCenter(string);
            this.addElement = new String[this.QOIV.length][];
            int n = 0;
            while (n < this.addElement.length) {
                this.addElement[n] = dataSetCenter2.getMappingNames(this.QOIV[n]);
                Arrays.sort(this.addElement[n]);
                ++n;
            }
            this.append = dataSetCenter2.getCubeModel();
            JetRptDataSet jetRptDataSet = dataSetCenter2.getDataSet();
            this.equals = jetRptDataSet.maxRecords.get();
            this.error = jetRptDataSet.maxPageNumber.get();
            this.get = jetRptDataSet.recordsPerPage.get();
            this.getCatalogName = jetRptDataSet.getDataSourceName();
            this.getCubeModel = jetRptDataSet.getQueryName();
            this.getDataDriver = jetRptDataSet.getCatalogName();
            IExpression iExpression = null;
            try {
                iExpression = jetRptDataSet.getIExpression();
                this.getDataSet = iExpression == null ? "" : iExpression.toExpString();
            }
            catch (ConditionException conditionException) {
                JRLog.error(2, conditionException);
            }
            this.getDataSetCenter = reportSetCenter.getDataDriver(string);
            this.getDataSourceName = dataSetCenter2.getSecContainer();
            this.getIExpression = jetRptDataSet.hasRecSec();
            Tools.logTrace(6, "End of DataSetStatus().");
        }

        boolean I(ReportSetCenter reportSetCenter, String string) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DataSetCenter.equalsForRawData()... rptSetCenter: " + reportSetCenter + " dataSetName: " + string);
            }
            DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(string);
            String[][] stringArrayArray = new String[this.QOIV.length][];
            int n = 0;
            while (n < stringArrayArray.length) {
                stringArrayArray[n] = dataSetCenter.getMappingNames(this.QOIV[n]);
                Arrays.sort(stringArrayArray[n]);
                if (!this.addElement(stringArrayArray[n], this.addElement[n])) {
                    Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), names don't equals, return false!");
                    return false;
                }
                ++n;
            }
            JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
            if (this.equals != jetRptDataSet.maxRecords.get()) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), maxRecords don't equals, return false!");
                return false;
            }
            if (this.error != jetRptDataSet.maxPageNumber.get()) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), maxPageNumber don't equals, return false!");
                return false;
            }
            if (this.get != jetRptDataSet.recordsPerPage.get()) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), recordsPerPage don't equals, return false!");
                return false;
            }
            if (!this.getCatalogName.equals(jetRptDataSet.getDataSourceName())) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), dataSourceName don't equals, return false!");
                return false;
            }
            if (!this.getCubeModel.equals(jetRptDataSet.getQueryName())) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), queryName don't equals, return false!");
                return false;
            }
            if (!this.getDataDriver.equals(jetRptDataSet.getCatalogName())) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), catalogName don't equals, return false!");
                return false;
            }
            try {
                if (!this.getDataSet.equals(jetRptDataSet.getIExpression() == null ? "" : jetRptDataSet.getIExpression().toExpString())) {
                    Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), filter don't equals, return false!");
                    return false;
                }
            }
            catch (ConditionException conditionException) {
                JRLog.error(2, conditionException);
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), throw exception, return false!");
                return false;
            }
            String string2 = reportSetCenter.getDataDriver(string);
            if (!this.QOIV(this.getDataSetCenter, string2)) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), dataDriver don't equals, return false!");
                return false;
            }
            if (this.getIExpression || this.getIExpression != jetRptDataSet.hasRecSec()) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), hasRecordSecurity don't equals, return false!");
                return false;
            }
            Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), return true!");
            return true;
        }

        private boolean QOIV(String string, String string2) {
            if (string != null && string2 == null || string == null && string2 != null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return string.equals(string2);
        }

        private boolean addElement(String[] stringArray, String[] stringArray2) {
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            if (stringArray.length == 0) {
                return true;
            }
            List list = this.append(stringArray);
            List list2 = this.append(stringArray2);
            return list.equals(list2);
        }

        private List append(String[] stringArray) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            return vector;
        }
    }

    class GroupValueContainer {
        private JGroupQuery QOIV;
        private Group I;
        private List Z;
        private final DataSetCenter this$0;

        GroupValueContainer(DataSetCenter dataSetCenter, JGroupQuery jGroupQuery) {
            this.this$0 = dataSetCenter;
            this.QOIV = null;
            this.I = null;
            this.Z = null;
            this.QOIV = jGroupQuery;
        }

        JGroupQuery I() {
            return this.QOIV;
        }

        void I(Group group) {
            this.I = group;
        }

        Group Z() {
            return this.I;
        }

        void I(List list) {
            this.Z = list;
        }

        List C() {
            return this.Z;
        }
    }
}

