/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.jdbc.obj.ObjectDriver;
import com.jinfonet.util.loader.DynamicClassManager;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.Env;
import jet.JResource;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.exception.ParseFormulaFailedException;
import jet.export.style.StyleToXSD;
import jet.formula.FormulaClassLoader;
import jet.formula.JavaFormula;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.jetc.WriteFailureException;
import jet.log.JRLogger;
import jet.universe.ConnectionDesc;
import jet.universe.DocObject;
import jet.universe.JetUAcl;
import jet.universe.JetUBuildInClassNode;
import jet.universe.JetUClassTreeNode;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUDocFolder;
import jet.universe.JetUDocNode;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUStyleGroup;
import jet.universe.JetUSummary;
import jet.universe.JetUTableView;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWherePortion;
import jet.universe.JetUWorkingSet;
import jet.universe.QueryFieldDesc;
import jet.universe.UUniverseListener;
import jet.universe.UniverseEditor;
import jet.universe.cp_info;
import jet.universe.exception.AddTableViewException;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.DocException;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.InvalidEntityException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.exception.UniverseFileException;
import jet.universe.psql.BadFileQueryException;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.util.FileUtil;
import jet.util.Filter;
import jet.util.TreeIterater;
import jet.util.WildcardMatcher;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.ParameterInfo;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.api.SQLNameAnalyser;
import toolkit.db.api.SQLStmtCreator;

public class JetUUniverse
extends JetUTree
implements JetRootable {
    public static final String CAT_FILE_EXTENSION = ".cat";
    public static final String CAT_FILE_WILDCARD = "*.cat";
    public static final String BACKUP_FILE_EXTENSION = ".backup";
    public static final String FORMULA_FILE_EXTENSION = ".fml";
    public static final String PREJOIN_FILE_EXTENSION = ".pre";
    private static final FormulaClassLoader AfterAdd;
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_VIEW = 2;
    public static final int TYPE_ALIAS = 4;
    public static final int TYPE_SYNONYM = 8;
    public JetString name = new JetString(this, "Name");
    public JetString description = new JetString(this, "Description");
    public JetString version = new JetString(this, "Version");
    public JetNumber versionNumber = new JetNumber(this, "VersionNumber");
    private int BuildDefaultUniverse = 65553;
    private File C = null;
    protected transient boolean bIsModified = false;
    protected static JetUUniverse curUniverse;
    protected static Vector listeners;
    private Hashtable Closing = new Hashtable();
    private Hashtable DataType = null;
    private Hashtable FormulaModified = new Hashtable();
    private Hashtable GetCurrentUniverse = new Hashtable();
    boolean GetQueryByResourceName;
    Hashtable InitAfterCreate = new Hashtable();
    boolean InitAfterLoad;
    Hashtable IsFileQueryNameOK = new Hashtable();
    boolean IsMappingNameExist;
    private Class IsModified = null;
    private Hashtable IsQueryNameExist = new Hashtable();
    private JetUParameter[] LoadNoCache = null;
    private Hashtable LoadUniverse = new Hashtable();
    private Class OpenUniverse = null;
    private Hashtable QOIV = new Hashtable();
    public JetString timeZone = new JetString(this, "TimeZone");
    private JetUParameter[] Save = null;
    private Hashtable SaveToJetFile = new Hashtable();
    public UniverseEditor editor = null;
    private String Searchable;
    public boolean isCatalogPrepareOK = false;
    public JetUStyleGroup root = null;
    private static JRLogger UniverseChanged;
    private static Object UniverseClosing;
    private int UniverseNameChanged = 0;
    private boolean add = false;
    private boolean addAcl = false;
    private String addConnection = "";
    private static final HashMap addDataSource;
    static Class class$jet$universe$JetUUniverse;
    static final boolean $assertionsDisabled;

    public JetUUniverse() {
        this.versionNumber.set(4);
    }

    public JetUUniverse(String string) {
        this();
        this.setFullFileName(new File(string));
    }

    public void setSingleThread(boolean bl) {
        this.IsMappingNameExist = bl;
    }

    public boolean getSingleThread() {
        return this.IsMappingNameExist;
    }

    public void afterInit() {
        super.afterInit();
        this.InitAfterLoad();
        this.BuildDefaultUniverse = 65553;
    }

    public void InitAfterCreate() {
        this.version.set("single-user");
        JetUDatabase jetUDatabase = new JetUDatabase();
        this.add(jetUDatabase);
        jetUDatabase.InitAfterCreate();
        JetUDocFolder jetUDocFolder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(jetUDocFolder);
        this.isCatalogPrepareOK = true;
    }

    public void InitAfterLoad() {
        JetUConnection jetUConnection;
        String string;
        Object object;
        Vector vector = this.getAllDatabases();
        if (this.C != null) {
            object = null;
            int n = 0;
            while (n < vector.size()) {
                string = ((JetUDatabase)vector.elementAt(n)).getResourceName();
                object = this.getFMLFile(string);
                if (((File)object).exists() && this.isFMLFileMatch((File)object, string)) {
                    this.FormulaModified.put(string, object);
                }
                this.InitAfterCreate.put(string, new Boolean(false));
                this.IsFileQueryNameOK.put(string, new Boolean(false));
                ++n;
            }
        }
        this.GetQueryByResourceName = false;
        this.InitAfterLoad = false;
        this.setModified(false);
        if (this.versionNumber.get() < 4) {
            this.updateVersion();
        }
        if (this.BuildDefaultUniverse < 65552) {
            this.GetQueryByResourceName = true;
            this.FormulaModified.clear();
        }
        if ((object = this.getDatabase()) != null && (jetUConnection = ((JetUDatabase)object).getConnection()) != null && jetUConnection instanceof JetUJDBCConnection) {
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
            this.$assertionsDisabled(jetUJDBCConnection.sqlStmtCreator.get(), "SQLStmtCreator", false);
            this.$assertionsDisabled(jetUJDBCConnection.sqlNameAnalyser.get(), "SQLNameAnalyser", false);
        }
        int n = 0;
        while (n < vector.size()) {
            object = (JetUDatabase)vector.elementAt(n);
            string = ((JetUDBTreeNode)object).getResourceName();
            JetUConnection jetUConnection2 = ((JetUDatabase)object).getConnection();
            if (jetUConnection2 != null && jetUConnection2 instanceof JetUJDBCConnection) {
                JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection2;
                jetUJDBCConnection.conFlag = 0;
                JetUParameter[] jetUParameterArray = this.AfterAdd(jetUJDBCConnection.sqlStmtCreator.get(), "SQLStmtCreator", string, false);
                if (jetUParameterArray != null) {
                    this.SaveToJetFile.put(string, jetUParameterArray);
                }
                if ((jetUParameterArray = this.AfterAdd(jetUJDBCConnection.sqlNameAnalyser.get(), "SQLNameAnalyser", string, false)) != null) {
                    this.LoadUniverse.put(string, jetUParameterArray);
                }
            }
            ++n;
        }
        this.isCatalogPrepareOK = true;
        if (UniverseChanged.isDebugEnabled()) {
            UniverseChanged.outLine("Catalog\nCatalog version is: " + String.valueOf(this.versionNumber.get()));
        }
    }

    private void $assertionsDisabled(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        if (stringTokenizer.countTokens() > 0) {
            if (string2.equals("SQLStmtCreator")) {
                this.Save = new JetUParameter[stringTokenizer.countTokens() - 1];
            } else if (string2.equals("SQLNameAnalyser")) {
                this.LoadNoCache = new JetUParameter[stringTokenizer.countTokens() - 1];
            }
            int n = 0;
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (bl2) {
                    bl2 = false;
                    if (string3 != null && string3.trim().length() != 0) {
                        if (!bl) continue;
                        try {
                            if (string2.equals("SQLStmtCreator")) {
                                this.OpenUniverse = Class.forName(string3.trim());
                                continue;
                            }
                            if (!string2.equals("SQLNameAnalyser")) continue;
                            this.IsModified = Class.forName(string3.trim());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (!UniverseChanged.isErrorEnabled()) continue;
                            UniverseChanged.error("", classNotFoundException);
                        }
                        continue;
                    }
                    return;
                }
                JetUResourceEntity jetUResourceEntity = this.getResourceByName((string3 = string3.substring(1).trim().toUpperCase()).toUpperCase());
                if (jetUResourceEntity instanceof JetUParameter) {
                    if (string2.equals("SQLStmtCreator")) {
                        this.Save[n++] = (JetUParameter)jetUResourceEntity;
                        continue;
                    }
                    if (!string2.equals("SQLNameAnalyser")) continue;
                    this.LoadNoCache[n++] = (JetUParameter)jetUResourceEntity;
                    continue;
                }
                if (!UniverseChanged.isErrorEnabled()) continue;
                UniverseChanged.error("", new Exception("Can not find parameter '" + string3 + "'!"));
            }
        }
    }

    private JetUParameter[] AfterAdd(String string, String string2, String string3, boolean bl) {
        JetUParameter[] jetUParameterArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        if (stringTokenizer.countTokens() > 0) {
            jetUParameterArray = new JetUParameter[stringTokenizer.countTokens() - 1];
            int n = 0;
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (bl2) {
                    bl2 = false;
                    if (string4 != null && string4.trim().length() != 0) {
                        if (!bl) continue;
                        try {
                            Class<?> clazz;
                            if (string2.equals("SQLStmtCreator")) {
                                clazz = Class.forName(string4.trim());
                                this.QOIV.put(string3, clazz);
                                continue;
                            }
                            if (!string2.equals("SQLNameAnalyser")) continue;
                            clazz = Class.forName(string4.trim());
                            this.LoadUniverse.put(string3, clazz);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (!UniverseChanged.isErrorEnabled()) continue;
                            UniverseChanged.error("", classNotFoundException);
                        }
                        continue;
                    }
                    return null;
                }
                JetUResourceEntity jetUResourceEntity = this.getMaterialByName(string3, (string4 = string4.substring(1).trim().toUpperCase()).toUpperCase());
                if (jetUResourceEntity instanceof JetUParameter) {
                    jetUParameterArray[n++] = (JetUParameter)jetUResourceEntity;
                    continue;
                }
                if (!UniverseChanged.isErrorEnabled()) continue;
                UniverseChanged.error("", new Exception("Can not find parameter '" + string4 + "'!"));
            }
        }
        return jetUParameterArray;
    }

    public SQLNameAnalyser createSQLNameAnalyser() {
        block5: {
            if (this.IsModified != null) {
                try {
                    return (SQLNameAnalyser)this.IsModified.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (UniverseChanged.isErrorEnabled()) {
                        UniverseChanged.error("", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!UniverseChanged.isErrorEnabled()) break block5;
                    UniverseChanged.error("", illegalAccessException);
                }
            }
        }
        return null;
    }

    public SQLNameAnalyser createSQLNameAnalyser(String string) {
        block5: {
            Class clazz = (Class)this.IsQueryNameExist.get(string);
            if (clazz != null) {
                try {
                    return (SQLNameAnalyser)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (UniverseChanged.isErrorEnabled()) {
                        UniverseChanged.error("", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!UniverseChanged.isErrorEnabled()) break block5;
                    UniverseChanged.error("", illegalAccessException);
                }
            }
        }
        return null;
    }

    public SQLStmtCreator createSQLStmtCreator() {
        block6: {
            JetUJDBCConnection jetUJDBCConnection;
            JetUDatabase jetUDatabase = this.getDatabase();
            if (jetUDatabase != null && (jetUJDBCConnection = (JetUJDBCConnection)jetUDatabase.getConnection()) != null) {
                this.$assertionsDisabled(jetUJDBCConnection.sqlStmtCreator.get(), "SQLStmtCreator", true);
            }
            if (this.OpenUniverse != null) {
                try {
                    return (SQLStmtCreator)this.OpenUniverse.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (UniverseChanged.isErrorEnabled()) {
                        UniverseChanged.error("", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!UniverseChanged.isErrorEnabled()) break block6;
                    UniverseChanged.error("", illegalAccessException);
                }
            }
        }
        return null;
    }

    public SQLStmtCreator createSQLStmtCreator(String string) {
        block8: {
            Object object;
            Vector vector = this.getAllDatabases();
            int n = 0;
            while (n < vector.size()) {
                JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n);
                String string2 = jetUDatabase.getResourceName();
                object = null;
                if (jetUDatabase.getConnection() instanceof JetUJDBCConnection) {
                    object = (JetUJDBCConnection)jetUDatabase.getConnection();
                }
                if (object != null) {
                    this.AfterAdd(((JetUJDBCConnection)object).sqlStmtCreator.get(), "SQLStmtCreator", string2, true);
                }
                ++n;
            }
            object = (Class)this.QOIV.get(string);
            if (object != null) {
                try {
                    return (SQLStmtCreator)((Class)object).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (UniverseChanged.isErrorEnabled()) {
                        UniverseChanged.error("", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!UniverseChanged.isErrorEnabled()) break block8;
                    UniverseChanged.error("", illegalAccessException);
                }
            }
        }
        return null;
    }

    protected void updateVersion() {
        JetUTreeNode jetUTreeNode;
        JetUDatabase jetUDatabase;
        int n = this.versionNumber.get();
        Vector vector = this.getAllDatabases();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            block18: {
                jetUDatabase = (JetUDatabase)vector.elementAt(n3);
                if (jetUDatabase != null) {
                    block17: {
                        if (n <= 0) {
                            try {
                                jetUDatabase.parseFormulas(false);
                            }
                            catch (ParseFormulaFailedException parseFormulaFailedException) {
                                if (!UniverseChanged.isDebugEnabled()) break block17;
                                UniverseChanged.debug(parseFormulaFailedException);
                            }
                        }
                    }
                    if (n <= 1 && (jetUTreeNode = jetUDatabase.getConnection()) != null) {
                        try {
                            ((JetUConnection)jetUTreeNode).fetchSupportInfo();
                        }
                        catch (SQLException sQLException) {
                            if (UniverseChanged.isDebugEnabled()) {
                                UniverseChanged.debug(sQLException);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (!UniverseChanged.isDebugEnabled()) break block18;
                            UniverseChanged.debug(classNotFoundException);
                        }
                    }
                }
            }
            ++n3;
        }
        if (n <= 2) {
            jetUTreeNode = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
            this.add(jetUTreeNode);
        }
        if (n <= 3) {
            int n4 = 0;
            while (n4 < n2) {
                jetUDatabase = (JetUDatabase)vector.elementAt(n4);
                JetUConnection jetUConnection = jetUDatabase.getConnection();
                if (jetUConnection != null) {
                    Vector<JetObject> vector2 = new Vector<JetObject>();
                    Vector vector3 = jetUConnection.getChildren();
                    int n5 = vector3.size();
                    JetObject jetObject = null;
                    int n6 = 0;
                    while (n6 < n5) {
                        jetObject = (JetObject)vector3.elementAt(n6);
                        if (jetObject instanceof JetUUserDataSource) {
                            vector2.addElement(jetObject);
                        }
                        ++n6;
                    }
                    JetUUserDataSource jetUUserDataSource = null;
                    int n7 = 0;
                    while (n7 < vector2.size()) {
                        jetUUserDataSource = (JetUUserDataSource)vector2.elementAt(n7);
                        jetUDatabase.add(jetUUserDataSource);
                        jetUUserDataSource.AfterAdd();
                        jetUConnection.remove((JetObject)vector2.elementAt(n7));
                        ++n7;
                    }
                }
                ++n4;
            }
        }
        this.versionNumber.set(4);
        this.setModified(true);
    }

    void BuildDefaultUniverse(Vector vector) throws FMLFileException {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            File file;
            JetUDatabase jetUDatabase;
            String string;
            block12: {
                string = (String)vector.elementAt(n2);
                jetUDatabase = this.getDatabase(string);
                file = (File)this.FormulaModified.get(string);
                bl = false;
                try {
                    bl = this.generateFormulaFile(string);
                    bl = true;
                }
                catch (GenerateFormulasCodeException generateFormulasCodeException) {
                    if (!UniverseChanged.isErrorEnabled()) break block12;
                    UniverseChanged.error("", generateFormulasCodeException);
                }
            }
            if (!bl && !$assertionsDisabled) {
                throw new AssertionError((Object)JResource.getMessage("CAT_FML_EXCP_3"));
            }
            if (((Boolean)this.InitAfterCreate.get(string)).booleanValue()) {
                file = (File)this.FormulaModified.get(string);
                File file2 = this.getFMLFile(string);
                boolean bl2 = file.getPath().equalsIgnoreCase(file2.getPath());
                bl = true;
                if (file2.exists() && !bl2) {
                    bl = file2.delete();
                }
                if (bl) {
                    try {
                        if (!bl2) {
                            FileUtil.copy(file, file2);
                        }
                        FileUtil.copy(file, file2);
                    }
                    catch (IOException iOException) {
                        throw new FMLFileException(file2.getPath());
                    }
                } else if (!bl2) {
                    throw new FMLFileException(file2.getPath());
                }
                this.InitAfterCreate.remove(string);
                this.InitAfterCreate.put(string, new Boolean(false));
            }
            jetUDatabase.I();
            ++n2;
        }
    }

    public void PrepareBeforeSaveForXMLCat() {
        Vector vector = this.getAllDatabases();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n2);
            String string = jetUDatabase.getResourceName();
            jetUDatabase.I();
            ++n2;
        }
    }

    void C() throws FMLFileException {
        Vector vector = this.getAllDatabases();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n2);
            String string = jetUDatabase.getResourceName();
            File file = (File)this.FormulaModified.get(string);
            if (this.C.getName().endsWith(CAT_FILE_EXTENSION) || this.C.getName().endsWith(".cat.xml")) {
                if (file == null || !file.exists() || jetUDatabase.isNeedGenerateJava()) {
                    boolean bl;
                    block14: {
                        bl = false;
                        try {
                            bl = this.generateFormulaFile(string);
                            bl = true;
                        }
                        catch (GenerateFormulasCodeException generateFormulasCodeException) {
                            if (!UniverseChanged.isErrorEnabled()) break block14;
                            UniverseChanged.error("", generateFormulasCodeException);
                        }
                    }
                    if (!bl && !$assertionsDisabled) {
                        throw new AssertionError((Object)JResource.getMessage("CAT_FML_EXCP_3"));
                    }
                }
                if (this.InitAfterCreate.get(string) == null || ((Boolean)this.InitAfterCreate.get(string)).booleanValue()) {
                    file = (File)this.FormulaModified.get(string);
                    File file2 = this.getFMLFile(string);
                    boolean bl = file.getPath().equalsIgnoreCase(file2.getPath());
                    boolean bl2 = true;
                    if (file2.exists() && !bl) {
                        bl2 = file2.delete();
                    }
                    if (bl2) {
                        try {
                            if (!bl) {
                                FileUtil.copy(file, file2);
                            }
                            FileUtil.copy(file, file2);
                        }
                        catch (IOException iOException) {
                            throw new FMLFileException(file2.getPath());
                        }
                    } else if (!bl) {
                        throw new FMLFileException(file2.getPath());
                    }
                    this.InitAfterCreate.remove(string);
                    this.InitAfterCreate.put(string, new Boolean(false));
                }
            }
            jetUDatabase.I();
            ++n2;
        }
    }

    void DataType() {
    }

    public void setName(String string) {
        this.name.set(string);
        this.IsQueryNameExist(this);
    }

    public String getName() {
        return this.name.get();
    }

    public String getDesc() {
        return this.description.get();
    }

    public void setDesc(String string) {
        this.description.set(string);
    }

    public boolean isSearchable(JetUResourceEntity jetUResourceEntity) {
        boolean bl = false;
        if (jetUResourceEntity != null) {
            DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
            bl = dbColDesc != null && this.GetCurrentUniverse(dbColDesc);
        }
        return bl;
    }

    public boolean isSearchable(String string, JetUResourceEntity jetUResourceEntity) {
        boolean bl = false;
        if (jetUResourceEntity != null) {
            DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
            bl = dbColDesc != null && this.GetQueryByResourceName(string, dbColDesc);
        }
        return bl;
    }

    boolean FormulaModified(JetUConnection jetUConnection, DbColDesc dbColDesc) {
        boolean bl = false;
        Vector vector = jetUConnection.getTypeInfo();
        int n = vector.size();
        JetUJDBCTypeInfo jetUJDBCTypeInfo = null;
        int n2 = 0;
        while (n2 < n) {
            jetUJDBCTypeInfo = (JetUJDBCTypeInfo)vector.elementAt(n2);
            int n3 = JetUConnection.mapColType(jetUJDBCTypeInfo.DataType.get());
            if (n3 == dbColDesc.sqlType) {
                short s = (short)jetUJDBCTypeInfo.Searchable.get();
                bl = s == 3 || s == 2;
                break;
            }
            ++n2;
        }
        return bl;
    }

    boolean GetCurrentUniverse(DbColDesc dbColDesc) {
        JetUConnection jetUConnection = this.getDatabase().getConnection();
        if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
            return this.FormulaModified((JetUJDBCConnection)jetUConnection, dbColDesc);
        }
        return false;
    }

    boolean GetQueryByResourceName(String string, DbColDesc dbColDesc) {
        JetUConnection jetUConnection = this.getDatabase(string).getConnection();
        if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
            return this.FormulaModified((JetUJDBCConnection)jetUConnection, dbColDesc);
        }
        return false;
    }

    public JetUDatabase getDatabase() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUDatabase) {
                return (JetUDatabase)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUDatabase getDatabase(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUDatabase && ((JetUDatabase)jetObject).name.get().equals(string)) {
                return (JetUDatabase)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public Vector getAllDatabases() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUDatabase) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public Vector getAllDatabaseNames() {
        Vector vector = this.getAllDatabases();
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(((JetUDatabase)vector.elementAt(n2)).getResourceName());
            ++n2;
        }
        return vector2;
    }

    public boolean hasHierDataSource() {
        boolean bl = false;
        Vector vector = this.getAllDatabases();
        if (vector != null && vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n);
                Vector vector2 = jetUDatabase.getHierDataSources();
                if (vector2 != null && vector2.size() > 0) {
                    return true;
                }
                ++n;
            }
        } else {
            return false;
        }
        return bl;
    }

    protected boolean createReportFolder(String string) throws DocException {
        JetUDocFolder jetUDocFolder = this.getDocumentTree();
        jetUDocFolder.addFolder(string);
        return true;
    }

    protected boolean createReportEntity(String string, String string2) throws DocException {
        return this.createReportEntity(string, string2, "", "", "", "", "", "", 0L, 0L, 0L);
    }

    protected boolean createReportEntity(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l, long l2, long l3) throws DocException {
        JetUDocFolder jetUDocFolder = this.getDocumentTree();
        this.createReportFolder(string);
        JetUDocNode jetUDocNode = this.getDocNodeByPath(string);
        if (jetUDocNode != null && jetUDocNode instanceof JetUDocFolder) {
            ((JetUDocFolder)jetUDocNode).addReport(string2, string3, string4, string5, string6, string7, string8, l, l2, l3);
            return true;
        }
        return false;
    }

    protected boolean renameTo(DocObject docObject, DocObject docObject2) {
        if (docObject2.exists()) {
            return false;
        }
        String string = docObject.getParent();
        String string2 = docObject2.getParent();
        if (string != null && string2 != null && string.equalsIgnoreCase(string2)) {
            JetUDocNode jetUDocNode = this.getDocNodeByPath(docObject.getPath());
            jetUDocNode.setName(docObject2.getName());
        }
        docObject2 = null;
        return true;
    }

    protected boolean deleteReport(DocObject docObject, boolean bl) {
        JetUDocNode jetUDocNode = this.getDocNodeByPath(docObject.getPath());
        if (jetUDocNode == null) {
            return false;
        }
        return jetUDocNode.delete(bl);
    }

    public JetUDocFolder getDocumentTree() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUDocFolder) {
                return (JetUDocFolder)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public Vector getAllDocFiles() {
        return this.getDocumentTree().getAllDocFiles();
    }

    public JetUDocNode getDocNodeByPath(String string) {
        JetUDocFolder jetUDocFolder = this.getDocumentTree();
        if (jetUDocFolder != null) {
            return jetUDocFolder.getChildByLocator(string);
        }
        return null;
    }

    public String getFullFileName() {
        String string = null;
        if (this.C == null) {
            return null;
        }
        try {
            string = this.C.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = this.C.getPath();
        }
        return string;
    }

    public String getFilePath() {
        return this.C != null ? this.C.getParent() + File.separator : "";
    }

    public void setFullFileName(File file) {
        int n;
        String string;
        Object object;
        Object object2;
        if (this.C != null && ((Vector)(object2 = this.getOdfFiles())).size() > 0 && !((String)(object = this.C.getParent())).equalsIgnoreCase(string = file.getParent())) {
            n = 0;
            while (n < ((Vector)object2).size()) {
                block5: {
                    String string2 = (String)((Vector)object2).elementAt(n);
                    try {
                        FileUtil.copyFile((String)object, string, new File(string2).getName());
                    }
                    catch (IOException iOException) {
                        if (!UniverseChanged.isErrorEnabled()) break block5;
                        UniverseChanged.error("", iOException);
                    }
                }
                ++n;
            }
        }
        this.C = new File(file.getParent(), file.getName());
        object2 = file.getName();
        this.setName(Env.getFileName((String)object2, 1));
        object = this.getAllDatabaseNames();
        n = 0;
        while (n < ((Vector)object).size()) {
            string = (String)((Vector)object).elementAt(n);
            this.setOOJDBCPath(string, this.InitAfterCreate(string));
            ++n;
        }
    }

    private String InitAfterCreate(String string) {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        if (jetUDatabase == null || jetUDatabase.getConnection() == null) {
            return "";
        }
        if (jetUDatabase.getConnection() instanceof JetUJDBCConnection) {
            return ((JetUJDBCConnection)jetUDatabase.getConnection()).getURL();
        }
        return "";
    }

    public void setOOJDBCPath(String string, String string2) {
        if (string2.startsWith("jdbc:jinfonet:object")) {
            this.InitAfterLoad(string, this.getFilePath(), string2);
        }
    }

    public Vector getOdfFiles() {
        Vector vector = this.getAllDatabaseNames();
        Vector<String> vector2 = new Vector<String>(1);
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = this.InitAfterCreate(string);
            if (string2.startsWith("jdbc:jinfonet:object")) {
                JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.getDatabase(string).getConnection();
                Driver driver = jetUJDBCConnection.getDriver();
                String string3 = ((ObjectDriver)driver).parseUrl(string2);
                if (string3 != null) {
                    vector2.addElement(string3);
                } else if (UniverseChanged.isErrorEnabled()) {
                    UniverseChanged.error("Fail to find the odf file of database " + string + "!");
                }
            }
            ++n;
        }
        return vector2;
    }

    private void InitAfterLoad(String string, String string2, String string3) {
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.getDatabase(string).getConnection();
        Driver driver = jetUJDBCConnection.getDriver();
        ((ObjectDriver)driver).setOdfPath(string2, string3);
    }

    public boolean isNeedUpdateFmlFile() {
        return this.GetQueryByResourceName;
    }

    public boolean isNeedUpdateFmlFile(String string) {
        Boolean bl = (Boolean)this.InitAfterCreate.get(string);
        return bl == null ? true : bl;
    }

    public boolean IsModified() {
        return this.bIsModified;
    }

    public void setModified(boolean bl) {
        this.bIsModified = bl;
    }

    public synchronized JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUClassTreeNode || jetObject instanceof JetUDatabase || jetObject instanceof JetUDocFolder)) {
            throw new AssertionError((Object)("Invalid child of JetUUniverse !" + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public boolean isNeedSaveCatalog() {
        Vector vector = this.getAllDatabaseNames();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            Boolean bl2 = (Boolean)this.InitAfterCreate.get(vector.elementAt(n));
            boolean bl3 = bl = bl2 == null ? true : bl2;
            if (bl) break;
            ++n;
        }
        return !this.C.exists() || this.IsModified() || this.isNeedUpdateFmlFile() || bl;
    }

    private boolean IsFileQueryNameOK() {
        String string = this.getFullFileName();
        File file = new File(string + BACKUP_FILE_EXTENSION);
        File file2 = new File(string);
        if (file.exists()) {
            file.delete();
        }
        boolean bl = true;
        if (file2.exists()) {
            bl = file2.renameTo(file);
        }
        return bl;
    }

    private void IsMappingNameExist() {
        block3: {
            if (this.root != null) {
                try {
                    new StyleToXSD(this.root, this.getFullFileName());
                }
                catch (Exception exception) {
                    if (!UniverseChanged.isErrorEnabled()) break block3;
                    UniverseChanged.error("", exception);
                }
            }
        }
    }

    public static Vector getStyleGroupNameList() {
        Vector vector = new Vector();
        JetUUniverse jetUUniverse = JetUUniverse.GetCurrentUniverse();
        if (jetUUniverse != null && jetUUniverse.root != null) {
            vector = jetUUniverse.root.getAllGroupNames(new Vector());
        }
        String string = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File file = new File(string);
        Filter filter = new Filter(file, "_stl.xsd");
        File[] fileArray = file.listFiles(filter);
        vector.add("None");
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            String string2 = fileArray[n].getName();
            String string3 = string2.substring(0, string2.lastIndexOf("_"));
            if (!vector.contains(string3)) {
                vector.add(string3);
            }
            ++n;
        }
        return vector;
    }

    public boolean Save() throws WriteFailureException, FMLFileException {
        boolean bl = true;
        this.C();
        this.IsFileQueryNameOK();
        this.SaveToJetFile(this.getFullFileName());
        Vector vector = this.getAllDatabaseNames();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            this.savePrejoin(string);
            ++n;
        }
        this.IsMappingNameExist();
        this.DataType();
        this.setModified(false);
        return bl;
    }

    public boolean Save(Vector vector) throws WriteFailureException, FMLFileException {
        boolean bl = true;
        this.BuildDefaultUniverse(vector);
        this.IsFileQueryNameOK();
        this.SaveToJetFile(this.getFullFileName());
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            this.savePrejoin(string);
            ++n;
        }
        this.IsMappingNameExist();
        this.DataType();
        this.setModified(false);
        return bl;
    }

    public boolean SaveNoParseFml() throws WriteFailureException {
        boolean bl = true;
        Vector vector = this.getAllDatabases();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n2);
            jetUDatabase.I();
            ++n2;
        }
        this.IsFileQueryNameOK();
        this.SaveToJetFile(this.getFullFileName());
        Vector vector2 = this.getAllDatabaseNames();
        int n3 = 0;
        while (n3 < vector2.size()) {
            String string = (String)vector2.elementAt(n3);
            this.savePrejoin(string);
            ++n3;
        }
        this.IsMappingNameExist();
        this.DataType();
        this.setModified(false);
        return bl;
    }

    public boolean Save(String string, String string2) throws WriteFailureException, FMLFileException {
        this.GetQueryByResourceName = true;
        Vector vector = this.getAllDatabaseNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (this.InitAfterCreate.get(string3) != null) {
                this.InitAfterCreate.remove(string3);
            }
            this.InitAfterCreate.put(string3, new Boolean(true));
            ++n;
        }
        this.setFullFileName(new File(string, string2));
        return this.Save();
    }

    public boolean Save(String string, String string2, Vector vector) throws WriteFailureException, FMLFileException {
        this.GetQueryByResourceName = false;
        Vector vector2 = this.getAllDatabaseNames();
        int n = 0;
        while (n < vector2.size()) {
            String string3 = (String)vector2.elementAt(n);
            if (this.InitAfterCreate.get(string3) != null) {
                this.InitAfterCreate.remove(string3);
            }
            if (vector.contains(string3)) {
                this.InitAfterCreate.put(string3, new Boolean(true));
            } else {
                this.InitAfterCreate.put(string3, new Boolean(false));
            }
            ++n;
        }
        this.setFullFileName(new File(string, string2));
        return this.Save(vector);
    }

    public static String getCatNameFromFileName(String string) {
        if (string.toLowerCase().endsWith(CAT_FILE_EXTENSION)) {
            return string.substring(0, string.lastIndexOf(46));
        }
        if (string.toLowerCase().endsWith(".cat.xml")) {
            return string.substring(0, string.length() - ".cat.xml".length());
        }
        return null;
    }

    public synchronized boolean SaveTo(File file) throws WriteFailureException, FMLFileException {
        String string = file.getParent() + File.separator;
        String string2 = file.getName();
        if (!string2.toLowerCase().endsWith(CAT_FILE_EXTENSION) && !string2.toLowerCase().endsWith(".cat.xml")) {
            throw new IllegalArgumentException("Catalog file name [" + string2 + "] is illegal, the Catalog file name must end with [.cat] or [.cat.xml]");
        }
        string2 = JetUUniverse.getCatNameFromFileName(string2);
        boolean bl = true;
        if (this.C == null) {
            this.setFullFileName(file);
        }
        this.C();
        if (string2 == null) {
            throw new WriteFailureException(32833, new String[]{string2}, null);
        }
        Vector vector = this.getAllDatabaseNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)vector.elementAt(n2);
            File file2 = (File)this.FormulaModified.get(string3);
            File file3 = new File(string + string2 + string3 + FORMULA_FILE_EXTENSION);
            try {
                FileUtil.copy(file2, file3);
            }
            catch (IOException iOException) {
                throw new FMLFileException(file3.getPath());
            }
            ++n2;
        }
        this.SaveToJetFile(file.getPath());
        this.DataType();
        return bl;
    }

    public void output(OutputStream outputStream) throws WriteFailureException {
        ReportLoader.save((JetObject)this, outputStream, "Catalog");
    }

    protected void SaveToJetFile(String string) throws WriteFailureException {
        ReportLoader reportLoader = new ReportLoader();
        ReportLoader.save((JetObject)this, "Catalog", string);
    }

    public JavaFormula loadJavaFormula() throws GenerateFormulasCodeException, ReadFailureException, ClassNotFoundException, FileNotFoundException, IOException, InstantiationException, IllegalAccessException, GenerateFormulasCodeException, LoadJavaFormulaException {
        return this.loadJavaFormula("");
    }

    protected Object loadJavaFormulaClass(String string, byte[] byArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LoadJavaFormulaException {
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        Class clazz = dynamicClassManager.bytesToClass(string, byArray);
        Object var5_5 = null;
        try {
            var5_5 = clazz.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (UniverseChanged.isErrorEnabled()) {
                UniverseChanged.error(this, noClassDefFoundError);
            }
            LoadJavaFormulaException loadJavaFormulaException = new LoadJavaFormulaException(1);
            loadJavaFormulaException.initCause(noClassDefFoundError);
            throw loadJavaFormulaException;
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JavaFormula loadJavaFormula(String string) throws GenerateFormulasCodeException, ReadFailureException, ClassNotFoundException, FileNotFoundException, IOException, InstantiationException, IllegalAccessException, GenerateFormulasCodeException, LoadJavaFormulaException {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        File file = (File)this.FormulaModified.get(string);
        byte[] byArray = null;
        byArray = (byte[])this.GetCurrentUniverse.get(string);
        Object object = UniverseClosing;
        synchronized (object) {
            if (file == null || jetUDatabase.isNeedGenerateJava()) {
                boolean bl = this.generateFormulaFile(string);
                if (UniverseChanged.isDebugEnabled()) {
                    UniverseChanged.info("generateFormulaFile returns: " + bl);
                }
                if (!bl) {
                    throw new LoadJavaFormulaException(2);
                }
                byArray = null;
            }
            if (byArray == null) {
                file = (File)this.FormulaModified.get(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                this.GetCurrentUniverse.put(string, byArray);
            }
        }
        return this.loadJavaFormula(byArray, string);
    }

    public JavaFormula loadJavaFormula(byte[] byArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, LoadJavaFormulaException {
        JetUDatabase jetUDatabase = this.getDatabase();
        String string = jetUDatabase.getCurFormulasFullClassName();
        JavaFormula javaFormula = (JavaFormula)this.loadJavaFormulaClass(string, byArray);
        return javaFormula;
    }

    public JavaFormula loadJavaFormula(byte[] byArray, String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, LoadJavaFormulaException {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        String string2 = jetUDatabase.getCurFormulasFullClassName();
        JavaFormula javaFormula = (JavaFormula)this.loadJavaFormulaClass(string2, byArray);
        return javaFormula;
    }

    public boolean savePrejoin() {
        return this.savePrejoin("");
    }

    public boolean savePrejoin(String string) {
        boolean bl = true;
        if (this.editor != null) {
            try {
                this.editor.saveToFile(string);
            }
            catch (WriteFailureException writeFailureException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean generateFormulaFile() throws GenerateFormulasCodeException {
        return this.generateFormulaFile("");
    }

    public boolean generateFormulaFile(String string) throws GenerateFormulasCodeException {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        String string2 = null;
        File file = null;
        boolean bl = false;
        jetUDatabase.generateFormulaCodes(true, false);
        string2 = jetUDatabase.getCurFormulasFullFileName();
        file = new File(string2);
        file.delete();
        String string3 = string2.substring(0, string2.length() - ".java".length());
        string3 = string3 + ".class";
        File file2 = new File(string3);
        if (file2.exists()) {
            File file3 = this.getFMLFile(string);
            if (this.IsFileQueryNameOK.get(string) != null && ((Boolean)this.IsFileQueryNameOK.get(string)).booleanValue() && file2 != null) {
                file3.delete();
            }
            bl = true;
            this.GetCurrentUniverse.remove(string);
            this.FormulaModified.remove(string);
            this.FormulaModified.put(string, file2);
            if (this.InitAfterCreate.get(string) != null) {
                this.InitAfterCreate.remove(string);
            }
            this.InitAfterCreate.put(string, new Boolean(true));
            if (this.IsFileQueryNameOK.get(string) != null) {
                this.IsFileQueryNameOK.remove(string);
            }
            this.IsFileQueryNameOK.put(string, new Boolean(true));
        }
        return bl;
    }

    public String reflectClasspath(ClassLoader classLoader, Class clazz) {
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = classLoader.getResource(string);
        String string2 = URLDecoder.decode(uRL.getPath());
        String string3 = uRL.getProtocol();
        if (string3.equals("jar") || string3.equals("wsjar") || string3.equals("zip")) {
            if (string2.startsWith("file:")) {
                string2 = string2.charAt(7) == ':' ? string2.substring(6) : string2.substring(5);
            }
            return string2.substring(0, string2.indexOf(33)).replace('/', File.separatorChar);
        }
        if (string2.length() >= 3 && string2.charAt(0) == '/' && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        return string2.substring(0, string2.length() - string.length()).replace('/', File.separatorChar);
    }

    public File getFMLFile() {
        String string = this.getFilePath() + this.getName() + FORMULA_FILE_EXTENSION;
        return new File(string);
    }

    public File getFMLFile(String string) {
        String string2 = this.getFilePath() + this.getName() + string + FORMULA_FILE_EXTENSION;
        return new File(string2);
    }

    public boolean isFMLFileMatch(File file) {
        JetUDatabase jetUDatabase = this.getDatabase();
        String string = jetUDatabase.getCurFormulasFullClassName();
        String string2 = JetUUniverse.getClassNameOfFMLFile(file);
        return string.equals(string2);
    }

    public boolean isFMLFileMatch(File file, String string) {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        String string2 = jetUDatabase.getCurFormulasFullClassName();
        String string3 = JetUUniverse.getClassNameOfFMLFile(file);
        return string2.equals(string3);
    }

    public static String getClassNameOfFMLFile(File file) {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
            dataInputStream.readInt();
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            int n = dataInputStream.readUnsignedShort();
            cp_info[] cp_infoArray = new cp_info[n];
            int n2 = 1;
            while (n2 < n) {
                cp_info cp_info2 = new cp_info();
                cp_info2.load(dataInputStream);
                cp_infoArray[n2] = cp_info2;
                switch (cp_info2.getTag()) {
                    case 5: 
                    case 6: {
                        ++n2;
                    }
                }
                ++n2;
            }
            dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            string = cp_infoArray[cp_infoArray[n3].getIndex0()].getUTF().replace('/', '.');
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public JetUWorkingSet getWorkingSetByName(String string) {
        return null;
    }

    public void objectModified() {
        this.setModified(true);
    }

    public static void addUniverseListener(UUniverseListener uUniverseListener) {
        if (!listeners.contains(uUniverseListener)) {
            listeners.addElement(uUniverseListener);
        }
    }

    public static void removeUniverseListener(UUniverseListener uUniverseListener) {
        if (listeners.contains(uUniverseListener)) {
            listeners.removeElement(uUniverseListener);
        }
    }

    public static void objectChanged(JetUUniverse jetUUniverse, JetUTreeNode jetUTreeNode, int n) {
        int n2 = listeners.size();
        int n3 = 0;
        while (n3 < n2) {
            ((UUniverseListener)listeners.elementAt(n3)).objectChanged(jetUUniverse, jetUTreeNode, n);
            ++n3;
        }
    }

    public static boolean isInUse(JetUUniverse jetUUniverse, JetUTreeNode jetUTreeNode, StringBuffer stringBuffer) {
        boolean bl = false;
        int n = listeners.size();
        int n2 = 0;
        while (n2 < n) {
            if (((UUniverseListener)listeners.elementAt(n2)).isInUse(jetUUniverse, jetUTreeNode, stringBuffer)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    protected static void Closing() {
        int n = listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((UUniverseListener)listeners.elementAt(n2)).UniverseClosing(curUniverse);
            ++n2;
        }
    }

    private static void IsModified(JetUUniverse jetUUniverse) {
        int n = listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((UUniverseListener)listeners.elementAt(n2)).UniverseChanged(jetUUniverse, curUniverse);
            ++n2;
        }
    }

    private void IsQueryNameExist(JetUUniverse jetUUniverse) {
        if (jetUUniverse == curUniverse) {
            int n = listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((UUniverseListener)listeners.elementAt(n2)).UniverseNameChanged();
                ++n2;
            }
        }
    }

    public static JetUUniverse GetCurrentUniverse() {
        return curUniverse;
    }

    public static void closeCurrentUniverse() {
        if (curUniverse != null) {
            curUniverse.clearMem();
            curUniverse = null;
        }
    }

    private static void LoadNoCache(JetUUniverse jetUUniverse) {
        JetUUniverse.Closing();
        JetUUniverse jetUUniverse2 = curUniverse;
        curUniverse = jetUUniverse;
        JetUUniverse.IsModified(jetUUniverse2);
        if (jetUUniverse2 != null && !jetUUniverse2.getName().equals(curUniverse.getName())) {
            jetUUniverse2.clearMem();
        }
    }

    public static void setUniverse(JetUUniverse jetUUniverse) {
        curUniverse = jetUUniverse;
    }

    public static JetUUniverse OpenUniverse(String string) throws ReadFailureException, UniverseFileException {
        File file = new File(string);
        return JetUUniverse.OpenUniverse(file.getParent(), file.getName());
    }

    public static JetUUniverse OpenUniverse(String string, String string2) throws ReadFailureException, UniverseFileException {
        JetUUniverse jetUUniverse = JetUUniverse.QOIV(string, string2);
        JetUUniverse.LoadNoCache(jetUUniverse);
        return jetUUniverse;
    }

    public static JetUUniverse LoadUniverse(String string) throws ReadFailureException, UniverseFileException {
        File file = new File(string);
        return JetUUniverse.LoadUniverse(file.getParent(), file.getName());
    }

    public static JetUUniverse LoadUniverse(String string, String string2) throws ReadFailureException, UniverseFileException {
        return JetUUniverse.QOIV(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JetUUniverse QOIV(String string, String string2) throws ReadFailureException, UniverseFileException {
        Object object;
        JetUUniverse jetUUniverse = null;
        JetObject jetObject = null;
        ReportLoader reportLoader = new ReportLoader(string, string2);
        jetObject = reportLoader.load();
        if (jetObject instanceof JetUUniverse) {
            jetUUniverse = (JetUUniverse)jetObject;
            if (string2.toLowerCase().endsWith(".cat.xml")) {
                object = jetUUniverse.getAllDatabaseNames();
                int n = ((Vector)object).size();
                Object object2 = UniverseClosing;
                synchronized (object2) {
                    int n2 = 0;
                    while (n2 < n) {
                        block12: {
                            String string3 = (String)((Vector)object).elementAt(n2);
                            File file = (File)jetUUniverse.FormulaModified.get(string3);
                            if (file == null || jetUUniverse.getDatabase(string3).isNeedGenerateJava()) {
                                try {
                                    long l = System.currentTimeMillis();
                                    jetUUniverse.generateFormulaFile(string3);
                                }
                                catch (GenerateFormulasCodeException generateFormulasCodeException) {
                                    if (!UniverseChanged.isErrorEnabled()) break block12;
                                    UniverseChanged.error("", generateFormulasCodeException);
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
        } else {
            throw new UniverseFileException(string2, 1);
        }
        if ((object = jetUUniverse.version.get()) != null && !((String)object).equals("") && !"single-user".equalsIgnoreCase((String)object)) {
            throw new UniverseFileException(string2, 2);
        }
        if (jetUUniverse.versionNumber.get() > 4) {
            throw new UniverseFileException(string2, 3, jetUUniverse.versionNumber.get(), 4);
        }
        return jetUUniverse;
    }

    public static JetUUniverse LoadNoCache(String string) throws ReadFailureException, UniverseFileException {
        File file = new File(string);
        return JetUUniverse.LoadNoCache(file.getParent(), file.getName());
    }

    public static JetUUniverse LoadNoCache(String string, String string2) throws ReadFailureException, UniverseFileException {
        return JetUUniverse.SaveToJetFile(string, string2);
    }

    private static JetUUniverse SaveToJetFile(String string, String string2) throws ReadFailureException, UniverseFileException {
        JetUUniverse jetUUniverse = null;
        JetObject jetObject = null;
        LoaderNoCache loaderNoCache = new LoaderNoCache(string, string2);
        jetObject = loaderNoCache.load();
        if (!(jetObject instanceof JetUUniverse)) {
            throw new UniverseFileException(string2, 1);
        }
        jetUUniverse = (JetUUniverse)jetObject;
        String string3 = jetUUniverse.version.get();
        if (string3 != null && !string3.equals("") && !"single-user".equalsIgnoreCase(string3)) {
            throw new UniverseFileException(string2, 2);
        }
        if (jetUUniverse.versionNumber.get() > 4) {
            throw new UniverseFileException(string2, 3, jetUUniverse.versionNumber.get(), 4);
        }
        return jetUUniverse;
    }

    public static JetUUniverse NewUniverse(String string) {
        JetUUniverse jetUUniverse = JetUUniverse.BuildDefaultUniverse(string);
        JetUUniverse.LoadNoCache(jetUUniverse);
        return jetUUniverse;
    }

    public static JetUUniverse BuildDefaultUniverse(String string) {
        JetUUniverse jetUUniverse = new JetUUniverse(string);
        jetUUniverse.InitAfterCreate();
        return jetUUniverse;
    }

    public static JetUUniverse BuildDefaultUniverse() {
        JetUUniverse jetUUniverse = new JetUUniverse();
        jetUUniverse.InitAfterCreate();
        return jetUUniverse;
    }

    public void setNamingTable(Hashtable hashtable) {
        this.Closing = hashtable;
    }

    public Hashtable getNamingTable() {
        return this.Closing;
    }

    public void setNamingCount(Hashtable hashtable) {
        this.DataType = hashtable;
    }

    public Hashtable getNamingCount() {
        if (this.DataType == null) {
            this.DataType = new Hashtable();
        }
        return this.DataType;
    }

    public JetUConnection getConnectionByResourceName(String string) {
        return this.getDatabase().getConnectionByResourceName(string);
    }

    public JetUConnection getConnectionByResourceName(String string, String string2) {
        return this.getDatabase(string).getConnectionByResourceName(string2);
    }

    public JetUQuery GetQueryByResourceName(String string) {
        return this.getDatabase().GetQueryByResourceName(string);
    }

    public JetUQuery GetQueryByResourceName(String string, String string2) {
        return this.getDatabase(string).GetQueryByResourceName(string2);
    }

    public boolean IsDataSourceNameExist(String string) {
        Vector vector = this.getAllDatabaseNames();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean IsQueryNameExist(String string) {
        return this.getDatabase().IsQueryNameExist(string);
    }

    public boolean IsQueryNameExist(String string, String string2) {
        return this.getDatabase(string).IsQueryNameExist(string2);
    }

    public boolean IsMappingNameOK(String string, StringBuffer stringBuffer) {
        Vector vector = this.getAllDatabases();
        int n = 0;
        while (n < vector.size()) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n);
            if (!jetUDatabase.I(string, stringBuffer)) {
                return false;
            }
            if (jetUDatabase.IsMappingNameExist(string)) {
                if (stringBuffer != null) {
                    stringBuffer.append(JResource.getMessage("CAT_16", (Object)string));
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public Vector getQueriables() {
        return this.getDatabase().getQueriables();
    }

    public Vector getQueriables(String string) {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        return jetUDatabase == null ? new Vector() : jetUDatabase.getQueriables();
    }

    public Vector getSummaries(String string, Vector vector, String string2) {
        return this.getDatabase().getSummaries(string, vector, string2);
    }

    public Vector getSummaries(String string, String string2, Vector vector, String string3) {
        return this.getDatabase(string).getSummaries(string2, vector, string3);
    }

    public JetUQueriable getQueriableByResourceName(String string) {
        return this.getDatabase().getQueriableByResourceName(string);
    }

    public JetUQueriable getQueriableByResourceName(String string, String string2) {
        return this.getDatabase(string).getQueriableByResourceName(string2);
    }

    public boolean isQueriableExist(String string) {
        return this.getDatabase().isQueriableExist(string);
    }

    public boolean isQueriableExist(String string, String string2) {
        return this.getDatabase(string).isQueriableExist(string2);
    }

    public JetUResourceEntity getResourceByName(String string) {
        return this.getDatabase().getResourceByName(string);
    }

    public JetUResourceEntity getAnyResourceByName(String string) {
        Vector vector = this.getAllDatabases();
        int n = 0;
        while (n < vector.size()) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n);
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string);
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUParameter) {
                return jetUResourceEntity;
            }
            ++n;
        }
        return null;
    }

    public JetUResourceEntity getMaterialByName(String string, String string2) {
        JetUDatabase jetUDatabase = this.getDatabase(string);
        if (jetUDatabase != null) {
            return jetUDatabase.getResourceByName(string2);
        }
        return null;
    }

    public JetUResourceEntity getResourceByName(String string, String string2) {
        return this.getDatabase().getResourceByName(string, string2);
    }

    public JetUResourceEntity getResourceByName(String string, String string2, String string3) {
        return this.getDatabase(string).getResourceByName(string2, string3);
    }

    public Vector getAvailableResourceEntitys(String string) {
        return this.getDatabase().getAvailableResourceEntitys(string);
    }

    public Vector getAvailableResourceEntitys(String string, String string2) {
        return this.getDatabase(string).getAvailableResourceEntitys(string2);
    }

    public Vector getParameters() {
        return this.getDatabase().getParameters();
    }

    public Vector getParameters(String string) {
        return this.getDatabase(string).getParameters();
    }

    public Vector getGroupByFormula(String string) {
        return this.getDatabase().getGroupByFormula(string);
    }

    public Vector getGroupByFormulas(String string, String string2) {
        return this.getDatabase(string).getGroupByFormula(string2);
    }

    public Vector getGroupByFormula(String string, String string2) {
        return this.getDatabase().getGroupByFormula(string, string2);
    }

    public Vector getGroupByFormula(String string, String string2, String string3) {
        return this.getDatabase(string).getGroupByFormula(string2, string3);
    }

    public boolean checkIfMappingFldsValidToQuery(String string, Vector vector) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase().checkIfMappingFldsValidToQuery(string, vector);
    }

    public boolean checkIfMappingFldsValidToQuery(String string, String string2, Vector vector) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase(string).checkIfMappingFldsValidToQuery(string2, vector);
    }

    public boolean checkIfMappingFldsValidToQuery(String string, Vector vector, Hashtable hashtable) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase().checkIfMappingFldsValidToQuery(string, vector, hashtable);
    }

    public boolean checkIfMappingFldsValidToQuery(String string, String string2, Vector vector, Hashtable hashtable) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase(string).checkIfMappingFldsValidToQuery(string2, vector, hashtable);
    }

    public DbColDesc getSQLType(String string) {
        return this.getDatabase().getSQLType(string);
    }

    public DbColDesc getSqlType(String string, String string2) {
        return this.getDatabase(string).getSQLType(string2);
    }

    public DbColDesc getSQLType(String string, String string2) {
        return this.getDatabase().getSQLType(string, string2);
    }

    public DbColDesc getSQLType(String string, String string2, String string3) {
        return this.getDatabase(string).getSQLType(string2, string3);
    }

    public Vector getFormulasInDatabase() {
        return this.getDatabase().getFormulas();
    }

    public Vector getFormulasInDatabase(String string) {
        return this.getDatabase(string).getFormulas();
    }

    public static boolean canCreateCatalog(String string) {
        File file = new File(string);
        return JetUUniverse.canCreateCatalog(new File(file.getParent()));
    }

    public static boolean canCreateCatalog(String string, String string2) {
        return JetUUniverse.canCreateCatalog(new File(string));
    }

    protected static boolean canCreateCatalog(File file) {
        if (!file.exists()) {
            return false;
        }
        String[] stringArray = file.list(new WildcardMatcher(CAT_FILE_WILDCARD, false));
        return stringArray == null || stringArray.length == 0;
    }

    public static boolean createCatalog(String string, String string2, ConnectionDesc connectionDesc) {
        boolean bl;
        block6: {
            if (!JetUUniverse.canCreateCatalog(string, string2)) {
                if (UniverseChanged.isDebugEnabled()) {
                    UniverseChanged.debug("Create the catalog failed.  Either the specified directory does not exist or there is an existing catalog in that directory.");
                }
                return false;
            }
            File file = new File(string, string2 + CAT_FILE_EXTENSION);
            JetUUniverse jetUUniverse = JetUUniverse.BuildDefaultUniverse(file.getPath());
            JetUDatabase jetUDatabase = jetUUniverse.getDatabase();
            jetUDatabase.addConnection(connectionDesc.strName, "", connectionDesc.strURL, connectionDesc.strUser, connectionDesc.strPassword, 0, connectionDesc.strDriver);
            try {
                bl = jetUUniverse.Save();
            }
            catch (WriteFailureException writeFailureException) {
                bl = false;
                if (UniverseChanged.isErrorEnabled()) {
                    UniverseChanged.error("", writeFailureException);
                }
            }
            catch (FMLFileException fMLFileException) {
                bl = false;
                if (!UniverseChanged.isErrorEnabled()) break block6;
                UniverseChanged.error("", fMLFileException);
            }
        }
        return bl;
    }

    public static ConnectionDesc getCatalogsDataSource(String string) {
        ConnectionDesc connectionDesc = null;
        try {
            File file = new File(string);
            JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse(file.getParent(), file.getName());
            JetUDatabase jetUDatabase = jetUUniverse.getDatabase();
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUDatabase.getConnection();
            if (jetUJDBCConnection != null) {
                connectionDesc = new ConnectionDesc();
                connectionDesc.strName = jetUJDBCConnection.getResourceName();
                connectionDesc.strURL = jetUJDBCConnection.getURL();
                connectionDesc.strUser = jetUJDBCConnection.getUID();
                connectionDesc.strDriver = jetUJDBCConnection.getJdbcDriver();
            }
        }
        catch (ReadFailureException readFailureException) {
        }
        catch (UniverseFileException universeFileException) {
            // empty catch block
        }
        return connectionDesc;
    }

    public static ConnectionDesc getCatalogsDataSource(String string, String string2) {
        ConnectionDesc connectionDesc = null;
        try {
            File file = new File(string2);
            JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse(file.getParent(), file.getName());
            JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUDatabase.getConnection();
            if (jetUJDBCConnection != null) {
                connectionDesc = new ConnectionDesc();
                connectionDesc.strName = jetUJDBCConnection.getResourceName();
                connectionDesc.strURL = jetUJDBCConnection.getURL();
                connectionDesc.strUser = jetUJDBCConnection.getUID();
                connectionDesc.strDriver = jetUJDBCConnection.getJdbcDriver();
            }
        }
        catch (ReadFailureException readFailureException) {
        }
        catch (UniverseFileException universeFileException) {
            // empty catch block
        }
        return connectionDesc;
    }

    public boolean saveWherePortion(String string, String string2, String string3) {
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", string3);
        jetUWherePortion.setQueryName(string2);
        return this.saveWherePortion(jetUWherePortion);
    }

    public boolean saveWherePortion(String string, String string2, String string3, String string4) {
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", string4);
        jetUWherePortion.setQueryName(string3);
        jetUWherePortion.setSourceName(string2);
        return this.saveWherePortion(jetUWherePortion);
    }

    public boolean saveWherePortion(String string, String string2, Vector vector) {
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", vector);
        jetUWherePortion.setQueryName(string2);
        return this.saveWherePortion(jetUWherePortion);
    }

    public boolean saveWherePortion(String string, String string2, String string3, Vector vector) {
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", vector);
        jetUWherePortion.setQueryName(string3);
        jetUWherePortion.setSourceName(string2);
        return this.saveWherePortion(jetUWherePortion);
    }

    public boolean saveWherePortion(String string, String string2) {
        return this.saveWherePortion(string, "", string2);
    }

    public boolean saveWherePortionBySourceName(String string, String string2, String string3) {
        return this.saveWherePortion(string, string2, "", string3);
    }

    public boolean saveWherePortion(String string, Vector vector) {
        return this.saveWherePortion(string, "", vector);
    }

    public boolean saveWherePortionBySourceName(String string, String string2, Vector vector) {
        return this.saveWherePortion(string, string2, "", vector);
    }

    protected boolean saveWherePortion(JetUWherePortion jetUWherePortion) {
        boolean bl = false;
        bl = this.getDatabase().addWherePortion(jetUWherePortion);
        if (bl) {
            bl = this.saveCatalog();
        }
        return bl;
    }

    protected boolean saveWherePortion(JetUWherePortion jetUWherePortion, String string) {
        boolean bl = false;
        bl = this.getDatabase(string).addWherePortion(jetUWherePortion);
        if (bl) {
            bl = this.saveCatalog();
        }
        return bl;
    }

    public boolean modifyWherePortion(String string, String string2, String string3) {
        return this.modifyWherePortion(string, string2, (Object)string3);
    }

    public boolean modifyWherePortion(String string, String string2, String string3, String string4) {
        return this.modifyWherePortion(string, string2, string3, (Object)string4);
    }

    public boolean modifyWherePortion(String string, String string2, Vector vector) {
        return this.modifyWherePortion(string, string2, (Object)vector);
    }

    public boolean modifyWherePortion(String string, String string2, String string3, Vector vector) {
        return this.modifyWherePortion(string, string2, string3, (Object)vector);
    }

    public boolean modifyWherePortion(String string, String string2, Object object) {
        JetUWherePortion jetUWherePortion = this.getDatabase().getWherePortionByResourceName(string);
        if (jetUWherePortion != null) {
            return this.Searchable(jetUWherePortion, null, string2, object);
        }
        return false;
    }

    public boolean modifyWherePortion(String string, String string2, String string3, Object object) {
        JetUWherePortion jetUWherePortion = this.getDatabase(string2).getWherePortionByResourceName(string);
        if (jetUWherePortion != null) {
            return this.Searchable(jetUWherePortion, string2, string3, object);
        }
        return false;
    }

    boolean Searchable(JetUWherePortion jetUWherePortion, String string, String string2, Object object) {
        boolean bl = false;
        if (object instanceof String) {
            jetUWherePortion.setWherePortion((String)object);
        } else if (object instanceof Vector) {
            jetUWherePortion.setGroups((Vector)object);
        }
        jetUWherePortion.setSourceName(string);
        jetUWherePortion.setQueryName(string2);
        bl = true;
        if (bl) {
            bl = this.saveCatalog();
        }
        return bl;
    }

    public boolean deleteWherePortion(String string) {
        boolean bl = this.getDatabase().removeWherePortion(string);
        if (bl) {
            bl = this.saveCatalog();
        }
        return bl;
    }

    public boolean deleteWherePortion(String string, String string2) {
        boolean bl = this.getDatabase(string2).removeWherePortion(string);
        if (bl) {
            bl = this.saveCatalog();
        }
        return bl;
    }

    public Enumeration getAvailableWherePortions() {
        Vector vector = this.getDatabase().getWherePortions();
        return this.UniverseChanged(vector, null);
    }

    public Enumeration getDataSourceAvailableWherePortions(String string) {
        Vector vector = this.getDatabase(string).getWherePortions();
        return this.UniverseChanged(vector, null);
    }

    Enumeration UniverseChanged(Vector vector, String string) {
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUWherePortion jetUWherePortion = (JetUWherePortion)vector.elementAt(n2);
            if (string != null) {
                if (jetUWherePortion.getQueryName().equals("") || string.equalsIgnoreCase(jetUWherePortion.getQueryName())) {
                    vector2.addElement(jetUWherePortion.getResourceName());
                }
            } else {
                vector2.addElement(jetUWherePortion.getResourceName());
            }
            ++n2;
        }
        return vector2.elements();
    }

    public Enumeration getAvailableWherePortions(String string) {
        Vector vector = this.getDatabase().getWherePortions();
        return this.UniverseChanged(vector, string);
    }

    public Enumeration getAvailableWherePortions(String string, String string2) {
        Vector vector = this.getDatabase(string).getWherePortions();
        return this.UniverseChanged(vector, string2);
    }

    public String getWherePortion(String string) {
        JetUWherePortion jetUWherePortion = this.getDatabase().getWherePortionByResourceName(string);
        if (jetUWherePortion != null) {
            return jetUWherePortion.getWherePortion();
        }
        return null;
    }

    public String getWherePortion(String string, String string2) {
        JetUWherePortion jetUWherePortion = this.getDatabase(string).getWherePortionByResourceName(string2);
        if (jetUWherePortion != null) {
            return jetUWherePortion.getWherePortion();
        }
        return null;
    }

    public JetUWherePortion getUWherePortion(String string) {
        return this.getDatabase().getWherePortionByResourceName(string);
    }

    public JetUWherePortion getUWherePortion(String string, String string2) {
        return this.getDatabase(string).getWherePortionByResourceName(string2);
    }

    public Enumeration getAvailableQueryFields(String string) {
        JetUQuery jetUQuery = this.GetQueryByResourceName(string);
        if (jetUQuery != null) {
            Vector vector = this.getAvailableResourceEntitys(string);
            return this.availableQueryFields(jetUQuery, vector);
        }
        return null;
    }

    public Enumeration getAvailableQueryFields(String string, String string2) {
        JetUQuery jetUQuery = this.GetQueryByResourceName(string, string2);
        if (jetUQuery != null) {
            Vector vector = this.getAvailableResourceEntitys(string, string2);
            return this.availableQueryFields(jetUQuery, vector);
        }
        return null;
    }

    public Enumeration availableQueryFields(JetUQuery jetUQuery, Vector vector) {
        QueryFieldDesc queryFieldDesc;
        Vector<QueryFieldDesc> vector2 = new Vector<QueryFieldDesc>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(n2);
            if (jetUResourceEntity instanceof JetUQueryField && !(jetUResourceEntity instanceof JetUFmlQueryField) || jetUResourceEntity instanceof JetUFormula && !((JetUFormula)jetUResourceEntity).isGroupBy() && !(jetUResourceEntity instanceof JetUSummary) || jetUResourceEntity instanceof JetUParameter) {
                queryFieldDesc = new QueryFieldDesc();
                DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
                queryFieldDesc.strFieldName = dbColDesc.colName;
                queryFieldDesc.iSqlType = dbColDesc.sqlType;
                queryFieldDesc.iPrecision = dbColDesc.precision;
                queryFieldDesc.iScale = dbColDesc.scale;
                queryFieldDesc.iNullable = dbColDesc.nullable;
                if (jetUResourceEntity instanceof JetUFldQueryField) {
                    queryFieldDesc.iFieldType = 1;
                    PsqlTable psqlTable = ((JetUFldQueryField)jetUResourceEntity).I.getPsqlTable();
                    queryFieldDesc.strTableAlias = psqlTable.getCorrelationName();
                    queryFieldDesc.bTableAlias = queryFieldDesc.strTableAlias != null;
                    queryFieldDesc.strTableQualifier = psqlTable.getQualifier();
                    queryFieldDesc.strTableOwner = psqlTable.getOwner();
                    queryFieldDesc.strTableName = psqlTable.getName();
                } else if (jetUResourceEntity instanceof JetUCompColQueryField) {
                    queryFieldDesc.iFieldType = 2;
                } else if (jetUResourceEntity instanceof JetUFormula) {
                    queryFieldDesc.iFieldType = 3;
                } else if (jetUResourceEntity instanceof JetUParameter) {
                    queryFieldDesc.iFieldType = 4;
                }
                vector2.addElement(queryFieldDesc);
            }
            ++n2;
        }
        RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
        Vector vector3 = rptPsqlQuery.getTablesForUnselectedCols();
        int n3 = vector3.size();
        int n4 = 0;
        while (n4 < n3) {
            PsqlTable psqlTable = (PsqlTable)vector3.elementAt(n4);
            Vector vector4 = psqlTable.getColumns();
            int n5 = vector4.size();
            int n6 = 0;
            while (n6 < n5) {
                PsqlColumn psqlColumn = (PsqlColumn)vector4.elementAt(n6);
                queryFieldDesc = new QueryFieldDesc();
                queryFieldDesc.iFieldType = 1;
                queryFieldDesc.strFieldName = psqlColumn.name;
                queryFieldDesc.iSqlType = psqlColumn.type;
                queryFieldDesc.iPrecision = psqlColumn.precision;
                queryFieldDesc.iScale = psqlColumn.scale;
                queryFieldDesc.iNullable = psqlColumn.nullable;
                queryFieldDesc.strTableAlias = psqlTable.getCorrelationName();
                queryFieldDesc.bTableAlias = queryFieldDesc.strTableAlias != null;
                queryFieldDesc.strTableQualifier = psqlTable.getQualifier();
                queryFieldDesc.strTableOwner = psqlTable.getOwner();
                queryFieldDesc.strTableName = psqlTable.getName();
                vector2.addElement(queryFieldDesc);
                ++n6;
            }
            ++n4;
        }
        return vector2.elements();
    }

    public Vector addTableViews(String string, String string2, String string3, int n) throws AddTableViewException, ClassNotFoundException, SQLException {
        JetUDatabase jetUDatabase = this.getDatabase();
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection == null) {
            throw new AddTableViewException(2);
        }
        if (n >> 2 != 0) {
            throw new AddTableViewException(1);
        }
        Vector vector = jetUConnection.addTableViews(string, string2, string3, n);
        return vector;
    }

    public Vector addTableViews(String string, String string2, String string3, String string4, int n) throws AddTableViewException, ClassNotFoundException, SQLException {
        JetUDatabase jetUDatabase = this.getDatabase(string2);
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection == null) {
            throw new AddTableViewException(2);
        }
        if (n >> 2 != 0) {
            throw new AddTableViewException(1);
        }
        Vector vector = jetUConnection.addTableViews(string, string3, string4, n);
        return vector;
    }

    public boolean addFileQuery(String string, File file, StringBuffer stringBuffer) {
        return this.addFileQuery(string, "", file, stringBuffer);
    }

    public boolean addFileQuery(String string, String string2, File file, StringBuffer stringBuffer) {
        boolean bl = true;
        JetUDatabase jetUDatabase = this.getDatabase(string2);
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl2 = jetUDatabase.IsFileQueryNameOK(jetUConnection.getResourceName(), string, stringBuffer2);
        if (bl2) {
            try {
                FileQuery fileQuery = FileQuery.createFileQuery(file.getPath(), this, string2);
                jetUConnection.addFileQuery(string, fileQuery);
            }
            catch (BadFileQueryException badFileQueryException) {
                bl = false;
                stringBuffer.append(badFileQueryException.getMessage());
            }
        } else {
            bl = false;
            stringBuffer.append(stringBuffer2);
        }
        return bl;
    }

    public boolean saveCatalog() {
        boolean bl;
        block4: {
            try {
                bl = this.Save();
            }
            catch (WriteFailureException writeFailureException) {
                bl = false;
                if (UniverseChanged.isErrorEnabled()) {
                    UniverseChanged.error("", writeFailureException);
                }
            }
            catch (FMLFileException fMLFileException) {
                bl = false;
                if (!UniverseChanged.isErrorEnabled()) break block4;
                UniverseChanged.error("", fMLFileException);
            }
        }
        return bl;
    }

    public String toString() {
        return "Name: " + this.getName();
    }

    public void clearMem() {
        JetObject jetObject;
        Vector vector = this.getAllDatabaseNames();
        this.Closing.clear();
        this.InitAfterCreate.clear();
        this.IsQueryNameExist.clear();
        this.LoadUniverse.clear();
        this.QOIV.clear();
        this.SaveToJetFile.clear();
        JetUBuildInClassNode.vAllBuildIn = null;
        JetUBuildInClassNode.vContainers = null;
        JetUBuildInClassNode.vDraws = null;
        JetUBuildInClassNode.vSpecialFields = null;
        TreeIterater treeIterater = new TreeIterater(this, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetUFileQuery) {
                ((JetUFileQuery)jetObject).clearMem();
            } else if (jetObject instanceof JetUQuery) {
                ((JetUQuery)jetObject).clearMem();
            } else if (jetObject instanceof JetUDatabase) {
                ((JetUDatabase)jetObject).clearMem();
            }
            jetObject.delete();
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            File file = (File)this.FormulaModified.remove(string);
            Boolean bl = (Boolean)this.IsFileQueryNameOK.remove(string);
            if (file != null && bl != null && bl.booleanValue()) {
                file.delete();
            }
            ++n2;
        }
    }

    public synchronized int getRefCount() {
        return this.UniverseNameChanged;
    }

    public synchronized void refer() {
        ++this.UniverseNameChanged;
    }

    public synchronized void free() {
        if (this.UniverseNameChanged > 0) {
            --this.UniverseNameChanged;
        }
        if (curUniverse == null && !this.add && this.UniverseNameChanged == 0) {
            this.clearMem();
        }
    }

    public void setCached(boolean bl) {
        this.add = bl;
    }

    public boolean isCached() {
        return this.add;
    }

    public void removeExceptJetUDB() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (!(jetObject instanceof JetUDatabase)) {
                this.remove(jetObject);
            }
            ++n2;
        }
        JetUDocFolder jetUDocFolder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(jetUDocFolder);
    }

    public SQLMapInfo createSQLMapInfoOnTable(JetUTableView jetUTableView) {
        JetUConnection jetUConnection = this.getDatabase().getConnection();
        return this.UniverseClosing(jetUTableView, jetUConnection);
    }

    public SQLMapInfo createSQLMapInfoOnTable(JetUTableView jetUTableView, String string) {
        JetUConnection jetUConnection = this.getDatabase(string).getConnection();
        return this.UniverseClosing(jetUTableView, jetUConnection);
    }

    SQLMapInfo UniverseClosing(JetUTableView jetUTableView, JetUConnection jetUConnection) {
        SQLMapInfo sQLMapInfo = new SQLMapInfo();
        if (jetUConnection instanceof JetUConnection) {
            sQLMapInfo.setQlfOpt(jetUConnection.getQualifiedNamePattern());
        }
        Hashtable hashtable = sQLMapInfo.getTabMap();
        hashtable.put(jetUTableView.getResourceName().toUpperCase(), "");
        Hashtable hashtable2 = sQLMapInfo.getColMap();
        Enumeration enumeration = jetUTableView.getFields().elements();
        while (enumeration.hasMoreElements()) {
            String string = ((JetUField)enumeration.nextElement()).getResourceName().toUpperCase();
            hashtable2.put(string, "");
        }
        return sQLMapInfo;
    }

    public JetUParameter[] getSQLStmtCreatorParams() {
        return this.Save;
    }

    public JetUParameter[] getSQLStmtCreatorParams(String string) {
        JetUJDBCConnection jetUJDBCConnection;
        JetUDatabase jetUDatabase = this.getDatabase(string);
        JetUParameter[] jetUParameterArray = null;
        if (jetUDatabase != null && (jetUJDBCConnection = (JetUJDBCConnection)jetUDatabase.getConnection()) != null && (jetUParameterArray = this.AfterAdd(jetUJDBCConnection.sqlStmtCreator.get(), "SQLStmtCreator", string, false)) != null) {
            this.SaveToJetFile.put(string, jetUParameterArray);
        }
        return jetUParameterArray;
    }

    public ParameterInfo[] getDefaultParamsForSQLStmtCreator() {
        return this.UniverseNameChanged(this.Save);
    }

    public ParameterInfo[] getDefaultParamsForSQLStmtCreator(String string) {
        JetUParameter[] jetUParameterArray = (JetUParameter[])this.SaveToJetFile.get(string);
        return this.UniverseNameChanged(jetUParameterArray);
    }

    public JetUParameter[] getSQLNameAnalyserParams() {
        return this.LoadNoCache;
    }

    public JetUParameter[] getSQLNameAnalyserParams(String string) {
        JetUParameter[] jetUParameterArray = (JetUParameter[])this.LoadUniverse.get(string);
        return jetUParameterArray;
    }

    public ParameterInfo[] getDefaultParamsForSQLNameAnalyser() {
        return this.UniverseNameChanged(this.LoadNoCache);
    }

    public ParameterInfo[] getDefaultParamsForSQLNameAnalyser(String string) {
        return this.UniverseNameChanged((JetUParameter[])this.LoadUniverse.get(string));
    }

    private ParameterInfo[] UniverseNameChanged(JetUParameter[] jetUParameterArray) {
        if (jetUParameterArray != null) {
            ParameterInfo[] parameterInfoArray = new ParameterInfo[this.Save.length];
            int n = 0;
            while (n < jetUParameterArray.length) {
                parameterInfoArray[n] = new ParameterInfo(jetUParameterArray[n].getResourceName(), jetUParameterArray[n].getType(), jetUParameterArray[n].getDefaultValue());
                ++n;
            }
        }
        return null;
    }

    public String getInstancePrefix() {
        return "Catalog";
    }

    public void copyDatabase(JetUUniverse jetUUniverse, String string, String string2) {
        int n;
        int n2;
        Vector vector;
        JetUConnection jetUConnection;
        JetUDatabase jetUDatabase = this.getDatabase(string);
        JetUDatabase jetUDatabase2 = jetUUniverse.getDatabase(string2);
        if (jetUDatabase2 == null) {
            jetUUniverse.addDatabase(string2);
            jetUDatabase2 = jetUUniverse.getDatabase(string2);
        }
        if ((jetUConnection = jetUDatabase.getConnection()) != null) {
            JetUConnection jetUConnection2 = jetUConnection.createNew();
            jetUDatabase2.addConnection(jetUConnection2);
            vector = jetUConnection.getTableViews();
            int n3 = 0;
            while (n3 < vector.size()) {
                JetUTableView jetUTableView = ((JetUTableView)vector.elementAt(n3)).createNew();
                Vector vector2 = ((JetUTableView)vector.elementAt(n3)).getFields();
                if (vector2 != null) {
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        jetUTableView.addField(((JetUField)vector2.elementAt(n2)).createNew());
                        ++n2;
                    }
                }
                jetUConnection2.addTableView(jetUTableView);
                ++n3;
            }
            vector = jetUConnection.getProcedures();
            n2 = 0;
            while (n2 < vector.size()) {
                jetUConnection2.addProcedure(((JetUProcedure)vector.elementAt(n2)).cloneEntity());
                ++n2;
            }
            vector = jetUConnection.getFileQueries();
            n = 0;
            while (n < vector.size()) {
                jetUConnection2.addFileQueryAfterInit(((JetUFileQuery)vector.elementAt(n)).getCopy());
                ++n;
            }
        }
        vector = jetUDatabase.getDataSources();
        int n4 = 0;
        while (n4 < vector.size()) {
            jetUDatabase2.addDataSource(((JetUUserDataSource)vector.elementAt(n4)).cloneEntity());
            ++n4;
        }
        vector = jetUDatabase.getQueries();
        int n5 = 0;
        while (n5 < vector.size()) {
            RptPsqlQuery rptPsqlQuery = ((JetUQuery)vector.elementAt(n5)).getPsqlQuery().getCopy();
            JetUQuery jetUQuery = new JetUQuery(((JetUQuery)vector.elementAt(n5)).getResourceName(), rptPsqlQuery);
            jetUDatabase2.addQuery(jetUQuery);
            rptPsqlQuery.setUniverse(jetUUniverse, string2);
            ++n5;
        }
        vector = jetUDatabase.getFormulas();
        int n6 = 0;
        while (n6 < vector.size()) {
            jetUDatabase2.addFormula(((JetUFormula)vector.elementAt(n6)).createNew());
            ++n6;
        }
        vector = jetUDatabase.getSummaries();
        n2 = 0;
        while (n2 < vector.size()) {
            jetUDatabase2.addSummary((JetUSummary)((JetUSummary)vector.elementAt(n2)).createNew());
            ++n2;
        }
        vector = jetUDatabase.getParameters();
        n = 0;
        while (n < vector.size()) {
            jetUDatabase2.addParameter(((JetUParameter)vector.elementAt(n)).createNew());
            ++n;
        }
        jetUDatabase2.FormulaModified();
        vector = jetUDatabase.getWherePortions();
        int n7 = 0;
        while (n7 < vector.size()) {
            jetUDatabase2.addWherePortion(((JetUWherePortion)vector.elementAt(n7)).cloneEntity());
            ++n7;
        }
        vector = jetUDatabase.getHierDataSources();
        int n8 = 0;
        while (n8 < vector.size()) {
            jetUDatabase2.addHierDataSource(((JetUHierDataSource)vector.elementAt(n8)).cloneHDS());
            ++n8;
        }
        vector = jetUDatabase.getAcls();
        int n9 = 0;
        while (n9 < vector.size()) {
            jetUDatabase2.addAcl(((JetUAcl)vector.elementAt(n9)).cloneEntity());
            ++n9;
        }
    }

    public JetUUniverse copySelectDatabase(Vector vector, boolean bl, Hashtable hashtable) {
        JetUUniverse jetUUniverse = JetUUniverse.BuildDefaultUniverse();
        int n = vector.size();
        if (!vector.contains("") && !bl) {
            this.copyDatabase(jetUUniverse, (String)vector.elementAt(0), "");
            hashtable.put((String)vector.elementAt(0), "");
            int n2 = 1;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                this.copyDatabase(jetUUniverse, string, string);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                String string = (String)vector.elementAt(n3);
                this.copyDatabase(jetUUniverse, string, string);
                ++n3;
            }
        }
        return jetUUniverse;
    }

    public JetUUniverse copy() {
        JetUUniverse jetUUniverse = JetUUniverse.BuildDefaultUniverse();
        Vector vector = this.getAllDatabaseNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            this.copyDatabase(jetUUniverse, string, string);
            ++n2;
        }
        return jetUUniverse;
    }

    public void setVersion(int n) {
        this.BuildDefaultUniverse = n;
    }

    public int getVersion() {
        return this.BuildDefaultUniverse;
    }

    public JetUDatabase addDatabase(String string) {
        JetUDatabase jetUDatabase = new JetUDatabase(string, "");
        this.add(jetUDatabase);
        jetUDatabase.InitAfterCreate();
        return jetUDatabase;
    }

    public boolean removeDatabase(String string) {
        if (!string.equals("")) {
            this.remove(this.getDatabase(string));
            return true;
        }
        return false;
    }

    public void setRptUserName(String string) {
        this.Searchable = string;
    }

    public String getRptUserName() {
        return this.Searchable;
    }

    public String getSpecialField(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.Searchable;
            }
        }
        return string;
    }

    public ArrayList getSpecialFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this.Searchable != null ? this.Searchable : "");
        return arrayList;
    }

    public void setCrossRefApply(boolean bl) {
        this.addAcl = bl;
    }

    public boolean isCrossRefApply() {
        return this.addAcl;
    }

    public void setUserTimeZone(String string) {
        this.addConnection = string;
    }

    public String getUserTimeZone() {
        return this.addConnection;
    }

    public HashMap getIndecialMap() {
        return addDataSource;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUUniverse == null ? (class$jet$universe$JetUUniverse = JetUUniverse.class$("jet.universe.JetUUniverse")) : class$jet$universe$JetUUniverse).desiredAssertionStatus();
        AfterAdd = new FormulaClassLoader();
        curUniverse = null;
        listeners = new Vector();
        UniverseChanged = JRLogger.getLogger((class$jet$universe$JetUUniverse == null ? (class$jet$universe$JetUUniverse = JetUUniverse.class$("jet.universe.JetUUniverse")) : class$jet$universe$JetUUniverse).getName());
        UniverseClosing = new Object();
        addDataSource = new HashMap(5);
        addDataSource.put("Description", new Integer(0));
        addDataSource.put("VersionNumber", new Integer(1));
        addDataSource.put("Name", new Integer(2));
        addDataSource.put("Version", new Integer(3));
        addDataSource.put("TimeZone", new Integer(4));
    }
}

