/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartEnv;
import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.data.ChartDataFilter;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartNumericAxisProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class ChartNumericRadarAxis
extends ChartNumericAxis {
    private ChartDataFilter F;
    private List I;
    private ChartTextStyle QOIV;
    private ChartLabelBase[] WORDWRAPPER_GAP;
    private float[][] drawAxis;
    private float[][] drawLabels;
    private Line2D.Float[] drawTickMark;
    private boolean get;
    private float[][] getChartTextStyle;

    public ChartNumericRadarAxis(ChartNumericAxisProperties chartNumericAxisProperties, double d, double d2, List list, ChartTextStyle chartTextStyle) {
        super(chartNumericAxisProperties, d, d2);
        this.I = list;
        this.QOIV = chartTextStyle;
        this.QOIV.setRotation(0.0);
    }

    public void init() {
        super.init();
        boolean bl = this.get = this.I != null && this.I.size() != 0 && this.get;
        if (this.get) {
            this.drawLabels = new float[this.I.size()][2];
            this.WORDWRAPPER_GAP = new ChartLabelBase[this.I.size()];
            int n = 0;
            while (n < this.I.size()) {
                String string = this.I.get(n) == null ? "" : (this.F != null ? this.F.filter(this.I.get(n), n) : this.I.get(n).toString());
                this.WORDWRAPPER_GAP[n] = new ChartLabelBase(string);
                this.WORDWRAPPER_GAP[n].setChartTextStyle(this.QOIV);
                ++n;
            }
        }
    }

    public void locate() {
        super.locate();
        if (this.get) {
            this.I();
        }
    }

    public void paint(Graphics2D graphics2D) {
        this.locate();
        float[][] fArray2 = new float[2][2];
        fArray2[0][0] = this.getChartTextStyle[0][0];
        fArray2[0][1] = this.getChartTextStyle[0][1];
        int n = 0;
        while (n < this.getChartTextStyle.length - 1) {
            if (n == 0) {
                if (this.properties.isShowTickMarkLabels()) {
                    super.drawLabels(graphics2D);
                }
                if (this.get) {
                    this.F(graphics2D);
                }
                if (this.properties.getTickMarkType() != 0) {
                    this.numOfTicks = this.labelPoint.length;
                    super.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.labelPoint, this.properties.getTickMarkLength(), this.properties.getTickMarkType(), this.numOfTicks);
                }
            }
            fArray2[1][0] = this.getChartTextStyle[n + 1][0];
            fArray2[1][1] = this.getChartTextStyle[n + 1][1];
            super.drawAxis(graphics2D, fArray2);
            ++n;
        }
    }

    private void F(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.WORDWRAPPER_GAP.length) {
            this.WORDWRAPPER_GAP[n].locate();
            this.WORDWRAPPER_GAP[n].paint(graphics2D, this.drawLabels[n][0], this.drawLabels[n][1]);
            ++n;
        }
    }

    private void I() {
        int n = 0;
        while (n < this.WORDWRAPPER_GAP.length) {
            this.WORDWRAPPER_GAP[n].locate();
            Rectangle2D.Float float_ = (Rectangle2D.Float)this.QOIV.getDimension(this.WORDWRAPPER_GAP[n].getLabelText());
            this.drawLabels[n] = this.QOIV(this.drawAxis[n], float_.width, float_.height, n);
            ++n;
        }
    }

    private float[] QOIV(float[] fArray2, float f, float f2, int n) {
        double d = Math.PI;
        float[] fArray3 = new float[2];
        int n2 = ChartEnv.WORDWRAPPER_GAP;
        float f3 = this.WORDWRAPPER_GAP.length;
        double d2 = d * 2.0 / (double)f3 * (double)n;
        if (d2 % d == 0.0) {
            fArray3[0] = fArray2[0] - f / 2.0f;
            fArray3[1] = fArray2[1];
        } else if (d2 < d) {
            fArray3[0] = fArray2[0] - f;
            fArray3[1] = fArray2[1];
        } else if (d2 == 1.5 * d) {
            fArray3[0] = fArray2[0];
            fArray3[1] = fArray2[1];
        } else {
            fArray3[0] = fArray2[0];
            fArray3[1] = fArray2[1] - f2;
        }
        if (d2 == d / 2.0 || d2 == 1.5 * d) {
            fArray3[1] = fArray3[1] - f2 / 2.0f;
        } else if (d2 < d / 2.0) {
            fArray3[1] = fArray3[1] - f2;
        } else if (d2 > d && d2 < 1.5 * d) {
            fArray3[1] = fArray3[1] + f2;
        }
        return fArray3;
    }

    public Dimension getMaxDimensionOfLabels() {
        Dimension dimension = new Dimension();
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.WORDWRAPPER_GAP == null) {
            return dimension;
        }
        int n = 0;
        while (n < this.WORDWRAPPER_GAP.length) {
            Rectangle2D.Float float_ = (Rectangle2D.Float)this.QOIV.getDimension(this.WORDWRAPPER_GAP[n].getLabelText());
            f2 = float_.width > f2 ? float_.width : f2;
            f = float_.height > f ? float_.height : f2;
            ++n;
        }
        dimension.width = (int)f2;
        dimension.height = (int)f;
        return dimension;
    }

    public Line2D[] getRadarAxisAreaPath() {
        return this.drawTickMark;
    }

    public void setRadarAxisAreaPath(Line2D.Float[] floatArray) {
        this.drawTickMark = floatArray;
    }

    public boolean searchSelectedAxis(int n, int n2) {
        if (this.drawTickMark != null) {
            int n3 = 0;
            while (n3 < this.drawTickMark.length) {
                if (this.drawTickMark[n3].intersects(n - 5, n2 - 5, 10.0, 10.0)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public void setIsShowRadarColumnName(boolean bl) {
        this.get = bl;
    }

    public boolean getIsShowRadarColumnName() {
        return this.get;
    }

    public void setRadarColumnNamePosition(float[][] fArray2) {
        this.drawAxis = fArray2;
    }

    public void setAxisPoint(float[][] fArray2) {
        this.getChartTextStyle = fArray2;
    }

    public float[][] getAxisPoint() {
        return this.getChartTextStyle;
    }

    public Dimension getMaxDimensionOfCategoryLabels() {
        int n;
        Dimension dimension = new Dimension();
        dimension.width = 0;
        dimension.height = 0;
        boolean bl = false;
        if (this.WORDWRAPPER_GAP != null && (n = this.WORDWRAPPER_GAP.length) != 0) {
            ChartTextStyle chartTextStyle = this.WORDWRAPPER_GAP[0].getChartTextStyle();
            if (n == 1) {
                if (this.WORDWRAPPER_GAP[0] != null) {
                    Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.WORDWRAPPER_GAP[0].getLabelText());
                    dimension.width = (int)(float_.width / 2.0f);
                    dimension.height = (int)float_.height;
                }
            } else {
                int n2 = 0;
                while (n2 < n) {
                    Rectangle2D.Float float_;
                    if (this.WORDWRAPPER_GAP[n2] != null && (float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.WORDWRAPPER_GAP[n2].getLabelText())) != null) {
                        float f = float_.width > (float)dimension.width ? float_.width : (float)dimension.width;
                        float f2 = float_.height > (float)dimension.height ? float_.height : (float)dimension.height;
                        dimension.width = (int)f;
                        dimension.height = (int)f2;
                    }
                    ++n2;
                }
            }
        }
        return dimension;
    }

    public ChartDataFilter getCategoryFilter() {
        return this.F;
    }

    public void setCategoryFilter(ChartDataFilter chartDataFilter) {
        this.F = chartDataFilter;
    }
}

