/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.util.IntList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.dataengine.api.DSException;

public abstract class AGeneralRelation
extends ARelation {
    protected final ITuple tuple;
    protected IRowID rowID;
    protected boolean isClose = false;
    protected final List subRelationDataList = new LinkedList();

    protected AGeneralRelation(String string, IRelationData iRelationData) throws DSException {
        super(string, iRelationData);
        this.tuple = iRelationData.createTuple();
        this.rowID = iRelationData.createRowID();
    }

    protected abstract void onGetValueBefore() throws DSException;

    protected abstract void onChangePosition() throws DSException;

    protected abstract void onClose() throws DSException;

    protected void beforeChangePosition(long l) throws DSException {
    }

    protected abstract boolean canClose() throws DSException;

    protected final void checkClose() throws DSException {
        if (this.isClose) {
            throw new DSException(1125);
        }
    }

    protected final void checkPosition() throws DSException {
        if (!this.rowID.currentRowIDIsAvailable()) {
            throw new IndexOutOfBoundsException("Position: " + this.rowID.getPosition());
        }
    }

    public final IntList getRowIDs() throws DSException {
        return this.rowID.getRowIDs();
    }

    public final int getCurrentRowID() throws DSException {
        return this.rowID.getCurrentRowID();
    }

    public final int size() throws DSException {
        return this.rowID.size();
    }

    public final JRelation getRelation(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getRelation(n);
    }

    public final JRelation getRelation(int n) throws DSException {
        IRelationData iRelationData = this.getRelationData(n);
        return iRelationData.createRelation();
    }

    public final IRelationData getRelationData(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getRelationData(n);
    }

    public final IRelationData getRelationData(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        IRelationData iRelationData = this.tuple.getRelationData(n);
        this.subRelationDataList.add(iRelationData);
        return iRelationData;
    }

    public final boolean next() throws DSException {
        this.checkClose();
        long l = this.getPosition();
        if (l == -1L) {
            l = 0L;
        }
        this.beforeChangePosition(l + 1L);
        boolean bl = this.rowID.next();
        this.onChangePosition();
        return bl;
    }

    public final void close() throws DSException {
        if (!this.canClose()) {
            return;
        }
        if (this.isClose) {
            return;
        }
        this.onClose();
        Iterator iterator = this.subRelationDataList.iterator();
        while (iterator.hasNext()) {
            IRelationData iRelationData = (IRelationData)iterator.next();
            if (iRelationData.isClosed()) continue;
            iRelationData.close();
        }
        this.subRelationDataList.clear();
        this.tuple.close();
        this.relationData.removeTuple(this.tuple);
        this.isClose = true;
    }

    public final void beforeFirst() throws DSException {
        this.checkClose();
        this.rowID.beforeFirst();
        this.onChangePosition();
    }

    public final void afterLast() throws DSException {
        this.checkClose();
        this.rowID.afterLast();
        this.onChangePosition();
    }

    public final boolean first() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.first();
        this.onChangePosition();
        return bl;
    }

    public final boolean isAfterLast() throws DSException {
        this.checkClose();
        return this.rowID.isAfterLast();
    }

    public final boolean isBeforeFirst() throws DSException {
        this.checkClose();
        return this.rowID.isBeforeFirst();
    }

    public final boolean isFirst() throws DSException {
        this.checkClose();
        return this.rowID.isFirst();
    }

    public final boolean isLast() throws DSException {
        this.checkClose();
        return this.rowID.isLast();
    }

    public final boolean last() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.last();
        this.onChangePosition();
        return bl;
    }

    public final boolean previous() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.previous();
        this.onChangePosition();
        return bl;
    }

    public final boolean relative(int n) throws DSException {
        this.checkClose();
        boolean bl = this.rowID.relative(n);
        this.onChangePosition();
        return bl;
    }

    public final void setFetchDirection(int n) throws DSException {
        this.checkClose();
        this.rowID.setFetchDirection(n);
    }

    public final void setFetchSize(int n) throws DSException {
        this.checkClose();
        this.rowID.setFetchSize(n);
    }

    public final void clearWarnings() throws DSException {
        this.checkClose();
        this.rowID.clearWarnings();
    }

    public final void getWarnings() throws DSException {
        this.checkClose();
        this.rowID.getWarnings();
    }

    public final int getFetchDirection() throws DSException {
        this.checkClose();
        return this.rowID.getFetchDirection();
    }

    public final int getFetchSize() throws DSException {
        this.checkClose();
        return this.rowID.getFetchSize();
    }

    public final long getExtent() throws DSException {
        this.checkClose();
        return this.rowID.getExtent();
    }

    public final void setPosition(long l) throws DSException {
        this.checkClose();
        this.beforeChangePosition(l);
        this.rowID.setPosition(l);
        this.onChangePosition();
    }

    public final long getPosition() throws DSException {
        this.checkClose();
        return this.rowID.getPosition();
    }

    public final InputStream getAsciiStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final InputStream getAsciiStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final BigDecimal getBigDecimal(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBigDecimal(n);
    }

    public final BigDecimal getBigDecimal(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    public final InputStream getBinaryStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final InputStream getBinaryStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Blob getBlob(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBlob(n);
    }

    public final Blob getBlob(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    public final boolean getBoolean(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBoolean(n);
    }

    public final boolean getBoolean(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    public final byte getByte(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getByte(n);
    }

    public final byte getByte(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    public final byte[] getBytes(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBytes(n);
    }

    public final byte[] getBytes(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public final Reader getCharacterStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Reader getCharacterStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Clob getClob(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getClob(n);
    }

    public final Clob getClob(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    public final Date getDate(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getDate(n);
    }

    public final Date getDate(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public final Date getDate(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Date getDate(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final double getDouble(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getDouble(n);
    }

    public final double getDouble(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public final float getFloat(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getFloat(n);
    }

    public final float getFloat(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public final int getInt(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getInt(n);
    }

    public final int getInt(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public final long getLong(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getLong(n);
    }

    public final long getLong(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public final Object getObject(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getObject(n);
    }

    public final Object getObject(String string) throws DSException {
        int n = this.findColumn(string);
        return this.tuple.getObject(n);
    }

    public final Object getObject(int n, Map map) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Object getObject(String string, Map map) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final short getShort(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getShort(n);
    }

    public final short getShort(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public final String getString(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getString(n);
    }

    public final String getString(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public final Time getTime(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getTime(n);
    }

    public final Time getTime(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public final Time getTime(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Time getTime(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Timestamp getTimestamp(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getTimeStamp(n);
    }

    public final Timestamp getTimestamp(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public final Timestamp getTimestamp(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final Timestamp getTimestamp(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    public final boolean wasNull() throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.wasNull();
    }

    public Array getArray(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getArray(n);
    }

    public Array getArray(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }
}

