/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.security.api.exception.NoPermissionException;
import com.jinfonet.security.control.CubePermissionCalculator;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.PermissionCalculator;
import com.jinfonet.security.util.AclToolkit;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Hashtable;

public class CubeAclManager {
    private Hashtable QOIV;
    private PrincipalManager append;
    private PermissionCalculator checkPermission = null;

    public CubeAclManager(PrincipalManager principalManager, Hashtable hashtable) {
        this.QOIV = hashtable;
        this.append = principalManager;
        String string = System.getProperty("com.jinfonet.permission.calculator");
        if (string == null || string.length() == 0) {
            this.checkPermission = new CubePermissionCalculator();
        } else {
            try {
                this.checkPermission = (PermissionCalculator)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                this.checkPermission = new CubePermissionCalculator();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                this.checkPermission = new CubePermissionCalculator();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                this.checkPermission = new CubePermissionCalculator();
            }
        }
    }

    public void setPrincipalManager(PrincipalManager principalManager) {
        this.append = principalManager;
    }

    public void setAcls(Hashtable hashtable) {
        this.QOIV = hashtable;
    }

    public Hashtable getAcls() {
        return this.QOIV;
    }

    public boolean checkPermission(Principal principal, String string, Permission permission) throws InvalidResource {
        if (!(principal instanceof JRPrincipal)) {
            return false;
        }
        Acl acl = (Acl)this.QOIV.get(string);
        if (acl == null) {
            return true;
        }
        boolean bl = this.checkPermission.checkPermission((JRPrincipal)principal, acl, permission);
        while (!bl) {
            if ((string = this.QOIV(string)) == null || string.length() == 0) {
                return false;
            }
            bl = this.checkPermission.checkPermission((JRPrincipal)principal, acl, permission);
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    private String QOIV(String string) {
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public Hashtable[] getPermissions(Principal principal, String string) throws NoPermissionException, InvalidResource {
        if (principal == null) {
            throw new NoPermissionException("The operator is null.");
        }
        if (string == null) {
            throw new InvalidResource("Resource path is null.");
        }
        Hashtable[] hashtableArray = null;
        Acl acl = (Acl)this.QOIV.get(string);
        if (acl != null) {
            hashtableArray = AclToolkit.getHsahtableFromAcls(acl);
        } else {
            String string2 = this.QOIV(string);
            if (string2 != null) {
                hashtableArray = this.getPermissions(principal, this.QOIV(string));
            }
        }
        return hashtableArray;
    }

    public void setPermissions(Principal principal, String string, Hashtable[] hashtableArray) throws NoPermissionException, InvalidResource {
        Acl acl;
        if (principal == null) {
            throw new NoPermissionException("The operator is null.");
        }
        if (string == null) {
            throw new InvalidResource("Resource path is null.");
        }
        String string2 = "JRAcl[" + string + "]";
        try {
            acl = AclToolkit.createAclByHashtable(principal, string2, hashtableArray, this.append);
        }
        catch (NotOwnerException notOwnerException) {
            notOwnerException.printStackTrace();
            throw new NoPermissionException("The operator is not acl owner!");
        }
        this.QOIV.put(string, acl);
    }

    public void clearMem() {
        this.append = null;
        this.QOIV = null;
    }
}

