/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.cs.Param;
import jet.cs.ui.GroupParameterChangeListener;
import jet.cs.ui.ParamsTookit;
import jet.cs.ui.param.EnterParameterValuesDialog;
import jet.formula.ParamDesc;
import jet.util.JHelp;

public class ParamsDialog
extends EnterParameterValuesDialog {
    private static GroupParameterChangeListener QOIV = new GroupParameterChangeListener();

    public ParamsDialog(Frame frame, String string, Vector vector, Vector vector2, boolean bl, Locale locale, Hashtable hashtable) {
        super(frame, ParamsDialog.QOIV(vector, locale), vector2, locale, QOIV, hashtable);
        QOIV.setLocale(locale);
    }

    public boolean isCanceled() {
        return !this.isOk() && !this.isDefault();
    }

    public Hashtable getParamValuesInHashtable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration enumeration = this.getParamDescs().elements();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
            if (paramDesc.isMultipleValue()) {
                if (paramDesc.isAllSelected() || this.isDefault) {
                    hashtable.put("jrs.param$" + paramDesc.getName(), new String[]{"\u0007"});
                } else if (paramDesc.getMultiStrValue() != null) {
                    hashtable.put("jrs.param$" + paramDesc.getName(), paramDesc.getMultiStrValue());
                }
                hashtable.put("_isMultiple_jrs.param$" + paramDesc.getName(), "true");
                continue;
            }
            if (this.isDefault) {
                hashtable.put("jrs.param$" + paramDesc.getName(), paramDesc.getDefaultValue());
                continue;
            }
            hashtable.put("jrs.param$" + paramDesc.getName(), paramDesc.value);
        }
        return hashtable;
    }

    public Vector getParamsVector() {
        Vector<Param> vector = new Vector<Param>();
        Enumeration enumeration = this.getParamDescs().elements();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
            Param param = Param.parseFromParamDescToParam(paramDesc);
            vector.addElement(param);
        }
        return vector;
    }

    private static Hashtable QOIV(Vector vector, Locale locale) {
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Param param = (Param)vector.elementAt(n2);
            ParamDesc paramDesc = Param.toParamDesc(param, locale);
            hashtable.put(paramDesc.getName(), paramDesc);
            ++n2;
        }
        return hashtable;
    }

    protected String serverValidateParam() {
        String string = super.serverValidateParam();
        if (string == null) {
            string = ParamsTookit.validateParameter(this.getParamValuesInHashtable(), this.rptProps);
        }
        return string;
    }

    protected void clickOk() {
        this.isDef = false;
        if (this.validateParam() && this.checkReqValue()) {
            this.isOk = true;
            this.isDefault = false;
            this.dialog.dispose();
        }
    }

    protected void clickDefault() {
        this.isDef = true;
        if (this.checkReqValue()) {
            this.isOk = false;
            this.isDefault = true;
            this.dialog.dispose();
        }
    }

    protected void onClickHelp() {
        JHelp.helpLink(30016);
    }
}

