/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util;

import java.util.HashSet;
import java.util.StringTokenizer;
import jet.dataengine8.util.SFT;

public final class StringTools {
    public static final String ENTER_STRING = System.getProperty("line.separator");

    public static boolean isEmptyString(String string) {
        if (string == null) {
            return true;
        }
        return string.equals("");
    }

    public static boolean isEmptyStringWithTrim(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() < 1;
    }

    public static String removeChar4BeginAndEnd(String string, char c) {
        if (StringTools.isEmptyString(string)) {
            return string;
        }
        String string2 = string;
        if (string2.charAt(0) == c && string2.charAt(string2.length() - 1) == c) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public static boolean isStartAndEndWithSpecialChar(String string, char c) {
        if (StringTools.isEmptyString(string)) {
            return false;
        }
        String string2 = string;
        return string2.charAt(0) == c && string2.charAt(string2.length() - 1) == c;
    }

    public static String getSubStringIngoreCase(String string, String string2, String string3) {
        if (StringTools.isEmptyString(string)) {
            return string;
        }
        String string4 = string.toUpperCase();
        int n = 0;
        int n2 = 0;
        if (!StringTools.isEmptyString(string2) || !StringTools.isEmptyString(string3)) {
            n = string4.indexOf(string2.toUpperCase());
            n2 = string4.lastIndexOf(string3.toUpperCase());
            string4 = n >= 0 && n < n2 ? string.substring(n + string2.length(), n2) : (n == -1 ? string.substring(0, n2) : (n2 == -1 ? string.substring(n) : string));
        } else if (!StringTools.isEmptyString(string2)) {
            n = string4.indexOf(string2.toUpperCase());
            string4 = string.substring(n + string2.length());
        } else if (!StringTools.isEmptyString(string3.toUpperCase())) {
            n2 = string4.lastIndexOf(string3);
            string4 = string.substring(0, n2);
        } else {
            string4 = string;
        }
        return string4;
    }

    public static int indexOf4IngnoreCase(String string, String string2) {
        if (!StringTools.isEmptyString(string) && !StringTools.isEmptyString(string2)) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            return string3.indexOf(string4);
        }
        return -1;
    }

    public static int indexOf4IngnoreCase(String string, String string2, int n) {
        if (!StringTools.isEmptyString(string) && !StringTools.isEmptyString(string2)) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            return string3.indexOf(string4, n);
        }
        return -1;
    }

    public static String replaceAllIngnoreCase(String string, String string2, String string3) {
        if (StringTools.isEmptyString(string)) {
            return string;
        }
        if (!StringTools.isEmptyString(string2)) {
            if (!StringTools.isEmptyString(string3) && string2.compareTo(string3) == 0) {
                return string;
            }
            String string4 = string;
            int n = StringTools.indexOf4IngnoreCase(string, string2, 0);
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (n != -1) {
                boolean bl = true;
                while (n != -1) {
                    if (bl) {
                        stringBuffer.append(string4.substring(0, n));
                        bl = false;
                    }
                    stringBuffer.append(string3 == null ? "" : string3);
                    n2 = n;
                    n = StringTools.indexOf4IngnoreCase(string, string2, n2 + string2.length());
                    if (n == -1) {
                        stringBuffer.append(string4.substring(n2 + string2.length()));
                        continue;
                    }
                    stringBuffer.append(string4.substring(n2 + string2.length(), n));
                }
                return stringBuffer.toString();
            }
            return string;
        }
        return string;
    }

    public static String replaceIngnoreCase(String string, String string2, String string3, int n) {
        String string4 = string;
        if (StringTools.isEmptyString(string)) {
            return string4;
        }
        if (!StringTools.isEmptyString(string2)) {
            String string5;
            if (!StringTools.isEmptyString(string3)) {
                if (string2.compareTo(string3) == 0) {
                    return string4;
                }
                if (string2.compareToIgnoreCase(string3) == 0) {
                    String string6;
                    String string7 = string;
                    String string8 = string.toUpperCase();
                    int n2 = string8.indexOf(string6 = string2.toUpperCase(), n);
                    if (n2 > -1) {
                        string4 = string7.substring(0, n2);
                        string4 = string4 + (string3 == null ? "" : string3);
                        string7 = string4 = string4 + string7.substring(n2 + string2.length());
                    }
                    string8 = string4.toUpperCase();
                    return string4;
                }
            }
            String string9 = string;
            String string10 = string.toUpperCase();
            int n3 = string10.indexOf(string5 = string2.toUpperCase(), n);
            if (n3 > -1) {
                string4 = string9.substring(0, n3);
                string4 = string4 + (string3 == null ? "" : string3);
                string9 = string4 = string4 + string9.substring(n3 + string2.length());
            }
            string10 = string4.toUpperCase();
        }
        return string4;
    }

    public static String getFirstParameterNameInString4UDSParameter(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer == null) {
            return null;
        }
        int n = 0;
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.setLength(0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = stringBuffer.charAt(n4);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer3.setLength(0);
                        break;
                    }
                    if (c == '\"') {
                        n3 = stringBuffer2.length();
                        n = 3;
                        break;
                    }
                    stringBuffer2.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        StringTools.delete(stringBuffer, n4);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        StringTools.delete(stringBuffer, n4 + 1);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        if (n3 == stringBuffer2.length()) {
                            stringBuffer2.append('\"');
                        }
                        n = 0;
                        break;
                    }
                    stringBuffer2.append(c);
                }
            }
            ++n4;
        }
        if (n == 1) {
            StringTools.delete(stringBuffer, n2);
            return stringBuffer3.toString();
        }
        if (n == 3) {
            stringBuffer2.insert(n3, '\"');
        }
        return null;
    }

    private static void delete(StringBuffer stringBuffer, int n) {
        String string = stringBuffer.toString();
        string = string.substring(n);
        stringBuffer.setLength(0);
        stringBuffer.append(string);
    }

    public static String[] getDistinctStringArray(String[] stringArray) {
        if (StringTools.isEmptyStringArray(stringArray)) {
            return SFT.ZERO_STRING_ARRAY;
        }
        if (stringArray.length == 1) {
            return stringArray;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        return hashSet.toArray(SFT.ZERO_STRING_ARRAY);
    }

    public static boolean isEmptyStringArray(String[] stringArray) {
        return stringArray == null || stringArray.length == 0;
    }

    public static boolean equalsStringArray(String[] stringArray, String[] stringArray2) {
        if (StringTools.isEmptyStringArray(stringArray) || StringTools.isEmptyStringArray(stringArray2) || stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        String string = null;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n && bl) {
            string = stringArray[n2];
            int n3 = 0;
            while (bl = n3 < n) {
                if (string.equals(stringArray2[n3])) break;
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int indexOfStringArray(String[] stringArray, String string) {
        if (StringTools.isEmptyString(string) || StringTools.isEmptyStringArray(stringArray)) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int indexOfStringArrayIngoreCase(String[] stringArray, String string) {
        if (StringTools.isEmptyString(string) || StringTools.isEmptyStringArray(stringArray)) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String replaceFirstWord(String string, String string2, String string3) {
        int n = -1;
        n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String getSQLString(String string) {
        if (!StringTools.isEmptyStringWithTrim(string)) {
            String string2 = null;
            string2 = StringTools.isStartAndEndWithSpecialString(string, "'") ? StringTools.removeChar4BeginAndEnd(string, '\'') : string;
            return "'" + string2 + "'";
        }
        return "''";
    }

    public static String getSQLString4pushdownParser(String string) {
        if (!StringTools.isEmptyStringWithTrim(string)) {
            String string2 = null;
            string2 = StringTools.replaceAllIngnoreCase(string, "'", "''");
            return "'" + string2 + "'";
        }
        return "''";
    }

    public static boolean isStartAndEndWithSpecialString(String string, String string2) {
        if (StringTools.isEmptyString(string) || StringTools.isEmptyString(string2)) {
            return false;
        }
        return string.startsWith(string2) && string.endsWith(string2);
    }

    public static int getReferenceIndex(String string, int n, StringBuffer stringBuffer) {
        int n2 = string.length();
        int n3 = -1;
        if (n2 < n) {
            return n3;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n4 = n;
        while (n4 < n2) {
            char c = string.charAt(n4);
            switch (c) {
                case ':': 
                case '@': {
                    if (++n4 >= n2) break;
                    c = string.charAt(n4);
                    stringBuffer2.setLength(0);
                    n3 = n4++;
                    if (c == '\"') {
                        while (n4 < n2) {
                            c = string.charAt(n4);
                            if (c == '\"') {
                                stringBuffer.append(stringBuffer2);
                                return n3;
                            }
                            stringBuffer2.append(c);
                            ++n4;
                        }
                        break;
                    }
                    int n5 = n4;
                    while (n4 < n2) {
                        c = string.charAt(n4);
                        if (n4 == n5 && c >= '0' && c <= '9' || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z') && c != '_' && (c < '0' || c > '9')) break;
                        stringBuffer2.append(c);
                        ++n4;
                    }
                    if (stringBuffer2.length() <= 0) break;
                    stringBuffer.append(stringBuffer2);
                    return n3;
                }
                case '\'': {
                    if (++n4 >= n2 || (c = string.charAt(n4)) == '\'') break;
                    ++n4;
                }
            }
            ++n4;
        }
        return -1;
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (!StringTools.isEmptyString(string) && !StringTools.isEmptyString(string2) && n <= string.length() && n + string2.length() <= string.length() && string.substring(n, n + string2.length()).equalsIgnoreCase(string2)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(n + string2.length(), string.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getAliasName(String string) {
        if (!StringTools.isEmptyStringWithTrim(string)) {
            if (string.matches("^@\".+\"$")) {
                return string.substring(2, string.length() - 1);
            }
            if (string.matches("^@.+$")) {
                return string.substring(1);
            }
            if (string.matches("^\".+\".\".+\"")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string2 = stringTokenizer.nextToken();
                String string3 = "'" + string2.substring(1, string2.length() - 1) + "'.";
                string2 = stringTokenizer.nextToken();
                string3 = string3 + "'" + string2.substring(1, string2.length() - 1) + "'";
                return string3;
            }
            if (string.matches("^\".+\"..+")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string4 = stringTokenizer.nextToken();
                String string5 = "'" + string4.substring(1, string4.length() - 1) + "'.";
                string4 = stringTokenizer.nextToken();
                string5 = string5 + string4.substring(1, string4.length() - 1);
                return string5;
            }
            if (string.matches("^.+.\".+\"")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string6 = stringTokenizer.nextToken();
                String string7 = string6 + ".";
                string6 = stringTokenizer.nextToken();
                string7 = string7 + "'" + string6.substring(1, string6.length() - 1) + "'";
                return string7;
            }
            if (string.matches("^'.+'.'.+'")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string8 = stringTokenizer.nextToken();
                String string9 = "'" + string8.substring(1, string8.length() - 1) + "'.";
                string8 = stringTokenizer.nextToken();
                string9 = string9 + "'" + string8.substring(1, string8.length() - 1) + "'";
                return string9;
            }
            if (string.matches("^'.+'..+")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string10 = stringTokenizer.nextToken();
                String string11 = "'" + string10.substring(1, string10.length() - 1) + "'.";
                string10 = stringTokenizer.nextToken();
                string11 = string11 + string10;
                return string11;
            }
            if (string.matches("^.+.'.+'")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string12 = stringTokenizer.nextToken();
                String string13 = string12 + ".";
                string12 = stringTokenizer.nextToken();
                string13 = string13 + "'" + string12.substring(1, string12.length() - 1) + "'";
                return string13;
            }
            return string;
        }
        return null;
    }

    public static boolean contains(String string, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String string, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String trimBlankSpace(String string) {
        if (StringTools.isEmptyString(string)) {
            return string;
        }
        String string2 = string.trim();
        int n = 0;
        if (string2.length() > 0) {
            while (string2.charAt(n) == ' ') {
                ++n;
            }
            string2 = string2.substring(n);
            return string2;
        }
        return "";
    }

    public static String convertSQLPattern2JavaPattern(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string;
        string2 = StringTools.replaceAllIngnoreCase(string2, "_", ".");
        string2 = StringTools.replaceAllIngnoreCase(string2, "%", ".*");
        return string2;
    }

    public static String removeBeginAndEndParentheses(String string) {
        String string2 = string;
        if (string2.startsWith("(") && string2.endsWith(")")) {
            string2 = string2.substring(1, string2.length() - 1);
        } else if (string2.startsWith("(") && !string2.endsWith(")")) {
            string2 = string2.substring(1, string2.length());
        } else if (!string2.startsWith("(") && string2.endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

