/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import chart.ChartPropertyValues;
import chart.data.ChartDataFilter;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.controls.JetVector;
import jet.util.MiscTools;

public class JetChartPropertyValues
extends ChartPropertyValues {
    private static final String I = "" + (char)("\u0007".charAt(0) + '\u0001');
    public static final String AXIS_PREFIX = "Axis";
    public static final String WALL_PREFIX = "Wall";
    public static final String BACKGROUND_PREFIX = "Background";
    public static final String TEXTSTYLE_PREFIX = "Text";
    public static final String PENSTYLE_PREFIX = "Pen";
    public static final String FILLPATTERN_PREFIX = "Pattern";

    public static String getFontSpecialEffect1String(ChartTextStyle chartTextStyle) {
        String string = null;
        string = chartTextStyle.isEmbossed() ? "Embossed" : (chartTextStyle.isEngraved() ? "Engraved" : (chartTextStyle.isOutlined() && chartTextStyle.isShadowed() ? "Shadowed & Outlined" : (chartTextStyle.isOutlined() ? "Outlined" : (chartTextStyle.isShadowed() ? "Shadowed" : "None"))));
        return string;
    }

    public static String getFontSpecialEffect2String(ChartTextStyle chartTextStyle) {
        String string = null;
        string = chartTextStyle.isSuperscript() ? "Superscript" : (chartTextStyle.isSubscript() ? "Subscript" : "None");
        return string;
    }

    public static void setFontSpecialEffect1(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleEmbossed();
                break;
            }
            case 2: {
                chartTextStyle.toggleEngraved();
                break;
            }
            case 3: {
                chartTextStyle.toggleShadowed();
                break;
            }
            case 4: {
                chartTextStyle.toggleOutlined();
                break;
            }
            case 5: {
                chartTextStyle.toggleShadowed();
                chartTextStyle.toggleOutlined();
            }
        }
    }

    public static void setFontSpecialEffect2(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleSuperscript();
                break;
            }
            case 2: {
                chartTextStyle.toggleSubscript();
            }
        }
    }

    public static ChartFillPattern mapFillPattern(String string) {
        ChartFillPattern chartFillPattern = null;
        switch (string.charAt(0)) {
            case 'C': 
            case 'c': {
                String string2 = string.substring(1, 9);
                Color color = !string2.equals("No_Color") ? MiscTools.mapStringToColor(string2) : null;
                chartFillPattern = new ChartColorPattern(color);
                String string3 = string.substring(9);
                float f = (float)Integer.valueOf(string3).intValue() / 100.0f;
                chartFillPattern.setAlpha(f);
                break;
            }
            case 'T': 
            case 't': {
                String string4 = string.charAt(1) != '0' ? string.substring(1, 3) : string.substring(1, 3);
                int n = Integer.valueOf(string4);
                String string5 = string.substring(3, 11);
                Color color = !string5.equals("No_Color") ? MiscTools.mapStringToColor(string5) : null;
                String string6 = string.substring(11, 19);
                Color color2 = !string6.equals("No_Color") ? MiscTools.mapStringToColor(string6) : null;
                chartFillPattern = new ChartTexturePattern(n, new ChartColorPattern(color), new ChartColorPattern(color2));
                String string7 = string.substring(19);
                float f = (float)Integer.valueOf(string7).intValue() / 100.0f;
                ((ChartTexturePattern)chartFillPattern).setAlpha(f);
                break;
            }
            case 'G': 
            case 'g': {
                String string8 = string.substring(1, 3);
                int n = Integer.valueOf(string8);
                String string9 = string.substring(3, 11);
                Color color = !string9.equals("No_Color") ? MiscTools.mapStringToColor(string9) : null;
                String string10 = string.substring(11, 19);
                Color color3 = !string10.equals("No_Color") ? MiscTools.mapStringToColor(string10) : null;
                String string11 = string.substring(19, 22);
                float f = (float)Integer.valueOf(string11).intValue() / 100.0f;
                String string12 = string.substring(22, 25);
                float f2 = 1.0f - (float)Integer.valueOf(string12).intValue() / 100.0f;
                String string13 = string.substring(25, 28);
                float f3 = (float)Integer.valueOf(string13).intValue() / 100.0f;
                String string14 = string.substring(28, 31);
                float f4 = 1.0f - (float)Integer.valueOf(string14).intValue() / 100.0f;
                String string15 = string.substring(31);
                chartFillPattern = new ChartGradientPattern(n);
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(color));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(color3));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float(f, f2));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float(f3, f4));
                float f5 = (float)Integer.valueOf(string15).intValue() / 100.0f;
                ((ChartGradientPattern)chartFillPattern).setAlpha(f5);
                break;
            }
            case 'N': 
            case 'n': {
                chartFillPattern = null;
            }
        }
        return chartFillPattern;
    }

    public static String mapPatternString(ChartFillPattern chartFillPattern) {
        String string;
        Object object;
        String string2 = "";
        if (chartFillPattern == null) {
            string2 = string2 + "n";
        } else if (chartFillPattern instanceof ChartColorPattern) {
            string2 = string2 + "c";
            Color color = ((ChartColorPattern)chartFillPattern).getColor();
            string2 = color != null ? string2 + MiscTools.mapColorToString(color) : string2 + "No_Color";
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            string2 = string2 + "t";
            object = (ChartTexturePattern)chartFillPattern;
            int n = ((ChartTexturePattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartTexturePattern)object).getForeground().getColor();
            String string3 = color != null ? MiscTools.mapColorToString(color) : "No_Color";
            Color color2 = ((ChartTexturePattern)object).getBackground().getColor();
            String string4 = color2 != null ? MiscTools.mapColorToString(color2) : "No_Color";
            string2 = string2 + string + string3 + string4;
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            string2 = string2 + "g";
            object = (ChartGradientPattern)chartFillPattern;
            int n = ((ChartGradientPattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartGradientPattern)object).getStartColor().getColor();
            String string5 = color != null ? MiscTools.mapColorToString(color) : "No_Color";
            Color color3 = ((ChartGradientPattern)object).getEndColor().getColor();
            String string6 = color3 != null ? MiscTools.mapColorToString(color3) : "No_Color";
            int n2 = (int)(((ChartGradientPattern)object).getStartPoint().getX() * 100.0);
            int n3 = (int)((1.0 - ((ChartGradientPattern)object).getStartPoint().getY()) * 100.0);
            int n4 = (int)(((ChartGradientPattern)object).getEndPoint().getX() * 100.0);
            int n5 = (int)((1.0 - ((ChartGradientPattern)object).getEndPoint().getY()) * 100.0);
            String string7 = "";
            if (n2 < 10) {
                string7 = "00";
            } else if (n2 < 100) {
                string7 = "0";
            }
            string7 = string7 + String.valueOf(new Integer(n2));
            String string8 = "";
            if (n4 < 10) {
                string8 = "00";
            } else if (n4 < 100) {
                string8 = "0";
            }
            string8 = string8 + String.valueOf(new Integer(n4));
            String string9 = "";
            if (n3 < 10) {
                string9 = "00";
            } else if (n3 < 100) {
                string9 = "0";
            }
            string9 = string9 + String.valueOf(new Integer(n3));
            String string10 = "";
            if (n5 < 10) {
                string10 = "00";
            } else if (n5 < 100) {
                string10 = "0";
            }
            string10 = string10 + String.valueOf(new Integer(n5));
            string2 = string2 + string + string5 + string6 + string7 + string9 + string8 + string10;
        }
        if (chartFillPattern != null) {
            object = "";
            int n = (int)(chartFillPattern.getAlpha() * 100.0f);
            if (n < 10) {
                object = "00";
            } else if (n < 100) {
                object = "0";
            }
            object = (String)object + String.valueOf(new Integer(n));
            string2 = string2 + (String)object;
        }
        return string2;
    }

    public static ChartFillPattern[] mapPatterns(JetVector jetVector) {
        return JetChartPropertyValues.mapPatterns(jetVector.get());
    }

    public static ChartFillPattern[] mapPatterns(Vector vector) {
        ChartFillPattern[] chartFillPatternArray = null;
        if (vector != null) {
            int n = vector.size();
            chartFillPatternArray = new ChartFillPattern[n];
            int n2 = 0;
            while (n2 < n) {
                chartFillPatternArray[n2] = JetChartPropertyValues.mapFillPattern((String)vector.get(n2));
                ++n2;
            }
        }
        return chartFillPatternArray;
    }

    public static ChartFillPattern[] mapPatterns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0007");
        int n = stringTokenizer.countTokens();
        ChartFillPattern[] chartFillPatternArray = null;
        if (string != null && n > 0) {
            chartFillPatternArray = new ChartFillPattern[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                chartFillPatternArray[n2] = JetChartPropertyValues.mapFillPattern(string2);
                ++n2;
            }
        }
        return chartFillPatternArray;
    }

    public static String mapPatternList(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        if (chartFillPatternArray != null) {
            int n = 0;
            while (n < chartFillPatternArray.length) {
                if (n != 0) {
                    string = string + "\u0007";
                }
                string = string + JetChartPropertyValues.mapPatternString(chartFillPatternArray[n]);
                ++n;
            }
        }
        return string;
    }

    public static ChartDataFilter mapChartDataFilter(JetVector jetVector) {
        return JetChartPropertyValues.mapChartDataFilter(jetVector.get());
    }

    public static ChartDataFilter mapChartDataFilter(Vector vector) {
        ChartDataFilter chartDataFilter = null;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector2 = new Vector<Object[]>();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.get(n2);
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
                vector2.add(objectArray);
                ++n2;
            }
            chartDataFilter.setFilters(vector2);
        }
        return chartDataFilter;
    }

    public static ChartDataFilter mapChartDataFilter(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0007");
        int n = stringTokenizer.countTokens();
        ChartDataFilter chartDataFilter = null;
        if (string != null && n > 0) {
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector = new Vector<Object[]>();
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string2.substring(0, 1))), string2.substring(1)};
                vector.add(objectArray);
                ++n2;
            }
            chartDataFilter.setFilters(vector);
        }
        return chartDataFilter;
    }

    public static String mapFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            int n = 0;
            while (n < chartDataFilter.getFilters().size()) {
                if (n != 0) {
                    string = string + "\u0007";
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(n);
                string = string + objectArray[0].toString() + objectArray[1].toString();
                ++n;
            }
        }
        return string;
    }

    public static ChartDataFilter[] mapChartDataFilters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, I);
        int n = stringTokenizer.countTokens();
        ChartDataFilter[] chartDataFilterArray = null;
        if (string != null && n > 0) {
            chartDataFilterArray = new ChartDataFilter[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                chartDataFilterArray[n2] = JetChartPropertyValues.mapChartDataFilter(string2);
                ++n2;
            }
        }
        return chartDataFilterArray;
    }

    public static String mapChartDataFilterList(ChartDataFilter[] chartDataFilterArray) {
        String string = "";
        if (chartDataFilterArray != null) {
            int n = 0;
            while (n < chartDataFilterArray.length) {
                if (n != 0) {
                    string = string + I;
                }
                JetChartPropertyValues.mapFilterString(chartDataFilterArray[n]);
                ++n;
            }
        }
        return string;
    }

    public static int[] mapIconStyles(String string) {
        int n = string.length() / 2;
        int[] nArray = null;
        if (n > 0) {
            nArray = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            String string2 = string.substring(n2 * 2, n2 * 2 + 2);
            nArray[n2] = Integer.valueOf(string2);
            ++n2;
        }
        return nArray;
    }

    public static String mapIconStyleList(int[] nArray) {
        String string = "";
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] < 10) {
                    string = string + "0";
                }
                string = string + nArray[n];
                ++n;
            }
        }
        return string;
    }

    public static int[] mapValueLabelPositions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0007");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        if (string != null && n > 0) {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (Integer)ChartPropertyValues.VALUELABEL_POSITION_ENUMERATIONS.get(stringTokenizer.nextToken());
                ++n2;
            }
        }
        return nArray;
    }

    public static String mapValueLabelPositionList(int[] nArray) {
        String string = "";
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                if (n != 0) {
                    string = string + "\u0007";
                }
                string = string + ChartPropertyValues.VALUELABEL_POSITION_INTEGERS.get(new Integer(nArray[n]));
                ++n;
            }
        }
        return string;
    }

    public static String getDefaultPatternString() {
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[ChartPropertyValues.COLORLENGTH];
        int n = 0;
        while (n < ChartPropertyValues.COLORLENGTH) {
            chartFillPatternArray[n] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[n]));
            ++n;
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    public static String getDefaultAreaPatternString() {
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[ChartPropertyValues.COLORLENGTH];
        int n = 0;
        while (n < ChartPropertyValues.COLORLENGTH) {
            chartFillPatternArray[n] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[n]));
            chartFillPatternArray[n].setAlpha(100.0f);
            ++n;
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    public static void addFilter(ChartDataFilter chartDataFilter, int n, int n2) {
        String string = "";
        if (n > 0 && n2 > 0) {
            if (chartDataFilter == null) {
                chartDataFilter = new ChartDataFilter();
            }
            int n3 = 0;
            while (n3 < n) {
                if (n3 == n2) {
                    string = string + ".";
                }
                string = string + "#";
                ++n3;
            }
        }
        ChartPropertyValues.addFilter(chartDataFilter, 1, JetChartPropertyValues.COLORLENGTH(string));
    }

    private static String COLORLENGTH(String string) {
        int n = string.indexOf(".");
        String string2 = "";
        String string3 = "";
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n, string.length());
        }
        String string4 = "";
        int n2 = 0;
        int n3 = string2.length();
        while (n2 < n3) {
            if (n2 % 3 == 0 && n2 != 0) {
                string4 = string4 + ",";
            }
            string4 = string4 + "#";
            ++n2;
        }
        char[] cArray = string4.toCharArray();
        int n4 = string4.length();
        char[] cArray2 = new char[n4];
        int n5 = 0;
        while (n5 < n4) {
            cArray2[n5] = cArray[n4 - 1 - n5];
            ++n5;
        }
        return new String(cArray2) + string3;
    }
}

