/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderDropDownList
extends Render {
    private Vector DEFAULT_SHADOW_WIDTH;
    private Vector I;
    private boolean QOIV;
    private String black;
    private String convertPixelToUnit;
    private Color convertUnitToPixel = Color.white;
    private Color drawBorder = Color.black;
    private DSMultiValueContainer get;

    public RenderDropDownList(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderDropDownList(DSMultiValueContainer dSMultiValueContainer) {
        this.get = dSMultiValueContainer;
        this.resolution = dSMultiValueContainer.getResolution();
    }

    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.DEFAULT_SHADOW_WIDTH.size()) {
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(n3), this.font).getWidth(), this.resolution) + 4;
            int n5 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(n3), this.font).getHeight(), this.resolution) + 4;
            if (n < n4) {
                n = n4;
            }
            if (n2 < n5) {
                n2 = n5;
            }
            ++n3;
        }
        this.width = n;
        this.height = n2;
    }

    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.get != null) {
            this.convertUnitToPixel = RenderUtil.getColorPropertyByName(this.get, "Background");
            this.drawBorder = RenderUtil.getColorPropertyByName(this.get, "Foreground");
        }
        this.DEFAULT_SHADOW_WIDTH(graphics);
        RenderGraphicsToolkit.paintDropdown(graphics, this.convertPixelToUnit, this.font, n, n2, n3, n4, this.QOIV, this.convertUnitToPixel, this.drawBorder);
    }

    private void DEFAULT_SHADOW_WIDTH(Graphics graphics) {
        if (this.get == null) {
            return;
        }
        Rectangle rectangle = null;
        int n = this.get.getResolution();
        rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.get.getWidth(), n), Unit.convertUnitToPixel(this.get.getHeight(), n));
        Color color = RenderUtil.getColorPropertyByName(this.get, "Background");
        Color color2 = RenderUtil.getColorPropertyByName(this.get, "BorderColor");
        Color color3 = RenderUtil.getColorPropertyByName(this.get, "ShadowColor");
        int n2 = RenderUtil.getIntPropertyByName(this.get, "LeftLine");
        int n3 = RenderUtil.getIntPropertyByName(this.get, "RightLine");
        int n4 = RenderUtil.getIntPropertyByName(this.get, "TopLine");
        int n5 = RenderUtil.getIntPropertyByName(this.get, "BottomLine");
        int n6 = RenderUtil.getIntPropertyByName(this.get, "BorderWidth");
        int n7 = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n);
        boolean bl = RenderUtil.getBooleanPropertyByName(this.get, "Shadow");
        boolean bl2 = color != null;
        Color color4 = graphics.getColor();
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color : null, color2, Unit.convertUnitToPixel(n6, n), n4, n5, n2, n3, bl, color3, n7);
        graphics.setColor(color4);
    }

    public Color getBg() {
        return this.convertUnitToPixel;
    }

    public void setBg(Color color) {
        this.convertUnitToPixel = color;
    }

    public boolean isDisabled() {
        return this.QOIV;
    }

    public void setDisabled(boolean bl) {
        this.QOIV = bl;
    }

    public Vector getTexts() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setTexts(Vector vector) {
        this.DEFAULT_SHADOW_WIDTH = vector;
    }

    public Vector getValues() {
        return this.I;
    }

    public void setValues(Vector vector) {
        this.I = vector;
    }

    public String getSelectedValues() {
        return this.black;
    }

    public void setSelectedValues(String string) {
        this.black = string;
    }

    public String getSelectedTexts() {
        return this.convertPixelToUnit;
    }

    public void setSelectedTexts(String string) {
        this.convertPixelToUnit = string;
    }
}

