/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ie.CLSInfo;
import jet.ie.RSDCLSInfos;
import jet.ie.RSDPermissions;
import jet.ie.RSDTools;
import jet.ie.VersionException;
import jet.ie.io.PJFDataOutput;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.RAFile;

public abstract class AbstractRSDExporter {
    public static final String SUF_STRING = ".rsd";
    public static final String COMPANY_CLAIM = "Copyright (c) 1998, Jinfonet Software, Inc.  All rights reserved.";
    public static final String REPORTNAMES = "ReportNames";
    public static final String REPORTINFOS = "ReportInfos";
    public static final String DATASETINFOS = "DatasetInfos";
    public static final String RESULTSETS = "ResultSets";
    public static final String REPORTSETS = "ReportSets";
    public static final String PARAMETERS = "Parameters";
    public static final String UNIVERSE = "Universe";
    public static final String BINDINFO = "BindInfo";
    public static final String INDEXINFO = "IndexInfo";
    public static final String PRECISION = "Precision";
    public static final String PERMISSION = "Permission";
    public static final String CLSINFOS = "CLSInfo";
    protected static final int versionNumber = 131600;
    protected String _fileName;
    protected String[] _reportNames;
    protected Hashtable _rptInfos = new Hashtable();
    protected Hashtable _dataSetInfos = new Hashtable();
    protected Hashtable _resultSets = new Hashtable();
    protected JetUUniverse _universe;
    protected Hashtable _rptReportSet = new Hashtable();
    protected Map _parameter;
    protected Hashtable _bindInfo = new Hashtable();
    protected Hashtable _CLSInfos = new Hashtable();
    protected Hashtable _permissions = new Hashtable();
    protected Hashtable _precisions = new Hashtable();
    protected int bufferSize = 4096;
    protected boolean _isZip;
    protected String _id;
    protected RSDTools _rsdTools;
    protected PJFDataOutput raf;
    protected RAFile rafFile;

    public void setFileName(String string) {
        this._fileName = string.endsWith(SUF_STRING) ? string : string + SUF_STRING;
    }

    public void setReportNames(String[] stringArray) {
        this._reportNames = stringArray;
    }

    public void setRptInfos(int n, Map map) {
        this._rptInfos.put(new Integer(n), map);
    }

    public void setDataSetinfos(int n, Vector vector) {
        this._dataSetInfos.put(new Integer(n), vector);
    }

    public void setUniverse(JetUUniverse jetUUniverse) {
        this._universe = jetUUniverse;
    }

    public void setResultSet(int n, String string, ResultSet resultSet) {
        String string2 = this._rsdTools.getKey(n, string);
        this._resultSets.put(string2, resultSet);
    }

    public void setRptSet(int n, JetRptReportSet jetRptReportSet) {
        this._rptReportSet.put(new Integer(n), jetRptReportSet);
    }

    public void setParameter(Map map) {
        this._parameter = map;
    }

    public void setBindInfo(int n, String string, String[][] stringArray) {
        String string2 = this._rsdTools.getKey(n, string);
        this._bindInfo.put(string2, stringArray);
    }

    public void setUserID(String string) {
        this._id = string;
    }

    public void setCLSInfos(int n, String string, CLSInfo cLSInfo) {
        String string2 = this._rsdTools.getKey(n, string);
        this._CLSInfos.put(string2, cLSInfo);
    }

    public void setBCRCPermissions(int n, String[] stringArray) {
        this._permissions.put(new Integer(n), stringArray);
    }

    public void setPrecision(String string, String string2, boolean bl) {
        String string3 = string.length() + string + string2.length() + string2;
        this._precisions.put(string3, new Boolean(bl));
    }

    public void hasToZip(boolean bl) {
        this._isZip = bl;
    }

    public abstract void write() throws VersionException, JRStopEngineException;

    public long saveBindInfo() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this._rsdTools.writeBindInfo(this.raf, this._bindInfo);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407221, string);
            long l3 = System.currentTimeMillis();
            String string2 = String.valueOf(l3 - l);
            JRLog.trace(5, 2407222, string2);
            return l2;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407207, (Throwable)iOException);
            }
            throw new VersionException(407207, (Throwable)iOException);
        }
    }

    public long saveParameter() throws VersionException {
        try {
            long l = this.raf.getPosition();
            if (this._parameter == null) {
                this.raf.writeBoolean(true);
            } else {
                this.raf.writeBoolean(false);
                this._rsdTools.writeParameter(this.raf, this._parameter);
            }
            return l;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407212, (Throwable)iOException);
            }
            throw new VersionException(407212, (Throwable)iOException);
        }
    }

    public long saveDataSetInfos() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this._rsdTools.writeDataSetInfo(this.raf, this._dataSetInfos);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407223, string);
            long l3 = System.currentTimeMillis();
            String string2 = String.valueOf(l3 - l);
            JRLog.trace(5, 2407224, string2);
            return l2;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407206, (Throwable)exception);
            }
            throw new VersionException(407206, (Throwable)exception);
        }
    }

    protected long saveReportSets() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            this.raf.writeLong(0L);
            Enumeration enumeration = this._rptReportSet.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                String string = String.valueOf(n);
                hashtable.put(string, new Long(this.raf.getPosition()));
                JetRptReportSet jetRptReportSet = (JetRptReportSet)this._rptReportSet.get(n);
                this._rsdTools.writeReportSet(this.raf, jetRptReportSet);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407225, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 2407226, string2);
            return l2;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)exception);
            }
            throw new VersionException(407208, (Throwable)exception);
        }
    }

    public long saveRptInfos() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.writeRptInfo(this.raf, this._rptInfos);
            return l;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407205, (Throwable)exception);
            }
            throw new VersionException(407205, (Throwable)exception);
        }
    }

    protected abstract long saveUniverse() throws VersionException;

    protected abstract long saveIndexInfo() throws VersionException;

    protected abstract long saveResultSets() throws VersionException;

    public long savePrecision() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.writePrecision(this.raf, this._precisions);
            return l;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public long savePermisions() throws VersionException {
        try {
            long l = this.raf.getPosition();
            RSDPermissions rSDPermissions = new RSDPermissions();
            rSDPermissions.setSrc(this._permissions);
            rSDPermissions.save(this.raf);
            return l;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public long saveCLSInfos() throws VersionException {
        try {
            long l = this.raf.getPosition();
            RSDCLSInfos rSDCLSInfos = new RSDCLSInfos();
            rSDCLSInfos.setSrc(this._CLSInfos);
            rSDCLSInfos.save(this.raf);
            return l;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public long saveReportNames() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.writeReportNames(this.raf, this._reportNames);
            return l;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407203, (Throwable)exception);
            }
            throw new VersionException(407203, (Throwable)exception);
        }
    }

    public long writeAddressTableH(Hashtable hashtable) throws VersionException {
        try {
            long l = this.raf.getPosition();
            Enumeration enumeration = hashtable.keys();
            this.raf.writeInt(hashtable.size());
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                String string = (String)k;
                long l2 = (Long)hashtable.get(string);
                this.raf.writeUTF(string);
                this.raf.writeLong(l2);
            }
            return l;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB22, (Throwable)iOException);
            }
            throw new VersionException(407202, (Throwable)iOException);
        }
    }

    public abstract void clear() throws IOException;
}

