/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.datastream.JetChartPropertyValues;
import jet.report.JetRptObject;
import jet.report.chart.JetChartElement;
import jet.reportset.JetRptReport;

public class JetChartFillPattern
extends JetChartElement {
    public JetEnumeration type;
    public JetNumber transparency;
    public JetColor color;
    public JetEnumeration textureStyle;
    public JetColor textureForeColor;
    public JetColor textureBackColor;
    public JetEnumeration gradientStyle;
    public JetColor gradientStartColor;
    public JetColor gradientEndColor;
    public JetNumber gradientStartX;
    public JetNumber gradientStartY;
    public JetNumber gradientEndX;
    public JetNumber gradientEndY;
    public JetImgProperty imageFile;
    public JetEnumeration imageLayout;
    public JetNumber imageX;
    public JetNumber imageY;
    public JetNumber imageWidth;
    public JetNumber imageHeight;
    private boolean C;

    public JetChartFillPattern(JetObject jetObject, String string) {
        this(jetObject, string, true);
    }

    public JetChartFillPattern(JetObject jetObject, String string, boolean bl) {
        super(jetObject, string + "Pattern");
        this.C = bl;
        string = this.prefix;
        this.type = new JetEnumeration(jetObject, string + "Type", 77);
        this.transparency = new JetNumber(jetObject, string + "Transparency");
        this.color = new JetColor(jetObject, string + "Color", null, true);
        this.textureStyle = new JetEnumeration(jetObject, string + "TextureStyle", 96);
        this.textureForeColor = new JetColor(jetObject, string + "TextureForeColor", Color.black, true);
        this.textureBackColor = new JetColor(jetObject, string + "TextureBackColor", Color.white, true);
        this.gradientStyle = new JetEnumeration(jetObject, string + "GradientStyle", 43);
        this.gradientStartColor = new JetColor(jetObject, string + "GradientStartColor", Color.blue, true);
        this.gradientEndColor = new JetColor(jetObject, string + "GradientEndColor", Color.red, true);
        this.gradientStartX = new JetNumber(jetObject, string + "GradientStartX", 0);
        this.gradientStartY = new JetNumber(jetObject, string + "GradientStartY", 0);
        this.gradientEndX = new JetNumber(jetObject, string + "GradientEndX", 100);
        this.gradientEndY = new JetNumber(jetObject, string + "GradientEndY", 100);
        if (bl) {
            this.type.setEnumerationSet(JetChartPropertyValues.PATTERN_TYPE_ENUMERATIONS);
        }
        this.type.set("None");
        this.textureStyle.set("Small Dot");
        this.gradientStyle.set("Linear");
        if (bl) {
            this.imageFile = new JetImgProperty(jetObject, string + "ImageFile");
            this.imageFile.setCanChangeByBL(false);
            this.imageFile.setCanChangeByFmtt(false);
            this.imageFile.setCanChangeByOthers(false);
            this.imageLayout = new JetEnumeration(jetObject, string + "ImageLayout", 49);
            this.imageX = new JetNumber(jetObject, string + "ImageX", 0);
            this.imageY = new JetNumber(jetObject, string + "ImageY", 0);
            this.imageWidth = new JetNumber(jetObject, string + "ImageWidth", 100);
            this.imageHeight = new JetNumber(jetObject, string + "ImageHeight", 100);
            this.imageLayout.set("Tile");
        }
    }

    public String getGroupName() {
        return "Pattern";
    }

    public boolean hasImage() {
        return this.C;
    }

    public void addToGroup(String string) {
        this.addToGroupExceptImage(string);
        this.owner.addPropertyToGroup(this.imageFile.getName(), string);
        this.owner.addPropertyToGroup(this.imageLayout.getName(), string);
        this.owner.addPropertyToGroup(this.imageX.getName(), string);
        this.owner.addPropertyToGroup(this.imageY.getName(), string);
        this.owner.addPropertyToGroup(this.imageWidth.getName(), string);
        this.owner.addPropertyToGroup(this.imageHeight.getName(), string);
    }

    public void addToGroupExceptImage(String string) {
        this.owner.addPropertyToGroup(this.type.getName(), string);
        this.owner.addPropertyToGroup(this.transparency.getName(), string);
        this.owner.addPropertyToGroup(this.color.getName(), string);
        this.owner.addPropertyToGroup(this.textureStyle.getName(), string);
        this.owner.addPropertyToGroup(this.textureForeColor.getName(), string);
        this.owner.addPropertyToGroup(this.textureBackColor.getName(), string);
        this.owner.addPropertyToGroup(this.gradientStyle.getName(), string);
        this.owner.addPropertyToGroup(this.gradientStartColor.getName(), string);
        this.owner.addPropertyToGroup(this.gradientEndColor.getName(), string);
        this.owner.addPropertyToGroup(this.gradientStartX.getName(), string);
        this.owner.addPropertyToGroup(this.gradientStartY.getName(), string);
        this.owner.addPropertyToGroup(this.gradientEndX.getName(), string);
        this.owner.addPropertyToGroup(this.gradientEndY.getName(), string);
    }

    public ChartFillPattern getChartFillPattern() {
        ChartFillPattern chartFillPattern = null;
        switch (this.type.intValue()) {
            case 1: {
                chartFillPattern = new ChartColorPattern((Color)this.color.getValue());
                ((ChartColorPattern)chartFillPattern).setAlpha((float)this.transparency.intValue() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartTexturePattern(this.textureStyle.intValue(), new ChartColorPattern((Color)this.textureForeColor.getValue()), new ChartColorPattern((Color)this.textureBackColor.getValue()));
                ((ChartTexturePattern)chartFillPattern).setAlpha((float)this.transparency.intValue() / 100.0f);
                break;
            }
            case 3: {
                chartFillPattern = new ChartGradientPattern(this.gradientStyle.intValue());
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(this.gradientStartColor.get()));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(this.gradientEndColor.get()));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)this.gradientStartX.intValue() / 100.0f, 1.0f - (float)this.gradientStartY.intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)this.gradientEndX.intValue() / 100.0f, 1.0f - (float)this.gradientEndY.intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)this.transparency.intValue() / 100.0f);
                break;
            }
            case 4: {
                if (!this.C) break;
                float f = (float)this.imageX.intValue() / 100.0f;
                float f2 = 1.0f - (float)this.imageY.intValue() / 100.0f;
                float f3 = (float)this.imageWidth.intValue() / 100.0f;
                float f4 = (float)this.imageHeight.intValue() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = this.imageLayout.intValue();
                float f5 = (float)this.transparency.intValue() / 100.0f;
                Image image = (Image)this.imageFile.getObject();
                String string = this.imageFile.get();
                if (image == null) {
                    String string2 = JetRptReport.getReport((JetRptObject)this.owner).getResourcePath();
                    String string3 = string2 + string;
                    chartFillPattern = new ChartCustomizedPattern(string3, float_, n, f5);
                    break;
                }
                chartFillPattern = new ChartCustomizedPattern(image, float_, n, f5, string);
            }
        }
        return chartFillPattern;
    }

    public void setChartFillPattern(ChartFillPattern chartFillPattern) {
        if (chartFillPattern instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
            this.type.set("Color");
            this.color.set(chartColorPattern.getColor());
            this.transparency.set(chartColorPattern.getAlpha() * 100.0f);
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            this.type.set("Texture");
            ChartTexturePattern chartTexturePattern = (ChartTexturePattern)chartFillPattern;
            this.textureStyle.set((String)JetChartPropertyValues.PATTERN_TEXTURESTYLE_INTEGERS.get(new Integer(chartTexturePattern.getPattern())));
            this.textureForeColor.set(chartTexturePattern.getForeground().getColor());
            this.textureBackColor.set(chartTexturePattern.getBackground().getColor());
            this.transparency.set(chartTexturePattern.getAlpha() * 100.0f);
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            this.type.set("Gradient");
            ChartGradientPattern chartGradientPattern = (ChartGradientPattern)chartFillPattern;
            this.gradientStyle.set((String)JetChartPropertyValues.PATTERN_GRADIENTSTYLE_INTEGERS.get(new Integer(chartGradientPattern.getPattern())));
            this.gradientStartColor.set(chartGradientPattern.getStartColor().getColor());
            this.gradientEndColor.set(chartGradientPattern.getEndColor().getColor());
            this.gradientStartX.set(chartGradientPattern.getStartPoint().x * 100.0f);
            this.gradientStartY.set((1.0f - chartGradientPattern.getStartPoint().y) * 100.0f);
            this.gradientEndX.set(chartGradientPattern.getEndPoint().x * 100.0f);
            this.gradientEndY.set((1.0f - chartGradientPattern.getEndPoint().y) * 100.0f);
            this.transparency.set(chartGradientPattern.getAlpha() * 100.0f);
        } else if (chartFillPattern instanceof ChartCustomizedPattern) {
            this.C = true;
            ChartCustomizedPattern chartCustomizedPattern = (ChartCustomizedPattern)chartFillPattern;
            String string = chartCustomizedPattern.getImageName();
            if (string != null && string.length() > 0) {
                this.type.set("Image");
                String string2 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
                this.imageFile.set(string2);
                this.imageX.set(Math.round(chartCustomizedPattern.getAnchor().x * 100.0f));
                this.imageY.set(Math.round((1.0f - chartCustomizedPattern.getAnchor().y) * 100.0f));
                this.imageWidth.set(Math.round(chartCustomizedPattern.getAnchor().width * 100.0f));
                this.imageHeight.set(Math.round(chartCustomizedPattern.getAnchor().height * 100.0f));
                this.imageLayout.set((String)JetChartPropertyValues.PATTERN_IMAGELAYOUT_INTEGERS.get(new Integer(chartCustomizedPattern.getLayout())));
                this.transparency.set(chartCustomizedPattern.getAlpha() * 100.0f);
            }
        } else {
            this.type.set("None");
        }
    }
}

