/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls;

import java.io.IOException;
import jet.report.xls.Blank;
import util.RandomAccessStream;

public class Formula
extends Blank {
    public static final short ALWAYSCALC = 1;
    public static final short CALCONLOAD = 2;
    public static final short SHRFMLA = 8;
    double I;
    short QOIV;
    int doubleToLongBits = 0;
    short Z;
    byte[] C;
    String J;

    public Formula(int n, int n2, int n3, double d, short s, byte[] byArray) {
        super(n, n2, n3);
        this.I = d;
        this.QOIV = s;
        this.C = byArray;
        this.Z = (short)byArray.length;
    }

    public Formula(int n, int n2, int n3, double d, short s, String string) {
        super(n, n2, n3);
        this.I = d;
        this.QOIV = s;
        this.J = string;
    }

    Formula() {
    }

    public final int opcode() {
        return 6;
    }

    public int output(RandomAccessStream randomAccessStream) throws IOException {
        this.length = 22 + this.C.length;
        super.output(randomAccessStream);
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.I));
        this.writeShort(randomAccessStream, this.QOIV);
        this.writeInt(randomAccessStream, this.doubleToLongBits);
        this.writeShort(randomAccessStream, this.Z);
        randomAccessStream.writeByteArray(this.C);
        return this.length + 4;
    }

    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.B = this.readShort(randomAccessStream);
        this.D = this.readShort(randomAccessStream);
        this.F = this.readShort(randomAccessStream);
        this.I = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.QOIV = this.readShort(randomAccessStream);
        this.doubleToLongBits = this.readInt(randomAccessStream);
        this.Z = this.readShort(randomAccessStream);
        this.C = new byte[this.Z];
        this.C = randomAccessStream.readByteArray(this.Z);
    }

    public int getLength() {
        this.length = 22 + this.C.length;
        return this.length + 4;
    }

    public void setFormulaStr(String string) {
        this.J = string;
    }

    public String getFormulaStr() {
        return this.J;
    }

    public void setAlwaysCalc(boolean bl) {
        this.QOIV = (short)(bl ? this.QOIV | 1 : this.QOIV & 0xFFFFFFFE);
    }

    public boolean isAlwaysCalc() {
        return (this.QOIV & 1) == 1;
    }

    public void setCalcOnLoad(boolean bl) {
        this.QOIV = (short)(bl ? this.QOIV | 2 : this.QOIV & 0xFFFFFFFD);
    }

    public boolean isCalcOnLoad() {
        return (this.QOIV & 2) == 2;
    }

    public void setShrFmla(boolean bl) {
        this.QOIV = (short)(bl ? this.QOIV | 8 : this.QOIV & 0xFFFFFFF7);
    }

    public boolean isShrFmla() {
        return (this.QOIV & 8) == 8;
    }
}

