/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSArea;
import jet.datastream.DSGroup;
import jet.datastream.DSMap;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.thinviewer.JReportAreaComponent;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.util.PropertySetable;
import util.RenderToolkit;

public class JReportArea
extends JReportAreaComponent
implements PainterConstants {
    Color QOIV = null;
    Color abs = null;
    int clickOnField;
    int convertUnitToPixel;
    int[] countTokens;
    int[] drawBox;
    int drawLine;
    private DSArea drawOval = null;
    private Render drillDown = null;

    public JReportArea() {
        this.enableEvents(16L);
    }

    public void setProperty(PropertySetable propertySetable) {
        this.drawOval = (DSArea)propertySetable;
        super.setProperty(this.drawOval);
        Rectangle rectangle = this.drawOval.getBounds();
        double d = 1.0;
        this.Z = this.drawOval.getShapeType();
        this.convertUnitToPixel = this.drawOval.getBoundaryStyle();
        DSMap dSMap = (DSMap)this.drawOval.getParent();
        int[][] nArray = this.drawOval.getPolygon();
        this.QOIV = this.drawOval.getFillColorValue();
        this.abs = this.drawOval.getBoundaryColorValue();
        this.clickOnField = Unit.convertUnitToPixel(this.drawOval.getBoundaryWidth(), this.resolution);
        if (this.Z == 3) {
            this.drawLine = nArray.length;
            this.countTokens = new int[this.drawLine];
            this.drawBox = new int[this.drawLine];
            int n = 0;
            while (n < this.drawLine) {
                this.countTokens[n] = Unit.convertUnitToPixel(nArray[n][0], this.resolution);
                this.drawBox[n] = Unit.convertUnitToPixel(nArray[n][1], this.resolution);
                ++n;
            }
            d = (double)rectangle.width / (double)new Polygon((int[])this.countTokens, (int[])this.drawBox, (int)this.drawLine).getBounds().width;
            if (Math.abs(d - 1.0) > 0.03) {
                int n2 = 0;
                while (n2 < this.drawLine) {
                    this.countTokens[n2] = (int)Math.round((double)this.countTokens[n2] * d);
                    this.drawBox[n2] = (int)Math.round((double)this.drawBox[n2] * d);
                    ++n2;
                }
            }
        } else {
            int[] nArray2 = this.QOIV((String)this.drawOval.getPropertyByName("Coordinates").getObject());
            d = this.Z == 2 ? (double)rectangle.width / (double)(nArray2[2] * 2) : (double)rectangle.width / (double)nArray2[2];
        }
        this.I = new Polygon(this.countTokens, this.drawBox, this.drawLine);
        if (Math.abs(d - 1.0) > 0.03) {
            this.clickOnField = (int)Math.round((double)this.clickOnField * d);
        }
    }

    protected void fillBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.QOIV != null) {
            graphics.setColor(this.QOIV);
            if (this.Z == 3) {
                graphics.fillPolygon(this.countTokens, this.drawBox, this.drawLine);
            } else if (this.Z == 2) {
                graphics.fillOval(0, 0, dimension.width, dimension.height);
            } else {
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.clickOnField > 0 && this.abs != null && this.convertUnitToPixel != 0) {
            if (this.Z == 3) {
                int n = 0;
                while (n < this.drawLine - 1) {
                    RenderToolkit.drawLine(graphics, this.countTokens[n], this.drawBox[n], this.countTokens[n + 1], this.drawBox[n + 1], this.abs, this.clickOnField, this.convertUnitToPixel);
                    ++n;
                }
                RenderToolkit.drawLine(graphics, this.countTokens[0], this.drawBox[0], this.countTokens[this.drawLine - 1], this.drawBox[this.drawLine - 1], this.abs, this.clickOnField, this.convertUnitToPixel);
            } else if (this.Z == 2) {
                RenderToolkit.drawOval(graphics, 0.0f, 0.0f, dimension.width, dimension.height, null, this.abs, this.clickOnField, this.convertUnitToPixel);
            } else {
                RenderToolkit.drawBox(graphics, 0.0f, 0.0f, dimension.width - 1, dimension.height - 1, null, this.abs, this.clickOnField, this.convertUnitToPixel);
            }
        }
        super.paint(graphics);
    }

    int[] QOIV(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, new String(","));
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                nArray[n2] = Unit.convertUnitToPixel(new Integer(string2.trim()), this.resolution);
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            ViewerTools.I(2401501, numberFormatException);
        }
        return nArray;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            if (this.abs()) {
                if (mouseEvent.getClickCount() == 1 && mouseEvent.isControlDown()) {
                    DSSection dSSection;
                    JReportViewer jReportViewer = this.drawBox();
                    if (this.clickOnField(jReportViewer) && (dSSection = this.drawOval.getSection()) != null) {
                        String string = this.getStringPropertyByName(dSSection, "Group");
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            jReportViewer.drillDown(string, dSSection);
                        }
                        catch (JRStopEngineException jRStopEngineException) {
                            ViewerTools.I(131600, jRStopEngineException);
                        }
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    JReportViewer jReportViewer = this.drawBox();
                    if (jReportViewer.C(this.drawOval) && !(jReportViewer instanceof JReportDrillDownViewer)) {
                        try {
                            jReportViewer.Z(this.drawOval);
                        }
                        catch (JRStopEngineException jRStopEngineException) {
                            ViewerTools.I(131600, jRStopEngineException);
                        }
                    }
                    if (this.drawOval.getSection() != null) {
                        JRecord jRecord = this.drawOval.getSection().getRecord();
                        jReportViewer.clickOnField(jRecord);
                    }
                }
            } else if (!mouseEvent.isMetaDown()) {
                JReportViewer jReportViewer = this.drawBox();
                if (this.clickOnField(jReportViewer)) {
                    DSSection dSSection = this.drawOval.getSection();
                    if (dSSection != null) {
                        String string = this.getStringPropertyByName(dSSection, "Group");
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            jReportViewer.drillDown(string, dSSection);
                        }
                        catch (JRStopEngineException jRStopEngineException) {
                            ViewerTools.I(131600, jRStopEngineException);
                        }
                    }
                } else {
                    if (jReportViewer.C(this.drawOval) && !(jReportViewer instanceof JReportDrillDownViewer)) {
                        try {
                            jReportViewer.Z(this.drawOval);
                        }
                        catch (JRStopEngineException jRStopEngineException) {
                            ViewerTools.I(131600, jRStopEngineException);
                        }
                    }
                    if (this.drawOval.getSection() != null) {
                        JRecord jRecord = this.drawOval.getSection().getRecord();
                        jReportViewer.clickOnField(jRecord);
                    }
                }
            }
        } else if (mouseEvent.getID() == 504) {
            DSSection dSSection;
            JReportViewer jReportViewer = this.drawBox();
            if (this.clickOnField(jReportViewer) && (dSSection = this.drawOval.getSection()) != null && jReportViewer.getMainCommunicator().isMain(dSSection.getDataStream().getSubIndex())) {
                if (jReportViewer.C(this.drawOval)) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
            if (!(jReportViewer instanceof JReportDrillDownViewer)) {
                if (jReportViewer.C(this.drawOval) || this.clickOnField(jReportViewer)) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private boolean abs() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JReportViewer jReportViewer = this.drawBox();
        bl2 = jReportViewer.C(this.drawOval) && !(jReportViewer instanceof JReportDrillDownViewer);
        bl3 = this.clickOnField(jReportViewer);
        bl = bl2 && bl3;
        return bl;
    }

    private boolean clickOnField(JReportViewer jReportViewer) {
        boolean bl = false;
        DSSection dSSection = this.drawOval.getSection();
        if (dSSection != null && (dSSection.getObjectType() == 515 || dSSection.getObjectType() == 518)) {
            String string = this.getStringPropertyByName(dSSection, "Group");
            if (this.countTokens(dSSection) && jReportViewer.I(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean convertUnitToPixel(DSSection dSSection) {
        DSSubReport dSSubReport = (DSSubReport)dSSection.getParent();
        DSGroup dSGroup = null;
        Vector vector = dSSubReport.getChildren();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) == dSSection) break;
            if (((JRObjectResult)vector.elementAt(n)).getObjectType() == 44) {
                dSGroup = (DSGroup)vector.elementAt(n);
            }
            ++n;
        }
        if (dSGroup != null) {
            if (!(this.getStringPropertyByName(dSGroup, "Grant").equals("") && this.getStringPropertyByName(dSGroup, "Groups").equals("") && this.getStringPropertyByName(dSGroup, "Role").equals(""))) {
                return this.getBooleanPropertyByName(dSGroup, "Cascade");
            }
            return true;
        }
        return false;
    }

    private boolean countTokens(DSSection dSSection) {
        boolean bl = false;
        return bl && this.convertUnitToPixel(dSSection);
    }

    private JReportViewer drawBox() {
        Container container = this.getParent();
        while (!(container instanceof JReportViewer)) {
            container = container.getParent();
        }
        return (JReportViewer)container;
    }
}

