/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.awt.Rectangle;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import jet.controls.JetObject;
import jet.export.xml.LoadXSDException;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.jetc.JetCReader;
import jet.jetc.JetCWriter;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.universe.JetUColumnInfo;
import jet.universe.JetUConnection;
import jet.universe.JetUField;
import jet.universe.JetUPath;
import jet.universe.JetUPrejoin;
import jet.universe.JetUPrejoins;
import jet.universe.JetUTableInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.Prejoin;
import prejoin.Join;
import prejoin.JoinsSet;
import prejoin.Loop;
import prejoin.Path;
import prejoin.PathFinder;
import toolkit.db.PsqlJoin;

public class UniverseEditor {
    JetUUniverse I;
    Hashtable QOIV = new Hashtable();

    public UniverseEditor(JetUUniverse jetUUniverse) throws ReadFailureException {
        this.I = jetUUniverse;
        JetCReader jetCReader = new JetCReader();
        String string = jetUUniverse.getFullFileName();
        boolean bl = string.endsWith(".cat.xml");
        Vector vector = jetUUniverse.getAllDatabaseNames();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            String string3 = JetUUniverse.getCatNameFromFileName(string) + string2 + (bl ? ".pre.xml" : ".pre");
            if (new File(string3).exists()) {
                JetUPrejoins jetUPrejoins;
                if (!bl) {
                    jetUPrejoins = (JetUPrejoins)jetCReader.read(string3);
                } else {
                    try {
                        jetUPrejoins = (JetUPrejoins)XMLToObject.toObject(string3);
                    }
                    catch (LoadXSDException loadXSDException) {
                        throw new ReadFailureException(loadXSDException);
                    }
                }
                this.QOIV.put(string2, jetUPrejoins);
            } else {
                this.I(string2);
            }
            ++n;
        }
    }

    void I(String string) {
        JetUPrejoins jetUPrejoins = new JetUPrejoins();
        jetUPrejoins.x.set(100);
        jetUPrejoins.y.set(100);
        jetUPrejoins.width.set(640);
        jetUPrejoins.height.set(480);
        JetUConnection jetUConnection = this.I.getDatabase(string).getConnection();
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getTableViews();
            int n = vector.size();
            int n2 = 10;
            int n3 = 10;
            int n4 = 100;
            int n5 = 100;
            int n6 = 20;
            int n7 = 600;
            int n8 = n2;
            int n9 = n3;
            int n10 = 0;
            while (n10 < n) {
                JetUTableView jetUTableView = (JetUTableView)vector.elementAt(n10);
                JetUTableInfo jetUTableInfo = new JetUTableInfo();
                jetUTableInfo.tableName.set(jetUTableView.tableName.get());
                Vector vector2 = jetUTableView.getFields();
                int n11 = 0;
                while (n11 < vector2.size()) {
                    JetUField jetUField = (JetUField)vector2.elementAt(n11);
                    JetUColumnInfo jetUColumnInfo = new JetUColumnInfo();
                    jetUColumnInfo.I.set(jetUField.colName.get());
                    jetUTableInfo.add(jetUColumnInfo);
                    ++n11;
                }
                if (n8 + n4 > n7) {
                    n8 = n2;
                    n9 += n5 + n6;
                }
                jetUTableInfo.x.set(n8);
                jetUTableInfo.y.set(n9);
                jetUTableInfo.width.set(n4);
                jetUTableInfo.height.set(n5);
                n8 += n4 + n6;
                jetUPrejoins.add(jetUTableInfo);
                ++n10;
            }
            this.QOIV.put(string, jetUPrejoins);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveToFile(String string) throws WriteFailureException {
        JetUConnection jetUConnection = this.I.getDatabase(string).getConnection();
        if (jetUConnection == null || jetUConnection.getTableViews().size() <= 0) return;
        String string2 = this.I.getFullFileName();
        if (string2.endsWith(".cat.xml")) {
            String string3 = string2.substring(0, string2.length() - ".cat.xml".length());
            if (string != null && string.length() > 0) {
                string3 = string3 + string;
            }
            try {
                JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
                if (jetUPrejoins == null) return;
                ObjectToXML objectToXML = new ObjectToXML(jetUPrejoins, string3);
                return;
            }
            catch (JetRptReportIOException jetRptReportIOException) {
                throw new WriteFailureException(jetRptReportIOException);
            }
        } else {
            JetCWriter jetCWriter = new JetCWriter();
            String string4 = JetUUniverse.getCatNameFromFileName(this.I.getFullFileName()) + string + ".pre";
            JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
            if (jetUPrejoins == null) return;
            jetCWriter.write((JetObject)jetUPrejoins, string4, "JetUPrejoins");
        }
    }

    public boolean finish(String string, Hashtable hashtable, Vector vector, Rectangle rectangle, boolean bl) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.remove(string);
        if (jetUPrejoins != null) {
            boolean bl2;
            boolean bl3 = bl2 = jetUPrejoins.x.get() != rectangle.x || jetUPrejoins.y.get() != rectangle.y || jetUPrejoins.width.get() != rectangle.width || jetUPrejoins.height.get() != rectangle.height;
            if (bl2) {
                jetUPrejoins.x.set(rectangle.x);
                jetUPrejoins.y.set(rectangle.y);
                jetUPrejoins.width.set(rectangle.width);
                jetUPrejoins.height.set(rectangle.height);
            }
            boolean bl4 = jetUPrejoins.update(hashtable, vector);
            this.I.setModified(bl2 || bl4 || bl);
            this.QOIV.put(string, jetUPrejoins);
            return bl4;
        }
        return false;
    }

    public void addTableView(JetUTableView jetUTableView, String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins == null) {
            this.I(string);
        }
        ((JetUPrejoins)this.QOIV.get(string)).addTableView(jetUTableView);
    }

    public void removeTableView(String string, String string2) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string2);
        if (jetUPrejoins != null) {
            jetUPrejoins.removeTableView(string);
        }
    }

    public void addPrejoin(JetUPrejoin jetUPrejoin, String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.add(jetUPrejoin);
        }
    }

    public void removePrejoin(JetUPrejoin jetUPrejoin, String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.remove(jetUPrejoin);
        }
    }

    public JetUPath[] getPaths(Vector vector, String[] stringArray) {
        return this.addElement(new PathFinder().getPaths(this.QOIV(vector), stringArray));
    }

    public Vector getPrejoins(String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            return jetUPrejoins.getPrejoins();
        }
        return null;
    }

    public Vector getUPrejoins(String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            Vector vector = jetUPrejoins.getChildren();
            Vector vector2 = new Vector();
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.elementAt(n);
                if (e instanceof JetUPrejoin) {
                    vector2.addElement(e);
                }
                ++n;
            }
            return vector2;
        }
        return null;
    }

    public Hashtable getTables(String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            return jetUPrejoins.getTables();
        }
        return null;
    }

    public Vector getPaths(String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            return jetUPrejoins.getPaths();
        }
        return null;
    }

    public JetUPath getPath(String string, String string2) {
        Vector vector = this.getPaths(string);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                JetUPath jetUPath = (JetUPath)vector.elementAt(n);
                if (jetUPath.pathName.get().equals(string2)) {
                    return jetUPath;
                }
                ++n;
            }
        }
        return null;
    }

    public JetUPath getPath(Vector vector, Vector vector2, JetUPath jetUPath) {
        vector = this.add(vector);
        Object[] objectArray = new String[vector2.size()];
        PathFinder pathFinder = new PathFinder();
        Path path = this.append(jetUPath);
        vector2.copyInto(objectArray);
        JetUPath jetUPath2 = this.addTableView(pathFinder.getPaths(path, (String[])objectArray, vector));
        return jetUPath2;
    }

    public void setPaths(Vector vector, String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.setPaths(vector);
        }
    }

    public void addPath(String string, JetUPath jetUPath) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.add(jetUPath);
        }
    }

    public void addPath(String string, JetUPath jetUPath, int n) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.add(jetUPath, n);
        }
    }

    public void removePath(String string, JetUPath jetUPath) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            jetUPrejoins.remove(jetUPath);
        }
    }

    public void removeAllPaths(String string) {
        Vector vector;
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null && (vector = jetUPrejoins.getPaths()) != null) {
            int n = 0;
            while (n < vector.size()) {
                JetUPath jetUPath = (JetUPath)vector.elementAt(n);
                jetUPrejoins.remove(jetUPath);
                ++n;
            }
        }
    }

    public Rectangle getPrejoinsBounds(String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins == null) {
            jetUPrejoins = new JetUPrejoins();
            jetUPrejoins.x.set(100);
            jetUPrejoins.y.set(100);
            jetUPrejoins.width.set(640);
            jetUPrejoins.height.set(480);
        }
        return new Rectangle(jetUPrejoins.x.get(), jetUPrejoins.y.get(), jetUPrejoins.width.get(), jetUPrejoins.height.get());
    }

    public Vector getPaths(Vector vector, String string) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins != null) {
            Vector vector2 = jetUPrejoins.getPaths();
            Vector vector3 = new Vector();
            if (vector2.size() > 0) {
                int n = 0;
                while (n < vector2.size()) {
                    Vector vector4 = ((JetUPath)vector2.elementAt(n)).getChildren();
                    Vector<String> vector5 = new Vector<String>();
                    int n2 = 0;
                    while (n2 < vector4.size()) {
                        if (vector4.elementAt(n2) instanceof JetUPrejoin) {
                            JetUPrejoin jetUPrejoin = (JetUPrejoin)vector4.elementAt(n2);
                            String string2 = jetUPrejoin.tableFrom.get();
                            String string3 = jetUPrejoin.tableTo.get();
                            if (!vector5.contains(string2)) {
                                vector5.addElement(string2);
                            }
                            if (!vector5.contains(string3)) {
                                vector5.addElement(string3);
                            }
                        }
                        ++n2;
                    }
                    boolean bl = true;
                    if (vector5.size() > 0) {
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            if (!vector5.contains(vector.elementAt(n3))) {
                                bl = false;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (bl) {
                        vector3.addElement(vector2.elementAt(n));
                    }
                    ++n;
                }
            }
            return vector3;
        }
        return null;
    }

    Vector QOIV(Vector vector) {
        Vector<Join> vector2 = new Vector<Join>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Prejoin prejoin = (Prejoin)vector.elementAt(n);
                String[] stringArray = prejoin.getJoinInfo();
                vector2.addElement(new Join(stringArray[0], stringArray[1], stringArray[4], stringArray[2], stringArray[3], Integer.parseInt(stringArray[6]), stringArray[5].equalsIgnoreCase("true")));
                ++n;
            }
        }
        return vector2;
    }

    Vector add(Vector vector) {
        Vector<Join> vector2 = new Vector<Join>();
        int n = 0;
        while (vector != null && n < vector.size()) {
            PsqlJoin psqlJoin = (PsqlJoin)vector.elementAt(n);
            vector2.add(new Join(psqlJoin.getTableFrom().getName(), psqlJoin.getColumnFrom().getName(), psqlJoin.getOperator(), psqlJoin.getTableTo().getName(), psqlJoin.getColumnTo().getName(), psqlJoin.getOuterJoin(), psqlJoin.isSql92()));
            ++n;
        }
        return vector2;
    }

    JetUPath[] addElement(Path[] pathArray) {
        JetUPath[] jetUPathArray = new JetUPath[pathArray.length];
        int n = 0;
        while (n < jetUPathArray.length) {
            jetUPathArray[n] = this.addTableView(pathArray[n]);
            ++n;
        }
        if (jetUPathArray.length == 1 && jetUPathArray[0].getChildren().size() == 0) {
            jetUPathArray = new JetUPath[]{};
        }
        return jetUPathArray;
    }

    JetUPath addTableView(Path path) {
        JetUPath jetUPath = new JetUPath();
        if (path != null) {
            Join[] joinArray = path.getJoins();
            int n = 0;
            while (n < joinArray.length) {
                JetUPrejoin jetUPrejoin = new JetUPrejoin();
                jetUPrejoin.tableFrom.set(joinArray[n].getFromTable());
                jetUPrejoin.tableTo.set(joinArray[n].getToTable());
                jetUPrejoin.columnFrom.set(joinArray[n].getFromColumn());
                jetUPrejoin.columnTo.set(joinArray[n].getToColumn());
                jetUPrejoin.operator.set(joinArray[n].getOperator());
                jetUPrejoin.outerJoin.set(joinArray[n].getOuterJoinType());
                jetUPrejoin.isSQL92.set(joinArray[n].isSQL92());
                jetUPath.add(jetUPrejoin);
                ++n;
            }
        }
        return jetUPath;
    }

    Path append(JetUPath jetUPath) {
        Path path = new Path();
        if (jetUPath != null) {
            path.setName(jetUPath.pathName.get());
            Vector vector = jetUPath.getChildren();
            Vector<Join> vector2 = new Vector<Join>();
            Vector<String> vector3 = new Vector<String>();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    JetUPrejoin jetUPrejoin = (JetUPrejoin)vector.elementAt(n);
                    vector2.addElement(new Join(jetUPrejoin.tableFrom.get(), jetUPrejoin.columnFrom.get(), jetUPrejoin.operator.get(), jetUPrejoin.tableTo.get(), jetUPrejoin.columnTo.get(), jetUPrejoin.outerJoin.get(), jetUPrejoin.isSQL92.get()));
                    if (!vector3.contains(jetUPrejoin.tableFrom.get())) {
                        vector3.addElement(jetUPrejoin.tableFrom.get());
                    }
                    if (!vector3.contains(jetUPrejoin.tableTo.get())) {
                        vector3.addElement(jetUPrejoin.tableTo.get());
                    }
                    ++n;
                }
                path.setJoins(vector2);
                path.setTables(vector3);
            }
        }
        return path;
    }

    private Hashtable clone(Vector vector, Vector vector2) {
        Hashtable<String, HashSet<String>> hashtable = new Hashtable<String, HashSet<String>>();
        JoinsSet joinsSet = null;
        int n = 0;
        while (n < vector.size()) {
            Join join = (Join)vector.elementAt(n);
            String string = join.getFromTable();
            String string2 = join.getToTable();
            HashSet<String> hashSet = (HashSet<String>)hashtable.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashtable.put(string, hashSet);
            }
            hashSet.add(string2);
            hashSet = (HashSet<String>)hashtable.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashtable.put(string2, hashSet);
            }
            hashSet.add(string);
            boolean bl = true;
            int n2 = 0;
            while (n2 < vector2.size()) {
                joinsSet = (JoinsSet)vector2.elementAt(n2);
                if (joinsSet.equals(string, string2)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                joinsSet = new JoinsSet(string, string2);
                vector2.addElement(joinsSet);
            }
            joinsSet.add(join);
            ++n;
        }
        return hashtable;
    }

    public JetUPath filterUPath(JetUPath jetUPath, Vector vector) {
        Vector<Object> vector2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Path path = this.append(jetUPath);
        Vector vector3 = path.getAllJoins();
        Vector vector4 = new Vector();
        Hashtable hashtable = this.clone(vector3, vector4);
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        Vector vector5 = this.columnTo(hashtable2, true);
        Hashtable<Hashtable, Vector<String>> hashtable3 = new Hashtable<Hashtable, Vector<String>>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            boolean bl = false;
            object5 = null;
            int n2 = 0;
            while (n2 < vector5.size()) {
                object5 = (Hashtable)vector5.elementAt(n2);
                if (((Hashtable)object5).containsKey(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                Vector<String> vector6 = (Vector<String>)hashtable3.get(object5);
                if (vector6 == null) {
                    vector6 = new Vector<String>();
                    hashtable3.put((Hashtable)object5, vector6);
                }
                vector6.addElement(string);
            }
            ++n;
        }
        Vector vector7 = new Vector();
        Enumeration enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (Hashtable)enumeration.nextElement();
            object3 = (Vector)hashtable3.get(object4);
            if (((Vector)object3).size() <= 1) continue;
            object2 = (String)((Vector)object3).remove(0);
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                object = new Stack<String>();
                ((Stack)object).push(object2);
                object5 = (String)((Vector)object3).elementAt(n3);
                vector2 = new Vector();
                this.colName((String)object5, (Stack)object, (Hashtable)object4, vector2);
                if (vector2.size() > 0) {
                    vector7.addElement(vector2);
                }
                ++n3;
            }
        }
        object4 = new Path();
        if (vector7.size() > 0) {
            vector2 = new Vector<Object>();
            int n4 = 0;
            while (n4 < vector7.size()) {
                Vector vector8 = (Vector)vector7.elementAt(n4);
                int n5 = vector8.size() - 1;
                int n6 = 0;
                while (n6 < n5) {
                    String string = (String)vector8.elementAt(n6);
                    object = (String)vector8.elementAt(n6 + 1);
                    int n7 = 0;
                    while (n7 < vector4.size()) {
                        object2 = (JoinsSet)vector4.elementAt(n7);
                        if (((JoinsSet)object2).equals(string, (String)object)) {
                            Vector vector9 = ((JoinsSet)object2).getJoins();
                            int n8 = 0;
                            while (n8 < vector9.size()) {
                                object3 = (Join)vector9.elementAt(n8);
                                if (!vector2.contains(object3)) {
                                    vector2.addElement(object3);
                                }
                                ++n8;
                            }
                        }
                        ++n7;
                    }
                    ++n6;
                }
                ++n4;
            }
            ((Path)object4).setJoins(vector2);
            return this.addTableView((Path)object4);
        }
        return null;
    }

    private void colName(String string, Stack stack, Hashtable hashtable, Vector vector) {
        String string2 = (String)stack.peek();
        HashSet hashSet = (HashSet)hashtable.get(string2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n;
            if (vector.size() != 0) break;
            String string3 = (String)iterator.next();
            if (string3.equals(string)) {
                n = 0;
                while (n < stack.size()) {
                    vector.addElement(stack.elementAt(n));
                    ++n;
                }
                vector.add(string);
                break;
            }
            n = stack.indexOf(string3);
            if (n == -1) {
                stack.push(string3);
                this.colName(string, stack, hashtable, vector);
            } else if (n == stack.size() - 2) continue;
            stack.pop();
        }
    }

    public Vector getPrejoinLoops(Vector vector) {
        Vector vector2 = this.QOIV(vector);
        Vector vector3 = new Vector();
        Hashtable hashtable = this.clone(vector2, vector3);
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        Vector vector4 = this.columnTo(hashtable2, false);
        Vector vector5 = new Vector();
        int n = 0;
        while (n < vector4.size()) {
            Hashtable hashtable3 = (Hashtable)vector4.elementAt(n);
            Vector vector6 = new Vector();
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                vector6.addElement(enumeration.nextElement());
            }
            Stack stack = new Stack();
            stack.push(vector6.elementAt(0));
            this.columnFrom(hashtable3, vector5, stack, vector3);
            ++n;
        }
        return vector5;
    }

    public boolean getLoops(Vector vector) {
        Vector vector2 = this.QOIV(vector);
        Vector vector3 = new Vector();
        Hashtable hashtable = this.clone(vector2, vector3);
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        Vector vector4 = this.columnTo(hashtable2, false);
        Vector vector5 = new Vector();
        int n = 0;
        while (n < vector4.size()) {
            Hashtable hashtable3 = (Hashtable)vector4.elementAt(n);
            Vector vector6 = new Vector();
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                vector6.addElement(enumeration.nextElement());
            }
            Stack stack = new Stack();
            stack.push(vector6.elementAt(0));
            this.columnFrom(hashtable3, vector5, stack, vector3);
            if (vector5.size() > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void columnFrom(Hashtable hashtable, Vector vector, Stack stack, Vector vector2) {
        String string = (String)stack.peek();
        HashSet hashSet = (HashSet)hashtable.get(string);
        if (!stack.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = stack.indexOf(string2);
                if (n == -1) {
                    if (((HashSet)hashtable.get(string2)).size() <= 1) continue;
                    stack.push(string2);
                    this.columnFrom(hashtable, vector, stack, vector2);
                    continue;
                }
                if (n == stack.size() - 2) continue;
                Vector vector3 = new Vector();
                int n2 = n;
                while (n2 < stack.size()) {
                    vector3.addElement(stack.elementAt(n2));
                    ++n2;
                }
                Vector<JoinsSet> vector4 = new Vector<JoinsSet>();
                int n3 = vector3.size();
                int n4 = 0;
                while (n4 < n3) {
                    String string3 = (String)vector3.elementAt(n4);
                    String string4 = n4 < n3 - 1 ? (String)vector3.elementAt(n4 + 1) : (String)vector3.elementAt(0);
                    int n5 = 0;
                    while (n5 < vector2.size()) {
                        JoinsSet joinsSet = (JoinsSet)vector2.elementAt(n5);
                        if (joinsSet.equals(string3, string4)) {
                            vector4.addElement(joinsSet);
                            break;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                Loop loop = new Loop(vector3, vector4);
                boolean bl = true;
                int n6 = 0;
                while (n6 < vector.size()) {
                    Loop loop2 = (Loop)vector.elementAt(n6);
                    if (loop2.equals(loop)) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
                if (!bl) continue;
                vector.addElement(loop);
            }
            stack.pop();
        }
    }

    private Vector columnTo(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        while (hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            String string = null;
            if (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
            }
            if (string == null) continue;
            Stack stack = new Stack();
            Hashtable<String, HashSet> hashtable2 = new Hashtable<String, HashSet>();
            HashSet hashSet = (HashSet)hashtable.remove(string);
            hashtable2.put(string, hashSet);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stack.push(iterator.next());
            }
            this.contains(hashtable, stack, hashtable2);
            if (bl) {
                vector.addElement(hashtable2);
                continue;
            }
            if (hashtable2.size() <= 2) continue;
            vector.addElement(hashtable2);
        }
        return vector;
    }

    private void contains(Hashtable hashtable, Stack stack, Hashtable hashtable2) {
        String string = (String)stack.pop();
        HashSet hashSet = (HashSet)hashtable.remove(string);
        if (hashSet != null) {
            hashtable2.put(string, hashSet);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!hashtable.containsKey(string2) || stack.search(string2) != -1) continue;
                stack.push(string2);
            }
        }
        if (!stack.empty()) {
            this.contains(hashtable, stack, hashtable2);
        }
    }

    public JetUUniverse getUniverse() {
        return this.I;
    }

    public void updateTableNames(String string, String string2, String string3) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string3);
        Vector vector = jetUPrejoins.getChildren();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JetUTableInfo) {
                JetUTableInfo jetUTableInfo = (JetUTableInfo)e;
                if (jetUTableInfo.tableName.get().equals(string)) {
                    jetUTableInfo.tableName.set(string2);
                }
            } else if (e instanceof JetUPrejoin) {
                this.containsKey((JetUPrejoin)e, string, string2);
            } else if (e instanceof JetUPath) {
                Vector vector2 = ((JetUPath)e).getChildren();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    this.containsKey((JetUPrejoin)vector2.elementAt(n2), string, string2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    void containsKey(JetUPrejoin jetUPrejoin, String string, String string2) {
        if (jetUPrejoin.tableFrom.get().equals(string)) {
            jetUPrejoin.tableFrom.set(string2);
        } else if (jetUPrejoin.tableTo.get().equals(string)) {
            jetUPrejoin.tableTo.set(string2);
        }
    }

    public void updateFieldNames(String string, String string2, String string3, String string4) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string4);
        Vector vector = jetUPrejoins.getChildren();
        Hashtable hashtable = jetUPrejoins.getTables();
        int n = 0;
        while (n < vector.size()) {
            int n2;
            Object e = vector.elementAt(n);
            if (e instanceof JetUTableInfo) {
                if (((JetUTableInfo)e).tableName.get().equals(string)) {
                    Vector vector2 = ((JetUTableInfo)e).getChildren();
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        JetUColumnInfo jetUColumnInfo = (JetUColumnInfo)vector2.elementAt(n2);
                        if (jetUColumnInfo.I.get().equals(string2)) {
                            jetUColumnInfo.I.set(string3);
                            break;
                        }
                        ++n2;
                    }
                }
            } else if (e instanceof JetUPrejoin) {
                this.updateFieldName((JetUPrejoin)e, string, string2, string3);
            } else if (e instanceof JetUPath) {
                Vector vector3 = ((JetUPath)e).getChildren();
                n2 = 0;
                while (n2 < vector3.size()) {
                    this.updateFieldName((JetUPrejoin)vector3.elementAt(n2), string, string2, string3);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void updateFieldName(JetUPrejoin jetUPrejoin, String string, String string2, String string3) {
        if (jetUPrejoin.tableFrom.get().equals(string) && jetUPrejoin.columnFrom.get().equals(string2)) {
            jetUPrejoin.columnFrom.set(string3);
        } else if (jetUPrejoin.tableTo.get().equals(string) && jetUPrejoin.columnTo.get().equals(string2)) {
            jetUPrejoin.columnTo.set(string3);
        }
    }

    public void mergePrejoin(String string, JetUPrejoin[] jetUPrejoinArray) {
        JetUPrejoins jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        if (jetUPrejoins == null) {
            this.I(string);
            jetUPrejoins = (JetUPrejoins)this.QOIV.get(string);
        }
        jetUPrejoins.mergePrejoin(jetUPrejoinArray);
    }
}

