/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.AlarmClock;
import guitools.toolkit.Hourmeter;
import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;

public class MsgCell
extends Component
implements AlarmClock {
    public static final int FLAT = 0;
    public static final int RAISED = 1;
    public static final int SUNK = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int QOIV;
    int activeCaption;
    int clipRect;
    int I = Unit.convertUnitToPixel(27306);
    String convertUnitToPixel;
    protected Image img;
    long createImage = 300L;
    Hourmeter dispose;

    public MsgCell() {
    }

    public MsgCell(int n) {
        this.QOIV = n;
    }

    public MsgCell(int n, int n2) {
        this.QOIV = n;
        this.activeCaption = n2;
    }

    public MsgCell(String string, int n, int n2) {
        this.convertUnitToPixel = string;
        this.QOIV = n;
        this.I = n2;
    }

    public final void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.img == null || this.img.getWidth(this) != dimension.width || this.img.getHeight(this) != dimension.height) {
            this.paintImage(0, 0, dimension.width - 2, dimension.height - 2);
        }
        if (this.img != null) {
            graphics.drawImage(this.img, 1, 1, this);
        } else {
            graphics.setColor(SystemColor.text);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.QOIV != 0) {
            graphics.setColor(SystemColor.text);
            graphics.draw3DRect(0, 0, --dimension.width, --dimension.height, this.QOIV == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintImage(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        dimension.width -= 2;
        dimension.height -= 2;
        if (dimension.width > 0 && dimension.height > 0) {
            if (this.img == null || this.img.getWidth(this) != dimension.width || this.img.getHeight(this) != dimension.height) {
                this.img = this.createImage(dimension.width, dimension.height);
            }
            if (this.img != null) {
                Graphics graphics = this.img.getGraphics();
                try {
                    n = n < 0 ? 0 : n;
                    n2 = n2 < 0 ? 0 : n2;
                    n3 = n3 > dimension.width ? dimension.width : n3;
                    n4 = n4 > dimension.height ? dimension.height : n4;
                    graphics.clipRect(n, n2, n3, n4);
                    graphics.setColor(SystemColor.text);
                    graphics.fillRect(n, n2, n3, n4);
                    this.drawImage(graphics, dimension);
                    Object var8_7 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        }
    }

    protected void drawImage(Graphics graphics, Dimension dimension) {
        if (this.clipRect > 0) {
            int n = 2;
            int n2 = 2;
            int n3 = 6;
            int n4 = dimension.height - 5;
            dimension.width -= 6;
            graphics.setColor(SystemColor.activeCaption);
            int n5 = this.clipRect;
            while (n5 > 0 && n < dimension.width) {
                graphics.fillRect(n, n2, n3, n4);
                n += n3 + 2;
                --n5;
            }
            this.clipRect = n <= dimension.width ? this.clipRect : 0;
        } else if (this.convertUnitToPixel != null) {
            graphics.setColor(this.isEnabled() ? SystemColor.textText : SystemColor.textInactiveText);
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(this.convertUnitToPixel);
            int n6 = this.activeCaption == 0 ? 3 : (this.activeCaption == 1 ? (dimension.width - n) / 2 : dimension.width - n - 5);
            int n7 = (dimension.height >> 1) + fontMetrics.getMaxAscent() - fontMetrics.getHeight() / 2 - 1;
            graphics.drawString(this.convertUnitToPixel, n6, n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    graphics.clipRect(n, n2, n3, n4);
                    Dimension dimension = this.getSize();
                    dimension.width -= 2;
                    dimension.height -= 2;
                    n = n < 0 ? 0 : n;
                    n2 = n2 < 0 ? 0 : n2;
                    n3 = n3 > dimension.width ? dimension.width : n3;
                    n4 = n4 > dimension.height ? dimension.height : n4;
                    this.paintImage(n, n2, n3, n4);
                    if (this.img != null) {
                        graphics.drawImage(this.img, 1, 1, this);
                    }
                    if (this.QOIV != 0) {
                        graphics.setColor(SystemColor.text);
                        graphics.draw3DRect(0, 0, ++dimension.width, ++dimension.height, this.QOIV == 1);
                    }
                    Object var11_9 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        }
    }

    public void setAlign(int n) {
        if (n >= 0 && n <= 2 && n != this.activeCaption) {
            this.activeCaption = n;
            this.repaint();
        }
    }

    public int getAlign() {
        return this.activeCaption;
    }

    public void setExterior(int n) {
        if (n >= 0 && n <= 2 && this.QOIV != n) {
            this.QOIV = n;
            this.repaint();
        }
    }

    public int getExterior() {
        return this.QOIV;
    }

    public void setMinWidth(int n) {
        if (this.I != n) {
            this.I = n;
            Container container = this.getParent();
            if (container != null) {
                container.doLayout();
            }
        }
    }

    public int getMinWidth() {
        return this.I;
    }

    public void setText(String string) {
        if (this.convertUnitToPixel == null || string == null || !this.convertUnitToPixel.equals(string)) {
            this.convertUnitToPixel = string;
            this.repaint();
        }
    }

    public String getText() {
        return this.convertUnitToPixel;
    }

    public void progress(int n) {
        Dimension dimension = this.getSize();
        dimension.width -= 8;
        this.clipRect = dimension.width * n / 800;
        this.repaint();
    }

    public void startProgress(long l) {
        this.createImage = l;
        if (this.dispose != null) {
            this.dispose.stop();
        }
        this.clipRect = 0;
        this.repaint();
        this.dispose = new Hourmeter(l, this, true);
        this.dispose.start();
    }

    public void stopProgress() {
        if (this.dispose != null) {
            this.dispose.stop();
        }
        this.dispose = null;
        this.clipRect = 0;
        this.repaint();
    }

    public void clock() {
        ++this.clipRect;
        this.repaint();
    }
}

