/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.util.Hashtable;
import java.util.StringTokenizer;
import jet.connect.DbChar;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.ParamDesc;
import toolkit.db.DbTools;

public class RecordValueComparer {
    public static final String[] opers = new String[]{"Equal,NotEquals,Less,Great,LessEqual,GreatEqual,IN"};
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int LESS = 2;
    public static final int GREAT = 3;
    public static final int LESSEQUALS = 4;
    public static final int GREATEQUALS = 5;
    public static final int IN = 6;
    public static final String[] strOper = new String[]{"==", "!=", "<", ">", "<=", ">=", "IN"};
    public String opLeft;
    public String opRight;
    public int operator;
    private int QOIV = -1;
    public DbValue valLeft = null;
    public DbValue valRight = null;
    public boolean bLeftIsCol = false;
    public boolean bRightIsCol = false;
    private Hashtable append;
    private Hashtable compare;

    public RecordValueComparer() {
    }

    public RecordValueComparer(RecordValueComparer recordValueComparer) {
        this.opLeft = recordValueComparer.opLeft;
        this.opRight = recordValueComparer.opRight;
        this.operator = recordValueComparer.operator;
        this.valLeft = recordValueComparer.valLeft;
        this.valRight = recordValueComparer.valRight;
        this.bLeftIsCol = recordValueComparer.bLeftIsCol;
        this.bRightIsCol = recordValueComparer.bRightIsCol;
    }

    public static int getOperatorForName(String string) {
        if (string.equals("==")) {
            return 0;
        }
        if (string.equals("!=")) {
            return 1;
        }
        if (string.equals("<")) {
            return 2;
        }
        if (string.equals(">")) {
            return 3;
        }
        if (string.equals("<=")) {
            return 4;
        }
        if (string.equals(">=")) {
            return 5;
        }
        if (string.equalsIgnoreCase("IN")) {
            return 6;
        }
        throw new RuntimeException();
    }

    public boolean compare(Record record) {
        Object object;
        boolean bl = false;
        int n = DbTools.isSpecialField(this.opLeft);
        if (n == -1) {
            if (this.bLeftIsCol) {
                try {
                    this.QOIV = record.indexOfCell(this.opLeft);
                    if (this.QOIV == -1) {
                        throw new Error("Undefined column name " + this.opLeft);
                    }
                    this.valLeft = record.getCell(this.QOIV);
                }
                catch (Exception exception) {
                    object = (ParamDesc)this.append.get(this.opLeft);
                    if (object != null) {
                        this.valLeft = ((ParamDesc)object).getValue();
                    }
                    return false;
                }
            }
        } else {
            this.valLeft = new DbChar((String)this.compare.get(new Integer(n)));
        }
        if ((n = DbTools.isSpecialField(this.opRight)) == -1) {
            if (this.bRightIsCol) {
                try {
                    this.QOIV = record.indexOfCell(this.opRight);
                    if (this.QOIV == -1) {
                        throw new Error("Undefined column name " + this.opRight);
                    }
                    this.valRight = record.getCell(this.QOIV);
                }
                catch (Exception exception) {
                    object = (ParamDesc)this.append.get(this.opRight);
                    if (object != null) {
                        this.valRight = ((ParamDesc)object).getValue();
                    }
                    return false;
                }
            }
        } else {
            this.valRight = new DbChar((String)this.compare.get(new Integer(n)));
        }
        if (this.operator == 6) {
            object = this.valRight.toString();
            if (((String)object).startsWith("(")) {
                object = ((String)object).substring(1, ((String)object).length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                String string = this.valLeft.toString();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.substring(1, string2.length() - 1).equals(string)) continue;
                    return true;
                }
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.valLeft.toString(), "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(object)) continue;
                return true;
            }
            return false;
        }
        int n2 = this.valLeft instanceof DbNumber || this.valRight instanceof DbNumber ? ((DbNumber)this.valLeft).compare((DbNumber)this.valRight) : this.valLeft.compareTo(this.valRight);
        switch (this.operator) {
            case 0: {
                bl = n2 == 0;
                break;
            }
            case 1: {
                bl = n2 != 0;
                break;
            }
            case 2: {
                bl = n2 == -1;
                break;
            }
            case 3: {
                bl = n2 == 1;
                break;
            }
            case 4: {
                bl = n2 == 0 || n2 == -1;
                break;
            }
            case 5: {
                bl = n2 == 0 || n2 == 1;
                break;
            }
            default: {
                throw new Error("Unknow operator " + this.operator);
            }
        }
        return bl;
    }

    public void reset(RecordValueComparer recordValueComparer) {
        if (recordValueComparer.valLeft == null) {
            this.valLeft = null;
        }
        if (recordValueComparer.valRight == null) {
            this.valRight = null;
        }
    }

    public void setParameters(Hashtable hashtable) {
        this.append = hashtable;
    }

    public void setSpecFields(Hashtable hashtable) {
        this.compare = hashtable;
    }
}

