/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import barcode.BarcodeConstants;
import barcode.linearBarcode.BarcodeConstraints;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.Image;
import java.util.Vector;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbValue;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSParameterField;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderButton;
import jet.datastream.render.RenderCheckBox;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderHidden;
import jet.datastream.render.RenderImage;
import jet.datastream.render.RenderImageButton;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderRadioButton;
import jet.datastream.render.RenderRank;
import jet.datastream.render.RenderResetButton;
import jet.datastream.render.RenderSubmitButton;
import jet.datastream.render.RenderText;
import jet.datastream.render.RenderTextArea;
import jet.datastream.render.RenderTextField;
import jet.datastream.render.RenderUtil;
import jet.naming.PropertyNameConstant;
import jet.util.ImageLoader;

public class RenderCreator {
    public static final int TEXT = 0;
    public static final int RANK = 1;
    public static final int BARCODE = 2;
    public static final int IMAGE = 3;
    public static final int TEXTFIELD = 4;
    public static final int TEXTAREA = 5;
    public static final int CHECKBOX = 6;
    public static final int RADIOBUTTON = 7;
    public static final int LIST = 8;
    public static final int DROPDOWNLIST = 9;
    public static final int IMAGEBUTTON = 10;
    public static final int BUTTON = 11;
    public static final int SUBMIT_BUTTON = 12;
    public static final int RESET_BUTTON = 13;
    public static final int HIDDEN = 14;
    public static final int DEFAULT_SHADOW_WIDTH = Unit.convertInchToUnit(0.045777);

    public static Render createConcreteRender(int n, DSField dSField) {
        Render render = null;
        switch (n) {
            case 0: {
                render = new RenderText(dSField);
                break;
            }
            case 1: {
                render = new RenderRank(dSField);
                break;
            }
            case 2: {
                render = new RenderBarCode(dSField);
                break;
            }
            case 3: {
                render = new RenderImage(dSField);
                break;
            }
            case 4: {
                render = new RenderTextField(dSField);
                break;
            }
            case 6: {
                render = new RenderCheckBox(dSField);
                break;
            }
            case 7: {
                render = new RenderRadioButton(dSField);
                break;
            }
            case 11: {
                render = new RenderButton(dSField);
                break;
            }
            case 5: {
                render = new RenderTextArea(dSField);
                break;
            }
            case 10: {
                render = new RenderImageButton(dSField);
                break;
            }
            case 8: {
                render = new RenderList(dSField);
                break;
            }
            case 9: {
                render = new RenderDropDownList(dSField);
                break;
            }
            case 12: {
                render = new RenderSubmitButton(dSField);
                break;
            }
            case 13: {
                render = new RenderResetButton(dSField);
                break;
            }
            case 14: {
                render = new RenderHidden(dSField);
            }
        }
        RenderCreator.BUILTINTYPES(render, dSField, n);
        render.locate();
        return render;
    }

    private static void BUILTINTYPES(Render render, DSField dSField, int n) {
        RenderCreator.setCommonRenderProperteis(render, dSField);
        switch (n) {
            case 0: {
                RenderCreator.booleanValue(render, dSField);
                break;
            }
            case 1: {
                RenderCreator.convertUnitToPixel(render, dSField);
                break;
            }
            case 2: {
                RenderCreator.convertInchToUnit(render, dSField);
                break;
            }
            case 3: {
                RenderCreator.doubleValue(render, dSField);
                break;
            }
            case 4: 
            case 14: {
                RenderCreator.error(render, dSField);
                break;
            }
            case 6: {
                RenderCreator.get(render, dSField);
                break;
            }
            case 7: {
                RenderCreator.getBarCode(render, dSField);
                break;
            }
            case 11: {
                RenderCreator.floatValue(render, dSField);
                break;
            }
            case 5: {
                RenderCreator.getBooleanPropertyByName(render, dSField);
                break;
            }
            case 10: {
                RenderCreator.add(render, dSField);
                break;
            }
            case 8: {
                RenderCreator.QOIV(render, dSField);
                break;
            }
            case 9: {
                RenderCreator.DEFAULT_SHADOW_WIDTH(render, dSField);
                break;
            }
            case 12: {
                RenderCreator.getEndLine(render, dSField);
                break;
            }
            case 13: {
                RenderCreator.getFont(render, dSField);
            }
        }
    }

    private static void DEFAULT_SHADOW_WIDTH(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            int n;
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector vector3 = ((DSParameterField)dSField).getSelectedValues();
            String string = "";
            String string2 = "";
            if (vector3.size() > 0) {
                string2 = (String)vector3.get(0);
            }
            if ((n = vector2.indexOf(string2)) != -1) {
                string = (String)vector.get(n);
            } else if (vector.size() > 0 && vector2.size() > 0) {
                string = (String)vector.get(0);
                string2 = (String)vector2.get(0);
            }
            ((RenderDropDownList)render).setTexts(vector);
            ((RenderDropDownList)render).setValues(vector2);
            ((RenderDropDownList)render).setSelectedTexts(string);
            ((RenderDropDownList)render).setSelectedValues(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderDropDownList)render).setTexts(vector);
            ((RenderDropDownList)render).setFont(new Font("Default", 1, 10));
        }
    }

    private static void QOIV(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector<String> vector3 = new Vector<String>();
            String string = "";
            Vector vector4 = ((DSParameterField)dSField).getSelectedValues();
            int n = 0;
            while (n < vector4.size()) {
                string = (String)vector4.get(n);
                int n2 = vector2.indexOf(string);
                if (n2 != -1) {
                    String string2 = (String)vector.get(n2);
                    if (string2 == null) {
                        string2 = "";
                    }
                    vector3.add(string2);
                    ((RenderList)render).setIndex(n2);
                }
                ++n;
            }
            ((RenderList)render).setSelectedText(vector3);
            ((RenderList)render).setTexts(vector);
            ((RenderList)render).setValues(vector2);
            ((RenderList)render).setSelectedValues(vector4);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderList)render).setTexts(vector);
        }
    }

    private static void add(Render render, DSField dSField) {
        boolean bl = (Boolean)dSField.getPropertyByName("FromURL").getObject();
        ((RenderImageButton)render).setFromURL((Boolean)dSField.getPropertyByName("FromURL").getObject());
        ((RenderImageButton)render).setWidth((Integer)dSField.getPropertyByName("Image_Display_Width").getObject());
        ((RenderImageButton)render).setHeight((Integer)dSField.getPropertyByName("Image_Display_Height").getObject());
        ((RenderImageButton)render).setOriginalSize((Boolean)dSField.getPropertyByName("Original_Size").getObject());
        ((RenderImageButton)render).setScaleMode((Integer)dSField.getPropertyByName("ScalingMode").getObject());
        ((RenderImageButton)render).setMaxRatio(((Number)dSField.getPropertyByName("MaxScalingRatio").getObject()).floatValue());
        if (bl) {
            Image image = (Image)dSField.getPropertyByName("Src").getObject();
            ((RenderImageButton)render).setImageType(ImageLoader.getImageType(image));
            ((RenderImageButton)render).setImage(image);
        } else if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            ((RenderImageButton)render).setValue(dbValue);
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300017);
        }
    }

    private static void booleanValue(Render render, DSField dSField) {
        block2: {
            try {
                render.setTopPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNameConstant.getNameByID(1963))).intValue());
                render.setBottomPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNameConstant.getNameByID(1960))).intValue());
                render.setLeftPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNameConstant.getNameByID(1961))).intValue());
                render.setRightPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNameConstant.getNameByID(1962))).intValue());
            }
            catch (Exception exception) {
                if (!JRLog.isError(3)) break block2;
                JRLog.error(3, 3300018);
            }
        }
        ((RenderText)render).setText(dSField.toString());
        ((RenderText)render).setStartLine(dSField.getStartLine());
        ((RenderText)render).setEndLine(dSField.getEndLine());
        ((RenderText)render).setLineBreakPos(dSField.getLineBreakPos());
    }

    private static void convertInchToUnit(Render render, DSField dSField) {
        BarcodeConstraints barcodeConstraints = ((RenderBarCode)render).getBarCode();
        barcodeConstraints.setBarHRFont(render.getFont());
        barcodeConstraints.setBarHeight(((Integer)dSField.getPropertyByName("BarHeight").getObject()).shortValue());
        barcodeConstraints.setBarNarrowWidth(((Integer)dSField.getPropertyByName("NarrowWidth").getObject()).shortValue());
        barcodeConstraints.setBarHRDisplay((Boolean)dSField.getPropertyByName("HRDisplay").getObject());
        try {
            barcodeConstraints.setBarRatio(((Number)dSField.getPropertyByName("Ratio").getObject()).floatValue());
            barcodeConstraints.setBarCheckEnable((Boolean)dSField.getPropertyByName("CheckEnable").getObject());
            barcodeConstraints.setBarQuietZone(((Integer)dSField.getPropertyByName("QuietZone").getObject()).shortValue());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = (Integer)dSField.getPropertyByName("Symbology").getObject();
        if (n >= BarcodeConstants.BUILTINTYPES.length) {
            barcodeConstraints.setBarSymbology(5);
            barcodeConstraints.setBar128Type(n - BarcodeConstants.BUILTINTYPES.length);
        } else {
            barcodeConstraints.setBarSymbology(n);
        }
        if (n == 5) {
            barcodeConstraints.setBarSymbology(5);
            barcodeConstraints.setBar128Type(3);
        }
        barcodeConstraints.setBarSupplement((String)dSField.getPropertyByName("Supplement").getObject());
        barcodeConstraints.setBarScaleMode((Integer)dSField.getPropertyByName("ScaleMode").getObject());
        int n2 = (Integer)dSField.getPropertyByName("Orientation").getObject();
        barcodeConstraints.setBarOrientation(n2);
        ((RenderBarCode)render).setOrientation(n2);
        boolean bl = (Boolean)dSField.getPropertyByName("UseDefaultMessage").getObject();
        if (bl) {
            barcodeConstraints.setBarMessage((String)dSField.getPropertyByName("Message").getObject());
        } else {
            barcodeConstraints.setBarMessage(dSField.toString());
        }
    }

    private static void convertUnitToPixel(Render render, DSField dSField) {
        Vector vector = (Vector)dSField.getPropertyByName("MaxValueVector").getObject();
        Vector vector2 = (Vector)dSField.getPropertyByName("MinValueVector").getObject();
        int n = vector == null ? 0 : vector.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = Double.parseDouble((String)vector.get(n2));
            dArray2[n2] = Double.parseDouble((String)vector2.get(n2));
            ++n2;
        }
        ((RenderRank)render).setMaxValue(dArray);
        ((RenderRank)render).setMinValue(dArray2);
        Image image = (Image)dSField.getPropertyByName("DefaultImagePath").getObject();
        ((RenderRank)render).setDefImgType(ImageLoader.getImageType(image));
        Vector vector3 = (Vector)dSField.getPropertyByName("ImagePathVector").getObject();
        String string = (String)dSField.getPropertyByName("DefaultName").getObject();
        Vector vector4 = (Vector)dSField.getPropertyByName("NameVector").getObject();
        double d = ((Number)dSField.getPropertyByName("DefaultRotate").getObject()).floatValue();
        Vector vector5 = (Vector)dSField.getPropertyByName("ImageRotateVector").getObject();
        String string2 = (String)dSField.getPropertyByName("DefaultTitle").getObject();
        Vector vector6 = (Vector)dSField.getPropertyByName("ImageTitleVector").getObject();
        Image[] imageArray = null;
        int[] nArray = null;
        if (vector3 != null) {
            n = vector3.size();
            imageArray = new Image[n];
            nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                imageArray[n3] = (Image)vector3.get(n3);
                nArray[n3] = imageArray[n3] != null ? ImageLoader.getImageType(imageArray[n3]) : -100;
                ++n3;
            }
        }
        String[] stringArray = null;
        if (vector4 != null) {
            n = vector4.size();
            stringArray = new String[n];
            int n4 = 0;
            while (n4 < n) {
                stringArray[n4] = ((String)vector4.get(n4)).trim();
                ++n4;
            }
        }
        String[] stringArray2 = null;
        double[] dArray3 = null;
        if (vector5 != null) {
            n = vector5.size();
        }
        stringArray2 = new String[n];
        dArray3 = new double[n];
        int n5 = 0;
        while (n5 < n) {
            stringArray2[n5] = ((String)vector5.get(n5)).trim();
            dArray3[n5] = Double.parseDouble(stringArray2[n5]);
            ++n5;
        }
        String[] stringArray3 = null;
        if (vector6 != null) {
            n = vector6.size();
        }
        stringArray3 = new String[n];
        int n6 = 0;
        while (n6 < n) {
            stringArray3[n6] = ((String)vector6.get(n6)).trim();
            ++n6;
        }
        ((RenderRank)render).setScopeImages(imageArray);
        ((RenderRank)render).setScopeImagesType(nArray);
        ((RenderRank)render).setDefImg(image);
        ((RenderRank)render).setDefImageAlt(string);
        ((RenderRank)render).setImageAlts(stringArray);
        ((RenderRank)render).setRotation(d);
        ((RenderRank)render).setImageRankRotate(dArray3);
        ((RenderRank)render).setImageRankTitles(stringArray3);
        ((RenderRank)render).setDefImageTitle(string2);
        if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            if (dbValue != null && !dbValue.isNull() && dbValue instanceof DbNumber) {
                ((RenderRank)render).setValue(((DbNumber)dbValue).doubleValue());
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6300065);
            }
        } else if (dSField instanceof DSParameterField) {
            DbNumber dbNumber = null;
            Object e = ((DSParameterField)dSField).getSelectedValues().get(0);
            if (e instanceof Number) {
                dbNumber = e instanceof Integer ? new DbInteger() : (e instanceof Float ? new DbReal() : new DbDouble());
                dbNumber.setValue(e.toString());
                ((RenderRank)render).setValue(((DbNumber)dbNumber).doubleValue());
            } else if (e instanceof String) {
                double d2 = -1.0;
                try {
                    d2 = Double.parseDouble((String)e);
                    dbNumber = new DbDouble();
                    dbNumber.setValue(e.toString());
                    ((RenderRank)render).setValue(dbNumber.doubleValue());
                }
                catch (Exception exception) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 6300065);
                    }
                }
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6300065);
            }
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6300066);
        }
    }

    private static void doubleValue(Render render, DSField dSField) {
        boolean bl = (Boolean)dSField.getPropertyByName("FromURL").getObject();
        ((RenderImage)render).setFromURL(bl);
        ((RenderImage)render).setWidth((Integer)dSField.getPropertyByName("Image_Display_Width").getObject());
        ((RenderImage)render).setHeight((Integer)dSField.getPropertyByName("Image_Display_Height").getObject());
        ((RenderImage)render).setOriginalSize((Boolean)dSField.getPropertyByName("Original_Size").getObject());
        ((RenderImage)render).setScaleMode((Integer)dSField.getPropertyByName("ScalingMode").getObject());
        ((RenderImage)render).setMaxRatio(((Number)dSField.getPropertyByName("MaxScalingRatio").getObject()).floatValue());
        ((RenderImage)render).setRotation(((Number)dSField.getPropertyByName("Rotation").getObject()).floatValue());
        if (bl) {
            Object object = dSField.getPropertyByName("Src").getObject();
            if (object instanceof Image) {
                Image image = (Image)object;
                ((RenderImage)render).setImageType(ImageLoader.getImageType(image));
                ((RenderImage)render).setImage(image);
            }
        } else if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            ((RenderImage)render).setValue(dbValue);
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300017);
        }
    }

    private static void error(Render render, DSField dSField) {
        render.setText(dSField.toString());
    }

    private static void floatValue(Render render, DSField dSField) {
        ((RenderButton)render).setText(dSField.toString());
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    private static void get(Render render, DSField dSField) {
        render.setResolution(96);
        ((RenderCheckBox)render).setChecked((Boolean)dSField.getPropertyByName("Check_Condition").getObject());
        ((RenderCheckBox)render).setText(dSField.toString());
    }

    private static void getBarCode(Render render, DSField dSField) {
        render.setResolution(96);
        ((RenderRadioButton)render).setChecked((Boolean)dSField.getPropertyByName("Check_Condition").getObject());
        ((RenderRadioButton)render).setText(dSField.toString());
    }

    private static void getBooleanPropertyByName(Render render, DSField dSField) {
        render.setText(dSField.toString());
    }

    private static void getEndLine(Render render, DSField dSField) {
        ((RenderButton)render).setText(dSField.toString());
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    private static void getFont(Render render, DSField dSField) {
        ((RenderButton)render).setText(dSField.toString());
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    public static void setCommonRenderProperteis(Render render, DSField dSField) {
        int n = ((JRObjectResult)dSField).getResolution();
        render.setResolution(n);
        render.setBorderWidth(RenderUtil.getIntPropertyByName(dSField, "BorderWidth"));
        render.setLeftStyle(RenderUtil.getIntPropertyByName(dSField, "LeftLine"));
        render.setRightStyle(RenderUtil.getIntPropertyByName(dSField, "RightLine"));
        render.setTopStyle(RenderUtil.getIntPropertyByName(dSField, "TopLine"));
        render.setBottomStyle(RenderUtil.getIntPropertyByName(dSField, "BottomLine"));
        render.setShadow(RenderUtil.getBooleanPropertyByName(dSField, "Shadow"));
        if (render.isShadow()) {
            render.setShadowWidth(DEFAULT_SHADOW_WIDTH);
        }
        String string = RenderUtil.getStringPropertyByName(dSField, "FontFace");
        int n2 = 0;
        if (!string.startsWith("*")) {
            if (RenderUtil.getBooleanPropertyByName(dSField, "Bold")) {
                n2 |= 1;
            }
            if (RenderUtil.getBooleanPropertyByName(dSField, "Italic")) {
                n2 |= 2;
            }
        }
        float f = RenderUtil.getIntPropertyByName(dSField, "FontSize");
        float f2 = Unit.convertUnitToPixel(f, n);
        if (n == 60) {
            if (f2 > (float)((int)f2)) {
                f2 += 1.0f;
            }
            render.setFont(RenderGraphicsToolkit.getFont(string, n2, (int)f2));
        } else {
            if (dSField.getRenderType() == 0 && !((RenderText)render).isPrecision()) {
                f2 = Unit.convertUnitToPixel(f = RenderCreator.getImageType(f), n);
                if (f2 > (float)((int)f2)) {
                    f2 += 0.5f;
                }
                f2 = (int)f2;
            }
            render.setFont(RenderGraphicsToolkit.getFont(string, n2, f2));
        }
        try {
            int n3 = ((Number)RenderUtil.getPropertyByName(dSField, "HorizontalAlignment")).intValue();
            int n4 = ((Number)RenderUtil.getPropertyByName(dSField, "VerticalAlignment")).intValue();
            int n5 = RenderUtil.parseAlignment(n3, n4);
            render.setLayout(n5);
        }
        catch (Exception exception) {
            render.setLayout(RenderUtil.getIntPropertyByName(dSField, "Alignment"));
        }
        render.setWordwrap(RenderUtil.getBooleanPropertyByName(dSField, "WordWrap"));
        if (dSField.getTemplate().getPropertyByName("AutoFit") == null) {
            render.setAutoFit(false);
        } else {
            render.setAutoFit(RenderUtil.getBooleanPropertyByName(dSField, "AutoFit"));
        }
    }

    private static float getImageType(float f) {
        int n = 40;
        float f2 = 0.0f;
        f2 = f % 80.0f > (float)n ? f + (80.0f - f % 80.0f) : f - f % 80.0f;
        return f2;
    }
}

