/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.math.BigDecimal;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;
import jet.formula.fCurrency;

class Summary
extends Aggregation {
    Summary() {
    }

    Summary(AggDesc aggDesc) {
        super(aggDesc);
    }

    public void exec(DbValue dbValue) {
        int n = this.I.getSumSqlType() == 3 ? DataTypeDef.SqlToFml(dbValue.getSqlType(), true) : DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
        if (this.agg == null) {
            this.agg = DataTypeDef.makeData(n);
            this.agg.bNull = true;
        }
        if (!dbValue.bNull) {
            if (this.agg.bNull) {
                this.agg.bNull = false;
            }
            switch (n) {
                case 1: {
                    ((DbBigInt)this.agg).value += ((DbNumber)dbValue).longValue();
                    break;
                }
                case 2: {
                    ((DbDouble)this.agg).value += ((DbNumber)dbValue).doubleValue();
                    break;
                }
                case 3: {
                    if (((fCurrency)this.agg).value == null) {
                        ((fCurrency)this.agg).value = new BigDecimal(0.0);
                    }
                    if (dbValue instanceof DbDecimal) {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(((DbDecimal)dbValue).get());
                        break;
                    }
                    try {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(new BigDecimal(dbValue.toString()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(new BigDecimal(((DbNumber)dbValue).doubleValue()));
                    }
                }
            }
        }
    }

    public void exec(Record record) {
        DbValue dbValue;
        int n;
        DbColDesc dbColDesc;
        try {
            dbColDesc = this.agg.getColDesc();
            n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        }
        catch (NullPointerException nullPointerException) {
            dbValue = record.getCell(this.I.fieldname);
            n = this.I.getSumSqlType() == 3 ? DataTypeDef.SqlToFml(dbValue.getSqlType(), true) : DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            this.agg = DataTypeDef.makeData(n);
            dbColDesc = this.agg.getColDesc();
            dbColDesc.setColIndex(dbValue.getColDesc().getColIndex());
            this.agg.bNull = true;
        }
        dbValue = record.getCell(dbColDesc);
        if (!dbValue.bNull) {
            if (this.agg.bNull) {
                this.agg.bNull = false;
            }
            switch (n) {
                case 1: {
                    ((DbBigInt)this.agg).value += ((DbNumber)dbValue).longValue();
                    break;
                }
                case 2: {
                    ((DbDouble)this.agg).value += ((DbNumber)dbValue).doubleValue();
                    break;
                }
                case 3: {
                    if (((fCurrency)this.agg).value == null) {
                        ((fCurrency)this.agg).value = new BigDecimal(0.0);
                    }
                    if (dbValue instanceof DbDecimal) {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(((DbDecimal)dbValue).get());
                        break;
                    }
                    try {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(new BigDecimal(dbValue.toString()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((fCurrency)this.agg).value = ((fCurrency)this.agg).value.add(new BigDecimal(((DbNumber)dbValue).doubleValue()));
                    }
                }
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.agg != null) {
            this.agg.bNull = true;
        }
    }
}

