/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import jet.datastream.Communicator;
import jet.ie.AbstractRSTExporter;
import jet.ie.ConvertToJCommunicator;
import jet.ie.RSTBlockWriter;
import jet.ie.RSTWriteTool;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.rptengine.JCommunicator;
import jet.security.PageFilter;
import jet.util.JFieldValueNLSManager;
import jet.util.RAFile;

public class RSTBlockSaveController
extends AbstractRSTExporter {
    private boolean QOIV = false;
    private PJFDataOutput append = null;
    private RAFile close;
    private long delete;
    private Hashtable error = new Hashtable();
    private boolean exists = true;

    public RSTBlockSaveController(String string) {
        this.setFileName(string);
    }

    public RSTBlockSaveController() {
    }

    public void setFileName(String string) {
        super.setFileName(string);
        if (!this.QOIV) {
            try {
                File file = new File(this._fileName);
                if (file.exists()) {
                    file.delete();
                }
                this.close = new RAFile(file, "rw");
                this.append = new PJFDataOutput(new FileBlockOutputStream(this.close));
                this.append.write(AbstractRSTExporter.PJF_TAG);
                this.PJF_TAG(this.append);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            throw new RuntimeException("The rst filename has been set!");
        }
        this.QOIV = true;
    }

    public void setReportInfos(Map map) {
        super.setReportInfos(map);
        if (this._mapInfo != null) {
            try {
                RSTWriteTool.writeMapInfo(this._mapInfo, this.append);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 2407001);
        }
    }

    public void setReportAttachInfos(Map map) {
        block5: {
            super.setReportAttachInfos(map);
            try {
                if (this._attachInfo != null) {
                    RSTWriteTool.writeMapInfo(this._attachInfo, this.append);
                } else if (JRLog.isError(2)) {
                    JRLog.error(2, 2407001);
                }
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, 2407005);
            }
        }
    }

    public void zipRST(boolean bl) {
        block2: {
            super.zipRST(bl);
            try {
                this.append.writeBoolean(this._isZipRst);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, 2407005);
            }
        }
    }

    public synchronized void setCommunicators(String string, String string2, Communicator communicator) throws VersionException {
        try {
            if (this.exists) {
                this.delete = this.append.getPosition();
                this.append.writeLong(0L);
                this.exists = false;
            }
            String string3 = string.length() + string + string2.length() + string2;
            this.error.put(string3, new Long(this.append.getPosition()));
            JCommunicator jCommunicator = communicator instanceof PageFilter ? new ConvertToJCommunicator((PageFilter)communicator) : (JCommunicator)communicator;
            RSTBlockWriter rSTBlockWriter = new RSTBlockWriter(jCommunicator, this._isZipRst);
            rSTBlockWriter.setCatalogPath(this._catalogPath);
            long l = this.append.getPosition();
            this.append.writeLong(0L);
            rSTBlockWriter.write(this.append);
            long l2 = this.append.getPosition();
            long l3 = l2 - l - 4L;
            this.append.seek(l);
            this.append.writeLong(l3);
            this.append.seek(l2);
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407004, (Throwable)exception);
            }
            throw new VersionException(407004, (Throwable)exception);
        }
    }

    public void setNLSManager(String string, String string2, JFieldValueNLSManager jFieldValueNLSManager) {
        if (jFieldValueNLSManager != null) {
            String string3 = string.length() + string + string2.length() + string2;
            this._nlsManager.put(string3, jFieldValueNLSManager);
        }
    }

    public void saveRSTFile() throws VersionException {
        try {
            long l = this.append.getPosition();
            this.append.writeInt(this.error.size());
            Enumeration enumeration = this.error.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                long l2 = (Long)this.error.get(string);
                this.append.writeUTF(string);
                this.append.writeLong(l2);
            }
            long l3 = this.append.getPosition();
            this.append.seek(this.delete);
            this.append.writeLong(l);
            this.append.seek(l3);
            RSTWriteTool.writeNLSManagers(this.append, this._nlsManager);
            this.close.close();
            this.append.close();
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401012);
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407002);
            }
            throw new VersionException(407002, (Throwable)iOException);
        }
    }

    private void PJF_TAG(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(262416);
        dataOutput.writeLong(1311768467294899695L);
        dataOutput.writeInt(4386);
    }
}

