/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import jet.connect.Record;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.udo.JRObjectRender;
import jet.util.PropertySetable;

public class JReportBox
extends TComponent
implements JRObjectRender,
PainterConstants {
    protected int startY = 0;
    private Color convertUnitToPixel;
    protected int borderWidth;
    protected int topStyle;
    protected int bottomStyle;
    protected int leftStyle;
    protected int rightStyle;
    protected boolean drawShadow;
    protected Color shadowColor;
    protected int shadowWidth;
    protected int resolution;

    public void setProperty(PropertySetable propertySetable) {
        JRVisiableResult jRVisiableResult = (JRVisiableResult)propertySetable;
        Color color = this.getColorPropertyByName(jRVisiableResult, "Background");
        if (color != null) {
            this.setBackground(color);
            this.setEraser(true);
        } else {
            this.setEraser(false);
        }
        this.resolution = jRVisiableResult.getResolution();
        this.convertUnitToPixel = this.getColorPropertyByName(jRVisiableResult, "BorderColor");
        this.borderWidth = this.getIntPropertyByName(jRVisiableResult, "BorderWidth");
        this.borderWidth = Unit.convertUnitToPixel(this.borderWidth, this.resolution);
        this.topStyle = this.getIntPropertyByName(jRVisiableResult, "TopLine");
        this.bottomStyle = this.getIntPropertyByName(jRVisiableResult, "BottomLine");
        this.leftStyle = this.getIntPropertyByName(jRVisiableResult, "LeftLine");
        this.rightStyle = this.getIntPropertyByName(jRVisiableResult, "RightLine");
        this.drawShadow = this.getBooleanPropertyByName(jRVisiableResult, "Shadow");
        this.shadowColor = this.getColorPropertyByName(jRVisiableResult, "ShadowColor");
        this.startY = Unit.convertUnitToPixel(jRVisiableResult.getStartYPos(), this.resolution);
        this.shadowWidth = Unit.convertUnitToPixel(PainterConstants.DEFAULT_SHADOW_WIDTH, this.resolution);
    }

    public void paint(Graphics graphics) {
        Painter.drawBorder(graphics, this.getSize(), this.hasEraser() ? this.getBackground() : null, this.convertUnitToPixel, this.borderWidth, this.topStyle, this.bottomStyle, this.leftStyle, this.rightStyle, this.drawShadow, this.shadowColor, this.shadowWidth);
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }
}

