/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import java.io.IOException;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUJdbcSupportInfo;
import toolkit.config.PoolConfig;
import toolkit.db.version2.CallTrace;
import toolkit.db.version2.JdbcPool;

public class ConnectionInfo
implements Connection {
    int QOIV;
    long append;
    String I;
    Connection class$;
    JdbcPool clearWarnings;
    private String close;
    private static JRLogger commit = JRLogger.getLogger((class$toolkit$db$version2$ConnectionInfo == null ? (class$toolkit$db$version2$ConnectionInfo = ConnectionInfo.class$("toolkit.db.version2.ConnectionInfo")) : class$toolkit$db$version2$ConnectionInfo).getName());
    private static DSLog createStatement = DSLog.getDSLog((class$toolkit$db$version2$ConnectionInfo == null ? (class$toolkit$db$version2$ConnectionInfo = ConnectionInfo.class$("toolkit.db.version2.ConnectionInfo")) : class$toolkit$db$version2$ConnectionInfo).getName());
    static Class class$toolkit$db$version2$ConnectionInfo;

    public Connection getRealConn() {
        Connection connection = this.class$;
        while (connection != this && connection instanceof ConnectionInfo) {
            connection = ((ConnectionInfo)connection).getRealConn();
        }
        return connection;
    }

    ConnectionInfo(JdbcPool jdbcPool, Connection connection, String string, String string2) {
        this.clearWarnings = jdbcPool;
        this.class$ = connection;
        this.I = string;
        this.close = string2;
        ++this.QOIV;
        this.append = System.currentTimeMillis();
        if (commit.isDebugEnabled()) {
            commit.debug("create connection\nshare count is " + this.QOIV);
        }
    }

    public String getUser() {
        return this.I;
    }

    public synchronized int getStartTime() {
        return this.QOIV > 0 ? (int)(System.currentTimeMillis() - this.append) : -1;
    }

    public synchronized int getIdleTime() {
        return this.QOIV == 0 ? (int)(System.currentTimeMillis() - this.append) : -1;
    }

    public synchronized int getLockNumber() {
        return this.QOIV;
    }

    public synchronized boolean isLock() {
        return this.QOIV > 0;
    }

    public JdbcPool getJdbcPool() {
        return this.clearWarnings;
    }

    synchronized void I() throws SQLException {
        SQLException sQLException = null;
        if (commit.isDebugEnabled()) {
            commit.debug("share connection\nshare count is " + this.QOIV);
        }
        if (this.QOIV()) {
            ++this.QOIV;
        } else {
            if (this.class$ != null) {
                try {
                    if (!this.class$.getAutoCommit()) {
                        this.class$.commit();
                    }
                    this.class$.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            PoolConfig poolConfig = this.clearWarnings.getConfig();
            int n = poolConfig.getMaxCount();
            int n2 = poolConfig.getShare();
            int n3 = poolConfig.getAttempt();
            int n4 = poolConfig.getInterval();
            int n5 = n4 * n3;
            int n6 = n3;
            while (--n6 >= 0) {
                try {
                    this.class$ = DriverManager.getConnection(poolConfig.getURL(), this.I, this.close);
                    if (this.QOIV()) {
                        ++this.QOIV;
                        sQLException = null;
                        break;
                    }
                }
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                }
                if (n4 <= 0) continue;
                try {
                    this.wait(n5);
                    n5 -= n4;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.append = System.currentTimeMillis();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized boolean QOIV() {
        boolean bl = true;
        return bl;
    }

    synchronized void append() {
        if (this.QOIV > 0 && --this.QOIV == 0) {
            this.append = System.currentTimeMillis();
        }
        if (commit.isDebugEnabled()) {
            commit.debug("reduce share connection\nshare count is " + this.QOIV);
        }
    }

    public void clearWarnings() throws SQLException {
        SQLWarning sQLWarning = this.class$.getWarnings();
        while (sQLWarning != null) {
            sQLWarning = sQLWarning.getNextWarning();
        }
        this.class$.clearWarnings();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConnectionInfo) {
            ConnectionInfo connectionInfo = (ConnectionInfo)object;
            return connectionInfo.class$.equals(this.class$) && connectionInfo.I.equals(this.I);
        }
        return false;
    }

    protected void finalize() {
        block2: {
            try {
                this.Z();
            }
            catch (SQLException sQLException) {
                if (!commit.isErrorEnabled()) break block2;
                commit.error("", sQLException);
            }
        }
    }

    void Z() throws SQLException {
        SQLException sQLException = null;
        if (this.class$ != null) {
            try {
                if (!this.class$.getAutoCommit()) {
                    this.class$.commit();
                }
                this.class$.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.clearWarnings = null;
            this.QOIV = 0;
        }
        this.class$ = null;
        if (createStatement.isDebugEnabled()) {
            createStatement.debug("disconnect connection H:[" + this.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] ShareCount[" + this.getLockNumber() + "]", new CallTrace());
            createStatement.debug("disconnect connection\nshare count is " + this.QOIV);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.class$.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.class$.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.class$.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLException {
        return this.class$.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.class$.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.class$.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.class$.commit();
    }

    public void rollback() throws SQLException {
        this.class$.rollback();
    }

    public void close() throws SQLException {
        if (createStatement.isDebugEnabled()) {
            createStatement.debug("close connection H:[" + this.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "]", new CallTrace());
        }
        this.append();
        if (this.class$ == null) {
            return;
        }
        if (this.clearWarnings.I.getIdleExpire() == 0) {
            this.clearWarnings.I(this.hashCode());
        }
    }

    public boolean isClosed() throws SQLException {
        return this.class$.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.class$.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.class$.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.class$.isReadOnly();
    }

    public String getCatalog() throws SQLException {
        return this.class$.getCatalog();
    }

    public void setCatalog(String string) throws SQLException {
        this.class$.setCatalog(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.class$.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.class$.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.class$.getWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.class$.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.class$.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.class$.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return this.class$.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.class$.setTypeMap(map);
    }

    public void setHoldability(int n) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    void I(Writer writer) throws IOException {
        writer.write("\t\tshare count is " + this.QOIV + "\r\n");
        writer.write("\t\t" + (this.QOIV == 0 ? "idle time is " : "last get time is ") + (System.currentTimeMillis() - this.append) + "ms\r\n");
        writer.write("\t\tconnection: " + this.class$ + "\r\n");
    }

    public String getPassword() {
        return this.close;
    }

    public JetUJdbcSupportInfo getSupportInfo() {
        return this.clearWarnings.Z();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

