/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import jet.ReportEnv;
import jet.log.JRLogger;
import toolkit.config.ConnectionPoolConfig;
import toolkit.config.PoolConfig;
import toolkit.db.version2.BeaDataSource;
import toolkit.db.version2.JdbcDataSource;

public class PoolService {
    ConnectionPoolConfig QOIV;
    JdbcDataSource append;
    BeaDataSource binPath;
    public static final String BEAURLPREFIX = "jdbc:weblogic:jinfonet:";
    public static final String BEAPOOLDRIVER = "weblogic.jinfonet.pool.Driver";
    private static JRLogger charAt = JRLogger.getLogger((class$toolkit$db$version2$PoolService == null ? (class$toolkit$db$version2$PoolService = PoolService.class$("toolkit.db.version2.PoolService")) : class$toolkit$db$version2$PoolService).getName());
    static Class class$toolkit$db$version2$PoolService;

    public PoolService() {
        String string = ReportEnv.binPath + "ConnectionPoolConfig.properties";
        this.QOIV = new ConnectionPoolConfig();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            this.QOIV.createConfig(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.append = new JdbcDataSource(this);
        this.append.start();
    }

    public Connection getConnection(String string, String string2, String string3, String string4, String string5) throws SQLException, ClassNotFoundException {
        if (charAt.isDebugEnabled()) {
            charAt.debug("get connection\ndriver name: " + string + ", url: " + string2 + ", use name: " + string3);
        }
        if (this.QOIV(string)) {
            if (!this.append()) {
                throw new SQLException("this version of JVM doesn't support the access to weblogic's DataSource, try jdk1.3.1 or higher verion");
            }
            if (this.binPath == null) {
                try {
                    this.binPath = new BeaDataSource();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (charAt.isErrorEnabled()) {
                        charAt.error("Connection Pool message\n", noClassDefFoundError);
                    }
                    throw new SQLException("can't get connection: please add weblogic.jar to classpath");
                }
            }
            return this.binPath.getConnection(string2, string3, string4);
        }
        return this.append.I(string, string2, string3, string4, string5);
    }

    public void disconnect(String string, String string2) throws SQLException {
        this.append.I(string, string2);
    }

    public void disconnect(String string) throws SQLException {
        this.append.I(string);
    }

    public void disconnect(int n) throws SQLException {
        this.append.I(n);
    }

    public ConnectionPoolConfig getConnectionPoolConfig() {
        return this.QOIV;
    }

    public PoolConfig getPoolConfig(String string) {
        return this.QOIV.getConfig(string);
    }

    public JdbcDataSource getJdbcDataSource() {
        return this.append;
    }

    public BeaDataSource getBeaDataSource() {
        return this.binPath;
    }

    public void dump(Writer writer) throws IOException {
        writer.write("dump connection pool:\r\n");
        this.append.I(writer);
        writer.write("end dump\r\n");
    }

    private boolean QOIV(String string) {
        return string == null ? false : string.equals(BEAPOOLDRIVER);
    }

    private boolean append() {
        String string = System.getProperty("java.vm.version");
        return string.charAt(2) > '2';
    }

    public void dispose() {
        try {
            this.append.Z();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void release() {
        try {
            this.append.I();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void destroy() {
        this.dispose();
        this.QOIV.dispose();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

