/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import com.jinfonet.awt.JFont;
import guitools.Painter;
import guitools.toolkit.RepaintImageListener;
import guitools.toolkit.TComponent;
import guitools.toolkit.TextCaret;
import guitools.toolkit.TextDoAction;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.ImageObserver;
import java.util.Stack;
import jet.log.JRLogger;

public class TextComp
extends TComponent
implements KeyListener,
FocusListener,
MouseListener,
MouseMotionListener,
RepaintImageListener {
    public static final int TOP = 0;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 2;
    private static final Insets actionPerformed = new Insets(3, 4, 3, 4);
    int add = 0;
    int addNotify = 1;
    boolean addRepaintImageListener;
    boolean adjustString;
    boolean append;
    String bottom = "";
    boolean charAt = true;
    boolean charWidth;
    int class$;
    int clipRect;
    char consume;
    String control;
    transient ActionListener controlDkShadow;
    protected transient TextListener textListener;
    boolean controlHighlight;
    int controlLtHighlight;
    int controlShadow;
    int copy;
    int createImage;
    FontMetrics cut;
    TextCaret delChar = new TextCaret((Component)((Object)this), 600L);
    Image delWord;
    Image dispose;
    static final Stack drawArea = new Stack();
    static final Stack drawImage = new Stack();
    static Clipboard drawLine = null;
    private static JRLogger drawRect = JRLogger.getLogger((String)(class$guitools$toolkit$TextComp == null ? (class$guitools$toolkit$TextComp = TextComp.class$("guitools.toolkit.TextComp")) : class$guitools$toolkit$TextComp).getName());
    boolean drawString = true;
    static Class class$guitools$toolkit$TextComp;

    public TextComp() {
        this("");
    }

    public TextComp(String string) {
        this.enableEvents(60L);
        this.bottom = string == null ? "" : string;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        super.reshape(n, n2, n3, n4);
        if (n3 != dimension.width && dimension.height != n4) {
            this.updateTextPos();
            this.updateCaretPos();
            this.updateBackImage();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.cut == null) {
            Font font = this.getFont();
            this.cut = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
        }
        if (this.tpb != null) {
            this.tpb.addRepaintImageListener((RepaintImageListener)this);
        }
    }

    public void removeNotify() {
        this.delChar.stop();
        super.removeNotify();
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.isShowing()) {
            this.cut = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
            this.updateTextPos();
        } else {
            this.cut = null;
        }
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public synchronized void setText(String string) {
        String string2 = string = string == null ? "" : string;
        if (!this.bottom.equals(string)) {
            int n;
            this.bottom = string;
            int n2 = string.length();
            int n3 = this.class$ > n2 ? n2 : this.class$;
            int n4 = n = this.clipRect > n2 ? n2 : this.clipRect;
            if (n3 != this.class$ || n != this.clipRect) {
                this.class$ = n3;
                this.clipRect = n;
                this.updateCaretPos();
            }
            this.processEvent(new TextEvent(this, 900));
            this.updateTextPos();
            this.repaint();
        }
    }

    public synchronized String getText() {
        return this.bottom;
    }

    public synchronized String getSelectedText() {
        int n = this.class$ < this.clipRect ? this.class$ : this.clipRect;
        int n2 = this.class$ > this.clipRect ? this.class$ : this.clipRect;
        String string = this.bottom.substring(n, n2);
        if (this.echoCharIsSet()) {
            String string2 = "";
            int n3 = 0;
            while (n3 < string.length()) {
                string2 = string2 + this.consume;
                ++n3;
            }
            string = string2;
        }
        return string;
    }

    public boolean isEditable() {
        return this.charAt;
    }

    public synchronized void setEditable(boolean bl) {
        this.charAt = bl;
    }

    public boolean isOvercast() {
        return this.charWidth;
    }

    public synchronized void setOvercast(boolean bl) {
        this.charWidth = bl;
    }

    public synchronized int getSelectionStart() {
        return this.class$;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.clipRect);
    }

    public synchronized int getSelectionEnd() {
        return this.clipRect;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.class$, n);
    }

    public synchronized void select(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.bottom.length();
        int n6 = n < 0 ? 0 : (n4 = n > n5 ? n5 : n);
        int n7 = n2 < 0 ? 0 : (n3 = n2 > n5 ? n5 : n2);
        if (n4 != this.class$ || n3 != this.clipRect) {
            boolean bl = this.class$ != this.clipRect;
            this.class$ = n4;
            this.clipRect = n3;
            if (!this.updateCaretPos() && (n4 != n3 || bl)) {
                this.repaint();
            }
        }
    }

    public synchronized void selectAll() {
        this.class$ = 0;
        this.clipRect = this.bottom.length();
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public void setCaretPosition(int n) {
        if (this.class$ != this.clipRect || this.class$ != n) {
            String string = this.addRepaintImageListener();
            if (n < 0) {
                Toolkit.getDefaultToolkit().beep();
                n = 0;
            }
            boolean bl = this.class$ != this.clipRect;
            int n2 = string.length();
            if (n > n2) {
                Toolkit.getDefaultToolkit().beep();
                n = n2;
            }
            this.class$ = n;
            this.clipRect = n;
            if (!this.updateCaretPos() && bl) {
                this.repaint();
            }
        }
    }

    public int getCaretPosition() {
        return this.clipRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.delChar.isAlive() && this.isVisible()) {
            this.delChar.setVisible(false);
            Dimension dimension = this.getSize();
            n = n < 0 ? 0 : n;
            n2 = n2 < 0 ? 0 : n2;
            n3 = (n3 += n) > dimension.width ? dimension.width - n : n3 - n;
            n4 = n4 > dimension.height ? dimension.height - n2 : (n4 += n2) - n2;
            this.editorPaint(n, n2, n3, n4);
            super.repaint(l, n, n2, n3, n4);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    if (this.dispose != null) {
                        graphics.clipRect(n, n2, n3, n4);
                        graphics.drawImage(this.dispose, 0, 0, (ImageObserver)((Object)this));
                    }
                    Object var10_8 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            if (this.isEnabled()) {
                this.delChar.setVisible(true);
            }
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            if (this.drawString) {
                this.updateTextPos();
            }
            if (this.delChar.isAlive() && !this.controlHighlight) {
                if (this.dispose != null) {
                    graphics.drawImage(this.dispose, 0, 0, (ImageObserver)((Object)this));
                }
            } else {
                Dimension dimension = this.getSize();
                if (this.hasEraser()) {
                    if (this.charAt && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
                }
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(1, 1, dimension.width - 2, 1);
                graphics.drawLine(1, 1, 1, dimension.height - 2);
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                if (!this.controlHighlight) {
                    this.drawText(graphics, dimension.width, dimension.height);
                }
            }
        }
    }

    protected void drawText(Graphics graphics, int n, int n2) {
        String string = this.addRepaintImageListener();
        int n3 = string.length();
        int n4 = this.cut.getMaxAscent();
        int n5 = this.delChar.isAlive() ? this.controlLtHighlight : this.copy;
        int n6 = this.delChar.isAlive() ? this.controlShadow : this.createImage;
        int n7 = this.cut.stringWidth(string);
        int n8 = n4 + this.cut.getMaxDescent();
        graphics.clipRect(TextComp.actionPerformed.left, TextComp.actionPerformed.top, n - TextComp.actionPerformed.left - TextComp.actionPerformed.right, n2 - TextComp.actionPerformed.top - TextComp.actionPerformed.bottom);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(string, n5, n6 + n4);
        if (this.addRepaintImageListener) {
            graphics.drawLine(n5, n6 + n8, n5 + n7, n6 + n8);
        }
        if (this.adjustString) {
            graphics.drawLine(n5, n6 + n4 * 2 / 3, n5 + n7, n6 + n4 * 2 / 3);
        }
        if (this.delChar.isAlive()) {
            int n9;
            int n10;
            int n11 = this.class$ == 0 ? this.controlLtHighlight : (n10 = this.class$ == n3 ? this.controlLtHighlight + n7 : this.controlLtHighlight + this.cut.stringWidth(string.substring(0, this.class$)));
            int n12 = this.clipRect == this.class$ ? n10 : (this.clipRect == 0 ? this.controlLtHighlight : (n9 = this.clipRect == n3 ? this.controlLtHighlight + n7 : this.controlLtHighlight + this.cut.stringWidth(string.substring(0, this.clipRect))));
            if (n10 != n9) {
                graphics.setXORMode(new Color(this.getBackground().getRGB()));
                graphics.setColor(this.getForeground());
                graphics.fillRect(n10 < n9 ? n10 : n9, n6, n10 < n9 ? n9 - n10 : n10 - n9, n8);
                graphics.setPaintMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editorPaint(int n, int n2, int n3, int n4) {
        if (this.dispose != null) {
            int n5 = this.dispose.getWidth((ImageObserver)((Object)this));
            int n6 = this.dispose.getHeight((ImageObserver)((Object)this));
            Graphics graphics = this.dispose.getGraphics();
            try {
                if (this.hasEraser()) {
                    if (this.charAt && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(0, 0, n5, n6);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(0, 0, n5 - 1, 0);
                    graphics.drawLine(0, 0, 0, n6 - 1);
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(1, 1, n5 - 2, 1);
                    graphics.drawLine(1, 1, 1, n6 - 2);
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 2);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
                    graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
                } else if (this.delWord != null) {
                    graphics.drawImage(this.delWord, 0, 0, (ImageObserver)((Object)this));
                }
                this.drawText(graphics, n5, n6);
                Object var9_8 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public void setAlignments(int n, int n2) {
        boolean bl = false;
        if (this.add != n && n >= 0 && n <= 2) {
            this.add = n;
            bl = true;
        }
        if (this.addNotify != n2 && n2 >= 0 && n2 <= 2) {
            this.addNotify = n2;
            bl = true;
        }
        if (bl) {
            this.updateTextPos();
            if (!this.updateCaretPos()) {
                this.repaint();
            }
        }
    }

    public int getHAlignment() {
        return this.add;
    }

    public int getVAlignment() {
        return this.addNotify;
    }

    public void setUnderline(boolean bl) {
        if (this.addRepaintImageListener != bl) {
            this.addRepaintImageListener = bl;
            this.repaint();
        }
    }

    public boolean getUnderline() {
        return this.addRepaintImageListener;
    }

    public void setStrikeout(boolean bl) {
        if (this.adjustString != bl) {
            this.adjustString = bl;
            this.repaint();
        }
    }

    public boolean getStrikeout() {
        return this.adjustString;
    }

    public void setWordwrap(boolean bl) {
        if (this.append != bl) {
            this.append = bl;
            this.repaint();
        }
    }

    public boolean getWordwrap() {
        return this.append;
    }

    public void beforeDrawImage() {
        if (this.delChar.isAlive()) {
            this.delChar.suspend();
            this.delChar.I = false;
        }
    }

    public void afterDrawImage() {
        if (this.delChar.isAlive()) {
            this.delChar.resume();
        }
    }

    public void clearStacks() {
        drawArea.removeAllElements();
        drawImage.removeAllElements();
    }

    public boolean isEmptyUndo() {
        return drawArea.isEmpty();
    }

    public boolean isEmptyRedo() {
        return drawImage.isEmpty();
    }

    public void undo() {
        if (!drawArea.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)drawArea.pop();
            switch (textDoAction.I) {
                case 0: {
                    drawImage.push(this.add(textDoAction));
                    break;
                }
                case 1: {
                    drawImage.push(this.QOIV(textDoAction));
                    break;
                }
                case 2: {
                    drawImage.push(this.actionPerformed(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        if (!drawImage.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)drawImage.pop();
            switch (textDoAction.I) {
                case 0: {
                    drawArea.push(this.add(textDoAction));
                    break;
                }
                case 1: {
                    drawArea.push(this.QOIV(textDoAction));
                    break;
                }
                case 2: {
                    drawArea.push(this.actionPerformed(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void cut() {
        if (this.class$ != this.clipRect) {
            int n = this.class$ < this.clipRect ? this.class$ : this.clipRect;
            int n2 = this.class$ > this.clipRect ? this.class$ : this.clipRect;
            String string = this.bottom.substring(n, n2);
            if (drawLine != null) {
                drawLine.setContents(new StringSelection(string), null);
            }
            this.pushUndo(this.QOIV(new TextDoAction(1, n, n2, string)));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void copy() {
        if (this.class$ != this.clipRect && drawLine != null) {
            drawLine.setContents(new StringSelection(this.getSelectedText()), null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void paste() {
        Transferable transferable;
        if (drawLine != null && (transferable = drawLine.getContents(null)) != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insert(Painter.adjustString((String)string));
            }
            catch (Exception exception) {
                if (drawRect.isErrorEnabled()) {
                    drawRect.error((Object)"", (Throwable)exception);
                }
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
    }

    public void setActionCommand(String string) {
        this.control = string;
    }

    public String getActionCommand() {
        return this.control == null ? this.bottom : this.control;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.controlDkShadow = AWTEventMulticaster.add(this.controlDkShadow, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.controlDkShadow = AWTEventMulticaster.remove(this.controlDkShadow, actionListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.controlDkShadow != null) {
            this.controlDkShadow.actionPerformed(actionEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.textListener != null) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = keyEvent.getID();
        if (n == 400) {
            this.keyTyped(keyEvent);
        } else if (n == 401) {
            this.keyPressed(keyEvent);
        } else if (n == 402) {
            this.keyReleased(keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.delChar.isAlive()) {
                    this.requestFocus();
                }
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 504: {
                this.setCursor(Cursor.getPredefinedCursor(2));
                break;
            }
            case 505: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            this.mouseDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.delChar.isAlive()) {
            this.delChar.suspend();
            this.setCaretPosition(this.getPos(mouseEvent.getX()));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isPopupTrigger() && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.delChar.isAlive()) {
            int n = this.getPos(mouseEvent.getX());
            if (mouseEvent.getClickCount() > 1 && this.bottom.length() > 0) {
                char c = this.bottom.charAt(n = n == this.bottom.length() ? --n : n);
                if (Character.isLetterOrDigit(c)) {
                    this.select(this.getPrevWord(n), this.getNextWord(n));
                } else if (Character.isSpaceChar(c)) {
                    this.select(this.class$, n);
                } else {
                    this.select(n, n + 1);
                }
            } else {
                this.select(this.class$, n);
            }
            this.delChar.resume();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.select(this.class$, this.getPos(mouseEvent.getX()));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        block34: {
            int n;
            char c;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block33: {
                if (!this.isEnabled()) {
                    return;
                }
                this.delChar.suspend();
                bl4 = keyEvent.isAltDown();
                bl3 = keyEvent.isShiftDown();
                bl2 = keyEvent.isControlDown();
                c = keyEvent.getKeyChar();
                n = keyEvent.getKeyCode();
                bl = true;
                if (!keyEvent.isActionKey() || bl4) break block33;
                switch (n) {
                    case 36: {
                        if (bl3) {
                            this.select(0, this.clipRect);
                            break;
                        }
                        this.setCaretPosition(0);
                        break;
                    }
                    case 35: {
                        int n2 = this.bottom.length();
                        if (bl3) {
                            this.select(this.class$, n2);
                            break;
                        }
                        this.setCaretPosition(n2);
                        break;
                    }
                    case 37: {
                        if (bl3 && bl2) {
                            this.select(this.class$, this.movePrevWord(this.clipRect - 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.class$, this.clipRect - 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.movePrevWord(this.clipRect - 1));
                            break;
                        }
                        int n3 = this.class$ < this.clipRect ? this.class$ : (this.class$ > this.clipRect ? this.clipRect : this.class$ - 1);
                        this.setCaretPosition(n3);
                        break;
                    }
                    case 39: {
                        if (bl3 && bl2) {
                            this.select(this.class$, this.moveNextWord(this.clipRect + 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.class$, this.clipRect + 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.moveNextWord(this.clipRect + 1));
                            break;
                        }
                        int n4 = this.class$ < this.clipRect ? this.clipRect : (this.class$ > this.clipRect ? this.class$ : this.clipRect + 1);
                        this.setCaretPosition(n4);
                        break;
                    }
                    case 155: {
                        if (this.charAt) {
                            this.setOvercast(!this.charWidth);
                            break;
                        }
                        break block34;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                break block34;
            }
            if (Character.isISOControl(c) && bl2 && (n == 67 || n == 99) && !bl4 && !bl3) {
                this.copy();
            } else if (this.charAt && Character.isISOControl(c)) {
                switch (n) {
                    case 8: {
                        if (bl4 && !bl3 && !bl2) {
                            this.undo();
                            break;
                        }
                        if (bl2) {
                            this.delWord(true);
                            break;
                        }
                        this.delChar(true);
                        break;
                    }
                    case 86: 
                    case 118: {
                        if (bl4 || bl3 || !bl2) break;
                        this.paste();
                        break;
                    }
                    case 88: 
                    case 120: {
                        if (bl4 || bl3 || !bl2) break;
                        this.cut();
                        break;
                    }
                    case 89: 
                    case 121: {
                        if (bl4 || bl3 || !bl2) break;
                        this.redo();
                        break;
                    }
                    case 90: 
                    case 122: {
                        if (bl4 || bl3 || !bl2) break;
                        this.undo();
                        break;
                    }
                    case 127: {
                        if (!bl4 && !bl3 && bl2) {
                            this.delWord(false);
                            break;
                        }
                        if (bl4 || bl3 || bl2) break;
                        this.delChar(false);
                        break;
                    }
                    case 10: {
                        if (bl4 || bl3 || bl2) break;
                        this.processEvent(new ActionEvent(this, 1001, this.getActionCommand(), keyEvent.getModifiers()));
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
        }
        this.delChar.resume();
        if (bl) {
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.charAt && !Character.isISOControl(c)) {
            this.insert("" + c);
            this.processEvent(new TextEvent(this, 900));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.charAt) {
            this.delChar.resume();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackImage() {
        Dimension dimension = this.getSize();
        if (this.delChar.isAlive() && dimension.width > 0 && dimension.height > 0) {
            this.delChar.setVisible(false);
            if (!this.hasEraser()) {
                this.delWord = this.createImage(dimension.width, dimension.height);
                if (this.delWord != null) {
                    Graphics graphics = this.delWord.getGraphics();
                    try {
                        this.controlHighlight = true;
                        this.tpb.drawArea(graphics, this.mapBoundsToBoard());
                        this.controlHighlight = false;
                        graphics.setColor(this.getForeground());
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                        Object var4_3 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        graphics.dispose();
                        throw throwable;
                    }
                }
            }
            if (this.dispose == null || this.dispose.getWidth((ImageObserver)((Object)this)) != dimension.width || this.dispose.getHeight((ImageObserver)((Object)this)) != dimension.height) {
                this.dispose = this.createImage(dimension.width, dimension.height);
            }
            this.repaint();
            this.repaintImage();
            this.delChar.setVisible(true);
        }
    }

    public void setEditor(boolean bl) {
        if (bl) {
            if (!this.delChar.isAlive()) {
                this.delChar.start();
                this.updateBackImage();
                this.updateCaretPos();
            }
        } else if (this.delChar.isAlive()) {
            this.delChar.stop();
            this.delWord = null;
            this.dispose = null;
            this.repaint();
        }
    }

    public boolean isEditor() {
        return this.delChar.isAlive();
    }

    protected void updateTextPos() {
        if (this.cut != null) {
            Dimension dimension = this.getSize();
            String string = this.addRepaintImageListener();
            int n = this.cut.stringWidth(string);
            int n2 = this.cut.getMaxAscent() + this.cut.getMaxDescent();
            if (this.add == 0) {
                this.copy = TextComp.actionPerformed.left;
            } else if (this.add == 1) {
                this.copy = (dimension.width - n) / 2;
            } else if (this.add == 2) {
                this.copy = dimension.width - n - TextComp.actionPerformed.right;
            }
            if (this.addNotify == 0) {
                this.createImage = TextComp.actionPerformed.top;
            } else if (this.addNotify == 1) {
                this.createImage = (dimension.height - n2) / 2;
            } else if (this.addNotify == 2) {
                this.createImage = dimension.height - n2 - TextComp.actionPerformed.bottom;
            }
            this.controlLtHighlight = this.copy;
            this.controlShadow = this.createImage;
            this.drawString = false;
        }
    }

    protected boolean updateCaretPos() {
        if (this.cut != null) {
            int n = this.controlLtHighlight;
            Dimension dimension = this.getSize();
            String string = this.addRepaintImageListener();
            int n2 = this.cut.stringWidth(string);
            if (n2 < dimension.width - 4) {
                this.updateTextPos();
            }
            int n3 = this.clipRect == 0 ? 0 : (this.clipRect == string.length() ? n2 : this.cut.stringWidth(string.substring(0, this.clipRect)));
            int n4 = this.controlLtHighlight + n3;
            n4 = n4 < 2 ? 2 : (n4 > dimension.width - 3 ? dimension.width - 3 : n4);
            this.controlLtHighlight = n4 - n3;
            this.delChar.setBounds(n4, this.controlShadow, 2, this.cut.getHeight());
            if (n != this.controlLtHighlight) {
                this.repaint();
                return true;
            }
        }
        return false;
    }

    protected int getPos(int n) {
        int n2;
        int n3 = this.getSize().width - 3;
        int n4 = this.bottom.length();
        int n5 = this.cut.stringWidth(this.bottom);
        if (n <= this.controlLtHighlight) {
            n2 = 0;
        } else if (n > this.controlLtHighlight + n5) {
            n2 = n4;
        } else {
            int n6;
            int n7 = 0;
            while ((n6 = this.controlLtHighlight + this.cut.stringWidth(this.bottom.substring(0, n2 = (n7 + n4) / 2))) != n) {
                if (n6 > n) {
                    n4 = n2;
                } else if (n6 < n) {
                    n7 = n2 + 1;
                }
                if (n7 != n4) continue;
            }
            if (n7 == n4) {
                int n8 = this.cut.charWidth(this.bottom.charAt(n2));
                n2 = n6 < n ? (n - n6 > n8 / 2 ? n2 + 1 : n2) : (n6 > n ? (n6 - n > n8 / 2 && n2 > 0 ? n2 - 1 : n2) : n2);
            }
        }
        return n2;
    }

    protected void delChar(boolean bl) {
        int n;
        int n2;
        if (this.class$ != this.clipRect) {
            n2 = this.class$ < this.clipRect ? this.class$ : this.clipRect;
            n = this.class$ > this.clipRect ? this.class$ : this.clipRect;
        } else {
            int n3 = this.bottom.length();
            if (bl && this.class$ == 0 && this.clipRect == 0 || !bl && this.class$ == n3 && this.clipRect == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.clipRect - (bl ? 1 : 0);
            n = this.clipRect + (bl ? 0 : 1);
        }
        this.pushUndo(this.QOIV(new TextDoAction(1, n2, n, this.bottom.substring(n2, n))));
    }

    protected void delWord(boolean bl) {
        int n;
        int n2;
        if (this.class$ != this.clipRect) {
            n2 = this.class$ < this.clipRect ? this.class$ : this.clipRect;
            n = this.class$ > this.clipRect ? this.class$ : this.clipRect;
        } else {
            int n3 = this.bottom.length();
            if (bl && this.class$ == 0 && this.clipRect == 0 || !bl && this.class$ == n3 && this.clipRect == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.clipRect - (bl ? 1 : 0);
            n = this.clipRect + (bl ? 0 : 1);
        }
        n2 = bl ? this.getPrevWord(n2) : n2;
        n = bl ? n : this.getNextWord(n);
        this.pushUndo(this.QOIV(new TextDoAction(1, n2, n, this.bottom.substring(n2, n))));
    }

    protected void insert(String string) {
        if (this.class$ != this.clipRect) {
            int n = this.class$ < this.clipRect ? this.class$ : this.clipRect;
            int n2 = this.class$ > this.clipRect ? this.class$ : this.clipRect;
            this.pushUndo(this.actionPerformed(new TextDoAction(2, n, n2, string)));
        } else if (this.charWidth && this.clipRect < this.bottom.length()) {
            this.pushUndo(this.actionPerformed(new TextDoAction(2, this.clipRect, this.clipRect + string.length(), string)));
        } else {
            this.pushUndo(this.add(new TextDoAction(0, this.clipRect, this.clipRect + string.length(), string)));
        }
    }

    TextDoAction QOIV(TextDoAction textDoAction) {
        textDoAction.I = 0;
        this.bottom = this.bottom.substring(0, textDoAction.Z) + this.bottom.substring(textDoAction.C, this.bottom.length());
        this.clipRect = this.class$ = textDoAction.Z;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction actionPerformed(TextDoAction textDoAction) {
        String string = this.bottom.substring(textDoAction.Z, textDoAction.C);
        this.bottom = this.bottom.substring(0, textDoAction.Z) + textDoAction.B + this.bottom.substring(textDoAction.C, this.bottom.length());
        this.clipRect = this.class$ = textDoAction.Z + textDoAction.B.length();
        textDoAction.C = this.class$;
        textDoAction.B = string;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction add(TextDoAction textDoAction) {
        textDoAction.I = 1;
        this.bottom = this.bottom.substring(0, textDoAction.Z) + textDoAction.B + this.bottom.substring(textDoAction.Z, this.bottom.length());
        this.clipRect = this.class$ = textDoAction.Z + textDoAction.B.length();
        textDoAction.C = this.class$;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    protected void pushUndo(TextDoAction textDoAction) {
        drawArea.push(textDoAction);
        drawImage.removeAllElements();
        this.processEvent(new TextEvent(this, 900));
    }

    protected int getPrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.bottom.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    protected int getNextWord(int n) {
        int n2;
        int n3 = 0;
        if ((n = this.skipNextSpaceChar(n)) < (n2 = this.bottom.length())) {
            char[] cArray = this.bottom.substring(n).toCharArray();
            n2 = cArray.length;
            if (Character.isLetterOrDigit(cArray[n3])) {
                while (n3 < n2) {
                    if (!Character.isLetterOrDigit(cArray[n3])) {
                        return n3 + n;
                    }
                    ++n3;
                }
            }
        }
        return n3 + n;
    }

    protected int movePrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.bottom.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            } else {
                --n;
                while (n >= 0) {
                    if (Character.isLetterOrDigit(cArray[n]) || Character.isSpaceChar(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    /*
     * Unable to fully structure code
     */
    protected int moveNextWord(int var1_1) {
        block4: {
            var3_2 = 0;
            if ((var1_1 = this.skipNextSpaceChar(var1_1)) >= (var4_3 = this.bottom.length())) break block4;
            var2_4 = this.bottom.substring(var1_1).toCharArray();
            var4_3 = var2_4.length;
            if (!Character.isLetterOrDigit(var2_4[var3_2])) ** GOTO lbl15
            while (var3_2 < var4_3) {
                if (!Character.isLetterOrDigit(var2_4[var3_2])) {
                    return var3_2 + var1_1;
                }
                ++var3_2;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (Character.isLetterOrDigit(var2_4[var3_2]) || Character.isSpaceChar(var2_4[var3_2])) {
                    return var3_2 + var1_1;
                }
                ++var3_2;
lbl15:
                // 2 sources

                ** while (var3_2 < var4_3)
            }
        }
        return var3_2 + var1_1;
    }

    protected int skipPrevSpaceChar(int n) {
        if (n > 0 && Character.isSpaceChar(this.bottom.charAt(n))) {
            --n;
            while (n >= 0) {
                if (!Character.isSpaceChar(this.bottom.charAt(n))) {
                    return ++n;
                }
                --n;
            }
        }
        return n < 0 ? 0 : n;
    }

    protected int skipNextSpaceChar(int n) {
        int n2 = this.bottom.length();
        if (n < n2 && Character.isSpaceChar(this.bottom.charAt(n))) {
            while (n < n2) {
                if (!Character.isSpaceChar(this.bottom.charAt(n))) {
                    return n;
                }
                ++n;
            }
        }
        return n;
    }

    protected String paramString() {
        String string = super.paramString() + ",text=" + this.bottom;
        if (this.charAt) {
            string = string + ",editable=" + this.charAt;
        }
        if (this.charWidth) {
            string = string + ",overcast=" + this.charWidth;
        }
        return string + ",selection=" + this.class$ + "-" + this.clipRect;
    }

    public char getEchoChar() {
        return this.consume;
    }

    public synchronized void setEchoChar(char c) {
        this.consume = c;
    }

    public boolean echoCharIsSet() {
        return this.consume != '\u0000';
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.delChar.stop();
        }
        super.setEnabled(bl);
        this.repaint();
    }

    private String addRepaintImageListener() {
        String string = this.bottom;
        if (this.consume != '\u0000') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < string.length()) {
                stringBuffer.setCharAt(n, this.consume);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            drawLine = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable throwable) {
            drawLine = null;
        }
    }
}

