/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageBars;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Graph2DGuageBar {
    Graph2DGuageBars QOIV;
    ChartLabelBase abs;
    float axisY;
    float dataset;
    float draw = 0.0f;
    float drawAxis = 0.0f;
    float fill = 0.0f;
    float fillBackPattern = 0.0f;
    float fillTempPattern;
    float fillValuePattern = 0.0f;
    int getAxisPen = 0;
    float getAxisXProperties = 0.0f;
    float getAxisY = 0.0f;
    float[][] getAxisYProperties;
    float[][][] getContourPen;
    Shape[] getDimension;
    float getGaugeAlertColor = 0.0f;
    Line2D getGaugeBarLayout = null;

    public Graph2DGuageBar(Graph2DGuageBars graph2DGuageBars, int n) {
        this.QOIV = graph2DGuageBars;
        this.getAxisPen = n;
    }

    public void locate() {
        float f = 0.25f;
        float f2 = 0.1f;
        float f3 = 0.3f;
        float f4 = 0.05f;
        float f5 = 0.3f;
        switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.drawAxis = this.QOIV.C * f;
                this.fillBackPattern = this.QOIV.C * f2;
                this.fillValuePattern = this.QOIV.C * f3;
                this.getGaugeAlertColor = this.QOIV.C * f4;
                this.getAxisY = this.QOIV.C * f5;
                this.draw = this.QOIV.Z;
                this.fill = this.QOIV.Z;
                this.fillTempPattern = this.QOIV.Z;
                this.getAxisXProperties = this.QOIV.Z;
                break;
            }
            case 1: {
                this.draw = this.QOIV.Z * f;
                this.fill = this.QOIV.Z * f2;
                this.fillTempPattern = this.QOIV.Z * f3;
                this.getGaugeAlertColor = this.QOIV.Z * f4;
                this.getAxisXProperties = this.QOIV.Z * f5;
                this.drawAxis = this.QOIV.C;
                this.fillBackPattern = this.QOIV.C;
                this.fillValuePattern = this.QOIV.C;
                this.getAxisY = this.QOIV.C;
            }
        }
        this.getDimension = new Shape[this.QOIV.I];
        int n = 0;
        while (n < this.QOIV.I) {
            this.getDimension[n] = new GeneralPath();
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.QOIV.getPaper().getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.getAxisPen(graphics2D);
        }
        switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarStyle()) {
            case 0: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, true);
                break;
            }
            case 1: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, false);
                break;
            }
            case 2: {
                this.fillBackPattern(graphics2D);
                break;
            }
        }
        if (this.QOIV.getPaper().getProperties().isShowAxisY()) {
            this.drawAxis(graphics2D);
        }
        this.getAxisXProperties(graphics2D);
    }

    public void drawAxis(Graphics2D graphics2D) {
        this.getGaugeBarLayout = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.dataset + this.drawAxis + this.fillBackPattern + this.fillValuePattern + this.getGaugeAlertColor;
                f3 = this.axisY + this.fillTempPattern;
                f4 = f2;
                break;
            }
            case 1: {
                f = this.axisY + this.draw + this.fill + this.fillTempPattern + this.getGaugeAlertColor;
                f2 = this.dataset;
                f3 = f;
                f4 = this.dataset + this.fillValuePattern;
            }
        }
        this.getGaugeBarLayout.setLine(f, f2, f3, f4);
        this.QOIV.getPaper().getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, this.getGaugeBarLayout);
        this.axisY(graphics2D);
        if (this.QOIV.getPaper().getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.fill(graphics2D);
        }
    }

    private void QOIV(float[][] fArray2, float[][][] fArray3) {
        int n = ((ChartNumericAxis)this.QOIV.layer.getAxisY()).getNumOfTick();
        float f = this.fillTempPattern / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.axisY;
        float f4 = this.dataset + this.drawAxis + this.fillBackPattern + this.fillValuePattern + this.getGaugeAlertColor;
        int n2 = 0;
        while (n2 <= n) {
            fArray2[n2][0] = f3 + (float)n2 * f;
            fArray2[n2][1] = f4;
            if (n2 != n) {
                int n3 = 0;
                while (n3 < 4) {
                    fArray3[n2][n3][0] = fArray2[n2][0] + (float)n3 * f2;
                    fArray3[n2][n3][1] = fArray2[n2][1];
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void abs(float[][] fArray2, float[][][] fArray3) {
        int n = ((ChartNumericAxis)this.QOIV.layer.getAxisY()).getNumOfTick();
        float f = this.fillValuePattern / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.axisY + this.draw + this.fill + this.fillTempPattern + this.getGaugeAlertColor;
        float f4 = this.dataset;
        int n2 = 0;
        while (n2 <= n) {
            fArray2[n2][0] = f3;
            fArray2[n2][1] = f4 + (float)n2 * f;
            if (n2 != n) {
                int n3 = 0;
                while (n3 < 4) {
                    fArray3[n2][n3][0] = f3;
                    fArray3[n2][n3][1] = fArray2[n2][1] + (float)n3 * f2;
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void axisY(Graphics2D graphics2D) {
        int n = ((ChartNumericAxis)this.QOIV.layer.getAxisY()).getNumOfTick();
        this.getAxisYProperties = new float[n + 1][2];
        this.getContourPen = new float[n][4][2];
        int n2 = this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        ChartPenStyle chartPenStyle = this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkPen();
        int n3 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        int n4 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getMinorTickMarkLength();
        int n5 = this.QOIV.getPaper().getProperties().getAxisYProperties().getMinorTickMarkType();
        switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.QOIV(this.getAxisYProperties, this.getContourPen);
                this.dataset(graphics2D, this.getAxisYProperties, n2, chartPenStyle, n3);
                int n6 = 0;
                while (n6 < n) {
                    this.dataset(graphics2D, this.getContourPen[n6], n5, chartPenStyle, n4);
                    ++n6;
                }
                break;
            }
            case 1: {
                this.abs(this.getAxisYProperties, this.getContourPen);
                this.draw(graphics2D, this.getAxisYProperties, n2, chartPenStyle, n3);
                int n7 = 0;
                while (n7 < n) {
                    this.draw(graphics2D, this.getContourPen[n7], n5, chartPenStyle, n4);
                    ++n7;
                }
                break;
            }
        }
    }

    private void dataset(Graphics2D graphics2D, float[][] fArray2, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray2.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n4 = 0;
        while (n4 < n3) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray2[n4][0];
                    f2 = fArray2[n4][1];
                    f3 = fArray2[n4][0];
                    f4 = fArray2[n4][1] - (float)n2;
                    break;
                }
                case 1: {
                    f = fArray2[n4][0];
                    f2 = fArray2[n4][1];
                    f3 = fArray2[n4][0];
                    f4 = fArray2[n4][1] + (float)n2;
                    break;
                }
                case 3: {
                    f = fArray2[n4][0];
                    f2 = fArray2[n4][1] - (float)n2;
                    f3 = fArray2[n4][0];
                    f4 = fArray2[n4][1] + (float)n2;
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
            ++n4;
        }
    }

    private void draw(Graphics2D graphics2D, float[][] fArray2, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray2.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n4 = 0;
        while (n4 < n3) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray2[n4][0];
                    f2 = fArray2[n4][1];
                    f3 = fArray2[n4][0] - (float)n2;
                    f4 = fArray2[n4][1];
                    break;
                }
                case 1: {
                    f = fArray2[n4][0];
                    f2 = fArray2[n4][1];
                    f3 = fArray2[n4][0] + (float)n2;
                    f4 = fArray2[n4][1];
                    break;
                }
                case 3: {
                    f = fArray2[n4][0] - (float)n2;
                    f2 = fArray2[n4][1];
                    f3 = fArray2[n4][0] + (float)n2;
                    f4 = fArray2[n4][1];
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
            ++n4;
        }
    }

    private void fill(Graphics2D graphics2D) {
        String[] stringArray = ((ChartNumericAxis)this.QOIV.layer.axisY).getLabels();
        int n = stringArray.length;
        ChartTextStyle chartTextStyle = this.QOIV.getPaper().getProperties().getAxisYProperties().getLabelTextStyle();
        float f = 0.0f;
        float f2 = 0.0f;
        float[][] fArray2 = new float[n][2];
        switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.fillBackPattern(graphics2D, this.getAxisYProperties, chartTextStyle, fArray2, stringArray);
                break;
            }
            case 1: {
                this.fillTempPattern(graphics2D, this.getAxisYProperties, chartTextStyle, fArray2, stringArray);
            }
        }
        this.fillValuePattern(graphics2D, chartTextStyle, fArray2, stringArray);
    }

    private void fillBackPattern(Graphics2D graphics2D, float[][] fArray2, ChartTextStyle chartTextStyle, float[][] fArray3, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        int n5 = 0;
        while (n5 < n) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[n5]);
            fArray3[n5][0] = (float)((double)fArray2[n5][0] - rectangle2D.getWidth() / 2.0);
            fArray3[n5][1] = fArray2[n5][1] + (float)n3 + (float)n4;
            ++n5;
        }
    }

    private void fillTempPattern(Graphics2D graphics2D, float[][] fArray2, ChartTextStyle chartTextStyle, float[][] fArray3, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.QOIV.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        int n5 = 0;
        while (n5 < n) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[n5]);
            fArray3[n5][0] = fArray2[n5][0] + (float)n3 + (float)n4;
            fArray3[n5][1] = (float)((double)fArray2[n5][1] - rectangle2D.getHeight() / 2.0);
            ++n5;
        }
    }

    private void fillValuePattern(Graphics2D graphics2D, ChartTextStyle chartTextStyle, float[][] fArray2, String[] stringArray) {
        int n = stringArray.length;
        switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                int n2 = 0;
                while (n2 < n) {
                    ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[n2]);
                    chartLabelBase.setChartTextStyle(chartTextStyle);
                    chartLabelBase.paint(graphics2D, fArray2[n2][0], fArray2[n2][1]);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[n - n3 - 1]);
                    chartLabelBase.setChartTextStyle(chartTextStyle);
                    chartLabelBase.paint(graphics2D, fArray2[n3][0], fArray2[n3][1]);
                    ++n3;
                }
                break;
            }
        }
    }

    private void getAxisPen(Graphics2D graphics2D) {
        if (this.abs != null) {
            Rectangle2D rectangle2D = this.QOIV.getPaper().getProperties().getAxisXProperties().getLabelTextStyle().getDimension(graphics2D, this.abs.getLabelText());
            this.draw = (float)rectangle2D.getWidth();
            this.drawAxis = (float)rectangle2D.getHeight();
            if (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout() == 1) {
                this.draw = (float)rectangle2D.getHeight();
                this.drawAxis = (float)rectangle2D.getWidth();
            }
            float f = 0.0f;
            float f2 = 0.0f;
            switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
                case 0: {
                    f = this.axisY + (this.QOIV.Z - this.draw) / 2.0f;
                    f2 = this.dataset;
                    this.abs.paint(graphics2D, f, f2);
                    break;
                }
                case 1: {
                    f = this.axisY;
                    f2 = this.dataset + (this.QOIV.C - this.drawAxis) / 2.0f;
                    graphics2D.rotate(1.5707963267948966, f, f2);
                    this.abs.paint(graphics2D, f, f2);
                    graphics2D.rotate(-1.5707963267948966, f, f2);
                }
            }
        }
    }

    private void getAxisXProperties(Graphics2D graphics2D) {
        switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.getAxisY(graphics2D);
                break;
            }
            case 1: {
                this.getAxisYProperties(graphics2D);
            }
        }
    }

    private void getAxisY(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray2 = new float[4][2];
        float f = this.axisY;
        float f2 = this.dataset + this.drawAxis + this.fillBackPattern + this.getGaugeAlertColor;
        int n = 0;
        while (n < this.QOIV.I) {
            if (((Chart1DDataSet)this.QOIV.dataset).getValue(n, this.getAxisPen) != null && !(this.QOIV.B[n][this.getAxisPen] > this.QOIV.S) && !(this.QOIV.B[n][this.getAxisPen] < this.QOIV.J)) {
                fArray2[0][0] = f + this.QOIV.Z * ((this.QOIV.B[n][this.getAxisPen] - this.QOIV.J) / (this.QOIV.S - this.QOIV.J));
                fArray2[0][1] = f2 + 12.0f;
                fArray2[1][0] = fArray2[0][0] - 6.0f;
                fArray2[1][1] = f2 + this.QOIV.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
                fArray2[2][0] = fArray2[1][0] + 12.0f;
                fArray2[2][1] = fArray2[1][1];
                fArray2[3][0] = fArray2[0][0];
                fArray2[3][1] = this.dataset + this.drawAxis + this.fillBackPattern + this.fillValuePattern + this.getGaugeAlertColor;
                ((GeneralPath)this.getDimension[n]).reset();
                ((GeneralPath)this.getDimension[n]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[1][0], fArray2[1][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[2][0], fArray2[2][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[0][0], fArray2[0][1]);
                if (this.QOIV.objectProperties.isContour()) {
                    this.QOIV.objectProperties.getContourPen().draw(graphics2D, this.getDimension[n]);
                }
                if (this.QOIV.getSeriesPattern()[n] != null) {
                    this.QOIV.getSeriesPattern()[n].fill(graphics2D, this.getDimension[n]);
                }
                generalPath.reset();
                generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
                generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
                if (this.QOIV.objectProperties.isContour()) {
                    this.QOIV.objectProperties.getContourPen().draw(graphics2D, generalPath);
                }
            }
            ++n;
        }
    }

    private void getAxisYProperties(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray2 = new float[4][2];
        float f = this.axisY + this.draw + this.fill + this.getGaugeAlertColor;
        float f2 = this.dataset;
        int n = 0;
        while (n < this.QOIV.I) {
            if (((Chart1DDataSet)this.QOIV.dataset).getValue(n, this.getAxisPen) != null && !(this.QOIV.B[n][this.getAxisPen] > this.QOIV.S) && !(this.QOIV.B[n][this.getAxisPen] < this.QOIV.J)) {
                fArray2[0][1] = f2 + this.QOIV.C * (1.0f - (this.QOIV.B[n][this.getAxisPen] - this.QOIV.J) / (this.QOIV.S - this.QOIV.J));
                fArray2[0][0] = f + 12.0f;
                fArray2[1][0] = f + this.QOIV.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
                fArray2[1][1] = fArray2[0][1] - 6.0f;
                fArray2[2][0] = fArray2[1][0];
                fArray2[2][1] = fArray2[1][1] + 12.0f;
                fArray2[3][0] = f + this.fillTempPattern;
                fArray2[3][1] = fArray2[0][1];
                ((GeneralPath)this.getDimension[n]).reset();
                ((GeneralPath)this.getDimension[n]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[1][0], fArray2[1][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[2][0], fArray2[2][1]);
                ((GeneralPath)this.getDimension[n]).lineTo(fArray2[0][0], fArray2[0][1]);
                if (this.QOIV.getSeriesPattern()[n] != null) {
                    this.QOIV.getSeriesPattern()[n].fill(graphics2D, this.getDimension[n]);
                }
                if (this.QOIV.objectProperties.isContour()) {
                    this.QOIV.objectProperties.getContourPen().draw(graphics2D, this.getDimension[n]);
                }
                generalPath.reset();
                generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
                generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
                if (this.QOIV.objectProperties.isContour()) {
                    this.QOIV.objectProperties.getContourPen().draw(graphics2D, generalPath);
                }
            }
            ++n;
        }
    }

    public void fillTempPattern(Graphics2D graphics2D) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.dataset + this.drawAxis + this.getGaugeAlertColor / 2.0f;
                break;
            }
            case 1: {
                f = this.axisY + this.draw + this.getGaugeAlertColor / 2.0f;
                f2 = this.dataset;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.fill, this.fillBackPattern);
        switch (this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.getContourPen(float_, graphics2D);
                break;
            }
            case 1: {
                this.getDimension(float_, graphics2D);
            }
        }
        this.QOIV.getPaper().getProperties().getGraphProperties().getGaugeBarPen().draw(graphics2D, float_);
    }

    private void getContourPen(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getHeight();
        float f4 = this.QOIV.F[0] == this.QOIV.F[1] ? 0.0f : (float)((double)(Math.abs(this.QOIV.F[1] - this.QOIV.F[0]) / (this.QOIV.S - this.QOIV.J)) * rectangle2D.getWidth());
        float f5 = f + f4;
        float f6 = f2;
        float f7 = (float)rectangle2D.getHeight();
        float f8 = (float)(rectangle2D.getWidth() - (double)f4);
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f4, f3);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeNormalColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeErrorColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_2);
    }

    private void getDimension(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = this.QOIV.F[0] == this.QOIV.F[1] ? 0.0f : (float)((double)(Math.abs(this.QOIV.F[1] - this.QOIV.F[0]) / (this.QOIV.S - this.QOIV.J)) * rectangle2D.getHeight());
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() - (double)f2);
        float f5 = (float)rectangle2D.getX();
        float f6 = (float)rectangle2D.getY();
        float f7 = (float)rectangle2D.getHeight() - f2;
        float f8 = (float)rectangle2D.getWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f4, f3, f2);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeNormalColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.QOIV.objectProperties.getGaugeErrorColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_2);
    }

    public void fillValuePattern(Graphics2D graphics2D, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.dataset + this.drawAxis + this.fillBackPattern + this.getGaugeAlertColor;
                break;
            }
            case 1: {
                f = this.axisY + this.draw + this.fill + this.getGaugeAlertColor;
                f2 = this.dataset;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.fillTempPattern, this.fillValuePattern);
        if (bl) {
            switch (this.QOIV.objectProperties.getGaugeBarLayout()) {
                case 0: {
                    this.getContourPen(float_, graphics2D);
                    f3 = f + this.fillTempPattern * (this.QOIV.D[this.getAxisPen] - this.QOIV.F[0]) / (this.QOIV.S - this.QOIV.J);
                    f4 = f2;
                    f5 = this.fillTempPattern - this.fillTempPattern * (this.QOIV.D[this.getAxisPen] - this.QOIV.F[0]) / (this.QOIV.S - this.QOIV.J);
                    f6 = this.fillValuePattern;
                    break;
                }
                case 1: {
                    this.getDimension(float_, graphics2D);
                    f4 = f2;
                    f3 = f;
                    f6 = this.fillValuePattern - this.fillValuePattern * (this.QOIV.D[this.getAxisPen] - this.QOIV.F[0]) / (this.QOIV.S - this.QOIV.J);
                    f5 = this.fillTempPattern;
                }
            }
            Rectangle2D.Float float_2 = new Rectangle2D.Float(f3, f4, f5, f6);
            graphics2D.setColor(Color.white);
            graphics2D.fill(float_2);
        }
        this.QOIV.objectProperties.getGaugeBarPen().draw(graphics2D, float_);
    }

    public void fillBackPattern(Graphics2D graphics2D) {
    }

    public Shape getItemShapes(int n) {
        return this.getDimension[n];
    }

    public void setStartX(float f) {
        this.axisY = f;
    }

    public void setStartY(float f) {
        this.dataset = f;
    }

    public void setCategoryLabel(ChartLabelBase chartLabelBase) {
        this.abs = chartLabelBase;
    }

    public Shape getAxisY1Shapes() {
        return this.getGaugeBarLayout;
    }
}

