/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.css.util;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.Vector;
import sun.io.Converters;

public class CharsetValidate {
    private static final String[] QOIV;

    public static final Vector getSupportCharsets() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < QOIV.length) {
            vector.add(QOIV[n]);
            ++n;
        }
        return vector;
    }

    public static final String getDefaultCharset() {
        return Converters.getDefaultEncodingName();
    }

    public static final boolean isSupportCharset(String string) {
        string = string.toUpperCase();
        int n = 0;
        while (n < QOIV.length) {
            if (QOIV[n].compareTo(string) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final int getCharsetIndex(String string) {
        string = string.toUpperCase();
        int n = 0;
        while (n < QOIV.length) {
            if (QOIV[n].compareTo(string) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final String getCharsetIndext(int n) {
        if (n < 0 || n > QOIV.length) {
            return null;
        }
        return QOIV[n];
    }

    static {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator iterator = sortedMap.entrySet().iterator();
        QOIV = new String[sortedMap.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Charset charset = (Charset)entry.getValue();
            CharsetValidate.QOIV[n] = charset.name();
            ++n;
        }
    }
}

