/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import jet.datastream.DSField;
import jet.datastream.JRObjectResult;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.export.util.ImageEngine;
import jet.log.JRLogger;

public abstract class Render {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean isCutOff = true;
    protected boolean isAutoFit;
    private double DEFAULT_SHADOW_WIDTH;
    private int QOIV;
    private int UTFLength;
    private int adjustString;
    private int afterAutoFitResetFieldSize;
    private int calculateAutoSize;
    private int calculateCoordinate;
    private int calculatePadding;
    private int class$;
    protected DSField dsField;
    protected int dsFieldX;
    protected int dsFieldY;
    protected int dsFieldWidth;
    protected int dsFieldHeight;
    private int clearCacheRecord = 0;
    private int convertPixelToUnit = 0;
    private int convertUnitToPixel = 0;
    private int createGraphics = 0;
    private int drawBorder;
    private int drawPattern;
    private int error;
    private int fieldRotation;
    private int fillRect;
    private int forName;
    private int getBooleanPropertyByName;
    private int getBounds;
    private int getColorPropertyByName;
    private int getEndLine;
    private boolean getHeight;
    protected String text;
    protected Font font;
    protected int resolution = 96;
    protected int layout;
    protected boolean isRotation = false;
    private boolean getIntPropertyByName = false;
    protected boolean isWordwrap = false;
    protected ImageObserver imageObserver = null;
    protected ImageEngine imageEngine;
    protected int fromEncoding = -1;
    protected int toEncoding = -1;
    public static final JRLogger logger = JRLogger.getLogger(class$jet$datastream$render$Render == null ? (class$jet$datastream$render$Render = Render.class$("jet.datastream.render.Render")) : class$jet$datastream$render$Render);
    static Class class$jet$datastream$render$Render;

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public void locate() {
        Box box = new Box(this);
        this.calculatePadding(box);
        this.x = box.x;
        this.y = box.y;
        this.width = box.I;
        this.height = box.Z;
        this.calculateCoordinate(box);
        boolean bl = this.isRotation = this.DEFAULT_SHADOW_WIDTH != 0.0;
        if (this.isRotation) {
            this.rotation();
        }
    }

    protected void calculatePadding(Box box) {
        box.x = 0;
        box.y = 0;
        box.I = this.dsFieldWidth = this.dsField.getWidth();
        box.Z = this.dsFieldHeight = this.dsField.getHeight();
        box.x += this.forName;
        box.I -= this.forName + this.getBooleanPropertyByName;
        box.y += this.getBounds;
        box.Z -= this.getBounds + this.getColorPropertyByName;
        if (this.error != 0) {
            this.clearCacheRecord = (this.error == 5 ? 3 : 1) * this.fillRect;
            box.x += this.clearCacheRecord;
            box.I -= this.clearCacheRecord;
        }
        if (this.drawBorder != 0) {
            this.convertUnitToPixel = (this.drawBorder == 5 ? 3 : 1) * this.fillRect;
            box.y += this.convertUnitToPixel;
            box.Z -= this.convertUnitToPixel;
        }
        if (this.fieldRotation != 0) {
            this.convertPixelToUnit = (this.fieldRotation == 5 ? 3 : 1) * this.fillRect;
            box.I -= this.convertPixelToUnit;
        }
        if (this.drawPattern != 0) {
            this.createGraphics = (this.drawPattern == 5 ? 3 : 1) * this.fillRect;
            box.Z -= this.createGraphics;
        }
        box.I = box.I - (this.getHeight ? this.getEndLine : 0);
        box.Z = box.Z - (this.getHeight ? this.getEndLine : 0);
    }

    protected void autoFit(Box box) {
        this.calculateAutoSize();
        box.I = this.width;
        box.Z = this.height;
        int n = box.I;
        int n2 = box.Z;
        this.afterAutoFitResetFieldSize(n, n2);
    }

    protected void afterAutoFitResetFieldSize(int n, int n2) {
        if (this.error != 0) {
            n += this.clearCacheRecord;
        }
        if (this.drawBorder != 0) {
            n2 += this.convertUnitToPixel;
        }
        if (this.fieldRotation != 0) {
            n += this.convertPixelToUnit;
        }
        if (this.drawPattern != 0) {
            n2 += this.createGraphics;
        }
        int n3 = this.getHeight ? this.getEndLine : 0;
        this.dsFieldWidth = n += this.getHeight ? this.getEndLine : 0;
        this.dsFieldHeight = n2 += n3;
        this.dsField.setWidth(this.dsFieldWidth);
        this.dsField.setHeight(this.dsFieldHeight);
    }

    protected void calculateAutoSize() {
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds(this.text, this.font);
        this.width = (int)Unit.convertPixelToUnit(rectangle2D.getWidth() + 16.0, this.resolution);
        this.height = (int)Unit.convertPixelToUnit(rectangle2D.getHeight() + 8.0, this.resolution);
    }

    protected void calculateCoordinate(Box box) {
        this.x = box.x;
        this.y = box.y;
        switch (this.layout) {
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                this.y = box.y + (box.Z - this.height) / 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                this.y = box.y + (box.Z - this.height);
            }
        }
        switch (this.layout) {
            case 2: 
            case 5: 
            case 8: {
                this.x = box.x + (box.I - this.width) / 2;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                this.x = box.x + (box.I - this.width);
            }
        }
    }

    protected void rotation() {
        int n = this.dsField.getX();
        int n2 = this.dsField.getY();
        int n3 = this.dsField.getWidth();
        int n4 = this.dsField.getHeight();
        Rectangle rectangle = RenderGraphicsToolkit.fieldRotation(this.DEFAULT_SHADOW_WIDTH, n + n3 / 2, n2 + n4 / 2, n3, n4);
        this.dsFieldWidth = rectangle.width;
        this.dsFieldHeight = rectangle.height;
        this.dsField.setWidth(this.dsFieldWidth);
        this.dsField.setHeight(this.dsFieldHeight);
        this.calculateAutoSize = Unit.convertUnitToPixel((this.dsFieldWidth - n3) / 2, this.resolution);
        this.calculateCoordinate = Unit.convertUnitToPixel((this.dsFieldHeight - n4) / 2, this.resolution);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = Unit.convertUnitToPixel(this.width, this.resolution);
        int n4 = Unit.convertUnitToPixel(this.height, this.resolution);
        if (this.getIntPropertyByName) {
            n = Unit.convertUnitToPixel(this.x, this.resolution);
            n2 = Unit.convertUnitToPixel(this.y, this.resolution);
        }
        if (this.isRotation) {
            n += this.calculateAutoSize;
            n2 += this.calculateCoordinate;
        }
        this.imageEngine = new ImageEngine();
        this.paintConcreteRender(graphics, n, n2, n3, n4);
    }

    public void paintFieldBorder(Graphics graphics) {
        Rectangle rectangle = null;
        int n = this.dsField.getResolution();
        rectangle = this.isRotation ? new Rectangle(this.calculateAutoSize, this.calculateCoordinate, Unit.convertUnitToPixel(this.dsField.getWidth(), n), Unit.convertUnitToPixel(this.dsField.getHeight(), n)) : new Rectangle(0, 0, Unit.convertUnitToPixel(this.dsField.getWidth(), n), Unit.convertUnitToPixel(this.dsField.getHeight(), n));
        Color color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
        Color color2 = RenderUtil.getColorPropertyByName(this.dsField, "BorderColor");
        Color color3 = RenderUtil.getColorPropertyByName(this.dsField, "ShadowColor");
        int n2 = RenderUtil.getIntPropertyByName(this.dsField, "LeftLine");
        int n3 = RenderUtil.getIntPropertyByName(this.dsField, "RightLine");
        int n4 = RenderUtil.getIntPropertyByName(this.dsField, "TopLine");
        int n5 = RenderUtil.getIntPropertyByName(this.dsField, "BottomLine");
        int n6 = RenderUtil.getIntPropertyByName(this.dsField, "BorderWidth");
        int n7 = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n);
        boolean bl = RenderUtil.getBooleanPropertyByName(this.dsField, "Shadow");
        boolean bl2 = color != null;
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color : null, color2, Unit.convertUnitToPixel(n6, n), n4, n5, n2, n3, bl, color3, n7);
        this.dsField.clearCacheRecord();
    }

    public void paintFieldBackground(Graphics graphics) {
        Rectangle rectangle = null;
        rectangle = this.isRotation ? new Rectangle(this.calculateAutoSize, this.calculateCoordinate, Unit.convertUnitToPixel(this.dsField.getWidth(), this.resolution), Unit.convertUnitToPixel(this.dsField.getHeight(), this.resolution)) : new Rectangle(0, 0, Unit.convertUnitToPixel(this.dsField.getWidth(), this.resolution), Unit.convertUnitToPixel(this.dsField.getHeight(), this.resolution));
        Color color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
        if (color != null) {
            graphics.setColor(color);
            int n = Unit.convertUnitToPixel(this.getEndLine, this.resolution);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - n, rectangle.height - n);
        }
        Color color2 = RenderUtil.getColorPropertyByName(this.dsField, "PatternColor");
        int n = RenderUtil.getIntPropertyByName(this.dsField, "PatternStyle");
        RenderGraphicsToolkit.drawPattern(graphics, rectangle, color2, n);
    }

    protected abstract void paintConcreteRender(Graphics var1, int var2, int var3, int var4, int var5);

    public Image getImage() {
        this.getIntPropertyByName = false;
        if (this.width == 0 || this.height == 0) {
            logger.error("BufferedImage can not be generated for its size is zero.");
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution));
        this.paint(graphics2D);
        return bufferedImage;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public Rectangle getBounds() {
        return new Rectangle(Unit.convertUnitToPixel(this.x, this.resolution), Unit.convertUnitToPixel(this.y, this.resolution), Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution));
    }

    public DSField getParent() {
        return this.dsField;
    }

    public int getBeforeRotaionHeight() {
        return this.afterAutoFitResetFieldSize;
    }

    public void setBeforeRotaionHeight(int n) {
        this.afterAutoFitResetFieldSize = n;
    }

    public int getBeforeRotationWidth() {
        return this.adjustString;
    }

    public void setBeforeRotationWidth(int n) {
        this.adjustString = n;
    }

    public int getBeforeRotationX() {
        return this.QOIV;
    }

    public void setBeforeRotationX(int n) {
        this.QOIV = n;
    }

    public int getBeforeRotationY() {
        return this.UTFLength;
    }

    public void setBeforeRotationY(int n) {
        this.UTFLength = n;
    }

    public void setBorderWidth(int n) {
        this.fillRect = n;
    }

    public void setBottomStyle(int n) {
        this.drawPattern = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public boolean isAutoFit() {
        return this.isAutoFit;
    }

    public void setAutoFit(boolean bl) {
        this.isAutoFit = bl;
    }

    public boolean isPaintCalledByField() {
        return this.getIntPropertyByName;
    }

    public void setPaintCalledByField(boolean bl) {
        this.getIntPropertyByName = bl;
    }

    public boolean isShadow() {
        return this.getHeight;
    }

    public void setShadow(boolean bl) {
        this.getHeight = bl;
    }

    public boolean isWordwrap() {
        return this.isWordwrap;
    }

    public void setWordwrap(boolean bl) {
        this.isWordwrap = bl;
    }

    public void setLayout(int n) {
        this.layout = n;
    }

    public void setLeftStyle(int n) {
        this.error = n;
    }

    public void setRightStyle(int n) {
        this.fieldRotation = n;
    }

    public double getRotation() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setRotation(double d) {
        this.DEFAULT_SHADOW_WIDTH = d;
    }

    public int getShadowWidth() {
        return this.getEndLine;
    }

    public void setShadowWidth(int n) {
        this.getEndLine = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTopStyle(int n) {
        this.drawBorder = n;
    }

    public int getRotationOffsetX() {
        return this.calculateAutoSize;
    }

    public void setRotationOffsetX(int n) {
        this.calculateAutoSize = n;
    }

    public int getRotationOffsetY() {
        return this.calculateCoordinate;
    }

    public int getRotationX() {
        return this.calculatePadding;
    }

    public void setRotationX(int n) {
        this.calculatePadding = n;
    }

    public int getRotationY() {
        return this.class$;
    }

    public void setRotationY(int n) {
        this.class$ = n;
    }

    public void setRotationOffsetY(int n) {
        this.calculateCoordinate = n;
    }

    public boolean isRotation() {
        return this.isRotation;
    }

    public void setRotation(boolean bl) {
        this.isRotation = bl;
    }

    public String getAlt() {
        return null;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getBottomPadding() {
        return this.getColorPropertyByName;
    }

    public void setBottomPadding(int n) {
        this.getColorPropertyByName = n;
    }

    public int getLeftPadding() {
        return this.forName;
    }

    public void setLeftPadding(int n) {
        this.forName = n;
    }

    public int getRightPadding() {
        return this.getBooleanPropertyByName;
    }

    public void setRightPadding(int n) {
        this.getBooleanPropertyByName = n;
    }

    public int getTopPadding() {
        return this.getBounds;
    }

    public void setTopPadding(int n) {
        this.getBounds = n;
    }

    public boolean canBeCatch() {
        return false;
    }

    public void updateRender(DSField dSField) {
    }

    public void setField(DSField dSField) {
        this.dsField = dSField;
    }

    public void clearCacheRender() {
        this.dsField = null;
        this.imageObserver = null;
        this.imageEngine = null;
    }

    public int memoryLength() {
        int n = 0;
        n += 136;
        n += 4;
        if (this.text != null) {
            n += JRObjectResult.UTFLength(this.text);
        }
        return n;
    }

    public boolean isCutOff() {
        return this.isCutOff;
    }

    public String getFieldRealString(DSField dSField) {
        String string = dSField.toString();
        String string2 = null;
        if (dSField.getStartYPos() == 0) {
            return string;
        }
        int[][] nArray = dSField.getLineBreakPos();
        int n = dSField.getStartLine();
        int n2 = dSField.getEndLine();
        if (nArray == null || n == -1 || n2 < n) {
            return string;
        }
        string = Painter.adjustString(string);
        int n3 = nArray[n][0];
        int n4 = 0;
        try {
            n4 = nArray[n2][0] + nArray[n2][1];
            string2 = string.substring(n3, n4);
        }
        catch (Exception exception) {
            string2 = nArray.length > n2 + 1 ? string.substring(n3, nArray[n2 + 1][0]) : string.substring(n3);
        }
        return string2;
    }

    public Rectangle getBox() {
        return null;
    }

    public void clipString() {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Box {
        int x;
        int y;
        int I;
        int Z;
        private final Render this$0;

        Box(Render render) {
            this.this$0 = render;
            this.Z = 0;
            this.I = 0;
            this.y = 0;
            this.x = 0;
        }
    }
}

