/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jet.connect.DbValue;
import jet.datastream.DSField;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.export.util.ImageTool;

public class RenderImage
extends Render {
    private boolean QOIV = false;
    private Image autoFit;
    private DbValue calculateCoordinate;
    private String calculatePadding;
    private boolean convertPixelToUnit = false;
    private boolean createImage = false;
    protected int renderX;
    protected int renderY;
    protected int scaleMode;
    protected float maxRatio;
    protected Dimension drawSize;
    protected float ratio;
    protected int imgWidth;
    protected int imgHeight;
    protected int imageType;

    public RenderImage(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public void locate() {
        Object[] objectArray;
        if (!this.QOIV) {
            int n = (Integer)this.dsField.getPropertyByName("MediaType").getObject();
            objectArray = RenderGraphicsToolkit.createImage(this.calculateCoordinate, n);
            if (objectArray == null) {
                return;
            }
            this.autoFit = (Image)objectArray[0];
            this.imageType = this.autoFit != null ? (Integer)objectArray[1] : -100;
        }
        if (this.autoFit == null) {
            return;
        }
        Render.Box box = new Render.Box(this);
        this.ratio = ImageTool.getResolutionRatio(this.resolution);
        this.imgWidth = (int)((float)this.autoFit.getWidth(null) * this.ratio);
        this.imgHeight = (int)((float)this.autoFit.getHeight(null) * this.ratio);
        this.calculatePadding(box);
        if (this.isAutoFit) {
            this.x = box.x;
            this.y = box.y;
            this.width = Unit.convertPixelToUnit(this.imgWidth, this.resolution);
            this.height = Unit.convertPixelToUnit(this.imgHeight, this.resolution);
            this.drawSize = new Dimension(this.width, this.height);
            super.autoFit(box);
        } else {
            if (this.convertPixelToUnit) {
                this.scaleMode = 5;
            }
            this.drawSize = ImageTool.getScalingSize(this.width, this.height, Unit.convertPixelToUnit(this.imgWidth, this.resolution), Unit.convertPixelToUnit(this.imgHeight, this.resolution), this.scaleMode, this.maxRatio);
            if (this.getRotation() == 0.0) {
                objectArray = RenderUtil.getClipScaleRect(this.width, this.height, box.I, box.Z, this.autoFit, this.scaleMode, this.maxRatio);
                this.width = (int)objectArray[0];
                this.height = (int)objectArray[1];
            } else {
                this.QOIV(new Dimension(box.I, box.Z));
            }
            super.calculateCoordinate(box);
        }
    }

    private void QOIV(Dimension dimension) {
        this.width = this.width > dimension.width ? dimension.width : this.width;
        this.height = this.height > dimension.height ? dimension.height : this.height;
    }

    protected void calculateAutoSize() {
    }

    protected void calculatePadding(Render.Box box) {
        super.calculatePadding(box);
        this.x = box.x;
        this.y = box.y;
        this.width = (Integer)this.dsField.getPropertyByName("Image_Display_Width").getObject();
        this.height = (Integer)this.dsField.getPropertyByName("Image_Display_Height").getObject();
        if (this.convertPixelToUnit) {
            this.width = Unit.convertPixelToUnit(this.imgWidth, this.resolution);
            this.height = Unit.convertPixelToUnit(this.imgHeight, this.resolution);
        }
    }

    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        this.autoFit(graphics, n, n2, n3, n4);
    }

    private void autoFit(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.autoFit == null) {
            this.calculateCoordinate(graphics, n, n2);
        } else {
            this.imageEngine.setResolusion(this.resolution);
            this.imageEngine.drawImage(graphics, this.imageObserver, this.dsField);
        }
    }

    private void calculateCoordinate(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.red);
        graphics.drawLine(n, n2, n + 10, n2 + 10);
        graphics.drawLine(n + 10, n2, n, n2 + 10);
    }

    public Image getImage() {
        return this.autoFit;
    }

    public boolean isConstraintProportion() {
        return this.createImage;
    }

    public void setConstraintProportion(boolean bl) {
        this.createImage = bl;
    }

    public boolean isFromURL() {
        return this.QOIV;
    }

    public void setFromURL(boolean bl) {
        this.QOIV = bl;
    }

    public boolean isOriginalSize() {
        return this.convertPixelToUnit;
    }

    public void setOriginalSize(boolean bl) {
        this.convertPixelToUnit = bl;
    }

    public String getUrl() {
        return this.calculatePadding;
    }

    public void setUrl(String string) {
        this.calculatePadding = string;
    }

    public DbValue getValue() {
        return this.calculateCoordinate;
    }

    public void setValue(DbValue dbValue) {
        this.calculateCoordinate = dbValue;
    }

    public void setImage(Image image) {
        this.autoFit = image;
    }

    public String getAlt() {
        return RenderUtil.getStringPropertyByName(this.dsField, "Alt");
    }

    public Dimension getdrawSize() {
        return this.drawSize;
    }

    public void setRender(Dimension dimension) {
        this.drawSize = dimension;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public void setMaxRatio(float f) {
        this.maxRatio = f;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleMode(int n) {
        this.scaleMode = n;
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }
}

