/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.TopableContainer;
import guitools.TopableContainerListener;
import guitools.toolkit.JDebug;
import guitools.toolkit.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import jet.Env;
import jet.JRStopEngineException;
import jet.JViewResource;
import jet.controls.editor.UndoRedoListener;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.export.print.JReportSwingPrinter;
import jet.export.print.NoSuchPrintAttributeException;
import jet.ie.PJFCommunicator;
import jet.ie.RSTLoadControler;
import jet.ie.VersionException;
import jet.ie.io.RAHTTPInput;
import jet.ie.io.RAStreamInput;
import jet.swingviewer.DesignerViewerPane;
import jet.swingviewer.DrillDownView;
import jet.swingviewer.JRFileFilter;
import jet.swingviewer.TableContentsDesigner;
import jet.swingviewer.ViewerHolder;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.JReportRunnerViewerHolder;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.JetRptDrillDown;
import jet.thinviewer.JetRptShowPageLabel;
import jet.util.FontSets;
import jet.util.NullStream;
import jet.util.TempFile;

public class JReportSwingRunner
extends JFrame
implements ActionListener,
JetRptDrillDown,
KeyListener,
TopableContainerListener,
JetRptShowPageLabel,
UndoRedoListener {
    protected JButton buttonFirst = null;
    protected JButton buttonPrev = null;
    protected JButton buttonTable = null;
    protected JButton buttonNext = null;
    protected JButton buttonLast = null;
    protected JButton reload = null;
    protected JButton buttonBack = null;
    protected JButton buttonForward = null;
    protected JTextField textPageNum = null;
    protected JLabel labelofPageNumber = null;
    protected String defaultLabel = "";
    protected JPanel panel1;
    protected JScrollBar hScrollbar;
    protected JScrollBar vScrollbar;
    protected JPanel sheet;
    protected Communicator communicator;
    protected RSTLoadControler rstLoader;
    protected TableContentsDesigner tableOfContents = null;
    protected ViewerHolder viewerHolder;
    protected DrillDownView drillDownViewerPane;
    protected DesignerViewerPane viewPane;
    protected Rectangle rectangle;
    protected String strURL;
    protected String rptsheet;
    protected String urlView;
    protected RAHTTPInput raf;
    private boolean I;
    private boolean _setZoom;
    protected Vector drillDownKey;
    protected Vector drillDownValue;
    protected JReportRunnerViewerHolder jviewerHolder;
    private static TempFile addActionListener = new TempFile(Env.temporaryPath, "client");

    public JReportSwingRunner() {
        super("Report Viewer");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.gray);
        this.viewerHolder = null;
        this.communicator = null;
        this.rptsheet = null;
        this.raf = null;
        this.urlView = null;
        this.tableOfContents = null;
        this.I = false;
        this._setZoom = true;
        this.drillDownKey = new Vector(5);
        this.drillDownValue = new Vector(5);
        this.drillDownViewerPane = null;
        this.setBounds(0, 0, 800, 500);
        this.setBackground(Color.gray);
        this.initMenu();
        this.initToolbar();
        this.addNotify();
        this.addWindowListener(new WindowAdapter(this){
            private final JReportSwingRunner this$0;
            {
                this.this$0 = jReportSwingRunner;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.exit();
            }
        });
        this.setEnableMenuBtn(false);
    }

    public JReportSwingRunner(String string) {
        super(string);
        this.initMenu();
        this.initToolbar();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel1, "North");
        this.panel1.setVisible(true);
        this.viewerHolder = null;
        this.communicator = null;
        this.rptsheet = null;
        this.raf = null;
        this.urlView = null;
        this.tableOfContents = null;
        this.I = false;
        this._setZoom = true;
        this.drillDownKey = new Vector(5);
        this.drillDownValue = new Vector(5);
        this.drillDownViewerPane = null;
    }

    public JReportSwingRunner(boolean bl) {
        super("Report Viewer");
        this.viewerHolder = null;
        this.rstLoader = null;
        this.communicator = null;
        this.rptsheet = null;
        this.tableOfContents = null;
        this.I = false;
        this._setZoom = true;
        this.drillDownKey = new Vector(5);
        this.drillDownValue = new Vector(5);
        this.drillDownViewerPane = null;
        this.I = bl;
        this.getContentPane().setLayout(new BorderLayout());
        this.setBounds(0, 0, 800, 500);
        this.setBackground(Color.gray);
        this.initMenu();
        this.initToolbar();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel1, "North");
        this.panel1.setVisible(true);
        this.enableEvents(1L);
        this.addNotify();
        this.addWindowListener(new WindowAdapter(this){
            private final JReportSwingRunner this$0;
            {
                this.this$0 = jReportSwingRunner;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.closeRSTFile();
                this.this$0.exit();
            }
        });
        this.setEnableMenuBtn(false);
    }

    public JReportSwingRunner(String string, boolean bl) {
        super(string);
        this.viewerHolder = null;
        this.communicator = null;
        this.rptsheet = null;
        this.tableOfContents = null;
        this.I = false;
        this._setZoom = true;
        this.drillDownKey = new Vector(5);
        this.drillDownValue = new Vector(5);
        this.drillDownViewerPane = null;
        this.I = bl;
        this.setBounds(0, 0, 800, 400);
        this.enableEvents(1L);
        this.addWindowListener(new WindowAdapter(this){
            private final JReportSwingRunner this$0;
            {
                this.this$0 = jReportSwingRunner;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.setVisible(false);
            }
        });
    }

    protected void initMenu() {
        JMenuItem jMenuItem;
        this.setTitleImage(null);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(JViewResource.getLabel("menufile"));
        JMenuItem jMenuItem2 = new JMenuItem(JViewResource.getLabel("menuopenrst"));
        jMenuItem2.setActionCommand("Open");
        JMenuItem jMenuItem3 = new JMenuItem(JViewResource.getLabel("menusaveas"));
        jMenuItem3.setActionCommand("Save As");
        JMenu jMenu2 = new JMenu(JViewResource.getLabel("menuprint"));
        JMenuItem jMenuItem4 = new JMenuItem(JViewResource.getLabel("menuprintjdk11"));
        jMenuItem4.setActionCommand("Print With JDK 1.1.x");
        jMenuItem4.addActionListener(this);
        JMenuItem jMenuItem5 = new JMenuItem(JViewResource.getLabel("menuprintjdk12"));
        jMenuItem5.setActionCommand("Print With JDK 1.2.x");
        jMenuItem5.addActionListener(this);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        if (string.compareTo("1.4.0") >= 0) {
            jMenuItem = new JMenuItem(JViewResource.getLabel("menuprintjdk14"));
            jMenuItem.setActionCommand("Print With JDK 1.4.x");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(JViewResource.getLabel("menuexport"));
        jMenuItem.setActionCommand("Export");
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        jMenu.add(jMenu2);
        jMenu.add(jMenuItem);
        JMenu jMenu3 = new JMenu(JViewResource.getLabel("menugo"));
        JMenuItem jMenuItem6 = new JMenuItem(JViewResource.getLabel("menufirstpage"));
        JMenuItem jMenuItem7 = new JMenuItem(JViewResource.getLabel("menuprevpage"));
        JMenuItem jMenuItem8 = new JMenuItem(JViewResource.getLabel("menunextpage"));
        JMenuItem jMenuItem9 = new JMenuItem(JViewResource.getLabel("menulastpage"));
        JMenuItem jMenuItem10 = new JMenuItem(JViewResource.getLabel("menugotopage"));
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        jMenu3.add(jMenuItem8);
        jMenu3.add(jMenuItem9);
        jMenu3.add(jMenuItem10);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        jMenuItem2.addActionListener(this);
        jMenuItem3.addActionListener(this);
        jMenuItem.addActionListener(this);
        jMenuItem6.addActionListener(this);
        jMenuItem7.addActionListener(this);
        jMenuItem8.addActionListener(this);
        jMenuItem9.addActionListener(this);
        jMenuItem10.addActionListener(this);
    }

    protected void initToolbar() {
        this.panel1 = new JPanel();
        this.panel1.setLayout(new FlowLayout());
        this.buttonFirst = new JButton("|<");
        this.buttonFirst.setToolTipText("to first page");
        this.buttonPrev = new JButton("<");
        this.buttonPrev.setToolTipText("to previous page");
        this.buttonNext = new JButton(">");
        this.buttonNext.setToolTipText("to next page");
        this.buttonLast = new JButton(">|");
        this.buttonLast.setToolTipText("to last page");
        this.buttonBack = new JButton("Back");
        this.buttonBack.setToolTipText("go back");
        this.buttonForward = new JButton("Forward");
        this.buttonForward.setToolTipText("forward");
        this.buttonTable = new JButton("TOC");
        this.buttonTable.setToolTipText("Table of Contents");
        this.reload = new JButton("Reload");
        this.reload.setToolTipText("Reload");
        this.textPageNum = new JTextField(" ");
        this.textPageNum.setPreferredSize(new Dimension(45, 25));
        this.labelofPageNumber = new JLabel("of ");
        this.defaultLabel = this.labelofPageNumber.getText();
        this.panel1.add(this.buttonFirst);
        this.panel1.setVisible(true);
        this.panel1.add(this.buttonPrev);
        this.panel1.add(this.buttonNext);
        this.panel1.add(this.buttonLast);
        this.panel1.add(this.buttonBack);
        this.panel1.add(this.buttonForward);
        this.panel1.add(this.buttonTable);
        this.panel1.add(this.textPageNum);
        this.panel1.add(this.labelofPageNumber);
        this.panel1.add(this.reload);
        this.getContentPane().add((Component)this.panel1, "North");
        this.buttonFirst.addActionListener(this);
        this.buttonPrev.addActionListener(this);
        this.buttonNext.addActionListener(this);
        this.buttonLast.addActionListener(this);
        this.buttonBack.addActionListener(this);
        this.buttonForward.addActionListener(this);
        this.buttonTable.addActionListener(this);
        this.reload.addActionListener(this);
        this.textPageNum.addKeyListener(this);
        this.buttonBack.setEnabled(false);
        this.buttonForward.setEnabled(false);
        this.panel1.setVisible(true);
    }

    public void setCurrentPageNumber(int n, int n2, boolean bl) {
        this.textPageNum.setText("" + n);
        this.textPageNum.requestFocus();
        this.textPageNum.selectAll();
        if (this.viewerHolder.reportEnd()) {
            this.labelofPageNumber.setText(this.defaultLabel + " " + n2);
            if (n == 1) {
                this.buttonFirst.setEnabled(false);
                this.buttonPrev.setEnabled(false);
                if (n2 == 1) {
                    this.buttonNext.setEnabled(false);
                    this.buttonLast.setEnabled(false);
                    return;
                }
                this.buttonNext.setEnabled(true);
                this.buttonLast.setEnabled(true);
                return;
            }
            if (n == n2) {
                this.buttonFirst.setEnabled(true);
                this.buttonPrev.setEnabled(true);
                this.buttonNext.setEnabled(false);
                this.buttonLast.setEnabled(false);
                return;
            }
            this.buttonFirst.setEnabled(true);
            this.buttonPrev.setEnabled(true);
            this.buttonNext.setEnabled(true);
            this.buttonLast.setEnabled(true);
            return;
        }
        this.labelofPageNumber.setText(this.defaultLabel + " " + n2 + "+");
        if (n == 1) {
            this.buttonFirst.setEnabled(false);
            this.buttonPrev.setEnabled(false);
        } else {
            this.buttonFirst.setEnabled(true);
            this.buttonPrev.setEnabled(true);
        }
        this.buttonNext.setEnabled(true);
        this.buttonLast.setEnabled(true);
    }

    public void addDrillDownCard(DSPage dSPage, String string, String string2, DataStream dataStream) {
        JRObjectResult jRObjectResult;
        int n = 0;
        do {
            jRObjectResult = dSPage.getObject(n);
            ++n;
        } while (!(jRObjectResult instanceof DSSection));
        int n2 = this.drillDownKey.indexOf(jRObjectResult);
        if (n2 == -1) {
            DrillDownView drillDownView = new DrillDownView(this.communicator, dataStream, dSPage, string + ":" + string2, this.I);
            drillDownView.initViewer(dSPage, string, dataStream);
            drillDownView.drillDownViewer.setDrillDownImplement(this);
            drillDownView.drillDownViewer.setShowPageNumberImplement(this);
            if (this.getIconImage() != null) {
                drillDownView.setIconImage(this.getIconImage());
            }
            this.drillDownKey.addElement(jRObjectResult);
            this.drillDownValue.addElement(drillDownView);
            return;
        }
        DrillDownView drillDownView = (DrillDownView)this.drillDownValue.elementAt(n2);
        drillDownView.show();
    }

    public void addTableContentsCard(DSPage dSPage, String string, String string2, DataStream dataStream) {
        if (this.drillDownViewerPane != null) {
            this.drillDownViewerPane.removeAll();
            this.drillDownViewerPane.dispose();
            this.drillDownViewerPane = new DrillDownView(this.communicator, dataStream, dSPage, string + ":" + string2, this.I);
            this.drillDownViewerPane.initViewer(dSPage, string, dataStream);
            this.drillDownViewerPane.drillDownViewer.setDrillDownImplement(this);
            this.drillDownViewerPane.drillDownViewer.setShowPageNumberImplement(this);
            if (this.getIconImage() != null) {
                this.drillDownViewerPane.setIconImage(this.getIconImage());
            }
            return;
        }
        this.drillDownViewerPane = new DrillDownView(this.communicator, dataStream, dSPage, string + ":" + string2, this.I);
        this.drillDownViewerPane.initViewer(dSPage, string, dataStream);
        this.drillDownViewerPane.drillDownViewer.setDrillDownImplement(this);
        this.drillDownViewerPane.drillDownViewer.setShowPageNumberImplement(this);
        if (this.getIconImage() != null) {
            this.drillDownViewerPane.setIconImage(this.getIconImage());
        }
    }

    public void viewDrillDown(DSPage dSPage, String string, DataStream dataStream) {
        JReportDrillDownViewer jReportDrillDownViewer = this.drillDownViewerPane.getDrillDownViwer();
        jReportDrillDownViewer.setCurPage(dSPage);
        jReportDrillDownViewer.setShowPageNumberImplement(this);
        jReportDrillDownViewer.setDrillDownImplement(this);
        int n = dataStream.getCommunicator().getResolution();
        Rectangle rectangle = dataStream.getPageArea();
        rectangle.x = Unit.convertUnitToPixel(rectangle.x, n);
        rectangle.y = Unit.convertUnitToPixel(rectangle.y, n);
        rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
        rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
        jReportDrillDownViewer.setBounds(0, 0, rectangle.width, rectangle.height);
        jReportDrillDownViewer.runThread();
        this.show();
    }

    public void removeAllDrillDownCard() {
        int n = this.drillDownKey.size();
        int n2 = 0;
        while (n2 < n) {
            DrillDownView drillDownView = (DrillDownView)this.drillDownValue.elementAt(n2);
            drillDownView.dispose();
            ++n2;
        }
        this.drillDownKey.removeAllElements();
        this.drillDownValue.removeAllElements();
    }

    protected void setPageNumberLabel(int n, int n2) {
        this.setCurrentPageNumber(n, n2, true);
    }

    protected void setEnableMenuBtn(boolean bl) {
        this.buttonFirst.setEnabled(bl);
        this.buttonPrev.setEnabled(bl);
        this.buttonTable.setEnabled(bl);
        this.buttonNext.setEnabled(bl);
        this.buttonLast.setEnabled(bl);
        this.reload.setEnabled(bl);
        this.textPageNum.setEnabled(bl);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar = this.getJMenuBar();
        jMenuBar.getMenu(0).getItem(1).setEnabled(bl);
        jMenuBar.getMenu(0).getItem(3).setEnabled(bl);
        jMenuBar.getMenu(0).getItem(4).setEnabled(bl);
        jMenuBar.getMenu(1).setEnabled(bl);
    }

    public void setAlone(boolean bl) {
        this._setZoom = bl;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() < 32) {
            if (keyEvent.getKeyCode() == 10) {
                int n = 1;
                int n2 = this.viewerHolder.getTotalPageNumber();
                try {
                    n = Integer.parseInt(this.textPageNum.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "The page number you input is not correct.", JViewResource.getMessage("TV_ERROR"), 1);
                }
                if (n > n2) {
                    JOptionPane.showMessageDialog(this, JViewResource.getMessage("TV_TOTALPAGE") + " " + n2);
                    n = n2;
                }
                this.viewerHolder.toPage(n);
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
                this.setPageNumberLabel(this.viewerHolder.getCurrentPageNumber(), this.viewerHolder.getTotalPageNumber());
                return;
            }
        } else if (keyEvent.getKeyChar() >= '0') {
            keyEvent.getKeyChar();
        }
    }

    public void closing(TopableContainer topableContainer) {
        this.tableOfContents.dispose();
        this.tableOfContents = null;
    }

    public static Communicator openRst(String string, String string2) throws Exception {
        PJFCommunicator pJFCommunicator = null;
        String string3 = null;
        if (!string.toLowerCase().startsWith("http")) {
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream.read() == 80 && fileInputStream.read() == 75) {
                fileInputStream.close();
                fileInputStream = new FileInputStream(string);
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                long l = zipEntry.getSize();
                RAStreamInput rAStreamInput = new RAStreamInput(zipInputStream, l);
                RSTLoadControler rSTLoadControler = new RSTLoadControler(rAStreamInput);
                rSTLoadControler.openFile();
                Map map = rSTLoadControler.getReportInfos();
                string3 = JReportSwingRunner.I(map, string2);
                pJFCommunicator = (PJFCommunicator)rSTLoadControler.getCommunicator(string2, string3);
                pJFCommunicator.setFieldNLSManager(rSTLoadControler.getNLSManager(string2, string3));
            } else {
                fileInputStream.close();
                RSTLoadControler rSTLoadControler = new RSTLoadControler(string);
                rSTLoadControler.openFile();
                Map map = rSTLoadControler.getReportInfos();
                string3 = JReportSwingRunner.I(map, string2);
                pJFCommunicator = (PJFCommunicator)rSTLoadControler.getCommunicator(string2, string3);
                pJFCommunicator.setFieldNLSManager(rSTLoadControler.getNLSManager(string2, string3));
            }
        } else {
            URL uRL = new URL(string);
            uRL.getProtocol();
            RAHTTPInput rAHTTPInput = new RAHTTPInput(uRL);
            RSTLoadControler rSTLoadControler = new RSTLoadControler(rAHTTPInput.getRandomInputable());
            rSTLoadControler.openFile();
            Map map = rSTLoadControler.getReportInfos();
            string3 = JReportSwingRunner.I(map, string2);
            pJFCommunicator = (PJFCommunicator)rSTLoadControler.getCommunicator(string2, string3);
            pJFCommunicator.setFieldNLSManager(rSTLoadControler.getNLSManager(string2, string3));
        }
        return pJFCommunicator;
    }

    private static String I(Map map, String string) {
        String string2 = null;
        if (map.containsKey(string)) {
            Vector vector = (Vector)map.get(string);
            String[] stringArray = null;
            if (vector != null && !vector.isEmpty()) {
                stringArray = (String[])vector.elementAt(0);
            }
            if (stringArray != null) {
                string2 = stringArray[0];
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage of JReportRunner test application:");
            System.out.println("    java jet.thinviewer.JReportRunner <index report file URL on server end> -Option");
            System.out.println("    Option :  -v verbose debug infomation.");
            System.exit(1);
            return;
        }
        try {
            if (stringArray.length < 2 || !stringArray[1].equals("-v")) {
                System.setOut(new PrintStream(new NullStream()));
            }
            Communicator communicator = JReportSwingRunner.openRst(stringArray[0], stringArray[1]);
            JReportSwingRunner jReportSwingRunner = new JReportSwingRunner(false);
            jReportSwingRunner.setRptSheet(stringArray[1]);
            jReportSwingRunner.strURL = stringArray[0];
            jReportSwingRunner.setCommunicator(communicator);
            jReportSwingRunner.show();
            jReportSwingRunner.viewIt();
            return;
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
            return;
        }
    }

    private void print(int n) {
        try {
            JReportSwingPrinter.printInSameProcess(this, this.communicator, null, true, null, true, null, n, false, false, JViewResource.getMessage("TV_PRINT_TITLE"), null, null);
        }
        catch (NoSuchPrintAttributeException noSuchPrintAttributeException) {
            JOptionPane.showMessageDialog(this, JViewResource.getMessage("TV_PRINTERATTRIBUTEERROR") + noSuchPrintAttributeException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
            noSuchPrintAttributeException.printStackTrace();
        }
        catch (JRStopEngineException jRStopEngineException) {
            JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
            jRStopEngineException.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        JReportViewer jReportViewer = this.viewerHolder.getViewer();
        if (object instanceof JButton) {
            if (object == this.buttonFirst) {
                this.viewerHolder.firstPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.buttonPrev) {
                this.viewerHolder.prevPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.buttonNext) {
                this.viewerHolder.nextPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.buttonLast) {
                this.viewerHolder.lastPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.buttonBack) {
                this.viewerHolder.back();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.buttonForward) {
                this.viewerHolder.forward();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (object == this.reload) {
                this.viewerHolder.reload();
                if (this.tableOfContents != null && this.tableOfContents.isContentsOn()) {
                    this.tableOfContents.dispose();
                }
                if (this.drillDownViewerPane != null) {
                    this.drillDownViewerPane.dispose();
                }
                this.removeAllDrillDownCard();
            } else if (object == this.buttonTable) {
                if (this.communicator != null) {
                    if (this.tableOfContents == null) {
                        if (this.communicator.getHeaderInfo(0).getUDTVersion() < 262145) {
                            int n = this.communicator.getPhysicalTotalPageNum();
                            int n2 = 1;
                            while (n2 <= n) {
                                try {
                                    this.communicator.getPage(n2);
                                }
                                catch (JRStopEngineException jRStopEngineException) {
                                    JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
                                    jRStopEngineException.printStackTrace();
                                }
                                ++n2;
                            }
                        }
                        this.tableOfContents = new TableContentsDesigner(this, jReportViewer, this);
                    } else if (!this.tableOfContents.isbNull()) {
                        this.tableOfContents.setVisible(true);
                    }
                }
                bl = false;
            }
        } else if (object instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals(JViewResource.getLabel("menufirstpage"))) {
                this.viewerHolder.firstPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (string.equals(JViewResource.getLabel("menuprevpage"))) {
                this.viewerHolder.prevPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (string.equals(JViewResource.getLabel("menunextpage"))) {
                this.viewerHolder.nextPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (string.equals(JViewResource.getLabel("menulastpage"))) {
                this.viewerHolder.lastPage();
                if (this.viewPane != null) {
                    this.viewPane._setZoom();
                }
            } else if (string.equals("Print With JDK 1.1.x")) {
                bl = false;
                if (this.communicator.isEngineFinished()) {
                    int n = this.communicator.getPhysicalTotalPageNum();
                } else {
                    int n = -1;
                }
                this.print(0);
            } else if (string.equals("Print With JDK 1.2.x")) {
                bl = false;
                this.print(1);
            } else if (string.equals("Print With JDK 1.4.x")) {
                bl = false;
                this.print(2);
            } else if (string.equals("Open")) {
                JFileChooser jFileChooser = new JFileChooser("openLocal");
                JRFileFilter jRFileFilter = new JRFileFilter();
                jRFileFilter.addExtension("rst");
                jFileChooser.setFileFilter(jRFileFilter);
                int n = jFileChooser.showOpenDialog(this);
                if (n == 1) {
                    return;
                }
                String string2 = null;
                if (jFileChooser.getSelectedFile() != null && jFileChooser.getSelectedFile().getPath() != null) {
                    string2 = jFileChooser.getSelectedFile().getPath();
                }
                if (string2 != null) {
                    this.clearMem();
                    try {
                        Communicator communicator = JReportSwingRunner.openRst(string2, this.rptsheet);
                        this.setCommunicator(communicator);
                        this.QOIV();
                        this.viewIt();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, JViewResource.getMessage("TV_OPENFILEERROR") + string2 + "!" + "\nPlease check the opened file name," + "and sure that is not more than one doc!", JViewResource.getMessage("TV_ERROR"), 0);
                        exception.printStackTrace();
                    }
                } else {
                    bl = false;
                }
                this.tableOfContents = null;
            } else if (string.equals("Save As")) {
                this.saveAs();
                bl = false;
            } else if (string.equals(JViewResource.getLabel("menugotopage"))) {
                int n = Integer.parseInt(this.textPageNum.getText());
                if (n <= this.viewerHolder.getTotalPageNumber() && n > 0) {
                    this.viewerHolder.toPage(n);
                    if (this.viewPane != null) {
                        this.viewPane._setZoom();
                    }
                }
                this.textPageNum.requestFocus();
            }
        } else {
            bl = false;
        }
        if (bl && this.viewerHolder != null) {
            this.setPageNumberLabel(this.viewerHolder.getCurrentPageNumber(), this.viewerHolder.getTotalPageNumber());
        }
    }

    public void closeRSTFile() {
        if (this.rstLoader != null) {
            try {
                this.rstLoader.clear();
            }
            catch (VersionException versionException) {
                JDebug.WARNING(versionException);
            }
        }
    }

    public void clearMem() {
        try {
            FontSets.unloadAllFonts();
            if (this.communicator != null) {
                this.communicator.clearMem();
            }
            if (this.viewerHolder != null && this.viewerHolder.getViewer() != null) {
                this.viewerHolder.getViewer().clearMem();
                return;
            }
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
        }
    }

    public void saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, JViewResource.getMessage("TV_SAVEFILEAS"), 1);
        fileDialog.setFile("*.rst");
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string + ".rst";
            string = fileDialog.getDirectory() + string;
            try {
                if (this.raf != null) {
                    this.raf.saveTo(string);
                } else if (this.urlView != null) {
                    RSTLoadControler rSTLoadControler = new RSTLoadControler(this.urlView);
                    rSTLoadControler.saveTo(string);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, JViewResource.getMessage("TV_SAVEFILEERROR") + string + "!", JViewResource.getMessage("TV_ERROR"), 0);
                exception.printStackTrace();
            }
        }
    }

    private void QOIV() {
        if (this.viewPane != null) {
            if (this.viewerHolder != null) {
                JReportViewer jReportViewer = this.viewerHolder.getViewer();
                if (jReportViewer != null) {
                    jReportViewer.removeAll();
                    jReportViewer = null;
                }
                this.viewerHolder = null;
            }
            this.viewPane.removeAll();
            this.remove(this.viewPane);
            if (this.tableOfContents != null) {
                this.closing(null);
            }
            this.removeAllDrillDownCard();
        }
    }

    public void afterDoAction(int n, int n2) {
        if (n == 0) {
            this.buttonBack.setEnabled(false);
        } else {
            this.buttonBack.setEnabled(true);
        }
        if (n2 == 0) {
            this.buttonForward.setEnabled(false);
            return;
        }
        this.buttonForward.setEnabled(true);
    }

    protected void exit() {
        this.clearMem();
        this.dispose();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() != this.viewerHolder) {
            return;
        }
        JReportViewer jReportViewer = this.viewerHolder.getViewer();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (!keyEvent.isControlDown()) break;
                try {
                    jReportViewer.prevPage();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
                    jRStopEngineException.printStackTrace();
                }
                this.setPageNumberLabel(jReportViewer.getCurrentPageNumber(), jReportViewer.getTotalPageNumber());
                break;
            }
            case 39: {
                if (!keyEvent.isControlDown()) break;
                try {
                    jReportViewer.nextPage();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
                    jRStopEngineException.printStackTrace();
                }
                this.setPageNumberLabel(jReportViewer.getCurrentPageNumber(), jReportViewer.getTotalPageNumber());
                break;
            }
            case 36: {
                if (!keyEvent.isControlDown()) break;
                try {
                    jReportViewer.firstPage();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
                    jRStopEngineException.printStackTrace();
                }
                this.setPageNumberLabel(jReportViewer.getCurrentPageNumber(), jReportViewer.getTotalPageNumber());
                break;
            }
            case 35: {
                if (!keyEvent.isControlDown()) break;
                try {
                    jReportViewer.lastPage();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
                    jRStopEngineException.printStackTrace();
                }
                this.setPageNumberLabel(jReportViewer.getCurrentPageNumber(), jReportViewer.getTotalPageNumber());
                break;
            }
            case 67: {
                if (keyEvent.isControlDown()) {
                    jReportViewer.copySelection();
                }
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: 
        }
    }

    public void alwaysOnTopChanged(TopableContainer topableContainer, boolean bl) {
    }

    public void setCommunicator(Communicator communicator) {
        this.communicator = communicator;
        this.QOIV();
        this.setEnableMenuBtn(false);
    }

    public void setRSTLoadControl(RSTLoadControler rSTLoadControler) {
        this.rstLoader = rSTLoadControler;
    }

    public void viewIt() {
        this.setCursor(new Cursor(3));
        this.viewPane = new DesignerViewerPane(this.communicator);
        this.getContentPane().add((Component)this.viewPane, "Center");
        this.setVisible(true);
        this.viewerHolder = new ViewerHolder();
        this.viewerHolder.addViewer(this.viewPane.viewer);
        this.viewPane.viewer.setDrillDownImplement(this);
        this.viewPane.viewer.setUndoRedoListener(this);
        this.viewPane.viewer.setShowPageNumberImplement(this);
        this.setPageNumberLabel(this.viewPane.viewer.getCurrentPageNumber(), this.viewPane.viewer.getTotalPageNumber());
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setEnableMenuBtn(true);
        if (this.viewPane.viewer.getTotalPageNumber() == 1) {
            this.buttonFirst.setEnabled(false);
            this.buttonPrev.setEnabled(false);
            this.buttonNext.setEnabled(false);
            this.buttonLast.setEnabled(false);
        }
    }

    public boolean setTitleImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
            return true;
        }
        return false;
    }

    public void refresh() {
        int n = this.communicator.getResolution();
        try {
            DataStream dataStream = (DataStream)this.communicator.getDataStream(0);
            JReportViewer jReportViewer = this.viewerHolder.getViewer();
            jReportViewer.setResolution(n);
            Rectangle rectangle = dataStream.getPageArea();
            rectangle.x = Unit.convertUnitToPixel(rectangle.x, n);
            rectangle.y = Unit.convertUnitToPixel(rectangle.y, n);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
            jReportViewer.setSize(rectangle.width, rectangle.height);
        }
        catch (JRStopEngineException jRStopEngineException) {
            JOptionPane.showMessageDialog(this, jRStopEngineException.getMessage(), JViewResource.getMessage("TV_ERROR"), 0);
            jRStopEngineException.printStackTrace();
        }
        this.viewerHolder.reload();
    }

    public void scrolls(int n, int n2) {
        if (this.jviewerHolder != null) {
            this.jviewerHolder.scrolls(n, n2);
        }
    }

    public void changeContentsSize() {
        JReportViewer jReportViewer = this.viewerHolder.getViewer();
        int n = jReportViewer.getCommunicator().getResolution();
        DataStream dataStream = jReportViewer.getDataStream();
        Rectangle rectangle = dataStream.getPageArea();
        rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
        rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
    }

    public void viewerSizeChanged(Dimension dimension) {
        this.hScrollbar.setMaximum(dimension.width);
        this.vScrollbar.setMaximum(dimension.height);
    }

    public void setScrollPosition(int n, int n2) {
        if (this.hScrollbar.getValue() != n) {
            this.hScrollbar.setValue(n - 25);
        }
        if (this.vScrollbar.getValue() != n2) {
            this.vScrollbar.setValue(n2 - 25);
        }
    }

    public int[] getScrollPosition() {
        int[] nArray = new int[]{};
        return nArray;
    }

    public void dispose() {
        if (this.tableOfContents != null && this.tableOfContents.isContentsOn()) {
            this.tableOfContents.dispose();
        }
        if (this.drillDownViewerPane != null) {
            this.drillDownViewerPane.dispose();
        }
        this.removeAllDrillDownCard();
        super.dispose();
    }

    public void setRptSheet(String string) {
        this.rptsheet = string;
    }

    protected String getRptSheet() {
        return this.rptsheet;
    }

    public void setRAHTTPInput(RAHTTPInput rAHTTPInput) {
        this.raf = rAHTTPInput;
    }

    public void setURLView(String string) {
        this.urlView = string;
    }
}

