/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import jet.connect.DbBinary;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.JRObjectResult;
import jet.thinviewer.JReportBox;
import jet.thinviewer.ViewerTools;
import jet.util.BitmapReader;
import jet.util.PictureFileFormatDetector;
import jet.util.PropertySetable;

public class JReportMediaField
extends JReportBox {
    private Image I;

    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        JRObjectResult jRObjectResult = (JRObjectResult)propertySetable;
        this.I = null;
        JRecord jRecord = ((JRObjectResult)propertySetable).getRecord();
        String string = this.getStringPropertyByName(jRObjectResult, "ColumnName");
        DbBinary dbBinary = (DbBinary)jRecord.getCell(string);
        if (!dbBinary.isNull()) {
            byte[] byArray = dbBinary.get();
            int n = this.getIntPropertyByName(jRObjectResult, "MediaType");
            if (byArray != null && byArray.length > 0) {
                BitmapReader bitmapReader;
                if (n == 2) {
                    n = PictureFileFormatDetector.getPictureFileType(byArray);
                }
                MediaTracker mediaTracker = new MediaTracker(this);
                if (n == 0) {
                    this.I = Toolkit.getDefaultToolkit().createImage(byArray);
                } else if (n == 1 && (bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream(byArray)))) != null) {
                    this.I = this.createImage(bitmapReader.getMemImgSrc());
                }
                if (this.I != null) {
                    mediaTracker.addImage(this.I, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        ViewerTools.I(2401506, interruptedException);
                    }
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.I != null) {
            int n;
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(0, -this.startY, dimension.width, dimension.height);
            if (this.leftStyle != 0) {
                n = (this.leftStyle == 5 ? 3 : 1) * this.borderWidth;
                rectangle.x += n;
                rectangle.width -= n;
            }
            if (this.topStyle != 0) {
                n = (this.topStyle == 5 ? 3 : 1) * this.borderWidth;
                rectangle.y += n;
                rectangle.height -= n;
            }
            if (this.rightStyle != 0) {
                rectangle.width = rectangle.width - (this.rightStyle == 5 ? 3 : 1) * this.borderWidth;
            }
            if (this.bottomStyle != 0) {
                rectangle.height = rectangle.height - (this.bottomStyle == 5 ? 3 : 1) * this.borderWidth;
            }
            rectangle.width = rectangle.width - (this.drawShadow ? this.shadowWidth : 0);
            rectangle.height = rectangle.height - (this.drawShadow ? this.shadowWidth : 0);
            graphics.drawImage(this.I, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        }
    }
}

