/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import guitools.GuiUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.exception.ParseFormulaFailedException;
import jet.log.JRLogger;
import jet.universe.AliasColumnInfoList;
import jet.universe.JetShare;
import jet.universe.JetUCloneable;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJoinPath;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.UMapTable;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.psql.JetRptPsqlQuery;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import jet.util.HashVector;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;

public class JetUQuery
extends JetUResourceContainer
implements JetUQueriable,
JetUCloneable {
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 99);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    public JetShare share = new JetShare(this, "Share", true);
    public JetBoolean enableSQLStmtCreator = new JetBoolean(this, "EnableSQLStmtCreator", false);
    public JetBoolean enableSQLNameAnalyser = new JetBoolean(this, "EnableSQLNameAnalyser", false);
    protected transient UMapTable mapTable = new UMapTable();
    protected RptPsqlQuery psqlQuery = null;
    Vector GetFieldByRealName = new Vector();
    public JetString pathName = new JetString(this, "pathName");
    private static JRLogger InitAfterCreate;
    private AliasColumnInfoList InitAfterLoad = new AliasColumnInfoList();
    private static final HashMap InitQuery;
    private static final HashVector InitQueryFields;
    static Class class$jet$universe$JetUQuery;
    static final boolean $assertionsDisabled;

    public JetUQuery() {
        this.initialize();
    }

    public JetUQuery(String string, String string2) {
        super(string, string2);
        this.initialize();
    }

    public JetUQuery(String string, RptPsqlQuery rptPsqlQuery) {
        super(string, "");
        this.initialize();
        this.psqlQuery = rptPsqlQuery;
        rptPsqlQuery.setMappingName(string);
        this.pathName.set(rptPsqlQuery.getPathName());
    }

    protected void initialize() {
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
        this.enableSQLNameAnalyser.setEditFlag(3);
        this.$assertionsDisabled();
    }

    private void $assertionsDisabled() {
        String string = "General";
    }

    public void InitAfterCreate() {
        this.IsMappingNameOK(this.psqlQuery);
        this.InitQuery();
        super.InitAfterCreate();
    }

    private void GetFieldByRealName(UMapTable uMapTable) {
        Vector vector = this.getFields();
        JetObject jetObject = null;
        Object var4_4 = null;
        int n = 0;
        while (n < vector.size()) {
            JetUFldQueryField jetUFldQueryField;
            jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof JetUCompColQueryField) {
                uMapTable.addElement((JetUResourceEntity)jetObject);
            } else if (jetObject instanceof JetUFldQueryField && (jetUFldQueryField = (JetUFldQueryField)jetObject).getCorrName() != null && jetUFldQueryField.getCorrName().trim().length() > 0) {
                uMapTable.addElement(jetUFldQueryField);
            }
            ++n;
        }
    }

    private void InitAfterCreate(UMapTable uMapTable) {
        Vector vector = this.getFields();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            JetUFldQueryField jetUFldQueryField;
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUCompColQueryField) {
                uMapTable.removeElement((JetUResourceEntity)jetObject);
            } else if (jetObject instanceof JetUFldQueryField && (jetUFldQueryField = (JetUFldQueryField)jetObject).getCorrName() != null && jetUFldQueryField.getCorrName().trim().length() > 0) {
                uMapTable.removeElement(jetUFldQueryField);
            }
            ++n2;
        }
    }

    void Z(UMapTable uMapTable) {
        this.GetFieldByRealName(uMapTable);
        if (uMapTable.hashCode() == this.mapTable.hashCode()) {
            UMapTable uMapTable2 = this.getDatabase().mapTable;
            this.GetFieldByRealName(uMapTable2);
        }
    }

    void I(UMapTable uMapTable) {
        this.InitAfterCreate(uMapTable);
        if (uMapTable.hashCode() == this.mapTable.hashCode()) {
            UMapTable uMapTable2 = this.getDatabase().mapTable;
            this.InitAfterCreate(uMapTable2);
        }
    }

    public void InitAfterLoad() {
        Vector vector = this.getChildren();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetRptPsqlQuery) {
                JetRptPsqlQuery jetRptPsqlQuery = (JetRptPsqlQuery)jetObject;
                this.psqlQuery = new RptPsqlQuery();
                JetUDatabase jetUDatabase = this.getDatabase();
                this.psqlQuery.setUniverse(jetUDatabase.getUniverse(), jetUDatabase.getResourceName());
                this.psqlQuery.getFromJetObject(jetRptPsqlQuery);
                this.psqlQuery.setPathName(this.pathName.get());
                break;
            }
            ++n2;
        }
        super.InitAfterLoad();
        this.InitQuery(this.psqlQuery);
    }

    void I() {
        JetObject jetObject;
        Vector vector = (Vector)this.getChildren().clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetRptPsqlQuery) {
                this.remove(n2);
            }
            ++n2;
        }
        jetObject = this.psqlQuery.createJetObject();
        this.add(jetObject);
    }

    protected void InitQuery() {
        JetUDBTreeNode jetUDBTreeNode;
        String string = null;
        boolean bl = false;
        Hashtable hashtable = this.psqlQuery.getParameterValuePairs();
        this.psqlQuery.prepareWhereClauseString(false);
        string = this.psqlQuery.getFormulaSelectionString();
        this.pathName.set(this.psqlQuery.getPathName());
        if (!string.equals("")) {
            jetUDBTreeNode = this.getWhereFormula();
            if (jetUDBTreeNode == null || !string.equals(((JetUFormula)jetUDBTreeNode).getExpression())) {
                if (jetUDBTreeNode == null) {
                    jetUDBTreeNode = this.createWhereFormula("~WhereFormula@" + this.getResourceName(), string);
                } else {
                    ((JetUFormula)jetUDBTreeNode).setExpression(string);
                }
                bl = true;
            }
        } else if (this.getWhereFormula() != null) {
            this.deleteWhereFormula();
            bl = true;
        }
        if (bl) {
            try {
                jetUDBTreeNode = this.getDatabase();
                ((JetUDatabase)jetUDBTreeNode).parseFormulas(false);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                // empty catch block
            }
        }
        this.InitQueryFields();
    }

    public String getWhereFormulaName() {
        String string = null;
        JetUWhereFormula jetUWhereFormula = this.getWhereFormula();
        string = jetUWhereFormula != null ? jetUWhereFormula.getResourceName() : null;
        return string;
    }

    public JetUWhereFormula createWhereFormula(String string, String string2) {
        JetUWhereFormula jetUWhereFormula = new JetUWhereFormula(string, "", string2);
        this.add(jetUWhereFormula);
        jetUWhereFormula.InitAfterCreate();
        return jetUWhereFormula;
    }

    public JetUWhereFormula deleteWhereFormula() {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUWhereFormula) {
                this.remove(n2);
                return (JetUWhereFormula)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUWhereFormula getWhereFormula() {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUWhereFormula) {
                return (JetUWhereFormula)jetObject;
            }
            ++n2;
        }
        return null;
    }

    protected void InitQueryFields() {
        Vector vector = this.psqlQuery.getSelColsVector();
        int n = 0;
        while (n < vector.size()) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n);
            if (!psqlSelColumn.isHide()) {
                this.addField(psqlSelColumn);
            }
            ++n;
        }
    }

    public void setResourceName(String string) {
        super.setResourceName(string);
        if (this.psqlQuery != null) {
            this.psqlQuery.setMappingName(string);
        }
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation.set(new Integer(n));
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int n) {
        this.readOnly.set(new Integer(n));
    }

    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public void setMaxRows(int n) {
        this.maxRows.set(n);
    }

    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int n) {
        this.maxDuration.set(n);
    }

    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    public JetUDBTreeNode copy() {
        JetUDatabase jetUDatabase = this.getDatabase();
        String string = this.getResourceName();
        int n = 1;
        String string2 = "Copy of " + string;
        while (jetUDatabase.IsQueryNameExist(string2)) {
            string2 = "Copy (" + String.valueOf(++n) + ") of " + string;
        }
        RptPsqlQuery rptPsqlQuery = this.getPsqlQuery().getCopy();
        JetUQuery jetUQuery = new JetUQuery(string2, rptPsqlQuery);
        JetObject.copyProperties(jetUQuery, this);
        jetUQuery.setResourceName(string2);
        jetUQuery.removeBL();
        JBusinessLogic jBusinessLogic = this.getBL();
        jetUQuery.add((JetObject)((Object)(jBusinessLogic == null ? null : jBusinessLogic.copy())));
        return jetUQuery;
    }

    public String getSQLString() {
        this.psqlQuery.prepareWhereClauseString(false);
        return this.psqlQuery.getRawQueryString(true);
    }

    public RptPsqlQuery getPsqlQuery() {
        return this.psqlQuery;
    }

    public void setPsqlQuery(RptPsqlQuery rptPsqlQuery) {
        this.IsMappingNameOK(rptPsqlQuery);
        this.psqlQuery = rptPsqlQuery;
        this.psqlQuery.setMappingName(this.getResourceName());
        UMapTable uMapTable = this.getDatabase().getMapTable();
        this.I(uMapTable);
        this.removeAllFields();
        this.InitQuery();
        this.objectModified();
        JetUUniverse.objectChanged(this.getUniverse(), this, 1002);
        this.Z(uMapTable);
    }

    public Vector getFields() {
        return this.GetFieldByRealName;
    }

    public JetUResourceEntity getFieldByResourceName(String string) {
        int n = this.GetFieldByRealName.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)this.GetFieldByRealName.elementAt(n2);
            if (jetUQueryField.getResourceName().equalsIgnoreCase(string)) {
                return jetUQueryField;
            }
            ++n2;
        }
        return null;
    }

    protected synchronized JetObject _addField(JetUQueryField jetUQueryField, int n) {
        if (jetUQueryField != null) {
            JetContainable jetContainable = jetUQueryField.getParent();
            if (jetContainable != null) {
                if (jetContainable == this) {
                    return jetUQueryField;
                }
                jetContainable.remove(jetUQueryField);
            }
            if (n == -1) {
                this.GetFieldByRealName.addElement(jetUQueryField);
            } else {
                this.GetFieldByRealName.insertElementAt(jetUQueryField, n);
            }
            jetUQueryField.setParent(this);
            this.objectModified();
        }
        return jetUQueryField;
    }

    protected JetObject _removeField(JetUQueryField jetUQueryField) {
        this.objectModified();
        this.GetFieldByRealName.removeElement(jetUQueryField);
        jetUQueryField.setParent(null);
        return jetUQueryField;
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetRptPsqlQuery || jetObject instanceof JetUJoinPath || jetObject instanceof BusinessLogic || jetObject instanceof JetUWhereFormula)) {
            throw new AssertionError((Object)("Invalid child of JetUQuery! " + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public void addField(PsqlSelColumn psqlSelColumn) {
        JetUQueryField jetUQueryField;
        String string = psqlSelColumn.getMappingName();
        if (string == null) {
            string = this.getDefaultQueryFieldName(psqlSelColumn);
        }
        if (psqlSelColumn instanceof RptPsqlFormulaColumn) {
            DbColDesc dbColDesc;
            jetUQueryField = new JetUFmlQueryField(string, "", psqlSelColumn);
            JetUDatabase jetUDatabase = this.getDatabase();
            JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(psqlSelColumn.getName());
            if (jetUFormula != null && (dbColDesc = jetUFormula.getColDesc()) != null) {
                jetUQueryField.setSqlType(dbColDesc.getSqlType());
                jetUQueryField.setPrecision(dbColDesc.getPrecision());
                jetUQueryField.setScale(dbColDesc.getScale());
                jetUQueryField.setNullable(dbColDesc.getNullable());
            }
        } else if (psqlSelColumn.isCompCol()) {
            jetUQueryField = new JetUCompColQueryField(string, "", psqlSelColumn);
        } else {
            PsqlTable psqlTable = psqlSelColumn.getPsqlTable();
            String string2 = psqlTable.getMappingName();
            String string3 = psqlTable.getNameCorr();
            String string4 = psqlTable.getShowName(true);
            JetUConnection jetUConnection = (JetUConnection)psqlTable.getDataObj();
            jetUQueryField = new JetUFldQueryField(string, "", psqlSelColumn, jetUConnection, string2, string3, string4);
            JetUDatabase jetUDatabase = this.getDatabase();
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(psqlSelColumn.getMappingName());
            if (jetUResourceEntity instanceof JetUField) {
                JetUField jetUField = (JetUField)jetUResourceEntity;
                jetUQueryField.currency.set(jetUField.currency.get());
            }
        }
        this.addField(jetUQueryField);
    }

    public String getDefaultQueryFieldName(PsqlSelColumn psqlSelColumn) {
        return JetUQuery.getDefaultQueryFieldName(this.getDatabase(), psqlSelColumn);
    }

    public void addField(JetUQueryField jetUQueryField) {
        this._addField(jetUQueryField, -1);
        jetUQueryField.InitAfterCreate();
    }

    public JetUQueryField removeField(JetUQueryField jetUQueryField) {
        jetUQueryField.I.setHide(true);
        this._removeField(jetUQueryField);
        return jetUQueryField;
    }

    protected void removeAllFields() {
        Vector vector = (Vector)this.getFields().clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            this._removeField(jetUQueryField);
            ++n2;
        }
    }

    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    public UMapTable getMapTable() {
        return this.mapTable;
    }

    void Z() {
        this.psqlQuery.resolveAll(this.getDatabase().getUniverse());
        if (this.psqlQuery.isResolved()) {
            this.InitQueryFields();
        }
    }

    public boolean isResolvedOK() {
        boolean bl = this.psqlQuery.isResolved();
        return bl;
    }

    public String check() {
        return this.psqlQuery.check();
    }

    public JetUResourceEntity getResourceByName(String string) {
        return this.mapTable.getResourceByName(string.toUpperCase());
    }

    public JetUFldQueryField getQueryFieldBy3PartName(String string) {
        Vector vector = this.getFields();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField instanceof JetUFldQueryField && string.equalsIgnoreCase(((JetUFldQueryField)jetUQueryField).get3PartName())) {
                return (JetUFldQueryField)jetUQueryField;
            }
            ++n2;
        }
        return null;
    }

    public JetUFldQueryField getSameFieldInQuery(JetUField jetUField) {
        return this.getQueryFieldBy3PartName(jetUField.get3PartName());
    }

    public JetUFldQueryField getSameFieldInQuery(JetUFldQueryField jetUFldQueryField) {
        return this.getQueryFieldBy3PartName(jetUFldQueryField.get3PartName());
    }

    public boolean isThereSameFieldInQuery(JetUField jetUField) {
        return this.getSameFieldInQuery(jetUField) != null;
    }

    public boolean isThereSameFieldInQuery(JetUFldQueryField jetUFldQueryField) {
        return this.getSameFieldInQuery(jetUFldQueryField) != null;
    }

    public boolean isQueryFieldInQuery(JetUQueryField jetUQueryField) {
        Vector vector = this.getFields();
        return vector.contains(jetUQueryField);
    }

    public boolean isThereSameFieldInQuery(JetUFormula jetUFormula) {
        Vector vector = this.getFields();
        int n = vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField instanceof JetUFmlQueryField && ((JetUFmlQueryField)jetUQueryField).getFomulaName().equalsIgnoreCase(jetUFormula.getResourceName())) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isThereSameFieldInQuery(JetUFmlQueryField jetUFmlQueryField) {
        Vector vector = this.getFields();
        int n = vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField instanceof JetUFmlQueryField && ((JetUFmlQueryField)jetUQueryField).getFomulaName().equalsIgnoreCase(jetUFmlQueryField.getFomulaName())) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(this.getResourceName(), string);
        if (jetUResourceEntity == null) {
            throw new CannotFindEntity(string);
        }
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity);
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string, String string2) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity jetUResourceEntity;
        String string3 = this.getResourceName();
        JetUResourceEntity jetUResourceEntity2 = jetUUniverse.getResourceByName(string2, string3, string);
        if (jetUResourceEntity2 == null && (jetUResourceEntity = jetUUniverse.getAnyResourceByName(string)) != null && jetUResourceEntity instanceof JetUParameter) {
            jetUResourceEntity2 = jetUResourceEntity;
        }
        if (jetUResourceEntity2 == null) {
            throw new CannotFindEntity(string);
        }
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity2, string2);
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bl = false;
        if (!$assertionsDisabled && jetUResourceEntity == null) {
            throw new AssertionError((Object)"entity can not be null");
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            bl = true;
        } else {
            if (jetUResourceEntity instanceof JetUFormula) {
                return this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse);
            }
            if (jetUResourceEntity instanceof JetUQueryField) {
                if (jetUResourceEntity instanceof JetUFldQueryField) {
                    bl = ((JetUQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (jetUResourceEntity instanceof JetUCompColQueryField) {
                    bl = ((JetUQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (jetUResourceEntity instanceof JetUFmlQueryField && ((JetUFmlQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName())) {
                    String string = jetUResourceEntity.getResourceName();
                    if ((jetUResourceEntity = jetUUniverse.getResourceByName(string)) == null) {
                        throw new CannotFindEntity(string);
                    }
                    bl = this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse);
                }
            }
        }
        return bl;
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bl = false;
        if (!$assertionsDisabled && jetUResourceEntity == null) {
            throw new AssertionError((Object)"entity can not be null");
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            bl = true;
        } else {
            if (jetUResourceEntity instanceof JetUFormula) {
                return this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse, string);
            }
            if (jetUResourceEntity instanceof JetUQueryField) {
                if (jetUResourceEntity instanceof JetUFldQueryField) {
                    bl = ((JetUQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (jetUResourceEntity instanceof JetUCompColQueryField) {
                    bl = ((JetUQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (jetUResourceEntity instanceof JetUFmlQueryField && ((JetUFmlQueryField)jetUResourceEntity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName())) {
                    String string2 = jetUResourceEntity.getResourceName();
                    if ((jetUResourceEntity = jetUUniverse.getMaterialByName(string, string2)) == null) {
                        throw new CannotFindEntity(string2);
                    }
                    bl = this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse, string);
                }
            }
        }
        return bl;
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(jetUFormula, this.getUniverse());
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector vector = jetUFormula.getRefDbFld();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                try {
                    if (!this.isFieldValidToQuery(jetUUniverse, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string);
                }
                ++n2;
            }
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string = (String)vector2.elementAt(n3);
            try {
                if (!this.isFieldValidToQuery(jetUUniverse, string)) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string);
            }
            ++n3;
        }
        Vector vector3 = jetUFormula.getGroupByVector();
        n = vector3.size();
        int n4 = 0;
        while (n4 < n) {
            String string = (String)vector3.elementAt(n4);
            try {
                if (!(jetUFormula instanceof JetUSummary && JetUDatabase.I(string) || string.equalsIgnoreCase("Report") || this.isFieldValidToQuery(jetUUniverse, string))) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string);
            }
            ++n4;
        }
        return true;
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector vector = jetUFormula.getRefDbFld();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)vector.elementAt(n2);
                try {
                    if (!this.isFieldValidToQuery(jetUUniverse, string2, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string2);
                }
                ++n2;
            }
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string3 = (String)vector2.elementAt(n3);
            try {
                if (!this.isFieldValidToQuery(jetUUniverse, string3, string)) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string3);
            }
            ++n3;
        }
        Vector vector3 = jetUFormula.getGroupByVector();
        n = vector3.size();
        int n4 = 0;
        while (n4 < n) {
            String string4 = (String)vector3.elementAt(n4);
            try {
                if (!(jetUFormula instanceof JetUSummary && JetUDatabase.I(string4) || string4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(jetUUniverse, string4, string))) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string4);
            }
            ++n4;
        }
        return true;
    }

    public Vector getFormulas() {
        Vector vector = this.getFields();
        Vector<JetUQueryField> vector2 = new Vector<JetUQueryField>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField instanceof JetUFmlQueryField) {
                vector2.addElement(jetUQueryField);
            }
            ++n2;
        }
        return vector2;
    }

    public JetUFmlQueryField getFmlFieldByFmlName(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = this.getFields();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField instanceof JetUFmlQueryField && string.equalsIgnoreCase(((JetUFmlQueryField)jetUQueryField).getFomulaName())) {
                return (JetUFmlQueryField)jetUQueryField;
            }
            ++n2;
        }
        return null;
    }

    public static String getDefaultQueryFieldName(JetUDatabase jetUDatabase, PsqlSelColumn psqlSelColumn) {
        String string = null;
        if (psqlSelColumn instanceof RptPsqlFormulaColumn) {
            string = psqlSelColumn.getName();
        } else if (psqlSelColumn.isCompCol()) {
            string = psqlSelColumn.getName();
        } else {
            PsqlTable psqlTable = psqlSelColumn.getPsqlTable();
            JetUConnection jetUConnection = (JetUConnection)psqlTable.getDataObj();
            JetUField jetUField = jetUDatabase.GetFieldByRealName(jetUConnection.getResourceName(), psqlTable.getMappingName(), psqlSelColumn.getName());
            string = psqlTable.getCorrelationName() != null ? psqlTable.getNameCorr() + "_" + jetUField.getResourceName() : jetUField.getResourceName();
        }
        return string;
    }

    public Vector getDBFields() {
        Vector<JetUQueryField> vector = new Vector<JetUQueryField>();
        int n = this.GetFieldByRealName.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)this.GetFieldByRealName.elementAt(n2);
            if (!(jetUQueryField instanceof JetUFmlQueryField)) {
                vector.addElement(jetUQueryField);
            }
            ++n2;
        }
        return vector;
    }

    public void clearMem() {
        int n;
        int n2 = n = this.GetFieldByRealName.size();
        while (--n2 >= 0) {
            try {
                ((JetObject)this.GetFieldByRealName.elementAt(n2)).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.GetFieldByRealName.removeAllElements();
        if (this.psqlQuery != null) {
            this.psqlQuery.setUniverse(null);
            this.psqlQuery.clearMem();
            this.psqlQuery = null;
        }
        if (this.mapTable != null) {
            this.mapTable.clearMem();
            this.mapTable = null;
        }
    }

    public boolean replaceFldName(String string, String string2) {
        Vector vector = this.getFields();
        int n = vector == null ? 0 : vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField.getResourceName().equalsIgnoreCase(string)) {
                jetUQueryField.setResourceName(string2);
                bl = true;
            }
            ++n2;
        }
        if (this.psqlQuery.replaceFldName(string, string2)) {
            bl = true;
        }
        return bl;
    }

    public boolean replaceFieldName(String string, String string2) {
        Vector vector = this.getFields();
        int n = vector == null ? 0 : vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n2);
            if (jetUQueryField.getResourceName().equalsIgnoreCase(string)) {
                jetUQueryField.setResourceName(string2);
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean replaceTabName(String string, String string2) {
        boolean bl = false;
        Vector vector = this.getFields();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUQueriableField jetUQueriableField = (JetUQueriableField)vector.elementAt(n2);
            if (jetUQueriableField instanceof JetUFldQueryField && ((JetUFldQueryField)jetUQueriableField).getTableName().equalsIgnoreCase(string)) {
                ((JetUFldQueryField)jetUQueriableField).setTableName(string2);
                bl = true;
            }
            ++n2;
        }
        if (this.psqlQuery.replaceTabName(string, string2)) {
            bl = true;
        }
        return bl;
    }

    public Vector getAutoGroupFields() {
        return null;
    }

    public String[] getUsedFiled() {
        String string;
        String[] stringArray = new String[this.GetFieldByRealName.size()];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = stringArray.length;
        while (--n >= 0) {
            JetUQueryField jetUQueryField = (JetUQueryField)this.GetFieldByRealName.elementAt(n);
            stringArray[n] = string = jetUQueryField.getResourceName();
            hashtable.put(string, jetUQueryField);
        }
        int n2 = 0;
        int n3 = this.psqlQuery.vPsqlJoin.size();
        String[] stringArray2 = new String[n3 + n3];
        int n4 = 0;
        while (n4 < n3) {
            PsqlJoin psqlJoin = (PsqlJoin)this.psqlQuery.vPsqlJoin.elementAt(n4);
            string = psqlJoin.getColumnFrom().mappingName;
            if (hashtable.get(string) == null) {
                stringArray2[n2++] = string;
                hashtable.put(string, string);
            }
            if (hashtable.get(string = psqlJoin.getColumnTo().mappingName) == null) {
                stringArray2[n2++] = string;
                hashtable.put(string, string);
            }
            ++n4;
        }
        if (n2 > 0) {
            String[] stringArray3 = new String[stringArray.length + n2];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, n2);
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public String getUsername() {
        return this.psqlQuery.getUsername();
    }

    public String getPassword() {
        return this.psqlQuery.getPassword();
    }

    public void setUsername(String string) {
        this.psqlQuery.setUsername(string);
    }

    public void setPassword(String string) {
        this.psqlQuery.setPassword(string);
    }

    public String getInstancePrefix() {
        return "Query";
    }

    public boolean isSimilar(JetUResourceContainer jetUResourceContainer) {
        boolean bl = super.isSimilar(jetUResourceContainer);
        if (bl) {
            bl = GuiUtil.areEqual(this.getSQLString(), ((JetUQuery)jetUResourceContainer).getSQLString());
        }
        if (bl) {
            bl = this.InitAfterLoad((JetUQuery)jetUResourceContainer);
        }
        return bl;
    }

    public boolean isEqual(JetUResourceContainer jetUResourceContainer) {
        boolean bl = super.isEqual(jetUResourceContainer);
        if (bl) {
            bl = GuiUtil.areEqual(this.getSQLString(), ((JetUQuery)jetUResourceContainer).getSQLString());
        }
        if (bl) {
            bl = this.InitAfterLoad((JetUQuery)jetUResourceContainer);
        }
        return bl;
    }

    private boolean InitAfterLoad(JetUQuery jetUQuery) {
        JBusinessLogic jBusinessLogic;
        JBusinessLogic jBusinessLogic2 = this.getBL();
        if (jBusinessLogic2 == (jBusinessLogic = jetUQuery.getBL())) {
            return true;
        }
        if (jBusinessLogic2 == null) {
            return jBusinessLogic == null;
        }
        return jBusinessLogic2.isSimilar(jBusinessLogic);
    }

    private void InitQuery(RptPsqlQuery rptPsqlQuery) {
        Vector vector = rptPsqlQuery.vSelCols;
        int n = 0;
        while (n < vector.size()) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n);
            String string = psqlSelColumn.corr;
            if (string != null && string.length() != 0) {
                String string2 = psqlSelColumn.sTableName;
                this.InitAfterLoad.addItem(psqlSelColumn.corr, string2, psqlSelColumn.getName(), psqlSelColumn.mappingName);
            }
            ++n;
        }
    }

    private String InitQueryFields(String string) {
        StringBuffer stringBuffer;
        String string2;
        JetUDatabase jetUDatabase = this.getDatabase();
        boolean bl = jetUDatabase.IsMappingNameOK(string2 = string, stringBuffer = new StringBuffer());
        if (!bl) {
            int n = 1;
            String string3 = string2;
            while (!bl) {
                string2 = string3 + "_" + n;
                ++n;
                bl = jetUDatabase.IsMappingNameOK(string2, stringBuffer);
            }
        }
        return string2;
    }

    private void IsMappingNameOK(RptPsqlQuery rptPsqlQuery) {
        Vector vector = rptPsqlQuery.vSelCols;
        int n = 0;
        while (n < vector.size()) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n);
            String string = psqlSelColumn.corr;
            if (string != null && string.length() != 0) {
                String string2 = psqlSelColumn.sTableName;
                String string3 = this.InitAfterLoad.getColumnMappingName(string, string2, psqlSelColumn.name);
                if (string3 != null) {
                    if (string3.equalsIgnoreCase(psqlSelColumn.mappingName)) {
                        psqlSelColumn.mappingName = string3;
                    }
                } else {
                    psqlSelColumn.mappingName = this.InitQueryFields(psqlSelColumn.mappingName);
                }
            }
            ++n;
        }
        this.InitAfterLoad.clear();
        this.InitQuery(this.psqlQuery);
    }

    public JBusinessLogic newBL(String string) throws BLIlegalNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic businessLogic = new BusinessLogic();
        try {
            businessLogic.setName(string);
        }
        catch (BLDupleNameException bLDupleNameException) {
            bLDupleNameException.printStackTrace();
        }
        this.add(businessLogic);
        return businessLogic;
    }

    public void removeBL() {
        JBusinessLogic jBusinessLogic = this.getBL();
        if (jBusinessLogic != null) {
            this.remove((JetObject)((Object)jBusinessLogic));
        }
    }

    public JBusinessLogic getBL() {
        Vector vector = this.getChildren();
        JBusinessLogic jBusinessLogic = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            JetObject jetObject = (JetObject)iterator.next();
            if (!(jetObject instanceof JBusinessLogic)) continue;
            jBusinessLogic = (JBusinessLogic)((Object)jetObject);
        }
        return jBusinessLogic;
    }

    public HashMap getIndecialMap() {
        return InitQuery;
    }

    public HashVector getPropGrpsDesc() {
        return InitQueryFields;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUQuery == null ? (class$jet$universe$JetUQuery = JetUQuery.class$("jet.universe.JetUQuery")) : class$jet$universe$JetUQuery).desiredAssertionStatus();
        InitAfterCreate = JRLogger.getLogger((class$jet$universe$JetUQuery == null ? (class$jet$universe$JetUQuery = JetUQuery.class$("jet.universe.JetUQuery")) : class$jet$universe$JetUQuery).getName());
        InitQuery = new HashMap(10);
        InitQuery.put("TransactionIsolation", new Integer(0));
        InitQuery.put("Name", new Integer(1));
        InitQuery.put("maxRows", new Integer(2));
        InitQuery.put("EnableSQLStmtCreator", new Integer(3));
        InitQuery.put("Description", new Integer(4));
        InitQuery.put("ReadOnly", new Integer(5));
        InitQuery.put("EnableSQLNameAnalyser", new Integer(6));
        InitQuery.put("Share", new Integer(7));
        InitQuery.put("pathName", new Integer(8));
        InitQuery.put("maxDuration", new Integer(9));
        InitQueryFields = new HashVector(1);
        String string = null;
        Vector<String> vector = null;
        string = "General";
        vector = new Vector<String>(9);
        vector.add("Name");
        vector.add("Description");
        vector.add("pathName");
        vector.add("EnableSQLStmtCreator");
        vector.add("TransactionIsolation");
        vector.add("ReadOnly");
        vector.add("Share");
        vector.add("maxRows");
        vector.add("maxDuration");
        InitQueryFields.put(string, vector);
    }
}

