/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.upgrade.UpgradeReportPanelImpl;
import jet.upgrade.UpgradeReportSetImpl;
import jet.upgrade.UpgradeRpt;

public class UpgradeUtil {
    protected static final UpgradeRpt getUpgradeRpt(JetRptObject jetRptObject) throws JUpgradeNotSupportedException {
        if (jetRptObject instanceof JetRptReportPanel && jetRptObject.getParent() == null) {
            return new UpgradeReportPanelImpl();
        }
        if (jetRptObject instanceof JetRptReportSet) {
            JetRptReportSet jetRptReportSet = (JetRptReportSet)jetRptObject;
            int n = UpgradeReportSetImpl.getVersionInfo(jetRptReportSet);
            if (n == UpgradeReportSetImpl.HIGHER_VERSION) {
                throw new JUpgradeNotSupportedException(219001, new String[]{((JetRptReportSet)jetRptObject).major.get() + "", "9"}, null);
            }
            if (n == UpgradeReportSetImpl.SAME_VERSION) {
                return null;
            }
            return new UpgradeReportSetImpl();
        }
        return null;
    }

    public static final JetRptObject upgradeRpt(JetRptObject jetRptObject) throws JUpgradeNotSupportedException {
        return UpgradeUtil.upgradeRpt(jetRptObject, null);
    }

    public static final JetRptObject upgradeRpt(JetRptObject jetRptObject, JetUUniverse jetUUniverse) throws JUpgradeNotSupportedException {
        UpgradeRpt upgradeRpt = UpgradeUtil.getUpgradeRpt(jetRptObject);
        if (upgradeRpt == null) {
            return jetRptObject;
        }
        JetRptObject jetRptObject2 = null;
        if (jetRptObject instanceof JetRptReportPanel) {
            JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)jetRptObject;
            boolean bl = jetRptReportPanel.isBundled();
            JetUUniverse jetUUniverse2 = jetRptReportPanel.getDataSource().getUniverse();
            if (bl) {
                jetRptReportPanel.getDataSource().setUniverse(jetRptReportPanel.getDataSource().getBindUniverse());
            } else if (jetUUniverse != null) {
                jetRptReportPanel.getDataSource().setUniverse(jetUUniverse);
            } else {
                JetUUniverse jetUUniverse3 = JetUUniverse.GetCurrentUniverse();
                if (jetUUniverse3 != null) {
                    jetRptReportPanel.getDataSource().setUniverse(jetUUniverse3);
                } else {
                    throw new JUpgradeNotSupportedException(219002);
                }
            }
            jetRptObject2 = upgradeRpt.upgrade(jetRptReportPanel);
            jetRptReportPanel.getDataSource().setUniverse(jetUUniverse2);
        } else {
            jetRptObject2 = upgradeRpt.upgrade(jetRptObject);
        }
        return jetRptObject2;
    }
}

