/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.Vector;
import jet.util.IntKeyHashNode;
import jet.util.IntVector;

public class IntKeyHashtable {
    private transient IntKeyHashNode[] QOIV;
    private transient int addElement;
    private int append;
    private float clone;

    public IntKeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.QOIV = new IntKeyHashNode[n];
        this.append = (int)((float)n * f);
    }

    public IntKeyHashtable(int n) {
        this(n, 0.618f);
    }

    public IntKeyHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < this.QOIV.length) {
            IntKeyHashNode intKeyHashNode = this.QOIV[n];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.Z.equals(object)) {
                    return true;
                }
                intKeyHashNode = intKeyHashNode.C;
            }
            ++n;
        }
        return false;
    }

    public synchronized IntVector getKeys(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntVector intVector = new IntVector(5);
        int n = 0;
        while (n < this.QOIV.length) {
            IntKeyHashNode intKeyHashNode = this.QOIV[n];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.Z.equals(object)) {
                    intVector.addElement(intKeyHashNode.I);
                }
                intKeyHashNode = intKeyHashNode.C;
            }
            ++n;
        }
        return intVector;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntKeyHashNode intKeyHashNode = this.QOIV[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                return true;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        return false;
    }

    public synchronized Object get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntKeyHashNode intKeyHashNode = this.QOIV[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                return intKeyHashNode.Z;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        return null;
    }

    protected void rehash() {
        int n = this.QOIV.length;
        IntKeyHashNode[] intKeyHashNodeArray = this.QOIV;
        int n2 = n * 2 + 1;
        IntKeyHashNode[] intKeyHashNodeArray2 = new IntKeyHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.QOIV = intKeyHashNodeArray2;
        int n3 = 0;
        while (n3 < n) {
            IntKeyHashNode intKeyHashNode = intKeyHashNodeArray[n3];
            while (intKeyHashNode != null) {
                IntKeyHashNode intKeyHashNode2 = intKeyHashNode;
                intKeyHashNode = intKeyHashNode.C;
                int n4 = (intKeyHashNode2.I & Integer.MAX_VALUE) % n2;
                intKeyHashNode2.C = intKeyHashNodeArray2[n4];
                intKeyHashNodeArray2[n4] = intKeyHashNode2;
            }
            ++n3;
        }
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntKeyHashNode intKeyHashNode = this.QOIV[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                Object object2 = intKeyHashNode.Z;
                intKeyHashNode.Z = object;
                return object2;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, object);
        }
        IntKeyHashNode intKeyHashNode2 = new IntKeyHashNode();
        intKeyHashNode2.I = n;
        intKeyHashNode2.Z = object;
        intKeyHashNode2.C = this.QOIV[n2];
        this.QOIV[n2] = intKeyHashNode2;
        ++this.addElement;
        return null;
    }

    public synchronized Object remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        IntKeyHashNode intKeyHashNode = this.QOIV[n2];
        IntKeyHashNode intKeyHashNode2 = null;
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                if (intKeyHashNode2 != null) {
                    intKeyHashNode2.C = intKeyHashNode.C;
                } else {
                    this.QOIV[n2] = intKeyHashNode.C;
                }
                --this.addElement;
                return intKeyHashNode.Z;
            }
            intKeyHashNode2 = intKeyHashNode;
            intKeyHashNode = intKeyHashNode.C;
        }
        return null;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = null;
            ++n;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable(this.QOIV.length, this.clone);
        int n = 0;
        while (n < this.QOIV.length) {
            intKeyHashtable.QOIV[n] = this.QOIV[n] != null ? (IntKeyHashNode)this.QOIV[n].clone() : null;
            ++n;
        }
        return intKeyHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            int n = 0;
            while (n < this.QOIV.length) {
                IntKeyHashNode intKeyHashNode = this.QOIV[n];
                if (intKeyHashNode != null) {
                    do {
                        intVector.addElement(intKeyHashNode.I);
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<Object> vector = null;
        if (this.addElement != 0) {
            vector = new Vector<Object>();
            int n = 0;
            while (n < this.QOIV.length) {
                IntKeyHashNode intKeyHashNode = this.QOIV[n];
                if (intKeyHashNode != null) {
                    do {
                        vector.addElement(intKeyHashNode.Z);
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
        }
        return vector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.QOIV.length) {
                IntKeyHashNode intKeyHashNode = this.QOIV[n];
                if (intKeyHashNode != null) {
                    do {
                        stringBuffer.append("[").append(intKeyHashNode.I).append(",").append(intKeyHashNode.Z == this ? super.toString() : intKeyHashNode.Z).append("],");
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

