/*
 * Decompiled with CFR 0.152.
 */
package jet.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLWriter {
    protected PrintWriter fOut;
    protected boolean fCanonical;
    private String QOIV = null;
    private static boolean charAt = false;
    protected int fIndent;
    private boolean close = true;

    public XMLWriter() {
    }

    public XMLWriter(boolean bl) {
        this.fCanonical = bl;
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(OutputStream outputStream) {
        try {
            this.setOutput(outputStream, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void writeNode(Node node) {
        String string = null;
        if (string != null) {
            this.fOut.write(string);
        } else {
            this.write(node);
        }
    }

    public void writeNode(Node node, boolean bl) {
        if (bl && node instanceof Document) {
            this.QOIV = ((Document)node).getDocumentElement().getNodeName();
        }
        this.writeNode(node);
    }

    private void write(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fIndent = 0;
                Document document = (Document)node;
                if (!this.fCanonical) {
                    this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(string);
                    this.fOut.print("' '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                } else {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    this.fOut.println(" [");
                    this.fOut.print(string3);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                Node node2;
                this.close = false;
                if (this.fIndent > 0) {
                    this.fOut.print('\n');
                }
                this.printIndent();
                ++this.fIndent;
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes(), charAt);
                int n = 0;
                while (n < attrArray.length) {
                    node2 = attrArray[n];
                    this.fOut.print(' ');
                    this.fOut.print(node2.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(node2.getNodeValue());
                    this.fOut.print('\"');
                    ++n;
                }
                this.fOut.print('>');
                this.fOut.flush();
                node2 = node.getFirstChild();
                while (node2 != null) {
                    this.write(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node node3 = node.getFirstChild();
                    while (node3 != null) {
                        this.write(node3);
                        node3 = node3.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue());
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue());
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(string);
                }
                this.fOut.println("?>");
                this.fOut.flush();
                break;
            }
        }
        if (!(s != 1 || this.QOIV != null && node.getNodeName().equals(this.QOIV))) {
            --this.fIndent;
            if (this.close) {
                this.fOut.print('\n');
                this.printIndent();
                this.fOut.print("</");
            } else {
                this.fOut.print("</");
                this.close = true;
            }
            this.fOut.print(node.getNodeName());
            this.fOut.print(">");
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap, boolean bl) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < n - 1) {
                Object object;
                Object object2 = attrArray[n3].getNodeName();
                int n4 = n3;
                int n5 = n3 + 1;
                while (n5 < n) {
                    object = attrArray[n5].getNodeName();
                    if (((String)object).compareTo((String)object2) < 0) {
                        object2 = object;
                        n4 = n5;
                    }
                    ++n5;
                }
                if (n4 != n3) {
                    object = attrArray[n3];
                    attrArray[n3] = attrArray[n4];
                    attrArray[n4] = object;
                }
                ++n3;
            }
        }
        return attrArray;
    }

    protected void normalizeAndPrint(String string) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printIndent() {
        int n = 0;
        while (n < this.fIndent * 2) {
            this.fOut.print(' ');
            ++n;
        }
    }

    public void close() {
        this.fOut.close();
    }
}

