/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageDial;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class Graph2DGuageDials
extends Chart2DObject {
    float[] abs;
    float[] append;
    float[][] I;
    String[][][] axisY;
    Graph2DGuageDial[] contains;
    int cos;
    int Z;
    float C;
    float[][] floatValue;
    float[][] getAxisXProperties;
    float[][][] getAxisY;
    float[][] getAxisYProperties;
    Shape[] getBounds;
    Shape[] getCategorySize;
    Shape[] getChartDataSetModel;
    Shape[][] getDimension;
    Shape[][] getFilteredCategoryNames;
    Shape[][] getFormatedHintValue;
    Shape[][] getGaugeAlertValueMax;
    float[][][] getGaugeAlertValueMin;
    Line2D[][] getGaugeDialCurveStyle;
    Arc2D[] getGaugeDialLineStyle;
    Shape[][] getGaugeDialOuterInnerGap;
    ChartLabelBase[] getGaugeDialStartAngle;
    ChartLabelBase[] getGaugeDialStopAngle;
    private float getGaugeErrorValueMax;
    private float getGaugeErrorValueMin;
    float getGaugeNormalValueMax;
    float getGaugeNormalValueMin;
    float getHeight;
    double[][] getLabelAxisGap;
    Shape[][] getLabelBaseDimension;

    Graph2DGuageDials(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        super.init();
        this.Z = this.dataset.getSeriesSize();
        this.cos = this.dataset.getCategorySize();
        this.contains = new Graph2DGuageDial[this.cos];
        int n = 0;
        while (n < this.cos) {
            this.contains[n] = new Graph2DGuageDial(this, n);
            ++n;
        }
        this.getLabelAxisGap = new double[this.Z][this.cos];
        this.getGaugeNormalValueMin = this.objectProperties.getGaugeDialStartAngle();
        this.getHeight = this.objectProperties.getGaugeDialStopAngle();
        this.getGaugeNormalValueMax = this.getHeight - this.getGaugeNormalValueMin;
        this.QOIV();
        this.cos();
        this.contains();
        this.dataset();
    }

    private void QOIV() {
        this.I = new float[this.Z][this.cos];
        this.axisY = new String[this.Z][this.cos][3];
        int n = 0;
        while (n < this.Z) {
            int n2 = 0;
            while (n2 < this.cos) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n, n2);
                if (number == null) {
                    this.I[n][n2] = 0.0f;
                } else {
                    this.I[n][n2] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.axisY[n][n2] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n, n2);
                    } else {
                        this.axisY[n][n2][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void locate() {
        if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f) {
            this.append();
        } else {
            this.axisY();
        }
        this.floatValue();
        this.getAxisXProperties();
        this.getBounds();
        this.drilldown();
        this.getAxisYProperties();
        this.getCategorySize();
        this.getAxisY();
    }

    private int[] abs() {
        int[] nArray = new int[2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = Math.min(f, f2);
        float f4 = Math.max(f, f2);
        int n = 1;
        int n2 = 1;
        boolean bl = false;
        int n3 = 1;
        while (n3 <= this.cos) {
            n = n3;
            int n4 = 1;
            while (n4 <= (int)(f4 / (f3 / (float)n))) {
                if (n * n4 >= this.cos) {
                    n2 = n4;
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) break;
            ++n3;
        }
        if (f >= f2) {
            nArray[0] = n;
            nArray[1] = n2;
        } else {
            nArray[0] = n2;
            nArray[1] = n;
        }
        return nArray;
    }

    private void append() {
        int[] nArray = this.abs();
        this.floatValue = new float[this.cos][2];
        this.getAxisXProperties = new float[this.cos][2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = f2 / (float)nArray[0];
        float f4 = f / (float)nArray[1];
        float f5 = Math.min(f3 * 2.0f, f / (float)nArray[1]);
        float f6 = f5 / 2.0f;
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f4 - f5 * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f3 - f6 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.C = (int)(f6 * this.objectProperties.getRadiusRange());
        this.getGaugeErrorValueMax = this.objectProperties.getGaugeDialOuterInnerGap() > this.C ? this.C : this.objectProperties.getGaugeDialOuterInnerGap();
        this.getGaugeErrorValueMin = this.C - this.getGaugeErrorValueMax;
        int n = 0;
        while (n < this.cos) {
            int n2 = n / nArray[1];
            int n3 = n % nArray[1];
            this.floatValue[n][0] = f9 + (float)n3 * f4;
            this.floatValue[n][1] = f10 + (float)n2 * f3;
            this.getAxisXProperties[n][0] = this.floatValue[n][0] + this.C;
            this.getAxisXProperties[n][1] = this.floatValue[n][1] + this.C;
            ++n;
        }
    }

    private void axisY() {
        float f;
        this.floatValue = new float[this.cos][2];
        this.getAxisXProperties = new float[this.cos][2];
        int[] nArray = this.abs();
        float f2 = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f3 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f4 = f = Math.min(f3 / (float)nArray[0], f2 / (float)nArray[1]);
        float f5 = f2 / (float)nArray[1];
        float f6 = f3 / (float)nArray[0];
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f5 - f * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f6 - f4 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.C = (int)(f4 * this.objectProperties.getRadiusRange()) / 2;
        this.getGaugeErrorValueMax = this.objectProperties.getGaugeDialOuterInnerGap() > this.C ? this.C : this.objectProperties.getGaugeDialOuterInnerGap();
        this.getGaugeErrorValueMin = this.C - this.getGaugeErrorValueMax;
        int n = 0;
        while (n < this.cos) {
            int n2 = n / nArray[1];
            int n3 = n % nArray[1];
            this.floatValue[n][0] = f9 + (float)n3 * f5;
            this.floatValue[n][1] = f10 + (float)n2 * f6;
            this.getAxisXProperties[n][0] = this.floatValue[n][0] + this.C;
            this.getAxisXProperties[n][1] = this.floatValue[n][1] + this.C;
            ++n;
        }
    }

    private void contains() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.getGaugeDialStartAngle = new ChartLabelBase[n];
            int n2 = 0;
            while (n2 < n) {
                this.getGaugeDialStartAngle[n2] = new ChartLabelBase(stringArray[n2]);
                this.getGaugeDialStartAngle[n2].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
                ++n2;
            }
        }
    }

    private void cos() {
        float f;
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f3 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.abs = new float[3];
        this.append = new float[3];
        this.abs[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.abs[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.abs[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.append[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.append[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.append[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        int n = 0;
        while (n < 3) {
            if (this.abs[n] > this.append[n]) {
                f = this.abs[n];
                this.abs[n] = this.append[n];
                this.append[n] = f;
            }
            bl = this.append[n] == this.append[n] && this.append[n] == 0.0f && bl;
            ++n;
        }
        if (bl) {
            f = (f2 - f3) / 3.0f;
            int n2 = 0;
            while (n2 < 3) {
                this.abs[n2] = f3 + (float)n2 * f;
                this.append[n2] = this.abs[n2] + f;
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            if (this.abs[n3] < f3) {
                this.abs[n3] = f3;
            }
            if (this.abs[n3] > f2) {
                this.abs[n3] = f2;
            }
            if (this.append[n3] < f3) {
                this.append[n3] = f3;
            }
            if (this.append[n3] > f2) {
                this.append[n3] = f2;
            }
            ++n3;
        }
    }

    private void dataset() {
        String[] stringArray = ((ChartNumericAxis)this.layer.axisY).getLabels();
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        this.getGaugeDialStopAngle = new ChartLabelBase[n];
        int n2 = 0;
        while (n2 < n) {
            this.getGaugeDialStopAngle[n2] = new ChartLabelBase(stringArray[n - n2 - 1]);
            this.getGaugeDialStopAngle[n2].setChartTextStyle(this.paper.getProperties().getAxisYProperties().getLabelTextStyle());
            this.getGaugeDialStopAngle[n2].locate();
            ++n2;
        }
    }

    private void drilldown() {
        if (this.getGaugeDialStartAngle == null) {
            return;
        }
        int n = this.getGaugeDialStartAngle.length;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.getAxisYProperties = new float[n][2];
        int n2 = 0;
        while (n2 < n) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(this.getGaugeDialStartAngle[n2].getLabelText());
            if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f) {
                this.getAxisYProperties[n2][0] = (float)((double)this.getAxisXProperties[n2][0] - rectangle2D.getWidth() / 2.0);
                this.getAxisYProperties[n2][1] = this.getAxisXProperties[n2][1] + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
            } else {
                this.getAxisYProperties[n2][0] = (float)((double)this.getAxisXProperties[n2][0] - rectangle2D.getWidth() / 2.0);
                this.getAxisYProperties[n2][1] = (float)((double)this.getAxisXProperties[n2][1] - rectangle2D.getHeight() / 2.0) + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
            }
            ++n2;
        }
    }

    private void floatValue() {
        this.getChartDataSetModel = new Shape[this.cos];
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 0: 
            case 1: {
                this.getLabelBaseDimension = new Shape[1][this.cos];
                int n = 0;
                while (n < this.cos) {
                    this.getChartDataSetModel[n] = new Arc2D.Float(this.floatValue[n][0], this.floatValue[n][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    this.getLabelBaseDimension[0][n] = this.getChartDataSetModel[n];
                    ++n;
                }
                break;
            }
            case 2: {
                this.getLabelBaseDimension = new Shape[1][this.cos];
                int n = 0;
                while (n < this.cos) {
                    this.getChartDataSetModel[n] = new Arc2D.Float(this.floatValue[n][0] + this.getGaugeErrorValueMax, this.floatValue[n][1] + this.getGaugeErrorValueMax, this.getGaugeErrorValueMin * 2.0f, this.getGaugeErrorValueMin * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    this.getLabelBaseDimension[0][n] = this.getChartDataSetModel[n];
                    ++n;
                }
                break;
            }
            case 3: {
                this.getLabelBaseDimension = new Shape[2][this.cos];
                int n = 0;
                while (n < this.cos) {
                    Arc2D.Float float_ = new Arc2D.Float(this.floatValue[n][0], this.floatValue[n][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.floatValue[n][0] + this.getGaugeErrorValueMax, this.floatValue[n][1] + this.getGaugeErrorValueMax, this.getGaugeErrorValueMin * 2.0f, this.getGaugeErrorValueMin * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    this.getChartDataSetModel[n] = new GeneralPath(float_);
                    ((GeneralPath)this.getChartDataSetModel[n]).append(float_2, false);
                    this.getLabelBaseDimension[0][n] = float_;
                    this.getLabelBaseDimension[1][n] = float_2;
                    ++n;
                }
                break;
            }
        }
    }

    private void getAxisXProperties() {
        int n = ((ChartNumericAxis)this.layer.getAxisY()).getNumOfTick();
        float f = this.paper.getProperties().getAxisYProperties().getTickMarkLength();
        float f2 = this.paper.getProperties().getAxisYProperties().getMinorTickMarkLength();
        float f3 = this.paper.getProperties().getAxisYProperties().getLabelAxisGap();
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisYProperties().getLabelTextStyle();
        float[][] fArray = new float[2][2];
        float[][] fArray2 = new float[2][2];
        this.getDimension = new Shape[this.cos][2 * n + 1];
        this.getAxisY = new float[this.cos][n + 1][2];
        int n2 = 0;
        while (n2 < this.cos) {
            double d = (double)this.getGaugeNormalValueMax / (2.0 * (double)n);
            int n3 = 0;
            while (n3 < 2 * n + 1) {
                this.getDimension[n2][n3] = new GeneralPath();
                double d2 = Math.cos((180.0 - (double)n3 * d - (double)this.getGaugeNormalValueMin) * Math.PI / 180.0);
                double d3 = Math.sin((180.0 - (double)n3 * d - (double)this.getGaugeNormalValueMin) * Math.PI / 180.0);
                switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
                    case 1: {
                        Cloneable cloneable;
                        if (n3 % 2 == 0) {
                            fArray[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C + f) * d2);
                            fArray[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C + f) * d3);
                            cloneable = this.getGaugeDialStopAngle[n3 / 2].getLabelBaseDimension();
                            float f4 = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C + f + f3) * d2);
                            float f5 = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C + f + f3) * d3);
                            this.getAxisY[n2][n3 / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f4 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f4 - (float)cloneable.width : f4);
                            this.getAxisY[n2][n3 / 2][1] = d3 >= 0.0 ? f5 - (float)cloneable.height : f5;
                        } else {
                            fArray[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C + f2) * d2);
                            fArray[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C + f2) * d3);
                        }
                        fArray[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)this.C * d2);
                        fArray[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)this.C * d3);
                        ((GeneralPath)this.getDimension[n2][n3]).moveTo(fArray[0][0], fArray[0][1]);
                        ((GeneralPath)this.getDimension[n2][n3]).lineTo(fArray[1][0], fArray[1][1]);
                        break;
                    }
                    case 2: {
                        Cloneable cloneable;
                        if (n3 % 2 == 0) {
                            fArray2[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.getGaugeErrorValueMin - f) * d2);
                            fArray2[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.getGaugeErrorValueMin - f) * d3);
                            cloneable = this.getGaugeDialStopAngle[n3 / 2].getLabelBaseDimension();
                            float f6 = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.getGaugeErrorValueMin - f - f3) * d2);
                            float f7 = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.getGaugeErrorValueMin - f - f3) * d3);
                            this.getAxisY[n2][n3 / 2][0] = Math.abs(d2 * 10.0) < 1.0 ? f6 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f6 : f6 - (float)cloneable.width);
                            this.getAxisY[n2][n3 / 2][1] = Math.abs(d3 * 10.0) < 1.0 ? f7 - (float)cloneable.height : (d3 > 0.0 ? f7 : f7 - (float)cloneable.height);
                        } else {
                            fArray2[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.getGaugeErrorValueMin - f2) * d2);
                            fArray2[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.getGaugeErrorValueMin - f2) * d3);
                        }
                        fArray2[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)this.getGaugeErrorValueMin * d2);
                        fArray2[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)this.getGaugeErrorValueMin * d3);
                        ((GeneralPath)this.getDimension[n2][n3]).moveTo(fArray2[0][0], fArray2[0][1]);
                        ((GeneralPath)this.getDimension[n2][n3]).lineTo(fArray2[1][0], fArray2[1][1]);
                        break;
                    }
                    case 3: {
                        Cloneable cloneable;
                        fArray[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)this.C * d2);
                        fArray[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)this.C * d3);
                        if (n3 % 2 == 0) {
                            fArray[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C - f) * d2);
                            fArray[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C - f) * d3);
                        } else {
                            fArray[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C - f2) * d2);
                            fArray[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C - f2) * d3);
                        }
                        fArray2[0][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)this.getGaugeErrorValueMin * d2);
                        fArray2[0][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)this.getGaugeErrorValueMin * d3);
                        if (n3 % 2 == 0) {
                            fArray2[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.getGaugeErrorValueMin + f) * d2);
                            fArray2[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.getGaugeErrorValueMin + f) * d3);
                        } else {
                            fArray2[1][0] = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.getGaugeErrorValueMin + f2) * d2);
                            fArray2[1][1] = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.getGaugeErrorValueMin + f2) * d3);
                        }
                        if (n3 % 2 == 0) {
                            cloneable = this.getGaugeDialStopAngle[n3 / 2].getLabelBaseDimension();
                            float f8 = (float)((double)this.getAxisXProperties[n2][0] - (double)((this.getGaugeErrorValueMin + this.C) / 2.0f) * d2);
                            float f9 = (float)((double)this.getAxisXProperties[n2][1] - (double)((this.getGaugeErrorValueMin + this.C) / 2.0f) * d3);
                            if (Math.abs(d3 * 10.0) < 1.0) {
                                this.getAxisY[n2][n3 / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.getAxisY[n2][n3 / 2][1] = f9 - (float)cloneable.height;
                            } else {
                                this.getAxisY[n2][n3 / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.getAxisY[n2][n3 / 2][1] = f9 - (float)(cloneable.height / 2);
                            }
                        }
                        cloneable = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                        Line2D.Float float_ = new Line2D.Float(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                        this.getDimension[n2][n3] = new GeneralPath((Shape)((Object)cloneable));
                        ((GeneralPath)this.getDimension[n2][n3]).append(float_, false);
                        break;
                    }
                    case 0: {
                        if (n3 % 2 != 0) break;
                        Dimension dimension = this.getGaugeDialStopAngle[n3 / 2].getLabelBaseDimension();
                        float f10 = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C + f3) * d2);
                        float f11 = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C + f3) * d3);
                        this.getAxisY[n2][n3 / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f10 - (float)(dimension.width / 2) : (d2 > 0.0 ? f10 - (float)dimension.width : f10);
                        if (d3 >= 0.0) {
                            this.getAxisY[n2][n3 / 2][1] = f11 - (float)dimension.height;
                            break;
                        }
                        this.getAxisY[n2][n3 / 2][1] = f11;
                        break;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void getAxisY() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        float[] fArray = new float[2];
        this.getGaugeDialOuterInnerGap = new Shape[this.Z][this.cos];
        this.getCategorySize = new Shape[this.Z];
        this.getGaugeDialCurveStyle = new Line2D[this.Z][this.cos];
        this.getGaugeDialLineStyle = new Arc2D[this.cos];
        this.getGaugeAlertValueMax = new Shape[this.Z][this.cos];
        this.getGaugeAlertValueMin = new float[this.Z][this.cos][2];
        int n = 0;
        while (n < this.Z) {
            this.getCategorySize[n] = new GeneralPath();
            int n2 = 0;
            while (n2 < this.cos) {
                this.getGaugeDialOuterInnerGap[n][n2] = new GeneralPath();
                if (!(this.I[n][n2] > f) && !(this.I[n][n2] < f2)) {
                    double d;
                    float f3 = 180.0f - this.getGaugeNormalValueMin - (float)((int)((f - this.I[n][n2]) * this.getGaugeNormalValueMax / (f - f2)));
                    this.getLabelAxisGap[n][n2] = d = (double)f3 * Math.PI / 180.0;
                    double d2 = Math.cos(d);
                    double d3 = Math.sin(d);
                    fArray[0] = this.getAxisXProperties[n2][0] - (float)((int)((double)(this.C - this.getGaugeErrorValueMax / 5.0f) * d2));
                    fArray[1] = this.getAxisXProperties[n2][1] - (float)((int)((double)(this.C - this.getGaugeErrorValueMax / 5.0f) * d3));
                    switch (this.objectProperties.getGaugeDialLineStyle()) {
                        case 0: {
                            float f4 = this.C / 16.0f;
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).moveTo((float)((double)this.getAxisXProperties[n2][0] - (double)f4 * d3), (float)((double)this.getAxisXProperties[n2][1] + (double)f4 * d2));
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo((float)((double)this.getAxisXProperties[n2][0] + (double)f4 * d3), (float)((double)this.getAxisXProperties[n2][1] - (double)f4 * d2));
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(fArray[0], fArray[1]);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo((float)((double)this.getAxisXProperties[n2][0] - (double)f4 * d3), (float)((double)this.getAxisXProperties[n2][1] + (double)f4 * d2));
                            break;
                        }
                        case 1: {
                            double d4 = Math.cos(0.1308996938995747);
                            double d5 = Math.cos(d - 0.1308996938995747);
                            double d6 = Math.sin(d - 0.1308996938995747);
                            double d7 = (double)this.C / (5.0 * Math.cos(d4));
                            float f5 = (float)((double)this.getAxisXProperties[n2][0] - d7 * d5);
                            float f6 = (float)((double)this.getAxisXProperties[n2][1] - d7 * d6);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).moveTo(this.getAxisXProperties[n2][0], this.getAxisXProperties[n2][1]);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(f5, f6);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(fArray[0], fArray[1]);
                            d5 = Math.cos(d + 0.1308996938995747);
                            d6 = Math.sin(d + 0.1308996938995747);
                            f5 = (float)((double)this.getAxisXProperties[n2][0] - d7 * d5);
                            f6 = (float)((double)this.getAxisXProperties[n2][1] - d7 * d6);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(f5, f6);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(this.getAxisXProperties[n2][0], this.getAxisXProperties[n2][1]);
                            break;
                        }
                        case 2: {
                            float f7 = (float)((double)this.getAxisXProperties[n2][0] - (double)(this.C - 2.0f * this.getGaugeErrorValueMax / 5.0f) * d2);
                            float f8 = (float)((double)this.getAxisXProperties[n2][1] - (double)(this.C - 2.0f * this.getGaugeErrorValueMax / 5.0f) * d3);
                            this.getGaugeAlertValueMin[n][n2][0] = f7;
                            this.getGaugeAlertValueMin[n][n2][1] = f8;
                            this.getGaugeDialCurveStyle[n][n2] = new Line2D.Float((float)((double)this.getAxisXProperties[n2][0] + (double)this.C * d2 / 6.0), (float)((double)this.getAxisXProperties[n2][1] + (double)this.C * d3 / 6.0), f7, f8);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).moveTo((float)((double)this.getAxisXProperties[n2][0] + (double)this.C * d2 / 6.0), (float)((double)this.getAxisXProperties[n2][1] + (double)this.C * d3 / 6.0));
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).lineTo(f7, f8);
                            this.getGaugeAlertValueMax[n][n2] = new GeneralPath();
                            ((GeneralPath)this.getGaugeAlertValueMax[n][n2]).moveTo(f7 - 5.0f, f8 + 5.0f);
                            ((GeneralPath)this.getGaugeAlertValueMax[n][n2]).lineTo(f7 + 5.0f, f8 + 5.0f);
                            ((GeneralPath)this.getGaugeAlertValueMax[n][n2]).lineTo(f7 + 5.0f, f8 - 5.0f);
                            ((GeneralPath)this.getGaugeAlertValueMax[n][n2]).lineTo(f7 - 5.0f, f8 - 5.0f);
                            ((GeneralPath)this.getGaugeAlertValueMax[n][n2]).lineTo(f7 - 5.0f, f8 + 5.0f);
                            ((GeneralPath)this.getGaugeDialOuterInnerGap[n][n2]).append(this.getGaugeAlertValueMax[n][n2], false);
                            this.getGaugeDialLineStyle[n2] = new Arc2D.Float(this.getAxisXProperties[n2][0] - 5.0f, this.getAxisXProperties[n2][1], 10.0f, 10.0f, 0.0f, 360.0f, 0);
                            break;
                        }
                    }
                    ((GeneralPath)this.getCategorySize[n]).append(this.getGaugeDialOuterInnerGap[n][n2], false);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void getAxisYProperties() {
        this.getFormatedHintValue = new Shape[this.cos][3];
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < this.cos) {
                float f3 = (this.append[n] - f2) * this.getGaugeNormalValueMax / (f - f2);
                float f4 = (this.abs[n] - f2) * this.getGaugeNormalValueMax / (f - f2);
                float f5 = f3 - f4;
                float f6 = (f - this.append[n]) * this.getGaugeNormalValueMax / (f - f2) + this.getGaugeNormalValueMin;
                this.getFormatedHintValue[n2][n] = new Arc2D.Double(this.floatValue[n2][0] + this.getGaugeErrorValueMax / 2.0f, this.floatValue[n2][1] + this.getGaugeErrorValueMax / 2.0f, (this.C - this.getGaugeErrorValueMax / 2.0f) * 2.0f, (this.C - this.getGaugeErrorValueMax / 2.0f) * 2.0f, f6, f5, 0);
                ++n2;
            }
            ++n;
        }
    }

    private void getBounds() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.getFilteredCategoryNames = new Shape[this.cos][4];
        int n = 0;
        while (n < this.cos) {
            int n2 = 0;
            while (n2 < 4) {
                float f3;
                float f4;
                float f5;
                float f6;
                double d;
                if (n2 == 0) {
                    d = (double)(this.getHeight - (this.abs[n2] - f2) * this.getGaugeNormalValueMax / (f - f2)) * Math.PI / 180.0;
                    f6 = (float)((double)this.getAxisXProperties[n][0] + (double)this.C * Math.cos(d));
                    f5 = (float)((double)this.getAxisXProperties[n][1] - (double)this.C * Math.sin(d));
                    f4 = (float)((double)this.getAxisXProperties[n][0] + (double)this.getGaugeErrorValueMin * Math.cos(d));
                    f3 = (float)((double)this.getAxisXProperties[n][1] - (double)this.getGaugeErrorValueMin * Math.sin(d));
                    this.getFilteredCategoryNames[n][n2] = new Line2D.Float(f6, f5, f4, f3);
                } else {
                    d = (double)(this.getHeight - (this.append[n2 - 1] - f2) * this.getGaugeNormalValueMax / (f - f2)) * Math.PI / 180.0;
                    f6 = (float)((double)this.getAxisXProperties[n][0] + (double)this.C * Math.cos(d));
                    f5 = (float)((double)this.getAxisXProperties[n][1] - (double)this.C * Math.sin(d));
                    f4 = (float)((double)this.getAxisXProperties[n][0] + (double)this.getGaugeErrorValueMin * Math.cos(d));
                    f3 = (float)((double)this.getAxisXProperties[n][1] - (double)this.getGaugeErrorValueMin * Math.sin(d));
                    this.getFilteredCategoryNames[n][n2] = new Line2D.Float(f6, f5, f4, f3);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void getCategorySize() {
        float f = this.C - this.getGaugeErrorValueMax;
        this.getBounds = new Shape[this.cos];
        int n = 0;
        while (n < this.cos) {
            float f2 = this.floatValue[n][0] + this.getGaugeErrorValueMax;
            float f3 = this.floatValue[n][1] + this.getGaugeErrorValueMax;
            switch (this.objectProperties.getGaugeDialCurveStyle()) {
                case 0: {
                    Arc2D.Float float_ = new Arc2D.Float(this.floatValue[n][0], this.floatValue[n][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    Arc2D.Double double_ = new Arc2D.Double(f2, f3, f * 2.0f, f * 2.0f, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    GeneralPath generalPath = new GeneralPath();
                    GeneralPath generalPath2 = new GeneralPath();
                    float f4 = this.getAxisXProperties[n][0] + (float)((double)this.C * Math.cos(Math.PI * (double)this.getGaugeNormalValueMin / 180.0));
                    float f5 = this.getAxisXProperties[n][1] - (float)((double)this.C * Math.sin(Math.PI * (double)this.getGaugeNormalValueMin / 180.0));
                    float f6 = this.getAxisXProperties[n][0] + (float)((double)f * Math.cos(Math.PI * (double)this.getGaugeNormalValueMin / 180.0));
                    float f7 = this.getAxisXProperties[n][1] - (float)((double)f * Math.sin(Math.PI * (double)this.getGaugeNormalValueMin / 180.0));
                    float f8 = this.getAxisXProperties[n][0] + (float)((double)this.C * Math.cos(Math.PI * (double)this.getHeight / 180.0));
                    float f9 = this.getAxisXProperties[n][1] - (float)((double)this.C * Math.sin(Math.PI * (double)this.getHeight / 180.0));
                    float f10 = this.getAxisXProperties[n][0] + (float)((double)f * Math.cos(Math.PI * (double)this.getHeight / 180.0));
                    float f11 = this.getAxisXProperties[n][1] - (float)((double)f * Math.sin(Math.PI * (double)this.getHeight / 180.0));
                    GeneralPath generalPath3 = new GeneralPath(double_);
                    GeneralPath generalPath4 = new GeneralPath(float_);
                    generalPath.moveTo(f4, f5);
                    generalPath.lineTo(f6, f7);
                    generalPath2.moveTo(f8, f9);
                    generalPath2.lineTo(f10, f11);
                    this.getBounds[n] = new GeneralPath();
                    ((GeneralPath)this.getBounds[n]).append(generalPath4, false);
                    ((GeneralPath)this.getBounds[n]).append(generalPath3, false);
                    ((GeneralPath)this.getBounds[n]).append(generalPath2, false);
                    ((GeneralPath)this.getBounds[n]).append(generalPath, false);
                    break;
                }
                case 1: {
                    this.getBounds[n] = new Arc2D.Double((this.floatValue[n][0] + f2) / 2.0f, (this.floatValue[n][1] + f3) / 2.0f, ((double)f + (double)this.getGaugeErrorValueMax / 2.0) * 2.0, ((double)f + (double)this.getGaugeErrorValueMax / 2.0) * 2.0, this.getGaugeNormalValueMin, this.getGaugeNormalValueMax, 0);
                    break;
                }
                case 3: {
                    break;
                }
            }
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.cos) {
            this.contains[n].paint(graphics2D);
            ++n;
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    Shape[][] getItemShapes() {
        return this.getGaugeDialOuterInnerGap;
    }

    public Shape getShapeBySeries(int n) {
        return this.getCategorySize[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.getGaugeDialOuterInnerGap[n][n2];
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.Z) {
            int n4 = 0;
            while (n4 < this.cos) {
                if (this.getGaugeDialOuterInnerGap[n3][n4] != null && this.getGaugeDialOuterInnerGap[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.axisY[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.Z) {
            if (this.getCategorySize[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public boolean searchGrid(int n, int n2) {
        int n3 = 0;
        while (n3 < this.cos) {
            int n4 = 0;
            while (n4 < this.getFilteredCategoryNames[0].length) {
                if (this.getFilteredCategoryNames[n3][n4].intersects(n - 2, n2 - 2, 5.0, 5.0)) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    public boolean searchAxis(int n, int n2) {
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 3: {
                int n3 = 0;
                while (n3 < this.cos) {
                    Arc2D.Float float_ = new Arc2D.Float(this.floatValue[n3][0] + 5.0f + this.getGaugeErrorValueMax, this.floatValue[n3][1] + 5.0f + this.getGaugeErrorValueMax, 2.0f * (this.C - 5.0f - this.getGaugeErrorValueMax), 2.0f * (this.C - 5.0f - this.getGaugeErrorValueMax), this.getGaugeNormalValueMin, this.getHeight, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.floatValue[n3][0] - 5.0f + this.getGaugeErrorValueMax, this.floatValue[n3][1] - 5.0f + this.getGaugeErrorValueMax, 2.0f * (this.C + 5.0f - this.getGaugeErrorValueMax), 2.0f * (this.C + 5.0f - this.getGaugeErrorValueMax), this.getGaugeNormalValueMin, this.getHeight, 0);
                    Arc2D.Float float_3 = new Arc2D.Float(this.floatValue[n3][0] + 5.0f, this.floatValue[n3][1] + 5.0f, 2.0f * (this.C - 5.0f), 2.0f * (this.C - 5.0f), this.getGaugeNormalValueMin, this.getHeight, 0);
                    Arc2D.Float float_4 = new Arc2D.Float(this.floatValue[n3][0] - 5.0f, this.floatValue[n3][1] - 5.0f, 2.0f * (this.C + 5.0f), 2.0f * (this.C + 5.0f), this.getGaugeNormalValueMin, this.getHeight, 0);
                    if (!float_.contains(n, n2) && float_2.contains(n, n2) || !float_3.contains(n, n2) && float_4.contains(n, n2)) {
                        return true;
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.cos) {
                    Arc2D.Float float_ = new Arc2D.Float(this.floatValue[n4][0] + 5.0f + this.getGaugeErrorValueMax, this.floatValue[n4][1] + 5.0f + this.getGaugeErrorValueMax, 2.0f * (this.C - 5.0f - this.getGaugeErrorValueMax), 2.0f * (this.C - 5.0f - this.getGaugeErrorValueMax), this.getGaugeNormalValueMin, this.getHeight, 0);
                    Arc2D.Float float_5 = new Arc2D.Float(this.floatValue[n4][0] - 5.0f + this.getGaugeErrorValueMax, this.floatValue[n4][1] - 5.0f + this.getGaugeErrorValueMax, 2.0f * (this.C + 5.0f - this.getGaugeErrorValueMax), 2.0f * (this.C + 5.0f - this.getGaugeErrorValueMax), this.getGaugeNormalValueMin, this.getHeight, 0);
                    if (!float_.contains(n, n2) && float_5.contains(n, n2)) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
            case 0: 
            case 1: {
                int n5 = 0;
                while (n5 < this.cos) {
                    Arc2D.Float float_ = new Arc2D.Float(this.floatValue[n5][0] + 5.0f, this.floatValue[n5][1] + 5.0f, 2.0f * (this.C - 5.0f), 2.0f * (this.C - 5.0f), this.getGaugeNormalValueMin, this.getHeight, 0);
                    Arc2D.Float float_6 = new Arc2D.Float(this.floatValue[n5][0] - 5.0f, this.floatValue[n5][1] - 5.0f, 2.0f * (this.C + 5.0f), 2.0f * (this.C + 5.0f), this.getGaugeNormalValueMin, this.getHeight, 0);
                    if (!float_.contains(n, n2) && float_6.contains(n, n2)) {
                        return true;
                    }
                    ++n5;
                }
                break;
            }
        }
        return false;
    }

    public Shape getNormalArea(int n) {
        return this.getFormatedHintValue[n][0];
    }

    public Shape getAlertArea(int n) {
        return this.getFormatedHintValue[n][1];
    }

    public Shape getErrorArea(int n) {
        return this.getFormatedHintValue[n][2];
    }

    public Shape getAxisPaths(int n) {
        return this.getChartDataSetModel[n];
    }

    public Shape[][] getAxisPaths() {
        return this.getLabelBaseDimension;
    }

    public Shape[] getTickPath(int n) {
        return this.getDimension[n];
    }

    public Shape[] getGridPath(int n) {
        return this.getFilteredCategoryNames[n];
    }

    public Shape[][] getGridPath() {
        return this.getFilteredCategoryNames;
    }

    public ChartLabelBase[] getLabels() {
        return this.getGaugeDialStopAngle;
    }

    public float[][] getAxisLabelsPos(int n) {
        return this.getAxisY[n];
    }

    public Shape getCurvePath(int n) {
        return this.getBounds[n];
    }

    public ChartLabelBase getCategoryLabel(int n) {
        return this.getGaugeDialStartAngle[n];
    }

    public float getCategoryLabelsX(int n) {
        return this.getAxisYProperties[n][0];
    }

    public float getCategoryLabelsY(int n) {
        return this.getAxisYProperties[n][1];
    }

    public float getCenterX(int n) {
        return this.getAxisXProperties[n][0];
    }

    public float getCenterY(int n) {
        return this.getAxisXProperties[n][1];
    }

    public Line2D getArrowLine(int n, int n2) {
        return this.getGaugeDialCurveStyle[n][n2];
    }

    public Shape getArrowPath(int n, int n2) {
        return this.getGaugeAlertValueMax[n][n2];
    }

    public float[] getArrowPoint(int n, int n2) {
        return this.getGaugeAlertValueMin[n][n2];
    }

    public double getValueAngle(int n, int n2) {
        return this.getLabelAxisGap[n][n2];
    }

    public float getOuterInnerGap() {
        return this.getGaugeErrorValueMax;
    }
}

