/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine;

import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.exception.FormulaRingException;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.VarsTable;
import jet.rptengine.ContainerInfo;
import jet.rptengine.RptFormulaContainer;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHDSField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.util.HashVector;
import toolkit.db.DbTools;

public class MappingFldsParseTool {
    protected JetUUniverse unvs;
    protected String strQueryName;
    protected String dataSourceName = "";
    protected int dataSetType;
    protected Vector mappingFlds;
    protected Hashtable rptFmls;
    protected Vector addMappingFlds;
    protected Vector groupParams;
    protected Hashtable htDbFields = new Hashtable();
    protected RptFormulaContainer fmlsContainer = null;
    protected Hashtable htDbFieldsInLocalWhere = null;
    protected RptFormulaContainer fmlsInLocalWhere = null;
    protected HashVector vecFormulas = null;
    protected HashVector vecFormulasInLocalWhere = null;
    protected Hashtable paramsBuff = new Hashtable();
    protected boolean bResolveRpt = false;
    protected JetUHierDataSource uHDS;
    Vector DATASET_HDS = null;
    protected Hashtable fmlWhere;
    private Vector DATASET_UNKNOWN = null;
    private Hashtable QOIV = null;
    private Hashtable addElement = null;
    private Vector addOnlyUserName = null;
    private Hashtable buildRptFormula;
    private Vector checkParameters;
    protected Hashtable htSummaryInfo = null;
    private boolean clear = false;

    public MappingFldsParseTool(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, int n, Hashtable hashtable) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        this.unvs = jetUUniverse;
        this.mappingFlds = vector;
        this.groupParams = vector2;
        this.addMappingFlds = vector3;
        this.dataSetType = n;
        this.rptFmls = hashtable;
        this.setQuery(string, string2);
    }

    protected void setQuery(String string, String string2) {
        this.strQueryName = string2;
        this.dataSourceName = string;
        if (this.dataSetType == ContainerInfo.DATASET_HDS) {
            this.uHDS = (JetUHierDataSource)this.unvs.getQueriableByResourceName(string, string2);
        }
    }

    protected void setAllGroupParams(Vector vector) {
        this.addOnlyUserName = vector;
    }

    public void setFormulaWhere(Hashtable hashtable) {
        if (hashtable != null) {
            if (hashtable.size() < 1) {
                return;
            }
            this.fmlWhere = new Hashtable();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                this.fmlWhere.put(string2, this.uHDS.getWhereFormula(string));
            }
        }
    }

    public void setFormulaWhere(JetUWhereFormula jetUWhereFormula) {
        if (this.fmlWhere == null) {
            this.fmlWhere = new Hashtable();
        }
        this.fmlWhere.put("Report", jetUWhereFormula);
    }

    public void setDynamicSummary(Hashtable hashtable) {
        this.QOIV = hashtable;
    }

    public void setHtOnTheFlyFlms(Hashtable hashtable) {
        this.buildRptFormula = hashtable;
    }

    protected void setUsedDefinedFormula(Vector vector) {
        this.DATASET_UNKNOWN = vector;
    }

    public Hashtable getMessureToColDesc() {
        return this.addElement;
    }

    protected void initGroupParameters() {
        if (this.groupParams != null && !this.groupParams.isEmpty()) {
            int n = this.groupParams.size();
            JetUResourceEntity jetUResourceEntity = null;
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.groupParams.elementAt(n2);
                Object object = this.getResourceEntity(string);
                if (object instanceof JetUResourceEntity) {
                    jetUResourceEntity = (JetUResourceEntity)object;
                }
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUParameter) {
                    this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity, 1);
                }
                if (this.addOnlyUserName != null && !this.addOnlyUserName.contains(string.toUpperCase())) {
                    this.addOnlyUserName.addElement(string.toUpperCase());
                }
                ++n2;
            }
        }
    }

    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, FormulaSyntaxErrorException {
        int n = this.mappingFlds.size();
        this.fmlsContainer = this.dataSourceName == null ? new RptFormulaContainer(this.unvs, this.strQueryName) : new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        this.fmlsContainer.setRptFormulas(this.rptFmls);
        this.fmlsContainer.setHtOnTheFlyFlms(this.buildRptFormula);
        JetUResourceEntity jetUResourceEntity = null;
        String string = this.dataSourceName;
        Object var5_4 = null;
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity2;
            String string2 = (String)this.mappingFlds.elementAt(n2);
            var5_4 = null;
            if (this.dataSetType != ContainerInfo.DATASET_UNKNOWN) {
                if (this.QOIV != null && this.QOIV.containsKey(string2)) {
                    var5_4 = this.QOIV.get(string2);
                } else {
                    jetUResourceEntity = this.buildRptFormula != null && this.buildRptFormula.containsKey(string2) ? (JetUFormula)this.buildRptFormula.get(string2) : (this.rptFmls != null && this.rptFmls.containsKey(string2) ? (JetUResourceEntity)this.rptFmls.get(string2) : (string != null ? this.unvs.getResourceByName(string, this.strQueryName, string2) : this.unvs.getResourceByName(this.strQueryName, string2)));
                }
            }
            if (jetUResourceEntity == null && var5_4 == null && (jetUResourceEntity2 = this.unvs.getAnyResourceByName(string2)) != null && jetUResourceEntity2 instanceof JetUParameter) {
                jetUResourceEntity = jetUResourceEntity2;
            }
            if (jetUResourceEntity == null && var5_4 == null && this.dataSetType != ContainerInfo.DATASET_UNKNOWN) {
                throw new CannotFindEntity(string2);
            }
            if (var5_4 != null) {
                this.putFormula(this.fmlsContainer, string2, (Object)var5_4);
            } else if (jetUResourceEntity instanceof JetUDBField) {
                this.htDbFields.put(string2, jetUResourceEntity);
            } else if (jetUResourceEntity instanceof JetUFormulaInterface) {
                this.putFormula(this.fmlsContainer, string2, (JetUFormulaInterface)((Object)jetUResourceEntity));
            } else if (jetUResourceEntity instanceof JetUParameter) {
                this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity);
            } else if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Unknow type of field");
            }
            ++n2;
        }
        this.putRefFldsToBuf(this.fmlsContainer, this.htDbFields);
        this.putRefParamToBuf(this.fmlsContainer);
    }

    public void initialize() throws QueryWhereFormulaGrammarError, FormulaRingException, ParseFormulaFailedException, CannotUseGlobalVarInFrmlWhere, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotFindEntity, FldNotFoundInQuery, FormulaSyntaxErrorException {
        if (!this.bResolveRpt) {
            this.initGroupParameters();
        }
        this.initMappingFields();
        this.initLocalWhere();
        this.prepareParameters();
        this.putMapFldsToBuff(this.addMappingFlds);
    }

    protected void initLocalWhere() throws QueryWhereFormulaGrammarError, FormulaRingException, ParseFormulaFailedException, CannotUseGlobalVarInFrmlWhere, CannotFindFrmlRefFld, FormulaHasGrammarError {
        if (this.haveLocalWhere()) {
            this.htDbFieldsInLocalWhere = new Hashtable();
            this.fmlsInLocalWhere = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
            this.putFormulasInLocalWhereToBuffer();
            VarsTable varsTable = new VarsTable();
            varsTable.addOnlyUserName();
            this.fmlsInLocalWhere.parseFormulas(true, varsTable);
            VarsTable varsTable2 = (VarsTable)this.fmlsInLocalWhere.getGVarTable().clone();
            varsTable2.remove("USERNAME");
            varsTable2.remove("PRINTDATE");
            varsTable2.remove("PRINTTIME");
            if (varsTable2.size() != 0) {
                throw new CannotUseGlobalVarInFrmlWhere();
            }
            this.putRefFldsToBuf(this.fmlsInLocalWhere, this.htDbFieldsInLocalWhere);
            this.putRefParamToBuf(this.fmlsInLocalWhere);
        }
    }

    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError {
        if (this.fmlWhere != null) {
            Enumeration enumeration = this.fmlWhere.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JetUWhereFormula jetUWhereFormula = (JetUWhereFormula)this.fmlWhere.get(string);
                if (!jetUWhereFormula.isParsedOK()) {
                    throw new QueryWhereFormulaGrammarError(jetUWhereFormula.getResourceName());
                }
                this.fmlsInLocalWhere.putFormula(jetUWhereFormula.getResourceName(), jetUWhereFormula);
            }
        }
    }

    public boolean haveLocalWhere() {
        return this.fmlWhere != null;
    }

    public void prepareStart(Hashtable hashtable) throws ParameterNotResolved, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotFindEntity {
        this.putMapFldsInParamToBuff(hashtable);
        if (!this.bResolveRpt) {
            this.checkParameters();
        }
        if (this.haveLocalWhere()) {
            this.purifyFmlsInLocalWhereCon();
            if (this.dataSetType == ContainerInfo.DATASET_HDS) {
                this.purifyFldsInLocalWhereCon_HDS();
            } else {
                this.purifyFldsInLocalWhereCon();
            }
        }
        this.prepareFormular();
    }

    protected void prepareFormular() {
        this.vecFormulas = this.fmlsContainer.getFormulas();
        if (this.haveLocalWhere()) {
            this.vecFormulasInLocalWhere = this.fmlsInLocalWhere.getFormulas();
            if (this.fmlWhere != null) {
                Enumeration enumeration = this.fmlWhere.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    JetUWhereFormula jetUWhereFormula = (JetUWhereFormula)this.fmlWhere.get(string);
                    this.fmlsContainer.setFormulaWhere(jetUWhereFormula.getResourceName(), jetUWhereFormula);
                }
            }
        }
    }

    public void setAddedEntity(Vector vector) {
        this.checkParameters = vector;
    }

    protected void purifyFmlsInLocalWhereCon() {
        HashVector hashVector = this.fmlsInLocalWhere.getFormulas();
        int n = hashVector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = (String)hashVector.elementAt(n2);
            if (this.fmlsContainer.containsReal(string)) {
                this.fmlsInLocalWhere.removeFrml(string);
            }
            --n2;
        }
    }

    protected void purifyFldsInLocalWhereCon() {
        Enumeration enumeration = this.htDbFieldsInLocalWhere.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)this.htDbFieldsInLocalWhere.get(string);
            if (!this.htDbFields.containsKey(string)) continue;
            this.htDbFieldsInLocalWhere.remove(string);
        }
    }

    protected void purifyFldsInLocalWhereCon_HDS() {
        Enumeration enumeration = this.htDbFieldsInLocalWhere.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetUHDSField jetUHDSField = (JetUHDSField)this.htDbFieldsInLocalWhere.get(string);
            String string2 = ((JetUHDSTable)jetUHDSField.getParent()).getFullName();
            String string3 = jetUHDSField.getFullName();
            if (this.DATASET_HDS == null) {
                this.DATASET_HDS = new Vector();
                this.DATASET_HDS.addElement(string2);
            } else {
                int n = this.DATASET_HDS.size();
                boolean bl = false;
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4;
                    String string4 = (String)this.DATASET_HDS.elementAt(n2);
                    int n5 = string4.length();
                    int n6 = n4 = n5 > (n3 = string2.length()) ? n3 : n5;
                    if (string4.substring(0, n4).equals(string2.substring(0, n4))) {
                        if (n3 > n4) {
                            this.DATASET_HDS.setElementAt(string2, n2);
                        }
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.DATASET_HDS.addElement(string2);
                }
            }
            if (!this.htDbFields.containsKey(string)) continue;
            this.htDbFieldsInLocalWhere.remove(string);
        }
    }

    public Hashtable getRptFormulaWheres_h() {
        Hashtable<String, JetRptFormula> hashtable = null;
        if (this.fmlWhere != null) {
            int n = this.fmlWhere.size();
            if (n < 1) {
                return null;
            }
            hashtable = new Hashtable<String, JetRptFormula>();
            Enumeration enumeration = this.fmlWhere.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, ((JetUWhereFormula)this.fmlWhere.get(string)).getRptFormula());
            }
        }
        return hashtable;
    }

    protected void putParamInHDSToBuf() {
        StringBuffer stringBuffer = new StringBuffer(this.uHDS.getParameter());
        String string = null;
        while ((string = DbTools.getFirstParameterNameInString(stringBuffer, new StringBuffer())) != null) {
            this.putParamToBuf(string);
        }
        Vector vector = this.uHDS.getParams();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.putParamToBuf((String)vector.elementAt(n2));
                ++n2;
            }
        }
    }

    protected void putParamToBuf(String string) {
        JetUDatabase jetUDatabase = this.unvs.getDatabase(this.dataSourceName);
        JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string);
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUParameter) {
            JetUParameter jetUParameter = (JetUParameter)jetUResourceEntity;
            ParamDesc paramDesc = jetUParameter.getParamDesc();
            paramDesc.setBeColumn(0);
            this.paramsBuff.put(string.toUpperCase(), paramDesc);
        }
    }

    public void putMapFldsToBuff(Vector vector) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError {
        RptFormulaContainer rptFormulaContainer = null;
        rptFormulaContainer = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        rptFormulaContainer.setRptFormulas(this.rptFmls);
        this.fmlsContainer.setHtOnTheFlyFlms(this.buildRptFormula);
        JetUResourceEntity jetUResourceEntity = null;
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            Object object = this.getResourceEntity(string);
            if (object instanceof JetUResourceEntity) {
                jetUResourceEntity = (JetUResourceEntity)object;
            }
            if (jetUResourceEntity == null && object == null) {
                throw new CannotFindEntity(string);
            }
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUDBField) {
                if (!this.DATASET_HDS(this.htDbFields, string)) {
                    this.htDbFields.put(string, jetUResourceEntity);
                }
            } else if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormulaInterface) {
                this.putFormula(this.fmlsContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                this.putFormula(rptFormulaContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
            } else if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUParameter) {
                this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity);
                String string2 = ((JetUParameter)jetUResourceEntity).getBinding();
                if (string2 != null) {
                    jetUResourceEntity = this.unvs.getMaterialByName(this.dataSourceName, string2);
                    this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity);
                }
            } else if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Unknow type of field");
            }
            ++n;
        }
        this.putRefFldsToBuf(rptFormulaContainer, this.htDbFields);
        this.putRefParamToBuf(rptFormulaContainer);
    }

    private boolean DATASET_HDS(Hashtable hashtable, String string) {
        boolean bl = false;
        String string2 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.toUpperCase().equals(string.toUpperCase())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void putMapFldsInParamToBuff(Hashtable hashtable) throws ParameterNotResolved, CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError {
        RptFormulaContainer rptFormulaContainer = null;
        rptFormulaContainer = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        rptFormulaContainer.setRptFormulas(this.rptFmls);
        this.fmlsContainer.setHtOnTheFlyFlms(this.buildRptFormula);
        JetUResourceEntity jetUResourceEntity = null;
        if (this.groupParams != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
                if (!this.groupParams.contains(paramDesc.name.toUpperCase()) || !paramDesc.isColumnCal()) continue;
                String string = paramDesc.inValue.toUpperCase();
                if (string == null) {
                    return;
                }
                Object object = this.getResourceEntity(string);
                if (object instanceof JetUResourceEntity) {
                    jetUResourceEntity = (JetUResourceEntity)object;
                }
                if (object == null && this.groupParams != null && this.groupParams.contains(paramDesc.name.toUpperCase())) {
                    return;
                }
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUDBField) {
                    this.htDbFields.put(string, jetUResourceEntity);
                    continue;
                }
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormulaInterface) {
                    this.putFormula(this.fmlsContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    this.putFormula(rptFormulaContainer, string, (JetUFormulaInterface)((Object)jetUResourceEntity));
                    continue;
                }
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUParameter) {
                    this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity);
                    String string2 = ((JetUParameter)jetUResourceEntity).getBinding();
                    if (string2 == null) continue;
                    jetUResourceEntity = this.unvs.getMaterialByName(this.dataSourceName, string2);
                    this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity);
                    continue;
                }
                if (!JRLog.isTrace(5)) continue;
                JRLog.trace(5, "Unknow type of field");
            }
        }
        this.putRefFldsToBuf(rptFormulaContainer, this.htDbFields);
        this.putRefParamToBuf(rptFormulaContainer);
    }

    protected void putParameter(String string, JetUParameter jetUParameter, int n) {
        if (!this.paramsBuff.containsKey(string)) {
            Object object;
            ParamDesc paramDesc = jetUParameter.getParamDesc();
            this.paramsBuff.put(string, paramDesc);
            String string2 = paramDesc.getBinding();
            String string3 = paramDesc.getColumn();
            if (string2 != null && (object = (JetUParameter)this.unvs.getMaterialByName(this.dataSourceName, string2)) != null) {
                paramDesc = ((JetUParameter)object).getParamDesc();
                this.paramsBuff.put(string2.toUpperCase(), paramDesc);
            }
            if (n != 0 || string3 == null || string3.length() > 0) {
                // empty if block
            }
            if (!this.clear && jetUParameter.isReferPara()) {
                object = new Hashtable();
                jetUParameter.getAllReferP(this.unvs, this.dataSourceName, this.strQueryName, (Hashtable)object);
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    if (this.mappingFlds.contains(string4.toUpperCase())) continue;
                    this.putParameter(string4.toUpperCase(), (JetUParameter)((Hashtable)object).get(string4));
                }
            }
        }
    }

    protected void putParameter(String string, JetUParameter jetUParameter) {
        this.putParameter(string, jetUParameter, 0);
    }

    protected void putRefFldsToBuf(RptFormulaContainer rptFormulaContainer, Hashtable hashtable) throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Hashtable hashtable2 = rptFormulaContainer.getRefDbFlds();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)hashtable2.get(string);
            if (hashtable.containsKey(string)) continue;
            hashtable.put(string, jetUResourceEntity);
        }
    }

    protected void putRefParamToBuf(RptFormulaContainer rptFormulaContainer) throws CannotFindFrmlRefFld {
        Hashtable hashtable = rptFormulaContainer.getRefParameters();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JetUParameter jetUParameter = (JetUParameter)hashtable.get(string);
                this.putParameter(string.toUpperCase(), jetUParameter);
            }
        }
    }

    protected void putFormula(RptFormulaContainer rptFormulaContainer, String string, Object object) throws FormulaHasGrammarError, FormulaSyntaxErrorException {
        JetRptFormula jetRptFormula = null;
        if (object instanceof JetUFormulaInterface) {
            jetRptFormula = ReportTools.buildRptFormula(string, (JetUFormulaInterface)object, (FormulaContainer)rptFormulaContainer);
        } else if (object instanceof MeasureInfo) {
            jetRptFormula = ReportTools.buildRptFormula(string, (MeasureInfo)object, (FormulaContainer)rptFormulaContainer);
        } else if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Unknow type of field");
        }
        if (jetRptFormula != null) {
            if (this.htSummaryInfo == null) {
                this.htSummaryInfo = new Hashtable();
            }
            this.htSummaryInfo.put(string, object);
        }
        FormulaInfo formulaInfo = jetRptFormula.formulainfo;
        if (formulaInfo.parseOK) {
            rptFormulaContainer.putFormula(jetRptFormula);
            if (this.addElement == null) {
                this.addElement = new Hashtable();
            }
        } else {
            throw new FormulaHasGrammarError(string);
        }
        this.addElement.put(string, jetRptFormula.getColDesc());
    }

    protected void checkParameters() throws ParameterNotResolved {
        Enumeration enumeration = this.paramsBuff.elements();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
            if (paramDesc.inValue != null) continue;
            throw new ParameterNotResolved(paramDesc.name);
        }
    }

    protected void putFormula(RptFormulaContainer rptFormulaContainer, String string, JetUFormulaInterface jetUFormulaInterface) throws FormulaHasGrammarError {
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        if (formulaInfo.parseOK) {
            rptFormulaContainer.putFormula(string, jetUFormulaInterface);
            if (jetUFormulaInterface instanceof JetUSummary) {
                if (this.htSummaryInfo == null) {
                    this.htSummaryInfo = new Hashtable();
                }
                this.htSummaryInfo.put(string, jetUFormulaInterface);
            }
        } else {
            throw new FormulaHasGrammarError(string);
        }
    }

    protected void prepareParameters() {
        if (this.dataSetType == ContainerInfo.DATASET_HDS) {
            this.putParamInHDSToBuf();
        }
    }

    public RptFormulaContainer getFormulaContainer() {
        return this.fmlsContainer;
    }

    public HashVector getFormulasInLocalWhere() {
        return this.vecFormulasInLocalWhere;
    }

    public Hashtable getParamsBuff() {
        return this.paramsBuff;
    }

    public ParamDesc getParameter(String string) {
        return (ParamDesc)this.paramsBuff.get(string.toUpperCase());
    }

    public Hashtable getFormulaWhere() {
        return this.fmlWhere;
    }

    public Vector getFmlsColDescs() {
        DbColDesc dbColDesc;
        JetRptFormula jetRptFormula;
        String string;
        Enumeration enumeration;
        Vector<DbColDesc> vector = new Vector<DbColDesc>(5);
        Hashtable<String, DbColDesc> hashtable = new Hashtable<String, DbColDesc>();
        if (this.vecFormulas != null && this.vecFormulas.size() != 0) {
            enumeration = this.vecFormulas.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                jetRptFormula = (JetRptFormula)this.vecFormulas.get(string);
                dbColDesc = (DbColDesc)hashtable.get(string);
                if (dbColDesc == null) {
                    dbColDesc = jetRptFormula.getColDesc();
                    dbColDesc.setColName(string);
                    hashtable.put(string, dbColDesc);
                }
                if (jetRptFormula.isConstant()) {
                    dbColDesc.setConstant(true);
                }
                vector.addElement(dbColDesc);
            }
        }
        if (this.vecFormulasInLocalWhere != null && this.vecFormulasInLocalWhere.size() != 0) {
            enumeration = this.vecFormulasInLocalWhere.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                jetRptFormula = (JetRptFormula)this.vecFormulasInLocalWhere.get(string);
                dbColDesc = (DbColDesc)hashtable.get(string);
                if (dbColDesc == null) {
                    dbColDesc = jetRptFormula.getColDesc();
                    dbColDesc.setColName(string);
                    hashtable.put(string, dbColDesc);
                }
                if (jetRptFormula.isConstant()) {
                    dbColDesc.setConstant(true);
                }
                vector.addElement(dbColDesc);
            }
        }
        return vector;
    }

    public Hashtable getHtDbFields() {
        return this.htDbFields;
    }

    public Hashtable getHtDbFieldsInLocalWhere() {
        return this.htDbFieldsInLocalWhere;
    }

    public Vector getBreakBranch() {
        return this.DATASET_HDS;
    }

    protected Object getResourceEntity(String string) {
        JetUResourceEntity jetUResourceEntity = null;
        if (this.dataSetType != ContainerInfo.DATASET_UNKNOWN) {
            JetUResourceEntity jetUResourceEntity2 = null;
            jetUResourceEntity2 = this.buildRptFormula != null && this.buildRptFormula.containsKey(string) ? (JetUFormula)this.buildRptFormula.get(string) : (this.rptFmls != null && this.rptFmls.containsKey(string) ? (JetUResourceEntity)this.rptFmls.get(string) : this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, string));
            jetUResourceEntity = jetUResourceEntity2;
        }
        return jetUResourceEntity;
    }

    public void clearMem() {
        if (this.mappingFlds != null) {
            this.mappingFlds.clear();
            this.mappingFlds = null;
        }
        if (this.addMappingFlds != null) {
            this.addMappingFlds.clear();
            this.addMappingFlds = null;
        }
        if (this.groupParams != null) {
            this.groupParams.clear();
            this.groupParams = null;
        }
        this.htDbFields.clear();
        this.fmlsContainer = null;
        this.htDbFieldsInLocalWhere = null;
        this.fmlsInLocalWhere = null;
        if (this.vecFormulas != null) {
            this.vecFormulas.clear();
            this.vecFormulas = null;
        }
        if (this.vecFormulasInLocalWhere != null) {
            this.vecFormulasInLocalWhere.clear();
            this.vecFormulasInLocalWhere = null;
        }
        this.paramsBuff.clear();
        if (this.DATASET_HDS != null) {
            this.DATASET_HDS.clear();
            this.DATASET_HDS = null;
        }
        if (this.fmlWhere != null) {
            this.fmlWhere.clear();
            this.fmlWhere = null;
        }
        if (this.DATASET_UNKNOWN != null) {
            this.DATASET_UNKNOWN.clear();
            this.DATASET_UNKNOWN = null;
        }
        if (this.QOIV != null) {
            this.QOIV.clear();
            this.QOIV = null;
        }
        if (this.htSummaryInfo != null) {
            this.htSummaryInfo.clear();
            this.htSummaryInfo = null;
        }
        this.addOnlyUserName = null;
    }

    public Hashtable getSummaryInfo() {
        return this.htSummaryInfo;
    }

    public void setSummaryInfo(Hashtable hashtable) {
        this.htSummaryInfo = hashtable;
    }

    public void setIgnoreParaRefPara(boolean bl) {
        this.clear = bl;
    }
}

