/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetVector;
import jet.universe.businesslogic.BLException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.impl.BLNodeImpl;

public class Hierarchy
extends BLNodeImpl
implements HierarchyInfo {
    private JetVector QOIV = new JetVector(this, "Dimensions");
    private static final HashMap add = new HashMap(4);

    public Hierarchy() {
        this.setElementType(9);
    }

    public void setDimensions(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.QOIV.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.QOIV.add(stringArray[n]);
            ++n;
        }
    }

    public String[] getDimensionQualifyNames() {
        String[] stringArray = this.QOIV.toStringArray();
        return stringArray;
    }

    public String getDownLevelDimQualifyName(String string) {
        String string2 = null;
        Vector vector = this.QOIV.get();
        int n = vector.indexOf(string);
        if (n != -1 && n + 1 < vector.size()) {
            string2 = (String)vector.get(n + 1);
        }
        return string2;
    }

    public String getUpLevelDimQualifyName(String string) {
        String string2 = null;
        Vector vector = this.QOIV.get();
        int n = vector.indexOf(string);
        if (n > 0) {
            string2 = (String)vector.get(n - 1);
        }
        return string2;
    }

    public boolean containsDimension(String string) {
        boolean bl = false;
        Vector vector = this.QOIV.get();
        int n = vector.indexOf(string);
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public void removeDimension(String string) {
        this.QOIV.remove(string);
    }

    public HierarchyInfo copy() {
        Hierarchy hierarchy = new Hierarchy();
        try {
            hierarchy.setName(this.getName());
            hierarchy.setDisplayName(this.getDisplayName());
        }
        catch (BLException bLException) {
            bLException.printStackTrace();
        }
        String[] stringArray = this.QOIV.toStringArray();
        int n = 0;
        while (n < stringArray.length) {
            hierarchy.QOIV.add(stringArray[n]);
            ++n;
        }
        return hierarchy;
    }

    public boolean isSimilar(BLNode bLNode) {
        String[] stringArray;
        if (!super.isSimilar(bLNode)) {
            return false;
        }
        HierarchyInfo hierarchyInfo = (HierarchyInfo)bLNode;
        String[] stringArray2 = this.getDimensionQualifyNames();
        if (stringArray2.length != (stringArray = hierarchyInfo.getDimensionQualifyNames()).length) {
            return false;
        }
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String string = stringArray2[n];
            boolean bl = false;
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                String string2 = stringArray[n3];
                if (string.equalsIgnoreCase(string2)) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getInstancePrefix() {
        return "Hierarchy";
    }

    public HashMap getIndecialMap() {
        return add;
    }

    static {
        add.put("name", new Integer(0));
        add.put("BLElementType", new Integer(1));
        add.put("Description", new Integer(2));
        add.put("Dimensions", new Integer(3));
    }
}

