/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartLabel;
import chart.ChartLegend;
import chart.ChartObject;
import chart.ChartPropertyValues;
import chart.ChartRenderInfo;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DPaper;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.properties.ChartPlatformProperties;
import chart.util.ChartRenderTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;

public class ChartPlatform
extends ChartComponent {
    private ChartDataSetModel COLORLENGTH;
    private ChartPlatformProperties D;
    private boolean DEFAULTCOLORS;
    private ChartFillPattern[] GAP_BETWEEN_COMPNENT;
    private List KEY_ANTIALIASING;
    private ChartFillPattern[] QOIV;
    private int VALUE_ANTIALIAS_ON;
    private List add;
    private ChartCoordinatePaper allIsIntegerData;
    private ChartLegend allLineArea;
    private boolean append;
    private boolean calculateTitleAutoPos;
    private boolean contains = true;
    private boolean cutRectangle = true;
    public static final int gap = 10;
    public static final int GAP = 0;
    private ChartDefinition depthEnable;
    private ChartRenderInfo get;
    private Rectangle getAxisInfo = null;
    private List getAxisY1;
    private int getBackground = 0;

    public ChartPlatform() {
        this.depthEnable = null;
        this.COLORLENGTH = null;
        this.D = null;
    }

    public ChartPlatform(ChartDefinition chartDefinition, ChartDataSetModel chartDataSetModel, ChartPlatformProperties chartPlatformProperties) {
        this.depthEnable = chartDefinition;
        this.COLORLENGTH = chartDataSetModel;
        this.D = chartPlatformProperties;
    }

    public void init() {
        int n;
        this.VALUE_ANTIALIAS_ON = 0;
        this.add = this.COLORLENGTH.getChartDataSets();
        ChartDataSet chartDataSet = null;
        int n2 = 0;
        while (n2 < this.add.size()) {
            chartDataSet = (ChartDataSet)this.add.get(n2);
            n = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ()) {
                this.VALUE_ANTIALIAS_ON += chartDataSet.getCategorySize();
            } else {
                switch (n) {
                    case 4: {
                        this.VALUE_ANTIALIAS_ON += chartDataSet.getCategorySize();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        this.VALUE_ANTIALIAS_ON += chartDataSet.getSeriesSize();
                    }
                }
            }
            ++n2;
        }
        this.COLORLENGTH();
        this.allLineArea();
        this.getAxisY1 = new ArrayList();
        n = this.children.size() - 1;
        while (n >= 0) {
            ChartComponent chartComponent = (ChartComponent)this.children.get(n);
            if (chartComponent instanceof ChartCoordinatePaper) {
                this.allIsIntegerData = (ChartCoordinatePaper)chartComponent;
            } else if (chartComponent instanceof ChartLegend) {
                this.allLineArea = (ChartLegend)chartComponent;
            } else if (chartComponent instanceof ChartLabel) {
                this.getAxisY1.add(chartComponent);
            }
            chartComponent.init();
            --n;
        }
    }

    public void setPatterns() {
        ChartFillPattern[] chartFillPatternArray = this.D.getPatterns();
        this.GAP_BETWEEN_COMPNENT = new ChartFillPattern[this.VALUE_ANTIALIAS_ON];
        if (chartFillPatternArray != null) {
            int n = 0;
            while (n < this.VALUE_ANTIALIAS_ON) {
                this.GAP_BETWEEN_COMPNENT[n] = chartFillPatternArray[n % chartFillPatternArray.length];
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.VALUE_ANTIALIAS_ON) {
                this.GAP_BETWEEN_COMPNENT[n] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[n % ChartPropertyValues.COLORLENGTH]));
                ++n;
            }
        }
        this.D.setPatterns(this.GAP_BETWEEN_COMPNENT);
    }

    private void COLORLENGTH() {
        this.DEFAULTCOLORS = this.D.isAntiAliasing();
        this.setBackground(this.D.getBackground());
        this.setPatterns();
        this.splitPattern();
    }

    public void splitPattern() {
        this.KEY_ANTIALIASING = new ArrayList();
        int n = 0;
        int n2 = 0;
        while (n2 < this.add.size()) {
            ChartFillPattern chartFillPattern;
            Object object;
            int n3;
            ArrayList<ChartFillPattern> arrayList = new ArrayList<ChartFillPattern>();
            ChartDataSet chartDataSet = (ChartDataSet)this.add.get(n2);
            int n4 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ()) {
                n3 = 0;
                while (n3 < chartDataSet.getCategorySize()) {
                    String string = String.valueOf(chartDataSet.getChartDataSetModel().getCategoryName(n3));
                    object = null;
                    if (string != null) {
                        object = this.D(string);
                    }
                    if (object != null) {
                        this.GAP_BETWEEN_COMPNENT[n3 + n] = object;
                    }
                    chartFillPattern = this.GAP_BETWEEN_COMPNENT[n3 + n];
                    arrayList.add(chartFillPattern);
                    ++n3;
                }
                n += chartDataSet.getCategorySize();
            } else {
                switch (n4) {
                    case 4: {
                        n3 = 0;
                        while (n3 < chartDataSet.getCategorySize()) {
                            String string = String.valueOf(chartDataSet.getChartDataSetModel().getCategoryName(n3));
                            object = null;
                            if (string != null) {
                                object = this.D(string);
                            }
                            if (object != null) {
                                this.GAP_BETWEEN_COMPNENT[n3 + n] = object;
                            }
                            chartFillPattern = this.GAP_BETWEEN_COMPNENT[n + n3];
                            arrayList.add(chartFillPattern);
                            ++n3;
                        }
                        n += chartDataSet.getCategorySize();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        int n5 = 0;
                        while (n5 < chartDataSet.getSeriesSize()) {
                            object = null;
                            if (chartDataSet.getLegendSeriesLabels() != null && chartDataSet.getLegendSeriesLabels().size() > 0) {
                                object = String.valueOf(chartDataSet.getLegendSeriesLabels().get(n5));
                            }
                            ChartFillPattern chartFillPattern2 = null;
                            if (object != null) {
                                chartFillPattern2 = this.D((String)object);
                            }
                            if (chartFillPattern2 != null) {
                                this.GAP_BETWEEN_COMPNENT[n5 + n] = chartFillPattern2;
                            }
                            chartFillPattern = this.GAP_BETWEEN_COMPNENT[n + n5];
                            arrayList.add(chartFillPattern);
                            ++n5;
                        }
                        n += chartDataSet.getSeriesSize();
                    }
                }
            }
            this.KEY_ANTIALIASING.add(arrayList);
            ++n2;
        }
    }

    private ChartFillPattern D(String string) {
        if (this.D.getBindedPatterns() == null) {
            return null;
        }
        return (ChartFillPattern)this.D.getBindedPatterns().get(string);
    }

    public synchronized void locate() {
        Object object;
        int n = this.D.getBackground().getBorderStyle();
        int n2 = n == 0 ? 0 : (int)this.D.getBackground().getPen().getPenWidth() + ChartEnv.GAP_BETWEEN_COMPNENT;
        int n3 = this.width - 2 * n2;
        int n4 = this.height - 2 * n2;
        this.getAxisInfo = new Rectangle(n2, n2, n3, n4);
        int n5 = this.getAxisY1.size();
        int n6 = 0;
        while (n6 < n5) {
            object = (ChartLabel)this.getAxisY1.get(n6);
            int n7 = ((ChartLabel)object).getTitleType();
            if (n7 == 1) {
                this.getAxisInfo = this.GAP_BETWEEN_COMPNENT((ChartLabel)object, this.getAxisInfo);
            } else if (n7 == 0) {
                this.getAxisInfo = this.KEY_ANTIALIASING((ChartLabel)object, this.getAxisInfo);
            } else {
                this.QOIV((ChartLabel)object, this.getAxisInfo);
            }
            ++n6;
        }
        object = this.DEFAULTCOLORS(this.getAxisInfo);
        this.add(this.allLineArea);
        this.allIsIntegerData(this.allIsIntegerData, (Rectangle)object);
        this.VALUE_ANTIALIAS_ON(this.allIsIntegerData.getGraphArea());
    }

    private Rectangle DEFAULTCOLORS(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        if (this.allIsIntegerData.x <= 0 && this.allIsIntegerData.y <= 0 && this.allIsIntegerData.height <= 0 && this.allIsIntegerData.width <= 0) {
            if (this.allLineArea != null && this.D.isShowLegend()) {
                switch (this.allLineArea.getPreferredPlacement()) {
                    case 2: 
                    case 4: {
                        rectangle2.setSize((int)((float)(rectangle.width * 12) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)), (int)((float)(rectangle.height * 15) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)));
                        break;
                    }
                    case 1: 
                    case 3: {
                        rectangle2.setSize((int)((float)(rectangle.width * 15) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)), (int)((float)(rectangle.height * 12) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)));
                        break;
                    }
                    default: {
                        rectangle2.setSize((int)((float)(rectangle.width * 12) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)), (int)((float)(rectangle.height * 15) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)));
                    }
                }
                int n = (int)rectangle2.getSize().getWidth();
                int n2 = (int)rectangle2.getSize().getHeight();
                switch (this.allLineArea.getPreferredPlacement()) {
                    case 2: {
                        rectangle2.setLocation((rectangle.x + rectangle.width * 12 / 16 - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT, rectangle.y + (rectangle.height - n2) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                        break;
                    }
                    case 4: {
                        rectangle2.setLocation(rectangle.x + rectangle.width * 4 / 16 + (rectangle.width * 12 / 16 - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT, rectangle.y + (rectangle.height - n2) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                        break;
                    }
                    case 1: {
                        rectangle2.setLocation(rectangle.x + (rectangle.width - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT, rectangle.y + rectangle.height * 4 / 16 + (rectangle.height * 12 / 16 - n2) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                        break;
                    }
                    case 3: {
                        rectangle2.setLocation(rectangle.x + (rectangle.width - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT, rectangle.y + (rectangle.height * 12 / 16 - n2) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                        break;
                    }
                    default: {
                        rectangle2.setLocation(rectangle.x + (rectangle.width * 12 / 16 - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT, rectangle.y + (rectangle.height - n2) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                        break;
                    }
                }
            } else {
                rectangle2.setLocation(rectangle.x + 10, rectangle.y + 10);
                rectangle2.setSize(rectangle.width - 20, rectangle.height - 20);
            }
        } else {
            rectangle2.setRect(this.allIsIntegerData.x, this.allIsIntegerData.y, this.allIsIntegerData.width, this.allIsIntegerData.height);
        }
        return rectangle2;
    }

    private Rectangle GAP_BETWEEN_COMPNENT(ChartLabel chartLabel, Rectangle rectangle) {
        if (chartLabel.x <= 0 && chartLabel.y <= 0) {
            Rectangle rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 0);
            chartLabel.setBounds(rectangle2);
            chartLabel.setBackground(new ChartBackground(Color.red));
            chartLabel.getProperties().setTextAlignment(1);
            chartLabel.locate();
            return ChartRenderTools.cutRectangle(rectangle, rectangle2, 0);
        }
        chartLabel.locate();
        return rectangle;
    }

    private Rectangle KEY_ANTIALIASING(ChartLabel chartLabel, Rectangle rectangle) {
        chartLabel.locate();
        return rectangle;
    }

    private Rectangle QOIV(ChartLabel chartLabel, Rectangle rectangle) {
        if (chartLabel.x <= 0 && chartLabel.y <= 0) {
            int n = chartLabel.getTitleType();
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = null;
            switch (n) {
                case 2: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 2);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 2);
                    break;
                }
                case 3: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 3);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 3);
                    break;
                }
                case 4: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 1);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 1);
                }
            }
            return rectangle3;
        }
        chartLabel.locate();
        return rectangle;
    }

    private void VALUE_ANTIALIAS_ON(Rectangle rectangle) {
        int n = 0;
        while (n < this.getAxisY1.size()) {
            ChartLabel chartLabel = (ChartLabel)this.getAxisY1.get(n);
            if (chartLabel.x <= 0 && chartLabel.y <= 0) {
                int n2 = chartLabel.getTitleType();
                switch (n2) {
                    case 2: {
                        int n3 = this.allIsIntegerData.height + chartLabel.height + this.allIsIntegerData.y > this.getAxisInfo.y + this.getAxisInfo.height ? this.getAxisInfo.y + this.getAxisInfo.height - chartLabel.height : this.allIsIntegerData.y + this.allIsIntegerData.height;
                        chartLabel.setLocation(this.allIsIntegerData.x + rectangle.x + (rectangle.width - chartLabel.width) / 2, n3);
                        break;
                    }
                    case 3: {
                        int n4 = this.allIsIntegerData.x - chartLabel.width < 0 ? 0 : this.allIsIntegerData.x - chartLabel.width;
                        chartLabel.setLocation(n4, this.allIsIntegerData.y + rectangle.y + (rectangle.height - chartLabel.height) / 2);
                        break;
                    }
                    case 4: {
                        int n4 = this.allIsIntegerData.width + chartLabel.width + this.allIsIntegerData.x > this.getAxisInfo.x + this.getAxisInfo.width ? this.getAxisInfo.x + this.getAxisInfo.width - chartLabel.width : this.allIsIntegerData.x + this.allIsIntegerData.width;
                        chartLabel.setLocation(n4, this.allIsIntegerData.y + rectangle.y + (rectangle.height - chartLabel.height) / 2);
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
            chartLabel.locate();
            ++n;
        }
    }

    private void add(ChartLegend chartLegend) {
        if (chartLegend != null) {
            if (this.D.isShowLegend()) {
                chartLegend.locate();
            } else {
                chartLegend.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void allIsIntegerData(ChartCoordinatePaper chartCoordinatePaper, Rectangle rectangle) {
        chartCoordinatePaper.setBounds(rectangle);
        chartCoordinatePaper.locate();
    }

    public synchronized void paint(Graphics2D graphics2D) {
        Object object = null;
        this.background = this.D.getBackground();
        if (this.DEFAULTCOLORS) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    protected void paintBorder(Graphics2D graphics2D) {
    }

    public boolean getLegendRelocated() {
        return this.append;
    }

    public boolean getShowLegend() {
        return this.calculateTitleAutoPos;
    }

    public List getFillPatterns() {
        return this.KEY_ANTIALIASING;
    }

    public List getFillPatternByList(int n) {
        return (List)this.KEY_ANTIALIASING.get(n);
    }

    public ChartFillPattern[] getFillPatternByArarry(int n) {
        List list = this.getFillPatternByList(n);
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            chartFillPatternArray[n2] = (ChartFillPattern)list.get(n2);
            ++n2;
        }
        return chartFillPatternArray;
    }

    public ChartFillPattern[] getFillPatternsForLegend() {
        return this.GAP_BETWEEN_COMPNENT;
    }

    public ChartFillPattern getFillPatternForLegend(int n) {
        if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ() && this.allIsIntegerData != null && !this.allIsIntegerData.getProperties().getGraphProperties().isVaryColorbyValues()) {
            return this.GAP_BETWEEN_COMPNENT[0];
        }
        return this.GAP_BETWEEN_COMPNENT[n];
    }

    public void setAutoLayoutPaper(boolean bl) {
        this.cutRectangle = bl;
    }

    public void setAutoLayoutLegend(boolean bl) {
        this.contains = bl;
    }

    public void setProperties(ChartPlatformProperties chartPlatformProperties) {
        this.D = chartPlatformProperties;
    }

    public ChartPlatformProperties getProperties() {
        return this.D;
    }

    public List getSurfaceLegendLabels() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ChartNumericAxis chartNumericAxis = this.allIsIntegerData.getAxisY1();
        int n = chartNumericAxis.getNumOfTick();
        double d = chartNumericAxis.getTickPace();
        double d2 = chartNumericAxis.getLabelStartValue();
        boolean[] blArray = chartNumericAxis.surfacePatternIncrea();
        if (blArray[0]) {
            string = d2 - d + "~" + d2;
            arrayList.add(string);
        }
        if (blArray[1]) {
            ++n;
        }
        int n2 = 0;
        while (n2 < n) {
            String string2 = String.valueOf(d2 + (double)n2 * d);
            String string3 = String.valueOf(d2 + (double)(n2 + 1) * d);
            string = string2 + "~" + string3;
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public ChartLegend getChartLegend() {
        return this.allLineArea;
    }

    protected void setChartLegend(ChartLegend chartLegend) {
        this.allLineArea = chartLegend;
    }

    public ChartCoordinatePaper getChartCoordinatePaper() {
        return this.allIsIntegerData;
    }

    protected void setChartCoordinatePaper(ChartCoordinatePaper chartCoordinatePaper) {
        this.allIsIntegerData = chartCoordinatePaper;
    }

    public ChartDataSetModel getDataSetModel() {
        return this.COLORLENGTH;
    }

    public void setDataSetModel(ChartDataSetModel chartDataSetModel) {
        this.COLORLENGTH = chartDataSetModel;
    }

    public ChartFillPattern[] getChartFillPatternForSurface(Chart3DPaper chart3DPaper) {
        ChartNumericAxis chartNumericAxis = chart3DPaper.getAxisY1();
        int n = chartNumericAxis.getNumOfTick();
        boolean[] blArray = chartNumericAxis.surfacePatternIncrea();
        if (blArray[0]) {
            ++n;
        }
        if (blArray[1]) {
            ++n;
        }
        this.QOIV = new ChartFillPattern[n];
        int n2 = 0;
        while (n2 < n) {
            this.QOIV[n2] = n2 > this.GAP_BETWEEN_COMPNENT.length - 1 ? new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[n2 % ChartPropertyValues.COLORLENGTH])) : this.GAP_BETWEEN_COMPNENT[n2];
            ++n2;
        }
        this.D.setPatterns(this.QOIV);
        return this.QOIV;
    }

    public ChartFillPattern getChartFillPatternForSurface(int n) {
        return this.QOIV[n];
    }

    public ChartObject getChartObject(int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (rectangle.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public ChartDefinition getChartDefinition() {
        return this.depthEnable;
    }

    public void setChartDefinition(ChartDefinition chartDefinition) {
        this.depthEnable = chartDefinition;
    }

    private void allLineArea() {
        this.get = new ChartRenderInfo();
        ChartDefinition chartDefinition = this.getChartDefinition();
        chartDefinition.getCoordinateInfo(this.get);
        ArrayList<ChartDataSet> arrayList = new ArrayList<ChartDataSet>();
        ArrayList<ChartDataSet> arrayList2 = new ArrayList<ChartDataSet>();
        int n = 0;
        while (n < this.add.size()) {
            ChartDataSet chartDataSet = (ChartDataSet)this.add.get(n);
            switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                case 0: {
                    arrayList.add(chartDataSet);
                    break;
                }
                case 1: {
                    arrayList2.add(chartDataSet);
                }
            }
            ++n;
        }
        this.append(this.get, this.get.primLayer, arrayList);
        this.append(this.get, this.get.secLayer, arrayList2);
        this.get.xAxisLineUnit = this.get.primLayer != null && this.get.secLayer == null && this.get.primLayer.allLineArea || this.get.secLayer != null && this.get.primLayer == null && this.get.secLayer.allLineArea;
        this.get.setHasLegend(this.D.isShowLegend());
    }

    private void append(ChartRenderInfo chartRenderInfo, ChartRenderInfo.ChartLayerRenderInfo chartLayerRenderInfo, List list) {
        ChartDataSet chartDataSet = null;
        double d = chartRenderInfo.xMin;
        double d2 = chartRenderInfo.xMax;
        if (chartLayerRenderInfo != null) {
            double d3 = 0.0;
            double d4 = 0.0;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            int n = 0;
            while (n < list.size()) {
                chartDataSet = (ChartDataSet)list.get(n);
                if (bl && !chartDataSet.isIntegerData()) {
                    bl = false;
                }
                int n2 = chartDataSet.getChartDataSetInfo().getChartType();
                int n3 = ChartTypeInfo.getPrimType(n2);
                int n4 = ChartTypeInfo.getSubType(n2);
                int n5 = ChartTypeInfo.getSeriesType(n2);
                switch (n3) {
                    case 0: {
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    case 1: {
                        bl2 = false;
                        bl4 = false;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    case 9: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                        bl5 = true;
                        break;
                    }
                    default: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                    }
                }
                switch (n4) {
                    case 256: {
                        bl6 = true;
                    }
                }
                switch (n5) {
                    case 65536: {
                        double d5 = ((Chart2DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart2DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart2DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart2DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                        break;
                    }
                    case 131072: {
                        double d5 = ((Chart3DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart3DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart3DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart3DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                        break;
                    }
                    case 0: 
                    case 196608: {
                        double d5 = chartDataSet.getMin();
                        double d6 = chartDataSet.getMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                    }
                }
                ++n;
            }
            chartLayerRenderInfo.yMin = d3;
            chartLayerRenderInfo.yMax = d4;
            chartLayerRenderInfo.allIsIntegerData = bl;
            chartLayerRenderInfo.depthEnable = bl2 || bl3;
            chartLayerRenderInfo.allLineArea = bl4;
            chartLayerRenderInfo.hasBubble = bl5;
            chartLayerRenderInfo.hasPercent = bl6;
        }
        chartRenderInfo.xMin = chartRenderInfo.xMin < d ? chartRenderInfo.xMin : d;
        chartRenderInfo.xMax = chartRenderInfo.xMax > d2 ? chartRenderInfo.xMax : d2;
    }

    public ChartRenderInfo getChartRenderInfo() {
        return this.get;
    }

    public Rectangle getGraphisRect() {
        return this.getAxisInfo;
    }

    public boolean isSameRes(int n) {
        return this.getBackground == n;
    }

    public void setRes(int n) {
        this.getBackground = n;
    }
}

