/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.ChartRenderInfo;
import chart.ChartWall;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPieLayer;
import chart.chart2d.Chart2DRadarLayer;
import chart.chart2d.Graph2DArea;
import chart.chart2d.Graph2DAreaA;
import chart.chart2d.Graph2DAreaP;
import chart.chart2d.Graph2DAreaSt;
import chart.chart2d.Graph2DBar;
import chart.chart2d.Graph2DBarP;
import chart.chart2d.Graph2DBarSi;
import chart.chart2d.Graph2DBarSt;
import chart.chart2d.Graph2DBubble;
import chart.chart2d.Graph2DGuageBalls;
import chart.chart2d.Graph2DGuageBars;
import chart.chart2d.Graph2DGuageDials;
import chart.chart2d.Graph2DLine;
import chart.chart2d.Graph2DLineA;
import chart.chart2d.Graph2DLineP;
import chart.chart2d.Graph2DLineSt;
import chart.chart2d.Graph2DMeanLine;
import chart.chart2d.Graph2DPie;
import chart.chart2d.Graph2DRadar;
import chart.chart2d.Graph2DScatterL;
import chart.chart2d.Graph2DScatterN;
import chart.chart2d.Graph2DScatterS;
import chart.chart2d.Graph2DStockHLC;
import chart.chart2d.Graph2DStockOC;
import chart.chart2d.Graph2DStockOHLC;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartShadow;
import chart.properties.ChartCoordinatePaperProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Chart2DPaper
extends ChartCoordinatePaper {
    public static final int GRAPH_POSITION_AUTO = 0;
    public static final int GRAPH_POSITION_KEEPCENTER = 1;
    ChartPlatform I;
    public ChartDataSetModel model;
    List D;
    ChartAxis IsLabelFontAutomaticOrientation;
    ChartAxis IsShowAxisXLabelTips;
    ChartAxis Z;
    ChartAxis IsShowAxisYLabelTips;
    private ChartWall OLD_PAPER_MARGINE = null;
    private GridLine QOIV = null;
    private GridLine add = null;
    private GridLine allIsIntegerData = null;
    private GridLine allLineArea = null;
    private GridLine append = null;
    Chart2DLayer axisX;
    Chart2DLayer black;
    Chart2DLayer calculateGraphArea;
    Chart2DObject[] contains;
    Chart2DObject[] createGraphics;
    private Rectangle depthEnable;
    private ChartAxis draw = null;
    private ChartAxis drawSelectedShape = null;
    private ChartAxis drawShadow = null;
    private ChartAxis fill = null;
    private float get;
    private int[] getAreaPatternList;
    private String getAutoOritention = null;
    private List getAxis;
    private List getAxisAreaPath;
    private ChartRenderInfo getAxisFristLabelWidht;
    private int getAxisInfo = -1;
    private BufferedImage getAxisLastLabelWidht = null;
    private int getAxisPaths = 0;
    String[] getAxisShapes;
    private int getAxisWithTickLength = 0;
    public int selectedLineIndex = -1;

    public Chart2DPaper(ChartPlatform chartPlatform, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.I = chartPlatform;
        this.properties = chartCoordinatePaperProperties;
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        this.background = this.properties.getBackground();
        super.paint(graphics2D);
        if (this.calculateGraphArea != null) {
            this.calculateGraphArea.paintWall(graphics2D, this.OLD_PAPER_MARGINE);
        }
        if (this.getAxisLastLabelWidht != null) {
            this.D(graphics2D);
            ChartShadow.drawShadow(graphics2D, this.getAxisLastLabelWidht, 3, 2);
        }
        if (this.axisX != null) {
            this.axisX.paintGrid(graphics2D);
        }
        if (this.black != null) {
            this.black.paintGrid(graphics2D);
        }
        if (this.properties.isReversePaintingOrder()) {
            n = this.contains.length - 1;
            while (n >= 0) {
                this.contains[n].paint(graphics2D);
                --n;
            }
            if (this.axisX != null) {
                this.axisX.paintAxis(graphics2D);
            }
            if (this.black != null) {
                this.black.paintAxis(graphics2D);
            }
        } else {
            n = 0;
            while (n < this.contains.length) {
                this.contains[n].paint(graphics2D);
                ++n;
            }
            if (this.axisX != null) {
                this.axisX.paintAxis(graphics2D);
            }
            if (this.black != null) {
                this.black.paintAxis(graphics2D);
            }
        }
        if (this.allLineArea()) {
            if (this.createGraphics != null && this.properties.getGraphProperties().isShowMeanLine()) {
                n = 0;
                while (n < this.createGraphics.length) {
                    if (this.createGraphics[n] != null) {
                        this.createGraphics[n].paint(graphics2D);
                    }
                    ++n;
                }
            }
            if (this.calculateGraphArea != null) {
                this.calculateGraphArea.paintThresholdLine(graphics2D);
            }
        }
        this.add(graphics2D);
        super.paintBorder(graphics2D);
    }

    private void D(Graphics2D graphics2D) {
        int n;
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (this.properties.isReversePaintingOrder()) {
            n = this.contains.length - 1;
            while (n >= 0) {
                int n2 = 0;
                while (n2 < this.model.getSeriesCount()) {
                    generalPath.append(this.contains[n].getShapeBySeries(n2), false);
                    ++n2;
                }
                --n;
            }
        } else {
            n = 0;
            while (n < this.contains.length) {
                int n3 = 0;
                while (n3 < this.model.getSeriesCount()) {
                    generalPath.append(this.contains[n].getShapeBySeries(n3), false);
                    ++n3;
                }
                ++n;
            }
        }
        Graphics2D graphics2D2 = this.getAxisLastLabelWidht.createGraphics();
        graphics2D2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.55f));
        graphics2D2.fill(generalPath);
        graphics2D2.draw(generalPath);
    }

    public void init() {
        int n;
        this.model = this.I.getDataSetModel();
        this.D = this.model.getChartDataSets();
        this.getAxisShapes = this.model.getValuesName();
        ChartDataSet chartDataSet = null;
        this.getAxis = new ArrayList();
        this.getAxisAreaPath = new ArrayList();
        int n2 = 0;
        while (n2 < this.D.size()) {
            chartDataSet = (ChartDataSet)this.D.get(n2);
            switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                case 0: {
                    this.getAxis.add(chartDataSet);
                    break;
                }
                case 1: {
                    this.getAxisAreaPath.add(chartDataSet);
                }
            }
            ++n2;
        }
        this.IsLabelFontAutomaticOrientation();
        this.IsShowAxisYLabelTips();
        this.contains = new Chart2DObject[this.D.size()];
        Chart2DLayer chart2DLayer = null;
        if (this.properties.isReversePaintingOrder()) {
            n = this.contains.length - 1;
            while (n >= 0) {
                chartDataSet = (ChartDataSet)this.D.get(n);
                switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                    case 0: {
                        chart2DLayer = this.axisX;
                        ++this.getAxisPaths;
                        break;
                    }
                    case 1: {
                        chart2DLayer = this.black;
                        ++this.getAxisPaths;
                    }
                }
                this.contains[n] = this.QOIV(chartDataSet, chart2DLayer, this.getAxisPaths);
                this.contains[n].setChartFillPatters(this.I.getFillPatternByArarry(n));
                --n;
            }
        } else {
            n = 0;
            while (n < this.contains.length) {
                chartDataSet = (ChartDataSet)this.D.get(n);
                switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                    case 0: {
                        chart2DLayer = this.axisX;
                        ++this.getAxisPaths;
                        break;
                    }
                    case 1: {
                        chart2DLayer = this.black;
                        ++this.getAxisPaths;
                    }
                }
                this.contains[n] = this.QOIV(chartDataSet, chart2DLayer, this.getAxisPaths);
                this.contains[n].setChartFillPatters(this.I.getFillPatternByArarry(n));
                ++n;
            }
        }
        if (this.properties.getGraphProperties().isShowMeanLine()) {
            n = this.contains.length;
            this.createGraphics = new Chart2DObject[n];
            int n3 = 0;
            while (n3 < n) {
                boolean bl;
                chartDataSet = (ChartDataSet)this.D.get(n3);
                int n4 = chartDataSet.getChartDataSetInfo().getChartType();
                int n5 = ChartTypeInfo.getPrimType(n4);
                boolean bl2 = bl = chartDataSet.getChartDataSetInfo().getAxisInfo() == 1;
                if (n5 == 3 || n5 == 0 || n5 == 1 || n5 == 2) {
                    float f = 0.0f;
                    f = n > 1 || n5 == 0 || n5 == 1 ? 0.5f : 0.0f;
                    boolean bl3 = false;
                    if (n5 == 1) {
                        bl3 = true;
                    }
                    this.createGraphics[n3] = bl ? new Graph2DMeanLine(chartDataSet, this, this.black, bl3, false, f) : new Graph2DMeanLine(chartDataSet, this, this.axisX, bl3, true, f);
                }
                ++n3;
            }
        }
    }

    private void IsLabelFontAutomaticOrientation() {
        this.getAxisFristLabelWidht = new ChartRenderInfo();
        ChartDefinition chartDefinition = this.I.getChartDefinition();
        chartDefinition.getCoordinateInfo(this.getAxisFristLabelWidht);
        this.IsShowAxisXLabelTips(this.getAxisFristLabelWidht, this.getAxisFristLabelWidht.primLayer, this.getAxis);
        this.IsShowAxisXLabelTips(this.getAxisFristLabelWidht, this.getAxisFristLabelWidht.secLayer, this.getAxisAreaPath);
        this.getAxisFristLabelWidht.xAxisLineUnit = this.getAxisFristLabelWidht.primLayer != null && this.getAxisFristLabelWidht.secLayer == null && this.getAxisFristLabelWidht.primLayer.allLineArea || this.getAxisFristLabelWidht.secLayer != null && this.getAxisFristLabelWidht.primLayer == null && this.getAxisFristLabelWidht.secLayer.allLineArea;
    }

    private void IsShowAxisXLabelTips(ChartRenderInfo chartRenderInfo, ChartRenderInfo.ChartLayerRenderInfo chartLayerRenderInfo, List list) {
        ChartDataSet chartDataSet = null;
        double d = chartRenderInfo.xMin;
        double d2 = chartRenderInfo.xMax;
        if (chartLayerRenderInfo != null) {
            double d3 = 0.0;
            double d4 = 0.0;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            int n = 0;
            while (n < list.size()) {
                chartDataSet = (ChartDataSet)list.get(n);
                if (bl && !chartDataSet.isIntegerData()) {
                    bl = false;
                }
                int n2 = chartDataSet.getChartDataSetInfo().getChartType();
                int n3 = ChartTypeInfo.getPrimType(n2);
                int n4 = ChartTypeInfo.getSubType(n2);
                int n5 = ChartTypeInfo.getSeriesType(n2);
                switch (n3) {
                    case 0: {
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    case 1: {
                        bl2 = false;
                        bl4 = false;
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 9: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                        bl5 = true;
                        break;
                    }
                    default: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                    }
                }
                switch (n4) {
                    case 256: {
                        bl6 = true;
                    }
                }
                switch (n5) {
                    case 65536: {
                        double d5 = ((Chart2DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart2DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart2DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart2DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        double d7 = d4 = d4 > d6 ? d4 : d6;
                        if (n3 != 10) break;
                        d3 = chartDataSet.getMin();
                        d4 = chartDataSet.getMax();
                        break;
                    }
                    case 131072: {
                        double d5 = ((Chart3DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart3DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart3DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart3DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        double d8 = d4 = d4 > d6 ? d4 : d6;
                        if (n3 != 10) break;
                        d3 = chartDataSet.getMin();
                        d4 = chartDataSet.getMax();
                        break;
                    }
                    case 0: 
                    case 196608: {
                        double d5 = chartDataSet.getMin();
                        double d6 = chartDataSet.getMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                    }
                }
                ++n;
            }
            chartLayerRenderInfo.yMin = d3;
            chartLayerRenderInfo.yMax = d4;
            chartLayerRenderInfo.allIsIntegerData = bl;
            chartLayerRenderInfo.depthEnable = bl2 || bl3;
            chartLayerRenderInfo.allLineArea = bl4;
            chartLayerRenderInfo.hasBubble = bl5;
            chartLayerRenderInfo.hasPercent = bl6;
        }
        chartRenderInfo.xMin = chartRenderInfo.xMin < d ? chartRenderInfo.xMin : d;
        chartRenderInfo.xMax = chartRenderInfo.xMax > d2 ? chartRenderInfo.xMax : d2;
    }

    private void IsShowAxisYLabelTips() {
        this.axisX = null;
        this.black = null;
        this.QOIV = new GridLine();
        this.allIsIntegerData = new GridLine();
        this.add = new GridLine();
        this.allLineArea = new GridLine();
        this.append = new GridLine();
        if (this.getAxisFristLabelWidht.primLayer != null) {
            switch (this.getAxisFristLabelWidht.primLayer.getCoordinateType()) {
                case 3: {
                    this.IsLabelFontAutomaticOrientation = new ChartNumericAxis(this.properties.getAxisXProperties(), this.getAxisFristLabelWidht.xMin, this.getAxisFristLabelWidht.xMax);
                    this.Z = new ChartNumericAxis(this.properties.getAxisYProperties(), this.getAxisFristLabelWidht.primLayer.yMin, this.getAxisFristLabelWidht.primLayer.yMax);
                    ((ChartNumericAxis)this.IsLabelFontAutomaticOrientation).setAutoExpand(true);
                    ((ChartNumericAxis)this.Z).setAutoExpand(true);
                    if (!this.getAxisFristLabelWidht.primLayer.hasBubble) break;
                    ((ChartNumericAxis)this.IsLabelFontAutomaticOrientation).setIsBubble(true);
                    ((ChartNumericAxis)this.Z).setIsBubble(true);
                    break;
                }
                case 0: {
                    this.IsLabelFontAutomaticOrientation = null;
                    this.Z = null;
                    break;
                }
                case 4: {
                    this.Z = new ChartNumericRadarAxis(this.properties.getAxisYProperties(), this.getAxisFristLabelWidht.primLayer.yMin, this.getAxisFristLabelWidht.primLayer.yMax, this.model.getCategoryNames(), this.properties.getAxisXProperties().getLabelTextStyle());
                    ((ChartNumericRadarAxis)this.Z).setIsShowRadarColumnName(this.properties.getGraphProperties().isRadarIsShowColumnName());
                    break;
                }
                case 5: {
                    this.IsLabelFontAutomaticOrientation = null;
                    this.Z = new ChartNumericAxis(this.properties.getAxisYProperties(), this.getAxisFristLabelWidht.primLayer.yMin, this.getAxisFristLabelWidht.primLayer.yMax);
                    break;
                }
                case 1: 
                case 2: {
                    this.IsLabelFontAutomaticOrientation = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                    this.Z = new ChartNumericAxis(this.properties.getAxisYProperties(), this.getAxisFristLabelWidht.primLayer.yMin, this.getAxisFristLabelWidht.primLayer.yMax);
                    if (this.getAxisFristLabelWidht.primLayer.hasPercent) break;
                    ((ChartNumericAxis)this.Z).setAutoExpand(true);
                    ((ChartNumericAxis)this.Z).setIntegerIncrement(this.getAxisFristLabelWidht.primLayer.allIsIntegerData);
                }
            }
            if (this.IsLabelFontAutomaticOrientation != null) {
                this.IsLabelFontAutomaticOrientation.setFilter(this.model.getCategoryFilter());
                this.IsLabelFontAutomaticOrientation.setShow(this.properties.isShowAxisX());
                this.IsLabelFontAutomaticOrientation.init();
            }
            if (this.Z != null) {
                this.Z.setFilter(this.model.getPrimFilter());
                this.Z.setShow(this.properties.isShowAxisY());
                if (this.Z instanceof ChartNumericRadarAxis) {
                    ((ChartNumericRadarAxis)this.Z).setCategoryFilter(this.model.getCategoryFilter());
                }
                this.Z.init();
            }
            switch (this.getAxisFristLabelWidht.primLayer.getCoordinateType()) {
                case 4: {
                    this.axisX = new Chart2DRadarLayer(this);
                    break;
                }
                case 0: 
                case 5: {
                    this.axisX = new Chart2DPieLayer(this);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.axisX = new Chart2DLayer(this);
                }
            }
            this.axisX.setAxisX(this.IsLabelFontAutomaticOrientation);
            this.axisX.setAxisY(this.Z);
            this.axisX.init();
            this.axisX.setChartCount(this.D.size());
        }
        if (this.getAxisFristLabelWidht.secLayer != null) {
            switch (this.getAxisFristLabelWidht.secLayer.getCoordinateType()) {
                case 3: {
                    this.IsShowAxisXLabelTips = new ChartNumericAxis(this.properties.getAxisXProperties(), this.getAxisFristLabelWidht.xMin, this.getAxisFristLabelWidht.xMax);
                    this.IsShowAxisYLabelTips = new ChartNumericAxis(this.properties.getAxisY2Properties(), this.getAxisFristLabelWidht.secLayer.yMin, this.getAxisFristLabelWidht.secLayer.yMax);
                    ((ChartNumericAxis)this.IsShowAxisXLabelTips).setAutoExpand(true);
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAutoExpand(true);
                    if (!this.getAxisFristLabelWidht.secLayer.hasBubble) break;
                    ((ChartNumericAxis)this.IsShowAxisXLabelTips).setIsBubble(true);
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setIsBubble(true);
                    break;
                }
                case 0: {
                    this.IsShowAxisXLabelTips = null;
                    this.IsShowAxisYLabelTips = null;
                    break;
                }
                case 4: {
                    this.IsShowAxisXLabelTips = null;
                    this.IsShowAxisYLabelTips = new ChartNumericAxis(this.properties.getAxisYProperties(), this.getAxisFristLabelWidht.secLayer.yMin, this.getAxisFristLabelWidht.secLayer.yMax);
                    break;
                }
                case 1: 
                case 2: {
                    this.IsShowAxisXLabelTips = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                    this.IsShowAxisYLabelTips = new ChartNumericAxis(this.properties.getAxisY2Properties(), this.getAxisFristLabelWidht.secLayer.yMin, this.getAxisFristLabelWidht.secLayer.yMax);
                    if (this.getAxisFristLabelWidht.secLayer.hasPercent) break;
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAutoExpand(true);
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setIntegerIncrement(this.getAxisFristLabelWidht.secLayer.allIsIntegerData);
                }
            }
            if (this.IsShowAxisXLabelTips != null) {
                this.IsShowAxisXLabelTips.setFilter(this.model.getCategoryFilter());
                this.IsShowAxisXLabelTips.setShow(this.properties.isShowAxisX());
                this.IsShowAxisXLabelTips.init();
            }
            if (this.IsShowAxisYLabelTips != null) {
                this.IsShowAxisYLabelTips.setFilter(this.model.getSecFilter());
                this.IsShowAxisYLabelTips.setShow(this.properties.isShowAxisY2());
                this.IsShowAxisYLabelTips.init();
            }
            this.black = new Chart2DLayer(this);
            this.black.setAxisX(this.IsShowAxisXLabelTips);
            this.black.setAxisY(this.IsShowAxisYLabelTips);
            this.black.init();
            this.black.setChartCount(this.D.size());
        }
        if (this.getAxisFristLabelWidht.primLayer != null && this.getAxisFristLabelWidht.primLayer.isHasWall()) {
            this.calculateGraphArea = this.axisX;
        } else if (this.getAxisFristLabelWidht.secLayer != null && this.getAxisFristLabelWidht.secLayer.isHasWall()) {
            this.calculateGraphArea = this.black;
        }
        if (this.calculateGraphArea != null) {
            this.OLD_PAPER_MARGINE = new ChartWall();
            this.OLD_PAPER_MARGINE.setProperties(this.properties.getWallProperties());
            if (this.axisX == null || this.black == null) {
                if (this.axisX != null) {
                    if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2) {
                        this.draw = null;
                        this.drawShadow = this.IsLabelFontAutomaticOrientation;
                        this.drawSelectedShape = this.Z;
                        this.fill = null;
                    } else if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 1 || this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 3) {
                        this.draw = null;
                        this.drawShadow = this.Z;
                        this.drawSelectedShape = this.IsLabelFontAutomaticOrientation;
                        this.fill = null;
                    }
                } else if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                    this.draw = null;
                    this.drawShadow = null;
                    this.drawSelectedShape = this.IsShowAxisYLabelTips;
                    this.fill = this.IsShowAxisXLabelTips;
                } else {
                    this.draw = null;
                    this.drawShadow = null;
                    this.drawSelectedShape = this.IsShowAxisXLabelTips;
                    this.fill = this.IsShowAxisYLabelTips;
                }
            } else if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2) {
                if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                    this.draw = this.Z;
                    this.drawShadow = this.IsLabelFontAutomaticOrientation;
                    this.drawSelectedShape = this.IsShowAxisYLabelTips;
                    this.fill = null;
                } else {
                    this.draw = this.Z;
                    this.drawShadow = this.IsLabelFontAutomaticOrientation;
                    this.drawSelectedShape = this.IsShowAxisXLabelTips;
                    this.fill = this.IsShowAxisYLabelTips;
                }
            } else if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                this.draw = this.IsShowAxisYLabelTips;
                this.drawShadow = this.Z;
                this.drawSelectedShape = this.IsLabelFontAutomaticOrientation;
                this.fill = this.IsShowAxisXLabelTips;
            } else {
                this.draw = null;
                this.drawShadow = this.Z;
                this.drawSelectedShape = this.IsLabelFontAutomaticOrientation;
                this.fill = this.IsShowAxisYLabelTips;
            }
        }
    }

    public void calculateGraphArea() {
        int n;
        Rectangle rectangle = super.getBounds();
        Rectangle rectangle2 = super.getCoreArea();
        int n2 = rectangle2.y;
        int n3 = rectangle2.x;
        int n4 = rectangle.width - rectangle2.x - rectangle2.width;
        int n5 = rectangle.height - rectangle2.y - rectangle2.height;
        n2 = (int)((float)n2 + this.properties.getTopMargin());
        n3 = (int)((float)n3 + this.properties.getLeftMargin());
        n4 = (int)((float)n4 + this.properties.getRightMargin());
        n5 = (int)((float)n5 + this.properties.getBottomMargin());
        if (this.calculateGraphArea != null) {
            n = 0;
            double d = 0.0;
            double d2 = 0.0;
            int n6 = 0;
            while (n6 < this.contains.length) {
                if (this.contains[n6] instanceof Graph2DLine || this.contains[n6] instanceof Graph2DArea || this.getAxisFristLabelWidht.primLayer != null && this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2 || this.getAxisFristLabelWidht.primLayer != null && this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 3) {
                    n = 1;
                }
                ++n6;
            }
            if (n != 0 && this.drawSelectedShape != null && this.drawSelectedShape.getProperties().isShowTickMarkLabels()) {
                d = this.drawSelectedShape.getAxisFristLabelWidht() / 2.0;
                d2 = this.drawSelectedShape.getAxisLastLabelWidht() / 2.0;
            }
            if (this.properties.getGraphPosition() == 1) {
                double d3;
                if (this.draw != null && this.draw.isShow()) {
                    this.draw.setAxisPosition(1);
                    if (this.draw.getProperties().isShowTickMarkLabels()) {
                        n2 += this.draw.getAxisWithTickLength() + this.draw.getMaxDimensionOfLabels().height + ChartEnv.OLD_PAPER_MARGINE;
                    }
                }
                if (this.drawSelectedShape != null && this.drawSelectedShape.isShow()) {
                    this.drawSelectedShape.setAxisPosition(3);
                    if (this.drawSelectedShape.getProperties().isShowTickMarkLabels()) {
                        n5 += this.drawSelectedShape.getAxisWithTickLength() + this.drawSelectedShape.getMaxDimensionOfLabels().height + ChartEnv.OLD_PAPER_MARGINE;
                    }
                }
                if (this.drawShadow != null) {
                    this.drawShadow.setAxisPosition(2);
                    if (this.drawShadow.isShow() && this.drawShadow.getProperties().isShowTickMarkLabels()) {
                        d3 = this.drawShadow.getAxisWithTickLength() + this.drawShadow.getMaxDimensionOfLabels().width;
                        if (d3 < d) {
                            d3 = d;
                        }
                        n3 = (int)((double)n3 + (d3 + (double)ChartEnv.OLD_PAPER_MARGINE));
                    }
                } else {
                    n3 = (int)((double)n3 + d);
                }
                if (this.fill != null) {
                    this.fill.setAxisPosition(4);
                    if (this.fill.isShow() && this.fill.getProperties().isShowTickMarkLabels()) {
                        d3 = this.fill.getAxisWithTickLength() + this.fill.getMaxDimensionOfLabels().width;
                        if (d3 < d2) {
                            d3 = d2;
                        }
                        n4 = (int)((double)n4 + (d3 + (double)ChartEnv.OLD_PAPER_MARGINE));
                    }
                } else {
                    n4 = (int)((double)n4 + d2);
                }
                if (n2 > n5) {
                    n5 = n2;
                } else {
                    n2 = n5;
                }
                if (n3 > n4) {
                    n4 = n3;
                } else {
                    n3 = n4;
                }
            } else {
                double d4;
                if (this.draw != null) {
                    if (this.draw.isShow()) {
                        this.draw.setAxisPosition(1);
                        if (this.draw.getProperties().isShowTickMarkLabels()) {
                            n2 += this.draw.getAxisWithTickLength();
                            n2 += this.draw.getMaxDimensionOfLabels().height;
                        }
                    }
                    if (this.properties.getGraphProperties().getDepth() > 0.0f && this.axisX == null && this.getAxisFristLabelWidht.secLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                        n2 = (int)((float)n2 + this.properties.getGraphProperties().getDepth());
                    }
                }
                if (this.drawShadow != null) {
                    if (this.drawShadow.isShow()) {
                        this.drawShadow.setAxisPosition(2);
                        d4 = 0.0;
                        if (this.drawShadow.getProperties().isShowTickMarkLabels()) {
                            d4 = this.drawShadow.getAxisWithTickLength();
                            d4 += (double)this.drawShadow.getMaxDimensionOfLabels().width;
                        }
                        if (d4 < d) {
                            d4 = d;
                        }
                        n3 = (int)((double)n3 + d4);
                    }
                    if (this.properties.getGraphProperties().getDepth() > 0.0f && this.black == null && this.getAxisFristLabelWidht.primLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                        n3 = (int)((float)n3 + this.properties.getGraphProperties().getDepth());
                    }
                } else {
                    n3 = (int)((double)n3 + d);
                }
                if (this.drawSelectedShape != null) {
                    if (this.drawSelectedShape.isShow()) {
                        this.drawSelectedShape.setAxisPosition(3);
                        if (this.drawSelectedShape.getProperties().isShowTickMarkLabels()) {
                            n5 += this.drawSelectedShape.getAxisWithTickLength();
                            n5 += this.drawSelectedShape.getMaxDimensionOfLabels().height;
                        }
                    }
                    if (this.properties.getGraphProperties().getDepth() > 0.0f && this.black == null && this.getAxisFristLabelWidht.primLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                        n5 = (int)((float)n5 + this.properties.getGraphProperties().getDepth());
                    }
                }
                if (this.fill != null) {
                    if (this.fill.isShow()) {
                        this.fill.setAxisPosition(4);
                        d4 = 0.0;
                        if (this.fill.getProperties().isShowTickMarkLabels()) {
                            d4 = this.fill.getAxisWithTickLength();
                            d4 += (double)this.fill.getMaxDimensionOfLabels().width;
                        }
                        if (d4 < d2) {
                            d4 = d2;
                        }
                        n4 = (int)((double)n4 + d4);
                    }
                    if (this.properties.getGraphProperties().getDepth() > 0.0f && this.axisX == null && this.getAxisFristLabelWidht.secLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                        n4 = (int)((float)n4 + this.properties.getGraphProperties().getDepth());
                    }
                } else {
                    n4 = (int)((double)n4 + d2);
                }
            }
        } else if (this.contains[0] instanceof Graph2DRadar) {
            n2 = rectangle2.y;
            n3 = rectangle2.x;
            n4 = rectangle.width - rectangle2.x - rectangle2.width;
            n5 = rectangle.height - rectangle2.y - rectangle2.height;
            ((ChartNumericRadarAxis)this.Z).setIsShowRadarColumnName(this.properties.getGraphProperties().isRadarIsShowColumnName());
        }
        n = n3;
        int n7 = n2;
        int n8 = rectangle.width - n3 - n4;
        int n9 = rectangle.height - n2 - n5;
        n = n > 0 ? n : 0;
        n7 = n7 > 0 ? n7 : 0;
        n8 = n8 > 0 ? n8 : 0;
        n9 = n9 > 0 ? n9 : 0;
        this.depthEnable = new Rectangle(n, n7, n8, n9);
    }

    public void locate() {
        this.calculateGraphArea();
        this.OLD_PAPER_MARGINE();
        if (this.properties.isShadowContents()) {
            this.getAxisLastLabelWidht = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        if (this.axisX != null || this.black != null) {
            if (this.axisX != null) {
                if (this.axisX.axisX != null) {
                    if (this.axisX.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                        this.calculateGraphArea();
                        this.OLD_PAPER_MARGINE();
                    }
                    if (this.axisX.getAutoOritention(true)) {
                        this.axisX.axisX.getProperties().getLabelTextStyle().setRotation(-0.5235987755982988);
                        this.calculateGraphArea();
                        this.OLD_PAPER_MARGINE();
                    } else if (this.axisX.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                        this.calculateGraphArea();
                        this.OLD_PAPER_MARGINE();
                    }
                }
            } else if (this.black.axisX != null) {
                if (this.black.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                    this.calculateGraphArea();
                    this.OLD_PAPER_MARGINE();
                }
                if (this.black.getAutoOritention(true)) {
                    this.black.axisX.getProperties().getLabelTextStyle().setRotation(-0.5235987755982988);
                    this.calculateGraphArea();
                    this.OLD_PAPER_MARGINE();
                } else if (this.black.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                    this.calculateGraphArea();
                    this.OLD_PAPER_MARGINE();
                }
            }
        }
        if (this.createGraphics != null) {
            int n = 0;
            while (n < this.createGraphics.length) {
                if (this.createGraphics[n] != null) {
                    ((Graph2DMeanLine)this.createGraphics[n]).setPercent(ChartTypeInfo.getSubType(this.model.getChartDataSet(n).getChartDataSetInfo().getChartType()) == 256);
                    this.createGraphics[n].init();
                    this.createGraphics[n].locate();
                }
                ++n;
            }
        }
        int[] nArray = this.properties.getValueLabelPositionList();
        int n = 0;
        int n2 = 0;
        while (n2 < this.contains.length) {
            if (nArray != null && nArray.length > 0 && n2 < nArray.length) {
                this.contains[n2].setValueLabelPosition(nArray[n2]);
            }
            if (this.contains[n2] instanceof Graph2DBar) {
                float f = this.properties.getGraphProperties().getBarWidth();
                if (this.allIsIntegerData((Graph2DBar)this.contains[n2])) {
                    int n3 = 0;
                    while (n3 < n) {
                        f *= 0.8f;
                        ++n3;
                    }
                    ++n;
                }
                ((Graph2DBar)this.contains[n2]).setBarWidth(f);
            }
            this.contains[n2].init();
            if (this.contains[n2] instanceof Graph2DLine) {
                ((Graph2DLine)this.contains[n2]).setAreaPatterns(this.properties.getGraphProperties().getAreaPatternList(), this.getAxisWithTickLength);
                this.getAxisWithTickLength = ((Graph2DLine)this.contains[n2]).getStartIndex();
            }
            this.contains[n2].locate();
            ++n2;
        }
    }

    private void OLD_PAPER_MARGINE() {
        if (this.axisX == null || this.black == null) {
            if (this.axisX != null) {
                this.axisX.I(super.getBounds(), this.depthEnable, this.properties.getScaleX(), this.properties.getScaleY());
                if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2) {
                    this.axisX.Z(0);
                    this.axisX.transformBench0();
                    ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(2);
                    ((ChartNumericAxis)this.Z).setAxisPosition(3);
                } else if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 4) {
                    this.axisX.transformRadar();
                    ((ChartNumericAxis)this.Z).setAxisPosition(4);
                } else {
                    this.axisX.transformNormal();
                    if (this.IsLabelFontAutomaticOrientation != null) {
                        if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 3 || this.getAxisFristLabelWidht.primLayer.hasBubble) {
                            ((ChartNumericAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(3);
                        }
                    }
                    if (this.Z != null) {
                        ((ChartNumericAxis)this.Z).setAxisPosition(2);
                    }
                }
                if (this.getAxisFristLabelWidht.xAxisLineUnit) {
                    ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setIsLineUnit(true);
                }
                if (this.getAxisFristLabelWidht.primLayer.depthEnable) {
                    this.axisX.setDepth((int)this.properties.getGraphProperties().getDepth());
                    this.axisX.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                    this.axisX.setUseDepth(this.properties.getGraphProperties().isUseDepth());
                }
                this.axisX.Z(this.properties.getAxisYProperties().getPlacement());
                this.axisX.I(this.properties.getAxisXProperties().getPlacement());
                this.axisX.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
                this.axisX.locate();
                if (this.axisX.isDepth()) {
                    if (this.IsLabelFontAutomaticOrientation != null) {
                        this.IsLabelFontAutomaticOrientation.setDepth(this.axisX.isDepth());
                    }
                    if (this.Z != null) {
                        this.Z.setDepth(this.axisX.isDepth());
                    }
                }
            } else {
                this.black.I(super.getBounds(), this.depthEnable, this.properties.getScaleX(), this.properties.getScaleY());
                this.black.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
                if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                    this.black.transformBench2();
                    ((ChartCategoryAxis)this.IsShowAxisXLabelTips).setAxisPosition(4);
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(3);
                } else {
                    this.black.Z(2);
                    this.black.transformNormal();
                    if (this.IsShowAxisXLabelTips != null) {
                        if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 3 || this.getAxisFristLabelWidht.secLayer.hasBubble) {
                            ((ChartNumericAxis)this.IsShowAxisXLabelTips).setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.IsShowAxisXLabelTips).setAxisPosition(3);
                        }
                    }
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(4);
                }
                if (this.getAxisFristLabelWidht.xAxisLineUnit) {
                    ((ChartCategoryAxis)this.IsShowAxisXLabelTips).setIsLineUnit(true);
                }
                if (this.getAxisFristLabelWidht.secLayer.depthEnable) {
                    this.black.setDepth((int)this.properties.getGraphProperties().getDepth());
                    this.black.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                    this.black.setUseDepth(this.properties.getGraphProperties().isUseDepth());
                }
                this.black.locate();
                if (this.black.isDepth()) {
                    if (this.IsShowAxisXLabelTips != null) {
                        this.IsShowAxisXLabelTips.setDepth(this.axisX.isDepth());
                    }
                    if (this.IsShowAxisYLabelTips != null) {
                        this.IsShowAxisYLabelTips.setDepth(this.axisX.isDepth());
                    }
                }
            }
        } else {
            this.axisX.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
            this.black.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
            this.axisX.I(super.getBounds(), this.depthEnable, this.properties.getScaleX(), this.properties.getScaleY());
            this.black.I(super.getBounds(), this.depthEnable, this.properties.getScaleX(), this.properties.getScaleY());
            if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2) {
                this.axisX.setCombo(true);
                this.axisX.transformBench1();
                ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(2);
                ((ChartNumericAxis)this.Z).setAxisPosition(1);
                if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                    this.black.setCombo(true);
                    this.black.Z(2);
                    this.black.transformBench1();
                    this.IsShowAxisXLabelTips = null;
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(3);
                } else {
                    this.black.Z(2);
                    this.black.transformNormal();
                    if (this.IsShowAxisXLabelTips != null) {
                        if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 3 || this.getAxisFristLabelWidht.secLayer.hasBubble) {
                            ((ChartNumericAxis)this.IsShowAxisXLabelTips).setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.IsShowAxisXLabelTips).setAxisPosition(3);
                        }
                    }
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(4);
                }
            } else {
                this.axisX.transformNormal();
                if (this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 3 || this.getAxisFristLabelWidht.primLayer.hasBubble) {
                    ((ChartNumericAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(3);
                } else {
                    ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setAxisPosition(3);
                }
                ((ChartNumericAxis)this.Z).setAxisPosition(2);
                if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2) {
                    this.black.Z(2);
                    this.black.transformBench2();
                    ((ChartCategoryAxis)this.IsShowAxisXLabelTips).setAxisPosition(4);
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(1);
                } else {
                    this.axisX.I(this.properties.getAxisXProperties().getPlacement());
                    this.axisX.Z(this.properties.getAxisYProperties().getPlacement());
                    this.black.Z(2);
                    this.black.transformNormal();
                    if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 3 || this.getAxisFristLabelWidht.secLayer.hasBubble) {
                        ((ChartNumericAxis)this.IsShowAxisXLabelTips).setAxisPosition(3);
                    } else {
                        this.IsShowAxisXLabelTips = null;
                    }
                    ((ChartNumericAxis)this.IsShowAxisYLabelTips).setAxisPosition(4);
                }
            }
            if (this.getAxisFristLabelWidht.primLayer.depthEnable) {
                this.axisX.setDepth((int)this.properties.getGraphProperties().getDepth());
                this.axisX.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                this.axisX.setUseDepth(this.properties.getGraphProperties().isUseDepth());
            }
            if (this.getAxisFristLabelWidht.secLayer.depthEnable) {
                this.black.setDepth((int)this.properties.getGraphProperties().getDepth());
                this.black.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                this.black.setUseDepth(this.properties.getGraphProperties().isUseDepth());
            }
            this.axisX.locate();
            this.black.locate();
            if (this.getAxisFristLabelWidht.secLayer.getCoordinateType() == 2 && this.getAxisFristLabelWidht.primLayer.getCoordinateType() == 2) {
                if (this.axisX.isDepth() || this.black.isDepth()) {
                    this.axisX.resetDepthPos(0.0f, 0.0f);
                }
            } else if (this.axisX.isDepth() || this.black.isDepth()) {
                this.black.resetDepthPos(0.0f, 0.0f);
            }
            if (this.axisX.isDepth() || this.black.isDepth()) {
                if (this.IsLabelFontAutomaticOrientation != null) {
                    this.IsLabelFontAutomaticOrientation.setDepth(this.axisX.isDepth());
                }
                if (this.IsShowAxisXLabelTips != null) {
                    this.IsShowAxisXLabelTips.setDepth(this.axisX.isDepth());
                }
                if (this.Z != null) {
                    this.Z.setDepth(this.axisX.isDepth());
                }
                if (this.IsShowAxisYLabelTips != null) {
                    this.IsShowAxisYLabelTips.setDepth(this.axisX.isDepth());
                }
            }
        }
    }

    private Chart2DObject QOIV(ChartDataSet chartDataSet, Chart2DLayer chart2DLayer, int n) {
        Chart2DObject chart2DObject = null;
        int n2 = chartDataSet.getChartDataSetInfo().getChartType();
        int n3 = ChartTypeInfo.getPrimType(n2);
        int n4 = ChartTypeInfo.getSubType(n2);
        block0 : switch (n3) {
            case 0: {
                switch (n4) {
                    case 256: {
                        chart2DObject = new Graph2DBarP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DBarSi(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DBarSt(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 1: {
                switch (n4) {
                    case 256: {
                        chart2DObject = new Graph2DBarP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DBarSi(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DBarSt(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 2: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DLineSt(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DLineP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 768: {
                        chart2DObject = new Graph2DLineA(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 3: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DAreaSt(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DAreaP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 768: {
                        chart2DObject = new Graph2DAreaA(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 4: {
                chart2DObject = new Graph2DPie(chartDataSet, this, chart2DLayer);
                break;
            }
            case 10: {
                switch (n4) {
                    case 512: {
                        chart2DObject = new Graph2DStockOC(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DStockHLC(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DStockOHLC(chartDataSet, this, chart2DLayer);
                    }
                }
                break;
            }
            case 5: {
                chart2DObject = new Graph2DRadar(chartDataSet, this, chart2DLayer);
                break;
            }
            case 9: {
                chart2DObject = new Graph2DBubble(chartDataSet, this, chart2DLayer);
                break;
            }
            case 8: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DScatterN(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DScatterS(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DScatterL(chartDataSet, this, chart2DLayer);
                    }
                }
                break;
            }
            case 6: {
                switch (n4) {
                    case 512: {
                        chart2DObject = new Graph2DGuageBalls(chartDataSet, this, chart2DLayer);
                        break block0;
                    }
                    case 0: {
                        chart2DObject = new Graph2DGuageDials(chartDataSet, this, chart2DLayer);
                        break block0;
                    }
                    case 256: {
                        chart2DObject = new Graph2DGuageBars(chartDataSet, this, chart2DLayer);
                    }
                }
            }
        }
        return chart2DObject;
    }

    private String Z(int n, int n2) {
        String string;
        if (this.axisX != null && this.IsLabelFontAutomaticOrientation != null) {
            string = this.axisX.searchAxisXLabel(n, n2);
            if (string != null) {
                this.getAutoOritention = string;
                if (this.axisX.IsShowAxisXLabelTips()) {
                    return string;
                }
            } else {
                this.getAutoOritention = null;
                string = this.axisX.searchAxisYLabel(n, n2);
                if (string != null && this.axisX.IsShowAxisYLabelTips()) {
                    return string;
                }
            }
        }
        if (this.black != null && this.IsShowAxisXLabelTips != null) {
            string = this.black.searchAxisXLabel(n, n2);
            if (string != null) {
                this.getAutoOritention = string;
                if (this.black.IsShowAxisXLabelTips()) {
                    return string;
                }
            } else {
                this.getAutoOritention = null;
                string = this.black.searchAxisYLabel(n, n2);
                if (string != null && this.black.IsShowAxisYLabelTips()) {
                    return string;
                }
            }
        }
        return null;
    }

    public String[] getHintValue(int n, int n2) {
        this.getAreaPatternList = null;
        String[] stringArray = null;
        int n3 = this.contains.length;
        if (!this.properties.isReversePaintingOrder()) {
            int n4 = 0;
            while (n4 < n3) {
                stringArray = this.contains[n4].search(n, n2);
                this.getAreaPatternList = this.contains[n4].drilldown;
                if (stringArray != null) {
                    return stringArray;
                }
                ++n4;
            }
        } else {
            int n5 = n3 - 1;
            while (n5 >= 0) {
                stringArray = this.contains[n5].search(n, n2);
                this.getAreaPatternList = this.contains[n5].drilldown;
                if (stringArray != null) {
                    return stringArray;
                }
                --n5;
            }
        }
        stringArray = new String[]{this.Z(n, n2)};
        return stringArray;
    }

    public void searchSelectedLineIndex(int n, int n2) {
        block6: {
            this.selectedLineIndex = -1;
            if (this.contains == null) break block6;
            if (this.properties.isReversePaintingOrder()) {
                int n3 = 0;
                while (n3 < this.contains.length) {
                    int n4;
                    if (this.contains[n3] instanceof Graph2DLine && (n4 = ((Graph2DLine)this.contains[n3]).searchIndex(n, n2)) != -1) {
                        this.selectedLineIndex = n4;
                        return;
                    }
                    ++n3;
                }
            } else {
                int n5 = this.contains.length - 1;
                while (n5 >= 0) {
                    int n6;
                    if (this.contains[n5] instanceof Graph2DLine && (n6 = ((Graph2DLine)this.contains[n5]).searchIndex(n, n2)) != -1) {
                        this.selectedLineIndex = n6;
                        return;
                    }
                    --n5;
                }
            }
        }
    }

    public void searchSelectedSeriesIndex(int n, int n2) {
        block6: {
            this.selectedSeriesIndex = -1;
            this.searchSelectedLineIndex(n, n2);
            if (this.contains == null) break block6;
            if (this.properties.isReversePaintingOrder()) {
                int n3 = 0;
                while (n3 < this.contains.length) {
                    int n4 = this.contains[n3].searchSeries(n, n2);
                    if (n4 != -1) {
                        this.selectedSeriesIndex = n4;
                        this.getAxisInfo = n3;
                        return;
                    }
                    ++n3;
                }
            } else {
                int n5 = this.contains.length - 1;
                while (n5 >= 0) {
                    int n6 = this.contains[n5].searchSeries(n, n2);
                    if (n6 != -1) {
                        this.selectedSeriesIndex = n6;
                        this.getAxisInfo = n5;
                        return;
                    }
                    --n5;
                }
            }
        }
    }

    public ChartPlatform getChartPlatform() {
        return this.I;
    }

    public ChartDataSetInfo[] getDataSetInfos() {
        return this.model.getDatasetInfos();
    }

    public ChartNumericAxis getAxisY1() {
        return (ChartNumericAxis)this.Z;
    }

    public Shape[][] getItemShapes(int n) {
        return this.contains[n].getItemShapes();
    }

    public void setXDimValue(Vector vector) {
        ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).setDimValue(vector);
    }

    public void setZDimValue(Vector vector) {
    }

    public String[] getXLabels() {
        if (this.IsLabelFontAutomaticOrientation == null) {
            return null;
        }
        return ((ChartCategoryAxis)this.IsLabelFontAutomaticOrientation).getLabelsForHtml();
    }

    public String[] getZLabels() {
        return null;
    }

    public Shape[] getAxisXShapes() {
        if (this.IsLabelFontAutomaticOrientation == null) {
            return null;
        }
        return this.IsLabelFontAutomaticOrientation.getAxisShapes();
    }

    public Shape[] getAxisZShapes() {
        return null;
    }

    public String getXDim() {
        return this.getAutoOritention;
    }

    public int[] getDrilldown() {
        return this.getAreaPatternList;
    }

    public float getMeanLineStartX() {
        return this.get;
    }

    public String[] getDrilldownGroup() {
        String[] stringArray = new String[2];
        if (this.getAreaPatternList != null) {
            if (this.model.isTurnedXZ()) {
                stringArray[0] = null;
                stringArray[1] = this.model.getSeriesName(this.getAreaPatternList[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getAreaPatternList[0] % this.model.getSeriesCount()).toString());
            } else {
                stringArray[0] = this.model.getSeriesName(this.getAreaPatternList[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getAreaPatternList[0] % this.model.getSeriesCount()).toString());
                stringArray[1] = this.model.getCategoryName(this.getAreaPatternList[1]) == null ? null : this.model.getCategoryName(this.getAreaPatternList[1]).toString();
            }
        }
        return stringArray;
    }

    public int formatLineNode(int n, int n2) {
        int n3 = 9;
        n3 = n2 == 0 ? n : n2;
        return n3;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    private void add(Graphics2D graphics2D) {
        if (this.IsLabelFontAutomaticOrientation != null && this.IsLabelFontAutomaticOrientation.getStatus() == 1) {
            Line2D line2D = this.IsLabelFontAutomaticOrientation.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.IsShowAxisXLabelTips != null && this.IsShowAxisXLabelTips.getStatus() == 1) {
            Line2D line2D = this.IsShowAxisXLabelTips.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.Z != null && this.Z.getStatus() == 1) {
            ChartDataSet chartDataSet = (ChartDataSet)this.getAxis.get(0);
            int n = chartDataSet.getChartDataSetInfo().getChartType();
            int n2 = ChartTypeInfo.getPrimType(n);
            int n3 = ChartTypeInfo.getSubType(n);
            if (n2 == 5) {
                Line2D[] line2DArray = ((ChartNumericRadarAxis)this.Z).getRadarAxisAreaPath();
                int n4 = 0;
                while (n4 < line2DArray.length) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[n4]);
                    ++n4;
                }
            } else if (n2 == 6) {
                if (n3 == 256) {
                    Line2D[] line2DArray = ((Graph2DGuageBars)this.contains[0]).getAxisYShape();
                    int n5 = 0;
                    while (n5 < line2DArray.length) {
                        ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[n5]);
                        ++n5;
                    }
                } else if (n3 == 0) {
                    Shape[][] shapeArray = ((Graph2DGuageDials)this.contains[0]).getAxisPaths();
                    int n6 = 0;
                    while (n6 < shapeArray.length) {
                        int n7 = 0;
                        while (n7 < shapeArray[0].length) {
                            ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[n6][n7]);
                            ++n7;
                        }
                        ++n6;
                    }
                }
            } else {
                Line2D line2D = this.Z.getAxisAreaPath();
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            }
            return;
        }
        if (this.IsShowAxisYLabelTips != null && this.IsShowAxisYLabelTips.getStatus() == 1) {
            Line2D line2D = this.IsShowAxisYLabelTips.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.QOIV != null && this.QOIV.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            Shape[] shapeArray = null;
            shapeArray = this.contains[0] instanceof Graph2DGuageBalls ? ((Graph2DGuageBalls)this.contains[0]).getVerticalGrid() : this.axisX.getGridXPath();
            int n = 0;
            while (n < shapeArray.length) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[n]);
                ++n;
            }
            return;
        }
        if (this.append != null && this.append.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            Shape[] shapeArray = null;
            if (this.contains[0] instanceof Graph2DGuageBalls) {
                shapeArray = ((Graph2DGuageBalls)this.contains[0]).getHorizonalGrid();
            }
            int n = 0;
            while (n < shapeArray.length) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[n]);
                ++n;
            }
            return;
        }
        if (this.add != null && this.add.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartDataSet chartDataSet = (ChartDataSet)this.getAxis.get(0);
            int n = chartDataSet.getChartDataSetInfo().getChartType();
            int n8 = ChartTypeInfo.getPrimType(n);
            int n9 = ChartTypeInfo.getSubType(n);
            if (n8 == 6) {
                if (n9 != 256 && n9 == 0) {
                    Shape[][] shapeArray = ((Graph2DGuageDials)this.contains[0]).getGridPath();
                    int n10 = 0;
                    while (n10 < shapeArray.length) {
                        int n11 = 0;
                        while (n11 < shapeArray[0].length) {
                            ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[n10][n11]);
                            ++n11;
                        }
                        ++n10;
                    }
                }
            } else {
                Line2D[] line2DArray = this.axisX.getGridYPath();
                int n12 = 0;
                while (n12 < line2DArray.length) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[n12]);
                    ++n12;
                }
            }
            return;
        }
        if (this.allIsIntegerData != null && this.allIsIntegerData.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = this.allIsIntegerData.getAxis().getProperties().getGridPen();
            Line2D[] line2DArray = this.black.getGridXPath();
            int n = 0;
            while (n < line2DArray.length) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[n]);
                ++n;
            }
            return;
        }
        if (this.allLineArea != null && this.allLineArea.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = this.allLineArea.getAxis().getProperties().getGridPen();
            Line2D[] line2DArray = this.black.getGridYPath();
            int n = 0;
            while (n < line2DArray.length) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[n]);
                ++n;
            }
            return;
        }
        if (this.OLD_PAPER_MARGINE != null && this.OLD_PAPER_MARGINE.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = new ChartPenStyle(0, new ChartColorPattern(Color.black));
            GeneralPath generalPath = this.calculateGraphArea.getWallPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.selectedSeriesIndex != -1 && this.contains[this.getAxisInfo].getStatus() == 1) {
            if (this.contains[this.getAxisInfo] instanceof Graph2DPie) {
                Shape[][] shapeArray = ((Graph2DPie)this.contains[this.getAxisInfo]).I();
                int n = 0;
                while (n < shapeArray.length) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[n][this.selectedSeriesIndex]);
                    ++n;
                }
            } else {
                Shape shape = this.contains[this.getAxisInfo].getShapeBySeries(this.selectedSeriesIndex);
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shape);
            }
        }
    }

    public ChartObject getChartObject(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.contains(n, n2)) {
            this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
            if (this.axisX != null) {
                if (this.IsLabelFontAutomaticOrientation != null && this.axisX.searchAxisX(n, n2)) {
                    this.IsLabelFontAutomaticOrientation.setType("x1");
                    return this.IsLabelFontAutomaticOrientation;
                }
                if (this.Z != null && this.axisX.searchAxisY(n, n2)) {
                    this.Z.setType("y1");
                    return this.Z;
                }
                if (this.getAxisInfo != -1 && this.selectedSeriesIndex != -1) {
                    if (this.contains[this.getAxisInfo] instanceof Graph2DPie) {
                        ((Graph2DPie)this.contains[0]).setSelectedObjectIndex(this.getAxisInfo);
                        ((Graph2DPie)this.contains[0]).setSelectedSeriesIndex(this.selectedSeriesIndex);
                    }
                    return this.contains[this.getAxisInfo];
                }
                if (this.contains[0] instanceof Graph2DPie) {
                    ((Graph2DPie)this.contains[0]).setSelectedObjectIndex(-1);
                } else if (this.contains[0] instanceof Graph2DGuageBars) {
                    if (((Graph2DGuageBars)this.contains[0]).searchAxisY(n, n2)) {
                        this.Z.setType("y1");
                        return this.Z;
                    }
                } else if (this.contains[0] instanceof Graph2DGuageDials) {
                    if (((Graph2DGuageDials)this.contains[0]).searchGrid(n, n2)) {
                        this.add.setType("y1");
                        return this.add;
                    }
                    if (((Graph2DGuageDials)this.contains[0]).searchAxis(n, n2)) {
                        this.Z.setType("y1");
                        return this.Z;
                    }
                } else if (this.contains[0] instanceof Graph2DGuageBalls) {
                    if (((Graph2DGuageBalls)this.contains[0]).searchHorizonalGrid(n, n2)) {
                        this.QOIV.setType("z");
                        return this.append;
                    }
                    if (((Graph2DGuageBalls)this.contains[0]).searchVerticalGrid(n, n2)) {
                        this.QOIV.setType("x1");
                        return this.QOIV;
                    }
                }
                if (this.QOIV != null && this.axisX.searchGridX(n, n2)) {
                    this.QOIV.setType("x1");
                    this.QOIV.setAxis(this.IsLabelFontAutomaticOrientation);
                    return this.QOIV;
                }
                if (this.add != null && this.axisX.searchGridY(n, n2)) {
                    this.add.setType("y1");
                    this.add.setAxis(this.Z);
                    return this.add;
                }
            }
            if (this.black != null) {
                if (this.IsShowAxisXLabelTips != null && this.black.searchAxisX(n, n2)) {
                    this.IsShowAxisXLabelTips.setType("x2");
                    return this.IsShowAxisXLabelTips;
                }
                if (this.IsShowAxisYLabelTips != null && this.black.searchAxisY(n, n2)) {
                    this.IsShowAxisYLabelTips.setType("y2");
                    return this.IsShowAxisYLabelTips;
                }
                if (this.getAxisInfo != -1 && this.selectedSeriesIndex != -1) {
                    return this.contains[this.getAxisInfo];
                }
                if (this.allIsIntegerData != null && this.black.searchGridX(n, n2)) {
                    this.allIsIntegerData.setType("x2");
                    this.allIsIntegerData.setAxis(this.IsShowAxisXLabelTips);
                    return this.allIsIntegerData;
                }
                if (this.allLineArea != null && this.black.searchGridY(n, n2)) {
                    this.allLineArea.setType("y2");
                    this.allLineArea.setAxis(this.IsShowAxisYLabelTips);
                    return this.allLineArea;
                }
            }
            if (this.calculateGraphArea != null && this.calculateGraphArea.searchWall(n, n2)) {
                return this.OLD_PAPER_MARGINE;
            }
            return this;
        }
        return null;
    }

    public Vector getChartObjects() {
        Vector<ChartObject> vector = new Vector<ChartObject>();
        vector.add(this);
        if (this.IsLabelFontAutomaticOrientation != null) {
            this.IsLabelFontAutomaticOrientation.setType("x1");
            vector.add(this.IsLabelFontAutomaticOrientation);
        }
        if (this.IsShowAxisXLabelTips != null) {
            this.IsShowAxisXLabelTips.setType("x2");
            vector.add(this.IsShowAxisXLabelTips);
        }
        if (this.Z != null && !(this.contains[0] instanceof Graph2DGuageBalls)) {
            this.Z.setType("y1");
            vector.add(this.Z);
        }
        if (this.IsShowAxisYLabelTips != null) {
            this.IsShowAxisYLabelTips.setType("y2");
            vector.add(this.IsShowAxisYLabelTips);
        }
        if (this.IsLabelFontAutomaticOrientation != null && this.QOIV != null) {
            this.QOIV.setType("x1");
            vector.add(this.QOIV);
        }
        if (this.IsShowAxisXLabelTips != null && this.allIsIntegerData != null) {
            this.allIsIntegerData.setType("x2");
            vector.add(this.allIsIntegerData);
        }
        if (this.Z != null && this.add != null && !(this.contains[0] instanceof Graph2DGuageBalls) && !(this.contains[0] instanceof Graph2DGuageBars)) {
            this.add.setType("y1");
            vector.add(this.add);
        }
        if (this.IsShowAxisYLabelTips != null && this.allLineArea != null) {
            this.allLineArea.setType("y2");
            vector.add(this.allLineArea);
        }
        if (this.contains[0] instanceof Graph2DGuageBalls && this.QOIV != null) {
            this.QOIV.setType("x1");
            vector.add(this.QOIV);
        }
        if (this.contains[0] instanceof Graph2DGuageBalls && this.append != null) {
            this.append.setType("z");
            vector.add(this.append);
        }
        if (this.OLD_PAPER_MARGINE != null) {
            this.OLD_PAPER_MARGINE.setType("xy");
            vector.add(this.OLD_PAPER_MARGINE);
        }
        return vector;
    }

    public Rectangle getGraphArea() {
        return this.depthEnable;
    }

    public int getLineLegendIconDescent(ChartDataSet chartDataSet) {
        int n = chartDataSet.getDataSetIndex();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((ChartDataSet)this.D.get(n3)).getLegendSeriesLabels().size();
            ++n3;
        }
        return n2;
    }

    private boolean allIsIntegerData(Graph2DBar graph2DBar) {
        return graph2DBar.getChartDataSet().getSeriesSize() == 1;
    }

    private boolean allLineArea() {
        int n = 0;
        while (n < this.D.size()) {
            ChartDataSetInfo chartDataSetInfo = ((ChartDataSet)this.D.get(n)).getChartDataSetInfo();
            int n2 = chartDataSetInfo.getChartType();
            int n3 = ChartTypeInfo.getPrimType(n2);
            if (n3 == 9 || n3 == 8 || n3 == 10) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

