/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dom.css.impl;

import com.jinfonet.css.sac.impl.parser.JCSSDOMParser;
import com.jinfonet.dom.css.JCSSImportRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.JMediaList;
import com.jinfonet.dom.css.impl.JDOMException;
import com.jinfonet.dom.css.impl.JLitConvertKit;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class JCSSImportRuleImpl
implements JCSSImportRule {
    private static final long serialVersionUID = 0x100100L;
    CSSStyleSheet QOIV = null;
    CSSRule append = null;
    String cvCSSRule = null;
    MediaList cvMediaList = null;

    public JCSSImportRuleImpl(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, String string, MediaList mediaList) {
        this.QOIV = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.append = JLitConvertKit.cvCSSRule(cSSRule);
        this.cvCSSRule = string;
        this.cvMediaList = JLitConvertKit.cvMediaList(mediaList);
    }

    public JCSSImportRuleImpl() {
    }

    public short getType() {
        return 3;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            stringBuffer.append(" ").append(this.getMedia().toString());
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        if (this.QOIV != null && ((JCSSStyleSheet)this.QOIV).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        try {
            InputSource inputSource = new InputSource((Reader)new StringReader(string));
            JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
            CSSRule cSSRule = jCSSDOMParser.parseRule(inputSource);
            if (cSSRule == null || cSSRule.getType() != 3) {
                throw new JDOMException(13, 6);
            }
            this.cvCSSRule = ((JCSSImportRuleImpl)cSSRule).cvCSSRule;
            this.cvMediaList = ((JCSSImportRuleImpl)cSSRule).cvMediaList;
        }
        catch (CSSException cSSException) {
            throw new JDOMException(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new JDOMException(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this.QOIV;
    }

    public CSSRule getParentRule() {
        return this.append;
    }

    public String getHref() {
        return this.cvCSSRule;
    }

    public MediaList getMedia() {
        return this.cvMediaList;
    }

    public CSSStyleSheet getStyleSheet() {
        JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
        try {
            Reader reader = this.getImportIO();
            return jCSSDOMParser.parseStyleSheet(new InputSource(reader));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Reader getImportIO() throws Exception {
        if (this.cvCSSRule.indexOf("://") >= 0) {
            URL uRL = new URL(this.cvCSSRule);
            return new InputStreamReader(uRL.openStream());
        }
        return new FileReader(this.cvCSSRule);
    }

    public String toString() {
        return this.getCssText();
    }

    public void resetParent(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) {
        this.QOIV = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.append = JLitConvertKit.cvCSSRule(cSSRule);
    }

    public CSSImportRule duplate() {
        return new JCSSImportRuleImpl(this.QOIV, this.append, this.cvCSSRule, ((JMediaList)this.cvMediaList).duplate());
    }
}

