/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine8.core.pushdown.NotProcessor;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;

class DataTypeProcessor {
    private ResourceContainer QOIV;

    public DataTypeProcessor(ResourceContainer resourceContainer) {
        this.QOIV = resourceContainer;
    }

    public void processDataType(IExpression iExpression) throws DSException {
        this.QOIV(iExpression, 0);
    }

    private void QOIV(IExpression iExpression, int n) throws DSException {
        if (iExpression == null) {
            return;
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            IExpression iExpression2 = NotProcessor.getLeafTupleExp(iExpression);
            this.processDataType(iExpression2);
        } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            this.getCompatibleNumaricType(iExpression, n);
        } else if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            IExpression iExpression3 = ((ISingle)((Object)iExpression)).getExpression();
            n = ExpressionToolKit.isSingleLogicExp(iExpression.expressionType()) ? -7 : 0;
            this.QOIV(iExpression3, n);
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IExpression iExpression4 = ((IBinary)((Object)iExpression)).getExpression1();
            IExpression iExpression5 = ((IBinary)((Object)iExpression)).getExpression2();
            n = ExpressionToolKit.isBinaryLogicExp(iExpression.expressionType()) ? -7 : this.append(iExpression4, iExpression5, null);
            this.QOIV(iExpression4, n);
            this.QOIV(iExpression5, n);
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            IExpression iExpression6 = ((ITriple)((Object)iExpression)).getExpression1();
            IExpression iExpression7 = ((ITriple)((Object)iExpression)).getExpression2();
            IExpression iExpression8 = ((ITriple)((Object)iExpression)).getExpression3();
            n = this.append(iExpression6, iExpression7, iExpression8);
            this.QOIV(iExpression6, n);
            this.QOIV(iExpression7, n);
            this.QOIV(iExpression8, n);
        } else if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
            IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
            int n2 = 0;
            while (n2 < iExpressionArray.length) {
                this.QOIV(iExpressionArray[n2], n);
                ++n2;
            }
        } else {
            System.out.println("The data type: " + n + " is wrong !");
        }
    }

    private int append(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        if (iExpression != null && iExpression2 != null && iExpression3 == null) {
            return this.expressionType(iExpression, iExpression2);
        }
        if (iExpression != null && iExpression2 != null && iExpression3 != null) {
            return this.containsIgnoreCase(iExpression, iExpression2, iExpression3);
        }
        throw new DSException(2551, new Object[]{"internal error, invalid usage"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int containsIgnoreCase(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        int n = 12;
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            if (!this.QOIV.containsIgnoreCase(((IReference)iExpression).getAttributeName())) throw new DSException(2553, new Object[]{"not contained field in resource container : " + ((IReference)iExpression).getAttributeName()});
            this.QOIV.getStringValue();
            if (!this.QOIV.wasField()) throw new DSException(2552, new Object[]{"resource node was not field : " + ((IReference)iExpression).getAttributeName()});
            return this.QOIV.getJAttribute().getDataType();
        }
        if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
            try {
                if (!this.QOIV.containsIgnoreCase(iExpression.getName())) throw new DSException(2555, new Object[]{"not contained formula in resource container : " + ((IReference)iExpression).getAttributeName()});
                this.QOIV.getStringValue();
                if (!this.QOIV.wasFormula()) throw new DSException(2554, new Object[]{"resource node was not formula : " + ((IReference)iExpression).getAttributeName()});
                return this.QOIV.getJAttribute().getDataType();
            }
            catch (ConditionException conditionException) {
                throw new DSException(2556, new Object[]{"Condition Exception"}, conditionException);
            }
        }
        try {
            throw new DSException(2557, new Object[]{"exp 1 type error : " + iExpression.getName()});
        }
        catch (ConditionException conditionException) {
            throw new DSException(2558, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private int expressionType(IExpression iExpression, IExpression iExpression2) throws DSException {
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            return 12;
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && (ExpressionToolKit.isReference(iExpression2.expressionType()) || ExpressionToolKit.isFormula(iExpression2.expressionType()))) {
            return this.getAttributeName((IReference)iExpression2);
        }
        if ((ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            return this.getAttributeName(iExpression);
        }
        int n = this.getAttributeName(iExpression);
        int n2 = this.getAttributeName(iExpression2);
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            return Types.getCompatibleNumaricType(n, n2);
        }
        return n;
    }

    private int getAttributeName(IExpression iExpression) throws DSException {
        try {
            if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                if (this.QOIV.containsIgnoreCase(((IReference)iExpression).getAttributeName())) {
                    this.QOIV.getStringValue();
                    if (this.QOIV.wasField()) {
                        JAttribute jAttribute = this.QOIV.getJAttribute();
                        return jAttribute.getDataType();
                    }
                }
            } else if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                if (this.QOIV.containsIgnoreCase(((IFormula)iExpression).getName())) {
                    this.QOIV.getStringValue();
                    if (this.QOIV.wasFormula()) {
                        JAttribute jAttribute = this.QOIV.getJAttribute();
                        return jAttribute.getDataType();
                    }
                }
            } else {
                return ((IVariableExpression)iExpression).getDataType();
            }
            throw new DSException(2559, new Object[]{"can not get field in resource container : " + iExpression.getName()});
        }
        catch (ConditionException conditionException) {
            throw new DSException(2560, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void getCompatibleNumaricType(IExpression iExpression, int n) throws DSException {
        block8: {
            try {
                if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                    if (n == 0) {
                        ((IConstant)iExpression).setDataType(12);
                    } else {
                        ((IConstant)iExpression).setDataType(n);
                    }
                    break block8;
                }
                if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) break block8;
                IVariableList iVariableList = (IVariableList)iExpression;
                IVariableExpression iVariableExpression = null;
                try {
                    int n2 = 0;
                    while (n2 < iVariableList.size()) {
                        iVariableExpression = iVariableList.getVariableExp(n2);
                        this.getCompatibleNumaricType(iVariableExpression, n);
                        ++n2;
                    }
                }
                catch (ConditionException conditionException) {
                    throw new DSException(2561, new Object[]{"Condition Exception"}, conditionException);
                }
            }
            catch (ConditionException conditionException) {
                throw new DSException(2562, new Object[]{"Condition Exception"}, conditionException);
            }
        }
    }
}

