/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jet.JRStopEngineException;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableObject;
import jet.util.DbValueComparer;
import jet.util.VersionControlable;

public class DSTableRow
extends DSContainer {
    private int QOIV;
    private int add;

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.QOIV = dataInput.readInt();
        if (dataInput instanceof VersionControlable) {
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            this.add = n >= 262176 || n == 0 ? (int)dataInput.readByte() : dataInput.readInt();
        }
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.QOIV);
        dataOutput.writeByte(this.add);
    }

    public boolean isTableHeader() {
        return this.getObjectType() == 0x1000004;
    }

    protected int propLength() {
        int n = super.propLength();
        n += 4;
        return ++n;
    }

    public int getRecordIndex() {
        return this.QOIV;
    }

    public void setRecordIndex(int n) {
        this.QOIV = n;
    }

    public int getGroupTreeIDX() {
        return ((DSTableObject)this.getParent()).getGroupTreeIDX();
    }

    public JRecord getRecord() {
        return ((DSTableObject)this.getParent()).getRecord(this);
    }

    public JRecord getCalculateRecord() {
        return ((DSTableObject)this.getParent()).getCalculateRecord(this);
    }

    public DSDataStreamable getDataStream() {
        return ((DSTableObject)this.getParent()).getStream();
    }

    public Communicator getCommunicator() {
        return this.getDataStream().getCommunicator();
    }

    public int getGroupLevel() {
        return this.add;
    }

    public void setGroupLevel(int n) {
        this.add = n;
    }

    public Record getSynRecord() {
        return this.getRecord();
    }

    public List getAvailableValues() {
        ArrayList<DbValueComparer> arrayList;
        block4: {
            arrayList = new ArrayList<DbValueComparer>();
            JRecord jRecord = this.getRecord();
            Groupable groupable = jRecord.getRecordModel().getGroupable();
            DbValue[] dbValueArray = null;
            try {
                dbValueArray = groupable.peekGroupValues(((DbInteger)jRecord.getCell((int)0)).value, this.add);
                int n = 0;
                while (n < dbValueArray.length) {
                    if (dbValueArray[n] != null) {
                        DbValueComparer dbValueComparer = new DbValueComparer();
                        dbValueComparer.columnName = dbValueArray[n].getColDesc().getColName();
                        dbValueComparer.value = dbValueArray[n];
                        dbValueComparer.operator = DbValueComparer.getOperatorForName("=");
                        arrayList.add(dbValueComparer);
                    }
                    ++n;
                }
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block4;
                JRLog.error(2, dSException);
            }
        }
        return arrayList;
    }

    public Object clone() {
        return this.dup(new DSTableRow());
    }

    public DSTableRow dup(DSTableRow dSTableRow) {
        super.dup(dSTableRow);
        dSTableRow.setRecordIndex(this.QOIV);
        dSTableRow.setGroupLevel(this.add);
        return dSTableRow;
    }
}

