/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;
import jet.ReportEnv;
import jet.util.RAFile;
import jet.util.RandomByteArrayInputOutput;
import jet.util.RandomInputOutputable;
import jet.util.RandomInputable;
import jet.util.TempFile;

public class RAStreamInput
implements RandomInputable {
    protected RandomInputOutputable impl;
    protected InputStream in;
    File QOIV;
    private long available;

    public RAStreamInput(InputStream inputStream, long l) throws IOException {
        this.in = inputStream;
        this.available = l;
        try {
            this.QOIV = new TempFile(ReportEnv.temporaryPath, "raf").createTempFile();
            this.impl = new RAFile(this.QOIV, "rw");
        }
        catch (Throwable throwable) {
            this.impl = new RandomByteArrayInputOutput();
        }
    }

    public int skipBytes(int n) throws IOException {
        this.QOIV(n);
        return this.impl.skipBytes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            try {
                this.impl.close();
            }
            catch (Exception exception) {
                Object var3_4 = null;
                this.QOIV.delete();
                return;
            }
            Object var3_3 = null;
            this.QOIV.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.QOIV.delete();
            throw throwable;
        }
    }

    public int read() throws IOException {
        this.QOIV(1L);
        return this.impl.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.QOIV(n2);
        return this.impl.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        this.QOIV(byArray.length);
        return this.impl.read(byArray);
    }

    public void saveTo(String string) throws IOException {
        this.impl.saveTo(string);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.QOIV(byArray.length);
        this.impl.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.QOIV(n2);
        this.impl.readFully(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        this.QOIV(10L);
        return this.impl.readBoolean();
    }

    public byte readByte() throws IOException {
        this.QOIV(1L);
        return this.impl.readByte();
    }

    public int readUnsignedByte() throws IOException {
        this.QOIV(2L);
        return this.impl.readUnsignedByte();
    }

    public short readShort() throws IOException {
        this.QOIV(2L);
        return this.impl.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.QOIV(2L);
        return this.impl.readUnsignedShort();
    }

    public char readChar() throws IOException {
        this.QOIV(2L);
        return this.impl.readChar();
    }

    public int readInt() throws IOException {
        this.QOIV(4L);
        return this.impl.readInt();
    }

    public long readLong() throws IOException {
        this.QOIV(8L);
        return this.impl.readLong();
    }

    public float readFloat() throws IOException {
        this.QOIV(8L);
        return this.impl.readFloat();
    }

    public double readDouble() throws IOException {
        this.QOIV(10L);
        return this.impl.readDouble();
    }

    public String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = new char[128];
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = this.in = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = this.readUnsignedByte();
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    int n6 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public void write(int n) throws IOException {
        this.impl.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.impl.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.impl.write(byArray);
    }

    public void seek(long l) throws IOException {
        if (l > this.impl.getPosition()) {
            this.QOIV(l - this.impl.getPosition());
        }
        this.impl.seek(l);
    }

    public long getPosition() throws IOException {
        return this.impl.getPosition();
    }

    public long length() throws IOException {
        if (this.available == 0L) {
            this.available = this.in.available();
        }
        return this.available;
    }

    private final void QOIV(long l) throws IOException {
        long l2 = this.impl.length();
        if (l2 == this.available) {
            return;
        }
        long l3 = this.impl.getPosition();
        int n = (int)(l - (l2 - l3));
        byte[] byArray = new byte[1024];
        this.impl.seek(l2);
        while (n > 0) {
            int n2 = this.in.read(byArray, 0, n > 1024 ? 1024 : n);
            if (n2 == -1) {
                this.impl.seek(l3);
                throw new IOException("End of file");
            }
            this.impl.write(byArray, 0, n2);
            n -= n2;
        }
        this.impl.seek(l3);
    }
}

