/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartWall;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DMatrix;
import chart.chart2d.Chart2DPaper;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartWallProperties;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Chart2DLayer {
    public static final int AXIS_X_POSITION_YORIGIN = 0;
    public static final int AXIS_X_POSITION_YMIN = 1;
    public static final int AXIS_X_POSITION_YMAX = 2;
    public static final int AXIS_Y_POSITION_XORIGIN = 0;
    public static final int AXIS_Y_POSITION_XMIN = 1;
    public static final int AXIS_Y_POSITION_XMAX = 2;
    protected ChartAxis axisX;
    protected ChartAxis axisY;
    private Rectangle2D.Float IsShowLabelTips;
    private Rectangle2D.Float QOIV;
    private float append;
    private float availableValue;
    protected Chart2DMatrix m2;
    private Chart2DMatrix bench1;
    private float bench2;
    private float boundFill;
    private int closePath;
    private int contains;
    private float[][] cos;
    protected float[][] axisXPos;
    protected float[][] axisYPos;
    private float[][] draw;
    protected float[][] yTickPos;
    private float[][] drawLine;
    private float[][] fill;
    private float[][] formatMinorTickMark;
    protected float[][] tYTickPos;
    private float[][] getAutoOritention;
    private float[][] getBorder;
    private float[][] getGraphProperties;
    private float[][] getGridPen;
    private float[][] getGridXAreaPath;
    private float getGridYAreaPath;
    private float getLabelStartValue;
    private float getLabelTextStyle;
    private float getLabels;
    private float[][] getMax;
    protected float[][] tYPos;
    private boolean getMin;
    private int getNumOfTick;
    private Chart2DPaper getPattern1;
    private boolean getPattern2;
    private Line2D[] getProperties;
    protected Line2D[] gridYPath;
    protected GeneralPath gridXAreaPath;
    protected GeneralPath gridYAreaPath;
    private boolean getThresholdFillTransparency = false;
    private int getThresholdLineColor;
    float I;
    float Z;
    private boolean getThresholdLineColor2;
    private float[][] getThresholdLineStyle;
    private float[][] getThresholdValue;
    GeneralPath getThresholdValue2 = new GeneralPath();
    private int getTickPace;
    private boolean getUnit;

    Chart2DLayer(Chart2DPaper chart2DPaper) {
        this.getPattern1 = chart2DPaper;
        this.bench1 = new Chart2DMatrix();
        this.m2 = new Chart2DMatrix();
        this.bench2 = 0.0f;
        this.boundFill = 0.0f;
    }

    public void init() {
        this.getMin = this.getThresholdFillTransparency && this.getNumOfTick > 0;
        this.I = (float)((double)this.getNumOfTick * Math.cos(Math.PI / 180 * (double)this.getThresholdLineColor));
        this.Z = (float)((double)this.getNumOfTick * Math.sin(Math.PI / 180 * (double)this.getThresholdLineColor));
        this.I = this.I < 0.0f ? 0.0f : this.I;
        this.Z = this.Z < 0.0f ? 0.0f : this.Z;
        this.getThresholdLineColor2 = false;
        this.gridXAreaPath = new GeneralPath();
        this.gridYAreaPath = new GeneralPath();
        this.getLabelStartValue = (float)((ChartNumericAxis)this.axisY).getMin();
        this.getGridYAreaPath = (float)((ChartNumericAxis)this.axisY).getMax();
        if (this.axisX instanceof ChartNumericAxis) {
            this.getLabels = (float)((ChartNumericAxis)this.axisX).getMin();
            this.getLabelTextStyle = (float)((ChartNumericAxis)this.axisX).getMax();
        }
    }

    private void IsShowLabelTips() {
        if (this.axisX != null) {
            this.bench2 = this.axisX.getZeroPosition(this.IsShowLabelTips.width);
        }
        if (this.axisY != null) {
            this.boundFill = this.axisY.getZeroPosition(this.IsShowLabelTips.height);
        }
    }

    public boolean getAutoOritention(boolean bl) {
        if (bl) {
            float f = this.axisX.getUnit(this.QOIV.width);
            return this.axisX.getAutoOritention(f);
        }
        float f = this.axisY.getUnit(this.QOIV.height);
        return this.axisY.getAutoOritention(f);
    }

    void locate() {
        this.getMin = this.getThresholdFillTransparency && this.getNumOfTick > 0;
        this.I = (float)((double)this.getNumOfTick * Math.cos(Math.PI / 180 * (double)this.getThresholdLineColor));
        this.Z = (float)((double)this.getNumOfTick * Math.sin(Math.PI / 180 * (double)this.getThresholdLineColor));
        this.I = this.I < 0.0f ? 0.0f : this.I;
        float f = this.Z = this.Z < 0.0f ? 0.0f : this.Z;
        if (this.axisX != null && this.axisY != null) {
            this.axisXPos = new float[2][2];
            this.axisYPos = new float[2][2];
            float f2 = this.axisX.getUnit(this.IsShowLabelTips.width);
            float f3 = this.axisY.getUnit(this.IsShowLabelTips.height);
            if (!this.getPattern2) {
                if (this.axisX.getProperties().isBestEffort() || this.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                    this.axisX.setUnitWidth((int)(f2 * this.m2.I));
                }
            } else {
                this.axisX.setUnitWidth(60);
            }
            if (this.axisX instanceof ChartNumericAxis) {
                this.axisXPos[0][0] = this.getLabels * f2;
                this.axisXPos[1][0] = this.getLabelTextStyle * f2;
            } else {
                this.axisXPos[0][0] = 0.0f;
                this.axisXPos[1][0] = this.IsShowLabelTips.width;
            }
            float f4 = 0.0f;
            float f5 = 0.0f;
            switch (this.closePath) {
                case 0: {
                    if (this.getLabelStartValue > 0.0f) {
                        f4 = this.getLabelStartValue * f3;
                        break;
                    }
                    f4 = 0.0f;
                    break;
                }
                case 1: {
                    f4 = this.getLabelStartValue * f3;
                    break;
                }
                case 2: {
                    f4 = this.getGridYAreaPath * f3;
                }
            }
            this.axisXPos[0][1] = f4;
            this.axisXPos[1][1] = f4;
            this.axisYPos[0][1] = this.getLabelStartValue * f3;
            this.axisYPos[1][1] = this.getGridYAreaPath * f3;
            switch (this.contains) {
                case 0: {
                    if (this.axisX instanceof ChartNumericAxis && this.getLabels > 0.0f) {
                        f5 = this.getLabels * f2;
                        break;
                    }
                    f5 = 0.0f;
                    break;
                }
                case 1: {
                    f5 = this.axisXPos[0][0];
                    break;
                }
                case 2: {
                    f5 = this.axisXPos[1][0];
                }
            }
            this.axisYPos[0][0] = f5;
            this.axisYPos[1][0] = f5;
            this.getMax = new float[this.axisXPos.length][2];
            this.tYPos = new float[this.axisYPos.length][2];
            this.m2.transform(this.axisXPos, this.getMax);
            this.m2.transform(this.axisYPos, this.tYPos);
            this.setAxisX(f2, f4);
            this.setAxisY(f3, f5);
            this.fill = new float[this.draw.length][2];
            this.formatMinorTickMark = new float[this.drawLine.length][2];
            this.tYTickPos = new float[this.yTickPos.length][2];
            this.m2.transform(this.draw, this.fill);
            this.m2.transform(this.drawLine, this.formatMinorTickMark);
            this.m2.transform(this.yTickPos, this.tYTickPos);
            if (this.getMin) {
                this.getGridPen = new float[this.axisXPos.length][2];
                this.getGridXAreaPath = new float[this.axisYPos.length][2];
                this.getAutoOritention = new float[this.draw.length][2];
                this.getBorder = new float[this.drawLine.length][2];
                this.getGraphProperties = new float[this.yTickPos.length][2];
                int n = 0;
                while (n < this.getMax.length) {
                    this.getGridPen[n][0] = this.getMax[n][0] - this.I;
                    this.getGridPen[n][1] = this.getMax[n][1] + this.Z;
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.fill.length) {
                    this.getAutoOritention[n2][0] = this.fill[n2][0] - this.I;
                    this.getAutoOritention[n2][1] = this.fill[n2][1] + this.Z;
                    ++n2;
                }
                int n3 = 0;
                while (n3 < this.formatMinorTickMark.length) {
                    this.getBorder[n3][0] = this.formatMinorTickMark[n3][0] - this.I;
                    this.getBorder[n3][1] = this.formatMinorTickMark[n3][1] + this.Z;
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.tYPos.length) {
                    this.getGridXAreaPath[n4][0] = this.tYPos[n4][0] - this.I;
                    this.getGridXAreaPath[n4][1] = this.tYPos[n4][1] + this.Z;
                    ++n4;
                }
                int n5 = 0;
                while (n5 < this.tYTickPos.length) {
                    this.getGraphProperties[n5][0] = this.tYTickPos[n5][0] - this.I;
                    this.getGraphProperties[n5][1] = this.tYTickPos[n5][1] + this.Z;
                    ++n5;
                }
            }
            this.QOIV(this.axisXPos[0][0], this.axisXPos[1][0], this.axisYPos[0][1], this.axisYPos[1][1]);
            this.append();
        }
    }

    public void resetDepthPos(float f, float f2) {
        this.getGridXAreaPath = new float[this.axisYPos.length][2];
        this.getGraphProperties = new float[this.yTickPos.length][2];
        int n = 0;
        while (n < this.tYPos.length) {
            this.getGridXAreaPath[n][0] = this.tYPos[n][0] - f;
            this.getGridXAreaPath[n][1] = this.tYPos[n][1] + f2;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.tYTickPos.length) {
            this.getGraphProperties[n2][0] = this.tYTickPos[n2][0] - f;
            this.getGraphProperties[n2][1] = this.tYTickPos[n2][1] + f2;
            ++n2;
        }
    }

    public float availableValue(float f) {
        f = f < this.getGridYAreaPath ? f : this.getGridYAreaPath;
        f = f > this.getLabelStartValue ? f : this.getLabelStartValue;
        return f;
    }

    public float availableValueX(float f) {
        f = f < this.getLabelTextStyle ? f : this.getLabelTextStyle;
        f = f > this.getLabels ? f : this.getLabels;
        return f;
    }

    public float getXLength() {
        return this.IsShowLabelTips.width;
    }

    public float getYLength() {
        return this.IsShowLabelTips.height;
    }

    float I() {
        return this.axisX == null ? this.IsShowLabelTips.width : this.axisX.getUnit(this.IsShowLabelTips.width);
    }

    float Z() {
        return this.axisY == null ? this.IsShowLabelTips.height : this.axisY.getUnit(this.IsShowLabelTips.height);
    }

    void I(int n) {
        this.closePath = n;
    }

    void Z(int n) {
        this.contains = n;
    }

    void I(Rectangle rectangle, Rectangle rectangle2, float f, float f2) {
        this.IsShowLabelTips = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.QOIV = new Rectangle2D.Float(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        this.append = f;
        this.availableValue = f2;
    }

    void I(float[][] fArray2, float[][] fArray3) {
        this.m2.transform(fArray2, fArray3);
    }

    public void transformNormal() {
        float f = this.IsShowLabelTips.width / 2.0f;
        float f2 = this.IsShowLabelTips.height / 2.0f;
        float f3 = this.QOIV.width / this.IsShowLabelTips.width;
        float f4 = this.QOIV.height / this.IsShowLabelTips.height;
        float f5 = f3 * this.append;
        float f6 = f4 * this.availableValue;
        float f7 = this.QOIV.x + this.QOIV.width / 2.0f;
        float f8 = this.QOIV.y + this.QOIV.height / 2.0f;
        this.IsShowLabelTips();
        this.bench1.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench1.xmirror();
        this.bench1.shift(f7, f8);
        this.m2.mul(this.bench1);
        this.m2.shift(this.bench2 * f5, -this.boundFill * f6);
        this.getPattern2 = false;
    }

    public void transformBench0() {
        float f = this.IsShowLabelTips.width / 2.0f;
        float f2 = this.IsShowLabelTips.height / 2.0f;
        float f3 = this.QOIV.height / this.IsShowLabelTips.width;
        float f4 = this.QOIV.width / this.IsShowLabelTips.height;
        float f5 = f3 * this.availableValue;
        float f6 = f4 * this.append;
        float f7 = this.QOIV.x + this.QOIV.width / 2.0f;
        float f8 = this.QOIV.y + this.QOIV.height / 2.0f;
        this.IsShowLabelTips();
        this.bench1.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench1.bench1();
        this.m2.mul(this.bench1);
        this.m2.shift(f7, f8);
        this.m2.shift(this.boundFill * f6, this.bench2 * f5);
        this.getPattern2 = true;
    }

    public void transformBench1() {
        float f = this.IsShowLabelTips.width / 2.0f;
        float f2 = this.IsShowLabelTips.height / 2.0f;
        float f3 = this.QOIV.height / this.IsShowLabelTips.width;
        float f4 = this.QOIV.width / this.IsShowLabelTips.height;
        float f5 = f3 * this.availableValue;
        float f6 = f4 * this.append;
        float f7 = this.QOIV.x + this.QOIV.width / 2.0f;
        float f8 = this.QOIV.y + this.QOIV.height / 2.0f;
        this.IsShowLabelTips();
        this.bench1.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench1.bench1();
        this.m2.mul(this.bench1);
        this.bench1.xmirror();
        this.m2.mul(this.bench1);
        this.m2.shift(f7, f8);
        this.m2.shift(this.boundFill * f6, -this.bench2 * f5);
        this.getPattern2 = true;
    }

    public void transformRadar() {
        float f = this.QOIV.width / 2.0f;
        float f2 = this.QOIV.height / 2.0f;
        float f3 = this.QOIV.x + this.QOIV.width / 2.0f;
        float f4 = this.QOIV.y + this.QOIV.height / 2.0f;
        this.bench1.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(this.append, this.availableValue);
        this.bench1.xmirror();
        this.bench1.shift(f3, f4);
        this.m2.mul(this.bench1);
        this.m2.shift(this.bench2 * this.append, -this.boundFill * this.availableValue);
        this.getPattern2 = false;
    }

    public void transformBench2() {
        float f = this.IsShowLabelTips.width / 2.0f;
        float f2 = this.IsShowLabelTips.height / 2.0f;
        float f3 = this.QOIV.height / this.IsShowLabelTips.width;
        float f4 = this.QOIV.width / this.IsShowLabelTips.height;
        float f5 = f3 * this.availableValue;
        float f6 = f4 * this.append;
        float f7 = this.QOIV.x + this.QOIV.width / 2.0f;
        float f8 = this.QOIV.y + this.QOIV.height / 2.0f;
        this.IsShowLabelTips();
        this.bench1.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench1.bench2();
        this.m2.mul(this.bench1);
        this.bench1.xmirror();
        this.m2.mul(this.bench1);
        this.m2.shift(f7, f8);
        this.m2.shift(-this.boundFill * f6, this.bench2 * f5);
        this.getPattern2 = true;
    }

    public ChartAxis getAxisX() {
        return this.axisX;
    }

    public void setAxisX(ChartAxis chartAxis) {
        this.axisX = chartAxis;
    }

    public ChartAxis getAxisY() {
        return this.axisY;
    }

    public void setAxisY(ChartAxis chartAxis) {
        this.axisY = chartAxis;
    }

    protected void setAxisX(float f, float f2) {
        if (this.axisX instanceof ChartNumericAxis) {
            ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisX;
            String[] stringArray = chartNumericAxis.getLabels();
            this.draw = new float[stringArray.length][2];
            float f3 = (float)chartNumericAxis.getTickPace() * f;
            float f4 = (float)chartNumericAxis.getLabelStartValue() * f;
            int n = chartNumericAxis.getNumOfTick();
            float f5 = f4;
            int n2 = 0;
            while (n2 <= n) {
                this.draw[n2][0] = f5;
                this.draw[n2][1] = f2;
                f5 += f3;
                ++n2;
            }
            this.drawLine = this.draw;
        } else {
            ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.axisX;
            String[] stringArray = chartCategoryAxis.getLabels();
            if (stringArray != null) {
                if (chartCategoryAxis.isLineUnit()) {
                    this.draw = new float[stringArray.length][2];
                    float f6 = 0.0f;
                    int n = 0;
                    while (n < stringArray.length) {
                        this.draw[n][0] = f6;
                        this.draw[n][1] = f2;
                        f6 += f;
                        ++n;
                    }
                    this.drawLine = this.draw;
                } else {
                    float f7 = 0.0f;
                    this.draw = new float[stringArray.length + 1][2];
                    int n = 0;
                    while (n <= stringArray.length) {
                        this.draw[n][0] = f7;
                        this.draw[n][1] = f2;
                        f7 += f;
                        ++n;
                    }
                    f7 = f / 2.0f;
                    this.drawLine = new float[stringArray.length][2];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        this.drawLine[n3][0] = f7;
                        this.drawLine[n3][1] = f2;
                        f7 += f;
                        ++n3;
                    }
                }
            }
        }
    }

    protected void setAxisY(float f, float f2) {
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        String[] stringArray = chartNumericAxis.getLabels();
        this.yTickPos = new float[stringArray.length][2];
        float f3 = (float)chartNumericAxis.getTickPace() * f;
        float f4 = (float)chartNumericAxis.getLabelStartValue() * f;
        int n = chartNumericAxis.getNumOfTick();
        float f5 = f4;
        int n2 = 0;
        while (n2 <= n) {
            this.yTickPos[n2][0] = f2;
            this.yTickPos[n2][1] = f5;
            f5 += f3;
            ++n2;
        }
    }

    private void QOIV(float f, float f2, float f3, float f4) {
        float[][] fArray2 = new float[4][2];
        fArray2[0][0] = f;
        fArray2[0][1] = f3;
        fArray2[1][0] = f2;
        fArray2[1][1] = f3;
        fArray2[2][0] = f2;
        fArray2[2][1] = f4;
        fArray2[3][0] = f;
        fArray2[3][1] = f4;
        this.cos = new float[4][2];
        this.m2.transform(fArray2, this.cos);
    }

    private void append() {
        if (this.getPattern1.getProperties().getGraphProperties().isShowThresholdLine() || this.getPattern1.getProperties().getGraphProperties().isShowThresholdLine2()) {
            float[][] fArray2 = new float[4][2];
            fArray2[0][0] = 0.0f;
            fArray2[0][1] = this.availableValue((float)this.getPattern1.getProperties().getGraphProperties().getThresholdValue()) * this.Z();
            fArray2[1][0] = this.IsShowLabelTips.width;
            fArray2[1][1] = fArray2[0][1];
            fArray2[2][0] = this.IsShowLabelTips.width;
            fArray2[2][1] = this.axisYPos[1][1];
            fArray2[3][0] = 0.0f;
            fArray2[3][1] = this.axisYPos[1][1];
            float[][] fArray3 = new float[4][2];
            fArray3[0][0] = 0.0f;
            fArray3[0][1] = 0.0f;
            fArray3[1][0] = this.IsShowLabelTips.width;
            fArray3[1][1] = 0.0f;
            fArray3[2][0] = this.IsShowLabelTips.width;
            fArray3[2][1] = this.availableValue((float)this.getPattern1.getProperties().getGraphProperties().getThresholdValue2()) * this.Z();
            fArray3[3][0] = 0.0f;
            fArray3[3][1] = fArray3[2][1];
            this.getThresholdLineStyle = new float[4][2];
            this.getThresholdValue = new float[4][2];
            this.m2.transform(fArray2, this.getThresholdLineStyle);
            this.m2.transform(fArray3, this.getThresholdValue);
        }
    }

    public void paintAxis(Graphics2D graphics2D) {
        if (this.axisX != null && this.axisX.isShow()) {
            if (this.getMin) {
                this.axisX.setAxisPoint(this.getGridPen);
                this.axisX.setMajorTickMarkPoint(this.getAutoOritention);
                this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.getAutoOritention, this.getGridPen, this.axisX.getUnit(this.IsShowLabelTips.width) / 2.0f));
                this.axisX.setLabelPoint(this.getBorder);
            } else {
                this.axisX.setAxisPoint(this.getMax);
                this.axisX.setMajorTickMarkPoint(this.fill);
                this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.fill, this.getMax, this.axisX.getUnit(this.IsShowLabelTips.width) / 2.0f));
                this.axisX.setLabelPoint(this.formatMinorTickMark);
            }
            this.axisX.paint(graphics2D);
        }
        if (this.axisY != null && this.axisY.isShow()) {
            if (this.getMin) {
                this.axisY.setAxisPoint(this.getGridXAreaPath);
                this.axisY.setMajorTickMarkPoint(this.getGraphProperties);
                this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.getGraphProperties, this.getGridXAreaPath, this.axisY.getUnit(this.IsShowLabelTips.height) / 2.0f));
                this.axisY.setLabelPoint(this.getGraphProperties);
            } else {
                this.axisY.setAxisPoint(this.tYPos);
                this.axisY.setMajorTickMarkPoint(this.tYTickPos);
                this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.tYTickPos, this.tYPos, this.axisY.getUnit(this.IsShowLabelTips.height) / 2.0f));
                this.axisY.setLabelPoint(this.tYTickPos);
            }
            this.axisY.paint(graphics2D);
        }
    }

    public void paintGrid(Graphics2D graphics2D) {
        int n;
        int n2;
        GridLine gridLine = new GridLine();
        float[][] fArray2 = new float[2][2];
        if (this.axisX != null && this.axisX.getProperties().isShowGrid()) {
            gridLine.setPenStyle(this.axisX.getProperties().getGridPen());
            this.getProperties = new Line2D[this.fill.length];
            this.gridXAreaPath.reset();
            n2 = 0;
            while (n2 < this.fill.length) {
                if (!this.getPattern2) {
                    fArray2[0][0] = this.fill[n2][0];
                    fArray2[0][1] = this.cos[0][1];
                    fArray2[1][0] = this.fill[n2][0];
                    fArray2[1][1] = this.cos[2][1];
                } else {
                    fArray2[0][0] = this.cos[0][0];
                    fArray2[0][1] = this.fill[n2][1];
                    fArray2[1][0] = this.cos[2][0];
                    fArray2[1][1] = this.fill[n2][1];
                }
                this.getProperties[n2] = new Line2D.Float();
                this.getProperties[n2].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                gridLine.setLocation(fArray2);
                gridLine.draw(graphics2D);
                ++n2;
            }
            if (this.getMin) {
                n = 0;
                while (n < this.getAutoOritention.length) {
                    fArray2[0][0] = this.getAutoOritention[n][0];
                    fArray2[0][1] = this.getAutoOritention[n][1];
                    fArray2[1][0] = this.getAutoOritention[n][0] + this.I;
                    fArray2[1][1] = this.getAutoOritention[n][1] - this.Z;
                    this.getProperties[n].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                    gridLine.setLocation(fArray2);
                    gridLine.draw(graphics2D);
                    ++n;
                }
            }
            n = 0;
            while (n < this.getProperties.length) {
                this.gridXAreaPath.append(this.getProperties[n], false);
                ++n;
            }
        }
        if (this.axisY != null && this.axisY.getProperties().isShowGrid()) {
            gridLine.setPenStyle(this.axisY.getProperties().getGridPen());
            this.gridYAreaPath.reset();
            this.gridYPath = new Line2D[this.tYTickPos.length];
            n2 = 0;
            while (n2 < this.tYTickPos.length) {
                if (!this.getPattern2) {
                    fArray2[0][0] = this.cos[0][0];
                    fArray2[0][1] = this.tYTickPos[n2][1];
                    fArray2[1][0] = this.cos[1][0];
                    fArray2[1][1] = this.tYTickPos[n2][1];
                } else {
                    fArray2[0][0] = this.tYTickPos[n2][0];
                    fArray2[0][1] = this.cos[0][1];
                    fArray2[1][0] = this.tYTickPos[n2][0];
                    fArray2[1][1] = this.cos[2][1];
                }
                this.gridYPath[n2] = new Line2D.Float();
                this.gridYPath[n2].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                gridLine.setLocation(fArray2);
                gridLine.draw(graphics2D);
                ++n2;
            }
            if (this.getMin) {
                if (this.getThresholdLineColor2 && this.getPattern2) {
                    n = 0;
                    while (n < this.tYTickPos.length) {
                        fArray2[0][0] = this.tYTickPos[n][0];
                        fArray2[0][1] = this.tYTickPos[n][1];
                        fArray2[1][0] = this.tYTickPos[n][0];
                        fArray2[1][1] = this.tYTickPos[n][1];
                        gridLine.setLocation(fArray2);
                        gridLine.draw(graphics2D);
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < this.tYTickPos.length) {
                        fArray2[0][0] = this.tYTickPos[n][0];
                        fArray2[0][1] = this.tYTickPos[n][1];
                        fArray2[1][0] = this.tYTickPos[n][0] - this.I;
                        fArray2[1][1] = this.tYTickPos[n][1] + this.Z;
                        gridLine.setLocation(fArray2);
                        gridLine.draw(graphics2D);
                        ++n;
                    }
                }
            }
            n = 0;
            while (n < this.gridYPath.length) {
                this.gridYAreaPath.append(this.gridYPath[n], false);
                ++n;
            }
        }
    }

    public int getDepth() {
        return this.getNumOfTick;
    }

    public void setDepth(int n) {
        this.getNumOfTick = n;
    }

    public void setDepthDirection(int n) {
        this.getThresholdLineColor = n;
    }

    public boolean isDepth() {
        return this.getMin;
    }

    public boolean searchGridX(int n, int n2) {
        if (this.getProperties != null && this.axisX.getProperties().isShowGrid()) {
            return this.getGridXAreaPath().intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public boolean searchGridY(int n, int n2) {
        if (this.gridYPath != null && this.axisY.getProperties().isShowGrid()) {
            return this.getGridYAreaPath().intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public String searchAxisXLabel(int n, int n2) {
        return this.axisX.searchAxisLabel(n, n2);
    }

    public String searchAxisYLabel(int n, int n2) {
        return this.axisY.searchAxisLabel(n, n2);
    }

    public boolean IsShowAxisXLabelTips() {
        return this.axisX.IsShowLabelTips();
    }

    public boolean IsShowAxisYLabelTips() {
        return this.axisY.IsShowLabelTips();
    }

    public boolean searchAxisX(int n, int n2) {
        return this.axisX.searchSelectedAxis(n, n2);
    }

    public boolean searchAxisY(int n, int n2) {
        return this.axisY.searchSelectedAxis(n, n2);
    }

    public Shape getGridXAreaPath() {
        return this.gridXAreaPath;
    }

    public Shape getGridYAreaPath() {
        return this.gridYAreaPath;
    }

    public void paintWall(Graphics2D graphics2D, ChartWall chartWall) {
        boolean bl = this.getPattern1.properties.isShowWall();
        ChartWallProperties chartWallProperties = chartWall.getProperties();
        GeneralPath generalPath = new GeneralPath();
        ChartFillPattern chartFillPattern = chartWallProperties.getPattern1();
        ChartFillPattern chartFillPattern2 = chartWallProperties.getPattern2();
        ChartPenStyle chartPenStyle = chartWallProperties.getBorder();
        if (bl) {
            Point2D.Float[] floatArray = new Point2D.Float[]{new Point2D.Float(this.cos[0][0], this.cos[0][1]), new Point2D.Float(this.cos[1][0], this.cos[1][1]), new Point2D.Float(this.cos[2][0], this.cos[2][1]), new Point2D.Float(this.cos[3][0], this.cos[3][1])};
            chartWall.setPoint(floatArray);
            this.getThresholdValue2.moveTo(this.cos[0][0], this.cos[0][1]);
            this.getThresholdValue2.lineTo(this.cos[1][0], this.cos[1][1]);
            this.getThresholdValue2.lineTo(this.cos[2][0], this.cos[2][1]);
            this.getThresholdValue2.lineTo(this.cos[3][0], this.cos[3][1]);
            this.getThresholdValue2.closePath();
            if (this.cos != null) {
                chartWall.setPattern(chartFillPattern);
                chartWall.setPen(chartPenStyle);
                chartWall.draw(graphics2D);
                if (this.getMin) {
                    generalPath.reset();
                    if (this.getThresholdLineColor2 && this.getPattern2) {
                        generalPath.moveTo(this.cos[1][0], this.cos[1][1]);
                        generalPath.lineTo(this.cos[1][0] - this.I, this.cos[1][1] + this.Z);
                        generalPath.lineTo(this.cos[2][0] - this.I, this.cos[2][1] + this.Z);
                        generalPath.lineTo(this.cos[2][0], this.cos[2][1]);
                    } else {
                        generalPath.moveTo(this.cos[0][0], this.cos[0][1]);
                        generalPath.lineTo(this.cos[0][0] - this.I, this.cos[0][1] + this.Z);
                        generalPath.lineTo(this.cos[3][0] - this.I, this.cos[3][1] + this.Z);
                        generalPath.lineTo(this.cos[3][0], this.cos[3][1]);
                    }
                    generalPath.closePath();
                    if (chartFillPattern != null) {
                        chartFillPattern.fill(graphics2D, generalPath);
                    }
                    chartPenStyle.draw(graphics2D, generalPath);
                    generalPath.reset();
                    generalPath.moveTo(this.cos[0][0], this.cos[0][1]);
                    generalPath.lineTo(this.cos[0][0] - this.I, this.cos[0][1] + this.Z);
                    generalPath.lineTo(this.cos[1][0] - this.I, this.cos[1][1] + this.Z);
                    generalPath.lineTo(this.cos[1][0], this.cos[1][1]);
                    generalPath.closePath();
                    if (chartFillPattern != null) {
                        chartFillPattern.fill(graphics2D, generalPath);
                    }
                    chartPenStyle.draw(graphics2D, generalPath);
                }
            }
            if (this.cos != null && chartFillPattern2 != null) {
                float[][] fArray2 = new float[4][2];
                Point2D.Float[][] floatArray2 = new Point2D.Float[this.tYTickPos.length - 1][4];
                int n = 0;
                while (n < this.tYTickPos.length - 1) {
                    if (!this.getPattern2) {
                        fArray2[0][0] = this.cos[0][0];
                        fArray2[0][1] = this.tYTickPos[n][1];
                        fArray2[1][0] = this.cos[1][0];
                        fArray2[1][1] = this.tYTickPos[n][1];
                        fArray2[2][0] = this.cos[0][0];
                        fArray2[2][1] = (this.tYTickPos[n][1] + this.tYTickPos[n + 1][1]) / 2.0f;
                        fArray2[3][0] = this.cos[1][0];
                        fArray2[3][1] = (this.tYTickPos[n][1] + this.tYTickPos[n + 1][1]) / 2.0f;
                    } else {
                        fArray2[0][0] = this.tYTickPos[n][0];
                        fArray2[0][1] = this.cos[0][1];
                        fArray2[1][0] = this.tYTickPos[n][0];
                        fArray2[1][1] = this.cos[2][1];
                        fArray2[2][0] = (this.tYTickPos[n][0] + this.tYTickPos[n + 1][0]) / 2.0f;
                        fArray2[2][1] = this.cos[0][1];
                        fArray2[3][0] = (this.tYTickPos[n][0] + this.tYTickPos[n + 1][0]) / 2.0f;
                        fArray2[3][1] = this.cos[2][1];
                    }
                    floatArray2[n][0] = new Point2D.Float(fArray2[0][0], fArray2[0][1]);
                    floatArray2[n][1] = new Point2D.Float(fArray2[1][0], fArray2[1][1]);
                    floatArray2[n][2] = new Point2D.Float(fArray2[3][0], fArray2[3][1]);
                    floatArray2[n][3] = new Point2D.Float(fArray2[2][0], fArray2[2][1]);
                    ++n;
                }
                chartWall.setPattern(chartFillPattern2);
                chartWall.setBoundFillPoint(floatArray2);
                chartWall.boundFill(graphics2D);
                if (this.getMin) {
                    float[][] fArray3 = new float[4][2];
                    int n2 = 0;
                    while (n2 < this.tYTickPos.length - 1) {
                        fArray2[0][0] = this.tYTickPos[n2][0];
                        fArray2[0][1] = this.tYTickPos[n2][1];
                        fArray2[1][0] = this.tYTickPos[n2][0] - this.I;
                        fArray2[1][1] = this.tYTickPos[n2][1] + this.Z;
                        fArray2[2][0] = this.tYTickPos[n2 + 1][0];
                        fArray2[2][1] = this.tYTickPos[n2 + 1][1];
                        fArray2[3][0] = this.tYTickPos[n2 + 1][0] - this.I;
                        fArray2[3][1] = this.tYTickPos[n2 + 1][1] + this.Z;
                        fArray3[0] = fArray2[0];
                        fArray3[1] = fArray2[1];
                        fArray3[2][0] = (fArray2[0][0] + fArray2[2][0]) / 2.0f;
                        fArray3[2][1] = (fArray2[0][1] + fArray2[2][1]) / 2.0f;
                        fArray3[3][0] = (fArray2[1][0] + fArray2[3][0]) / 2.0f;
                        fArray3[3][1] = (fArray2[1][1] + fArray2[3][1]) / 2.0f;
                        floatArray2[n2][0] = new Point2D.Float(fArray3[0][0], fArray3[0][1]);
                        floatArray2[n2][1] = new Point2D.Float(fArray3[1][0], fArray3[1][1]);
                        floatArray2[n2][2] = new Point2D.Float(fArray3[3][0], fArray3[3][1]);
                        floatArray2[n2][3] = new Point2D.Float(fArray3[2][0], fArray3[2][1]);
                        ++n2;
                    }
                    chartWall.setPattern(chartFillPattern2);
                    chartWall.setPen(chartPenStyle);
                    chartWall.setBoundFillPoint(floatArray2);
                    chartWall.boundFill(graphics2D);
                    generalPath.reset();
                    generalPath.moveTo(this.cos[0][0], this.cos[0][1]);
                    generalPath.lineTo(this.cos[0][0] - this.I, this.cos[0][1] + this.Z);
                    generalPath.lineTo(this.cos[3][0] - this.I, this.cos[3][1] + this.Z);
                    generalPath.lineTo(this.cos[3][0], this.cos[3][1]);
                    generalPath.closePath();
                    chartPenStyle.draw(graphics2D, generalPath);
                }
            }
        }
    }

    public void paintThresholdLine(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        switch (this.getPattern1.getProperties().getGraphProperties().getThresholdLineStyle()) {
            case 0: {
                if (this.getPattern1.getProperties().getGraphProperties().isShowThresholdLine()) {
                    if (this.isDepth()) {
                        generalPath.reset();
                        generalPath.moveTo(this.getThresholdLineStyle[0][0] - this.I, this.getThresholdLineStyle[0][1] + this.Z);
                        generalPath.lineTo(this.getThresholdLineStyle[1][0] - this.I, this.getThresholdLineStyle[1][1] + this.Z);
                        generalPath.lineTo(this.getThresholdLineStyle[2][0] - this.I, this.getThresholdLineStyle[2][1] + this.Z);
                        generalPath.lineTo(this.getThresholdLineStyle[3][0] - this.I, this.getThresholdLineStyle[3][1] + this.Z);
                        generalPath.lineTo(this.getThresholdLineStyle[0][0] - this.I, this.getThresholdLineStyle[0][1] + this.Z);
                        generalPath.closePath();
                        graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                        if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold()) {
                            graphics2D.fill(generalPath);
                        }
                        graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor());
                        graphics2D.drawLine((int)(this.getThresholdLineStyle[0][0] - this.I), (int)(this.getThresholdLineStyle[0][1] + this.Z), (int)(this.getThresholdLineStyle[1][0] - this.I), (int)(this.getThresholdLineStyle[1][1] + this.Z));
                    } else {
                        generalPath.reset();
                        generalPath.moveTo(this.getThresholdLineStyle[0][0], this.getThresholdLineStyle[0][1]);
                        generalPath.lineTo(this.getThresholdLineStyle[1][0], this.getThresholdLineStyle[1][1]);
                        generalPath.lineTo(this.getThresholdLineStyle[2][0], this.getThresholdLineStyle[2][1]);
                        generalPath.lineTo(this.getThresholdLineStyle[3][0], this.getThresholdLineStyle[3][1]);
                        generalPath.lineTo(this.getThresholdLineStyle[0][0], this.getThresholdLineStyle[0][1]);
                        generalPath.closePath();
                        graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                        if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold()) {
                            graphics2D.fill(generalPath);
                        }
                        graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor());
                        graphics2D.drawLine((int)this.getThresholdLineStyle[0][0], (int)this.getThresholdLineStyle[0][1], (int)this.getThresholdLineStyle[1][0], (int)this.getThresholdLineStyle[1][1]);
                    }
                }
                if (!this.getPattern1.getProperties().getGraphProperties().isShowThresholdLine2()) break;
                if (this.isDepth()) {
                    generalPath.reset();
                    generalPath.moveTo(this.getThresholdValue[0][0] - this.I, this.getThresholdValue[0][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[1][0] - this.I, this.getThresholdValue[1][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[2][0] - this.I, this.getThresholdValue[2][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[3][0] - this.I, this.getThresholdValue[3][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[0][0] - this.I, this.getThresholdValue[0][1] + this.Z);
                    generalPath.closePath();
                    graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor2(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                    if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold2()) {
                        graphics2D.fill(generalPath);
                    }
                    graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor2());
                    graphics2D.drawLine((int)(this.getThresholdValue[2][0] - this.I), (int)(this.getThresholdValue[2][1] + this.Z), (int)(this.getThresholdValue[3][0] - this.I), (int)(this.getThresholdValue[3][1] + this.Z));
                    break;
                }
                generalPath.reset();
                generalPath.moveTo(this.getThresholdValue[0][0], this.getThresholdValue[0][1]);
                generalPath.lineTo(this.getThresholdValue[1][0], this.getThresholdValue[1][1]);
                generalPath.lineTo(this.getThresholdValue[2][0], this.getThresholdValue[2][1]);
                generalPath.lineTo(this.getThresholdValue[3][0], this.getThresholdValue[3][1]);
                generalPath.lineTo(this.getThresholdValue[0][0], this.getThresholdValue[0][1]);
                generalPath.closePath();
                graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor2(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold2()) {
                    graphics2D.fill(generalPath);
                }
                graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor2());
                graphics2D.drawLine((int)this.getThresholdValue[2][0], (int)this.getThresholdValue[2][1], (int)this.getThresholdValue[3][0], (int)this.getThresholdValue[3][1]);
                break;
            }
            case 1: {
                if (!this.getPattern1.getProperties().getGraphProperties().isShowThresholdLine()) break;
                if (this.isDepth()) {
                    generalPath.reset();
                    generalPath.moveTo(this.getThresholdLineStyle[0][0] - this.I, this.getThresholdLineStyle[0][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineStyle[1][0] - this.I, this.getThresholdLineStyle[1][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[2][0] - this.I, this.getThresholdValue[2][1] + this.Z);
                    generalPath.lineTo(this.getThresholdValue[3][0] - this.I, this.getThresholdValue[3][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineStyle[0][0] - this.I, this.getThresholdLineStyle[0][1] + this.Z);
                    generalPath.closePath();
                    graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                    if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold()) {
                        graphics2D.fill(generalPath);
                    }
                    graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor());
                    graphics2D.drawLine((int)(this.getThresholdLineStyle[0][0] - this.I), (int)(this.getThresholdLineStyle[0][1] + this.Z), (int)(this.getThresholdLineStyle[1][0] - this.I), (int)(this.getThresholdLineStyle[1][1] + this.Z));
                    graphics2D.drawLine((int)(this.getThresholdValue[2][0] - this.I), (int)(this.getThresholdValue[2][1] + this.Z), (int)(this.getThresholdValue[3][0] - this.I), (int)(this.getThresholdValue[3][1] + this.Z));
                    break;
                }
                generalPath.moveTo(this.getThresholdLineStyle[0][0], this.getThresholdLineStyle[0][1]);
                generalPath.lineTo(this.getThresholdLineStyle[1][0], this.getThresholdLineStyle[1][1]);
                generalPath.lineTo(this.getThresholdValue[2][0], this.getThresholdValue[2][1]);
                generalPath.lineTo(this.getThresholdValue[3][0], this.getThresholdValue[3][1]);
                generalPath.lineTo(this.getThresholdLineStyle[0][0], this.getThresholdLineStyle[0][1]);
                generalPath.closePath();
                graphics2D.setColor(ChartColorPattern.transparent(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor(), this.getPattern1.getProperties().getGraphProperties().getThresholdFillTransparency()));
                if (this.getPattern1.getProperties().getGraphProperties().isFillThreshold()) {
                    graphics2D.fill(generalPath);
                }
                graphics2D.setColor(this.getPattern1.getProperties().getGraphProperties().getThresholdLineColor());
                graphics2D.drawLine((int)this.getThresholdLineStyle[0][0], (int)this.getThresholdLineStyle[0][1], (int)this.getThresholdLineStyle[1][0], (int)this.getThresholdLineStyle[1][1]);
                graphics2D.drawLine((int)this.getThresholdValue[2][0], (int)this.getThresholdValue[2][1], (int)this.getThresholdValue[3][0], (int)this.getThresholdValue[3][1]);
            }
        }
    }

    public float[][] getWallCoordinate() {
        return this.cos;
    }

    public boolean searchWall(int n, int n2) {
        return this.getWallPath().contains(n, n2);
    }

    public GeneralPath getWallPath() {
        return this.getThresholdValue2;
    }

    public Line2D[] getGridXPath() {
        return this.getProperties;
    }

    public Line2D[] getGridYPath() {
        return this.gridYPath;
    }

    public void setUseDepth(boolean bl) {
        this.getThresholdFillTransparency = bl;
    }

    public boolean isCombo() {
        return this.getThresholdLineColor2;
    }

    public void setCombo(boolean bl) {
        this.getThresholdLineColor2 = bl;
    }

    public void setChartCount(int n) {
        this.getTickPace = n;
    }

    public int getChartCount() {
        return this.getTickPace;
    }

    public boolean isShowCategoryAndSeries() {
        return this.getUnit;
    }

    public void setShowCategoryAndSeries(boolean bl) {
        this.getUnit = bl;
    }
}

