/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartAxisArrowStyle;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageDials;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Graph2DGuageDial {
    int F = 0;
    Graph2DGuageDials QOIV;

    Graph2DGuageDial(Graph2DGuageDials graph2DGuageDials, int n) {
        this.QOIV = graph2DGuageDials;
        this.F = n;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.QOIV.objectProperties.isGaugeDialCurveIsFill()) {
            this.getAxisLabelsPos(graphics2D);
        }
        if (this.QOIV.paper.getProperties().isShowAxisY()) {
            this.getAlertArea(graphics2D);
        }
        if (this.QOIV.paper.getProperties().getAxisYProperties().isShowGrid()) {
            this.getArrowPoint(graphics2D);
        }
        this.fill(graphics2D);
        this.QOIV(graphics2D);
        this.draw(graphics2D);
        this.F(graphics2D);
    }

    private void F(Graphics2D graphics2D) {
        if (!this.QOIV.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            return;
        }
        ChartLabelBase chartLabelBase = this.QOIV.getCategoryLabel(this.F);
        if (chartLabelBase == null) {
            return;
        }
        float f = this.QOIV.getCategoryLabelsX(this.F);
        float f2 = this.QOIV.getCategoryLabelsY(this.F);
        chartLabelBase.locate();
        chartLabelBase.paint(graphics2D, f, f2);
    }

    private void QOIV(Graphics2D graphics2D) {
        ChartFillPattern[] chartFillPatternArray = this.QOIV.seriesPattern;
        int n = this.QOIV.Z;
        float f = (float)((ChartNumericAxis)this.QOIV.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.QOIV.layer.getAxisY()).getMin();
        int n2 = 0;
        while (n2 < n) {
            if (((Chart1DDataSet)this.QOIV.dataset).getValue(n2, this.F) != null && !(this.QOIV.I[n2][this.F] > f) && !(this.QOIV.I[n2][this.F] < f2)) {
                Shape shape = this.QOIV.getShapeByItem(n2, this.F);
                this.dataset(graphics2D, shape, n2, chartFillPatternArray[n2]);
            }
            ++n2;
        }
    }

    private void dataset(Graphics2D graphics2D, Shape shape, int n, ChartFillPattern chartFillPattern) {
        if (shape == null) {
            return;
        }
        switch (this.QOIV.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 1: {
                if (chartFillPattern == null) break;
                chartFillPattern.fill(graphics2D, shape);
                if (!this.QOIV.objectProperties.isContour()) break;
                this.QOIV.objectProperties.getContourPen().draw(graphics2D, shape);
                break;
            }
            case 2: {
                Color color = null;
                ChartColorPattern chartColorPattern = null;
                if (this.QOIV.seriesPattern[n] == null) break;
                if (this.QOIV.seriesPattern[n] instanceof ChartColorPattern) {
                    chartColorPattern = (ChartColorPattern)this.QOIV.seriesPattern[n];
                    color = ((ChartColorPattern)this.QOIV.seriesPattern[n]).getColor();
                } else if (this.QOIV.seriesPattern[n] instanceof ChartGradientPattern) {
                    chartColorPattern = ((ChartGradientPattern)this.QOIV.seriesPattern[n]).getStartColor();
                    color = ((ChartGradientPattern)this.QOIV.seriesPattern[n]).getStartColor().getColor();
                } else if (this.QOIV.seriesPattern[n] instanceof ChartTexturePattern) {
                    chartColorPattern = ((ChartTexturePattern)this.QOIV.seriesPattern[n]).getForeground();
                    color = ((ChartTexturePattern)this.QOIV.seriesPattern[n]).getForeground().getColor();
                }
                ChartPenStyle chartPenStyle = new ChartPenStyle();
                chartPenStyle.setPenWidth(3.0f);
                chartPenStyle.setPenColor(chartColorPattern);
                if (this.QOIV.getArrowLine(n, this.F) != null) {
                    chartPenStyle.draw(graphics2D, this.QOIV.getArrowLine(n, this.F));
                }
                ChartAxisArrowStyle chartAxisArrowStyle = null;
                graphics2D.setColor(color);
                int n2 = (int)this.QOIV.getArrowPoint(n, this.F)[0];
                int n3 = (int)this.QOIV.getArrowPoint(n, this.F)[1];
                graphics2D.rotate(Math.PI * 2 + this.QOIV.getValueAngle(n, this.F) - 1.5707963267948966, n2, n3);
                switch (this.QOIV.objectProperties.getGaugeDialLineArrowStyle()) {
                    case 1: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(1);
                        break;
                    }
                    case 2: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(2);
                        break;
                    }
                    case 3: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(3);
                        break;
                    }
                    case 0: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(0);
                        break;
                    }
                }
                chartAxisArrowStyle.draw(graphics2D, n2, n3);
                graphics2D.rotate(Math.PI * -2 - this.QOIV.getValueAngle(n, this.F) + 1.5707963267948966, n2, n3);
                break;
            }
        }
    }

    private void draw(Graphics2D graphics2D) {
        float f = this.QOIV.getCenterX(this.F);
        float f2 = this.QOIV.getCenterY(this.F);
        switch (this.QOIV.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 2: {
                Arc2D.Float float_ = new Arc2D.Float(f - this.QOIV.C / 10.0f, f2 - this.QOIV.C / 10.0f, this.QOIV.C / 5.0f, this.QOIV.C / 5.0f, 0.0f, 360.0f, 0);
                ChartGradientPattern chartGradientPattern = new ChartGradientPattern(3);
                chartGradientPattern.setStartColor(new ChartColorPattern(Color.white));
                chartGradientPattern.setEndColor(new ChartColorPattern(Color.gray));
                Point2D.Float float_2 = new Point2D.Float(0.3f, 0.3f);
                Point2D.Float float_3 = new Point2D.Float(1.0f, 1.0f);
                chartGradientPattern.setStartPoint(float_2);
                chartGradientPattern.setEndPoint(float_3);
                chartGradientPattern.fill(graphics2D, float_);
            }
        }
    }

    private void fill(Graphics2D graphics2D) {
        Shape shape = this.QOIV.getCurvePath(this.F);
        if (shape == null) {
            return;
        }
        this.QOIV.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
    }

    private void getAlertArea(Graphics2D graphics2D) {
        Shape shape = this.QOIV.getAxisPaths(this.F);
        this.QOIV.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
        this.drawTickMark(graphics2D);
        if (this.QOIV.paper.getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.getArrowLine(graphics2D);
        }
    }

    private void getArrowLine(Graphics2D graphics2D) {
        ChartLabelBase[] chartLabelBaseArray = this.QOIV.getLabels();
        if (chartLabelBaseArray == null) {
            return;
        }
        float[][] fArray2 = this.QOIV.getAxisLabelsPos(this.F);
        int n = chartLabelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            chartLabelBaseArray[n2].locate();
            chartLabelBaseArray[n2].paint(graphics2D, fArray2[n2][0], fArray2[n2][1]);
            ++n2;
        }
    }

    public void drawTickMark(Graphics2D graphics2D) {
        Shape[] shapeArray = this.QOIV.getTickPath(this.F);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.QOIV.paper.getProperties().getAxisYProperties().getTickMarkPen().draw(graphics2D, shapeArray[n2]);
            ++n2;
        }
    }

    private void getArrowPoint(Graphics2D graphics2D) {
        Shape[] shapeArray = this.QOIV.getGridPath(this.F);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.QOIV.paper.getProperties().getAxisYProperties().getGridPen().draw(graphics2D, shapeArray[n2]);
            ++n2;
        }
    }

    private void getAxisLabelsPos(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(this.QOIV.getOuterInnerGap(), 0, 0));
        if (this.QOIV.objectProperties.getGaugeNormalColor() != null) {
            graphics2D.setColor(this.QOIV.objectProperties.getGaugeNormalColor());
            graphics2D.draw(this.QOIV.getNormalArea(this.F));
        }
        if (this.QOIV.objectProperties.getGaugeAlertColor() != null) {
            graphics2D.setColor(this.QOIV.objectProperties.getGaugeAlertColor());
            graphics2D.draw(this.QOIV.getAlertArea(this.F));
        }
        if (this.QOIV.objectProperties.getGaugeErrorColor() != null) {
            graphics2D.setColor(this.QOIV.objectProperties.getGaugeErrorColor());
            graphics2D.draw(this.QOIV.getErrorArea(this.F));
        }
        graphics2D.setStroke(stroke);
    }
}

