/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core.node;

import jet.dataengine.api.DSException;
import jet.dataengine8.olap.core.node.ACalculator;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.ICountCalculator;
import jet.dataengine8.olap.util.DataValue;

public class DoubleCalculator
extends ACalculator {
    protected DoubleCalculator(ICountCalculator iCountCalculator, int n, int n2) {
        super(iCountCalculator, n, n2);
    }

    protected DataValue sum(ANode aNode, DataValue dataValue) throws DSException {
        double d = this.I(aNode, 2);
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue squareSum(ANode aNode, DataValue dataValue) throws DSException {
        double d = this.I(aNode, 3);
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue max(ANode aNode, DataValue dataValue) throws DSException {
        double d = this.I(aNode, 0);
        if (d == Double.NEGATIVE_INFINITY) {
            dataValue.set(0, null);
            return dataValue;
        }
        dataValue.set(this.baseType, d);
        return dataValue;
    }

    protected DataValue min(ANode aNode, DataValue dataValue) throws DSException {
        double d = this.I(aNode, 1);
        if (d == Double.POSITIVE_INFINITY) {
            dataValue.set(0, null);
            return dataValue;
        }
        dataValue.set(this.baseType, d);
        return dataValue;
    }

    protected DataValue variance(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(0, null);
            return dataValue;
        }
        double d = this.QOIV(aNode) / (double)(l - 1L);
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue populationVariance(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(8, 0L);
            return dataValue;
        }
        double d = this.QOIV(aNode) / (double)l;
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue stdDev(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(0, null);
            return dataValue;
        }
        double d = this.QOIV(aNode) / (double)(l - 1L);
        d = Math.sqrt(d);
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue populationStdDev(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(8, 0L);
            return dataValue;
        }
        double d = this.QOIV(aNode) / (double)l;
        d = Math.sqrt(d);
        dataValue.set(8, d);
        return dataValue;
    }

    protected DataValue average(ANode aNode, DataValue dataValue) throws DSException {
        double d = this.I(aNode, 2);
        long l = this.getCount(aNode);
        double d2 = d / (double)l;
        dataValue.set(8, d2);
        return dataValue;
    }

    private double I(ANode aNode, int n) {
        double[] dArray = (double[])aNode.getValues(this.nodeValueIndex);
        return dArray[n];
    }

    private double QOIV(ANode aNode) throws DSException {
        double[] dArray = (double[])aNode.getValues(this.nodeValueIndex);
        double d = dArray[2] / (double)this.getCount(aNode);
        return dArray[3] - d * dArray[2];
    }
}

